/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model.faction;

import enterprises.orbital.evekit.account.EveKitRefDataProvider;
import enterprises.orbital.evekit.model.AttributeParameters;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.RefCachedData;
import enterprises.orbital.evekit.model.faction.AbstractVictoryPointStat;
import enterprises.orbital.evekit.model.faction.StatAttribute;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.NoResultException;
import javax.persistence.Table;
import javax.persistence.TypedQuery;

@Entity
@Table(name="evekit_eve_factionvpstat")
@NamedQueries(value={@NamedQuery(name="FactionVictoryPointStat.get", query="SELECT c FROM FactionVictoryPointStat c WHERE c.attribute = :attr AND c.factionID = :fid AND c.lifeStart <= :point AND c.lifeEnd > :point")})
public class FactionVictoryPointStat
extends AbstractVictoryPointStat {
    private static final Logger log = Logger.getLogger(FactionVictoryPointStat.class.getName());
    private int factionID;

    protected FactionVictoryPointStat() {
        super(StatAttribute.TOTAL, 0);
    }

    public FactionVictoryPointStat(StatAttribute attribute, int victoryPoints, int factionID) {
        super(attribute, victoryPoints);
        this.factionID = factionID;
    }

    @Override
    public void prepareTransient() {
        this.fixDates();
    }

    @Override
    public boolean equivalent(RefCachedData sup) {
        if (!(sup instanceof FactionVictoryPointStat)) {
            return false;
        }
        if (!super.equivalent(sup)) {
            return false;
        }
        FactionVictoryPointStat other = (FactionVictoryPointStat)sup;
        return this.factionID == other.factionID;
    }

    public int getFactionID() {
        return this.factionID;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FactionVictoryPointStat that = (FactionVictoryPointStat)o;
        return this.factionID == that.factionID;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.factionID);
    }

    @Override
    public String toString() {
        return "FactionVictoryPointStat{factionID=" + this.factionID + ", attribute=" + (Object)((Object)this.attribute) + ", victoryPoints=" + this.victoryPoints + '}';
    }

    public static FactionVictoryPointStat get(long time, StatAttribute attr, int factionID) throws IOException {
        try {
            return (FactionVictoryPointStat)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitRefDataProvider.getFactory().getEntityManager().createNamedQuery("FactionVictoryPointStat.get", FactionVictoryPointStat.class);
                getter.setParameter("point", (Object)time);
                getter.setParameter("attr", (Object)attr);
                getter.setParameter("fid", (Object)factionID);
                try {
                    return (FactionVictoryPointStat)getter.getSingleResult();
                }
                catch (NoResultException e) {
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static List<FactionVictoryPointStat> accessQuery(long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector attribute, AttributeSelector factionID, AttributeSelector victoryPoints) throws IOException {
        try {
            return (List)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                StringBuilder qs = new StringBuilder();
                qs.append("SELECT c FROM FactionVictoryPointStat c WHERE 1=1");
                AttributeSelector.addLifelineSelector((StringBuilder)qs, (String)"c", (AttributeSelector)at);
                AttributeParameters p = new AttributeParameters("att");
                AttributeSelector.addEnumSelector((StringBuilder)qs, (String)"c", (String)"attribute", (AttributeSelector)attribute, StatAttribute::valueOf, (AttributeParameters)p);
                AttributeSelector.addLongSelector((StringBuilder)qs, (String)"c", (String)"factionID", (AttributeSelector)factionID);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"victoryPoints", (AttributeSelector)victoryPoints);
                FactionVictoryPointStat.setCIDOrdering(qs, contid, reverse);
                TypedQuery query = EveKitRefDataProvider.getFactory().getEntityManager().createQuery(qs.toString(), FactionVictoryPointStat.class);
                p.fillParams(query);
                query.setMaxResults(maxresults);
                return query.getResultList();
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }
}

