/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model.faction;

import enterprises.orbital.evekit.account.EveKitRefDataProvider;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.RefCachedData;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.NoResultException;
import javax.persistence.Table;
import javax.persistence.TypedQuery;

@Entity
@Table(name="evekit_eve_factionstats")
@NamedQueries(value={@NamedQuery(name="FactionStats.get", query="SELECT c FROM FactionStats c WHERE c.factionID = :fid AND c.lifeStart <= :point AND c.lifeEnd > :point")})
public class FactionStats
extends RefCachedData {
    private static final Logger log = Logger.getLogger(FactionStats.class.getName());
    private int factionID;
    private int killsLastWeek;
    private int killsTotal;
    private int killsYesterday;
    private int pilots;
    private int systemsControlled;
    private int victoryPointsLastWeek;
    private int victoryPointsTotal;
    private int victoryPointsYesterday;

    protected FactionStats() {
    }

    public FactionStats(int factionID, int killsLastWeek, int killsTotal, int killsYesterday, int pilots, int systemsControlled, int victoryPointsLastWeek, int victoryPointsTotal, int victoryPointsYesterday) {
        this.factionID = factionID;
        this.killsLastWeek = killsLastWeek;
        this.killsTotal = killsTotal;
        this.killsYesterday = killsYesterday;
        this.pilots = pilots;
        this.systemsControlled = systemsControlled;
        this.victoryPointsLastWeek = victoryPointsLastWeek;
        this.victoryPointsTotal = victoryPointsTotal;
        this.victoryPointsYesterday = victoryPointsYesterday;
    }

    @Override
    public void prepareTransient() {
        this.fixDates();
    }

    @Override
    public boolean equivalent(RefCachedData sup) {
        if (!(sup instanceof FactionStats)) {
            return false;
        }
        FactionStats other = (FactionStats)sup;
        return this.factionID == other.factionID && this.killsLastWeek == other.killsLastWeek && this.killsTotal == other.killsTotal && this.killsYesterday == other.killsYesterday && this.pilots == other.pilots && this.systemsControlled == other.systemsControlled && this.victoryPointsLastWeek == other.victoryPointsLastWeek && this.victoryPointsTotal == other.victoryPointsTotal && this.victoryPointsYesterday == other.victoryPointsYesterday;
    }

    public int getFactionID() {
        return this.factionID;
    }

    public int getKillsLastWeek() {
        return this.killsLastWeek;
    }

    public int getKillsTotal() {
        return this.killsTotal;
    }

    public int getKillsYesterday() {
        return this.killsYesterday;
    }

    public int getPilots() {
        return this.pilots;
    }

    public int getSystemsControlled() {
        return this.systemsControlled;
    }

    public int getVictoryPointsLastWeek() {
        return this.victoryPointsLastWeek;
    }

    public int getVictoryPointsTotal() {
        return this.victoryPointsTotal;
    }

    public int getVictoryPointsYesterday() {
        return this.victoryPointsYesterday;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FactionStats that = (FactionStats)o;
        return this.factionID == that.factionID && this.killsLastWeek == that.killsLastWeek && this.killsTotal == that.killsTotal && this.killsYesterday == that.killsYesterday && this.pilots == that.pilots && this.systemsControlled == that.systemsControlled && this.victoryPointsLastWeek == that.victoryPointsLastWeek && this.victoryPointsTotal == that.victoryPointsTotal && this.victoryPointsYesterday == that.victoryPointsYesterday;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.factionID, this.killsLastWeek, this.killsTotal, this.killsYesterday, this.pilots, this.systemsControlled, this.victoryPointsLastWeek, this.victoryPointsTotal, this.victoryPointsYesterday);
    }

    @Override
    public String toString() {
        return "FactionStats{factionID=" + this.factionID + ", killsLastWeek=" + this.killsLastWeek + ", killsTotal=" + this.killsTotal + ", killsYesterday=" + this.killsYesterday + ", pilots=" + this.pilots + ", systemsControlled=" + this.systemsControlled + ", victoryPointsLastWeek=" + this.victoryPointsLastWeek + ", victoryPointsTotal=" + this.victoryPointsTotal + ", victoryPointsYesterday=" + this.victoryPointsYesterday + '}';
    }

    public static FactionStats get(long time, int factionID) throws IOException {
        try {
            return (FactionStats)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitRefDataProvider.getFactory().getEntityManager().createNamedQuery("FactionStats.get", FactionStats.class);
                getter.setParameter("point", (Object)time);
                getter.setParameter("fid", (Object)factionID);
                try {
                    return (FactionStats)getter.getSingleResult();
                }
                catch (NoResultException e) {
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static List<FactionStats> accessQuery(long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector factionID, AttributeSelector killsLastWeek, AttributeSelector killsTotal, AttributeSelector killsYesterday, AttributeSelector pilots, AttributeSelector systemsControlled, AttributeSelector victoryPointsLastWeek, AttributeSelector victoryPointsTotal, AttributeSelector victoryPointsYesterday) throws IOException {
        try {
            return (List)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                StringBuilder qs = new StringBuilder();
                qs.append("SELECT c FROM FactionStats c WHERE 1=1");
                AttributeSelector.addLifelineSelector((StringBuilder)qs, (String)"c", (AttributeSelector)at);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"factionID", (AttributeSelector)factionID);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"killsLastWeek", (AttributeSelector)killsLastWeek);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"killsTotal", (AttributeSelector)killsTotal);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"killsYesterday", (AttributeSelector)killsYesterday);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"pilots", (AttributeSelector)pilots);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"systemsControlled", (AttributeSelector)systemsControlled);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"victoryPointsLastWeek", (AttributeSelector)victoryPointsLastWeek);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"victoryPointsTotal", (AttributeSelector)victoryPointsTotal);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"victoryPointsYesterday", (AttributeSelector)victoryPointsYesterday);
                FactionStats.setCIDOrdering(qs, contid, reverse);
                TypedQuery query = EveKitRefDataProvider.getFactory().getEntityManager().createQuery(qs.toString(), FactionStats.class);
                query.setMaxResults(maxresults);
                return query.getResultList();
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }
}

