/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model.faction;

import enterprises.orbital.evekit.account.EveKitRefDataProvider;
import enterprises.orbital.evekit.model.AttributeParameters;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.RefCachedData;
import enterprises.orbital.evekit.model.faction.AbstractKillStat;
import enterprises.orbital.evekit.model.faction.StatAttribute;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.NoResultException;
import javax.persistence.Table;
import javax.persistence.TypedQuery;

@Entity
@Table(name="evekit_eve_corpkillstat")
@NamedQueries(value={@NamedQuery(name="CorporationKillStat.get", query="SELECT c FROM CorporationKillStat c WHERE c.attribute = :attr AND c.corporationID = :corpid AND c.lifeStart <= :point AND c.lifeEnd > :point")})
public class CorporationKillStat
extends AbstractKillStat {
    private static final Logger log = Logger.getLogger(CorporationKillStat.class.getName());
    private int corporationID;

    protected CorporationKillStat() {
        super(StatAttribute.TOTAL, 0);
    }

    public CorporationKillStat(StatAttribute attribute, int kills, int corporationID) {
        super(attribute, kills);
        this.corporationID = corporationID;
    }

    @Override
    public void prepareTransient() {
        this.fixDates();
    }

    @Override
    public boolean equivalent(RefCachedData sup) {
        if (!(sup instanceof CorporationKillStat)) {
            return false;
        }
        if (!super.equivalent(sup)) {
            return false;
        }
        CorporationKillStat other = (CorporationKillStat)sup;
        return this.corporationID == other.corporationID;
    }

    public int getCorporationID() {
        return this.corporationID;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CorporationKillStat that = (CorporationKillStat)o;
        return this.corporationID == that.corporationID;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.corporationID);
    }

    @Override
    public String toString() {
        return "CorporationKillStat{corporationID=" + this.corporationID + ", attribute=" + (Object)((Object)this.attribute) + ", kills=" + this.kills + '}';
    }

    public static CorporationKillStat get(long time, StatAttribute attr, int corporationID) throws IOException {
        try {
            return (CorporationKillStat)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitRefDataProvider.getFactory().getEntityManager().createNamedQuery("CorporationKillStat.get", CorporationKillStat.class);
                getter.setParameter("point", (Object)time);
                getter.setParameter("attr", (Object)attr);
                getter.setParameter("corpid", (Object)corporationID);
                try {
                    return (CorporationKillStat)getter.getSingleResult();
                }
                catch (NoResultException e) {
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static List<CorporationKillStat> accessQuery(long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector attribute, AttributeSelector corporationID, AttributeSelector kills) throws IOException {
        try {
            return (List)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                StringBuilder qs = new StringBuilder();
                qs.append("SELECT c FROM CorporationKillStat c WHERE 1=1");
                AttributeSelector.addLifelineSelector((StringBuilder)qs, (String)"c", (AttributeSelector)at);
                AttributeParameters p = new AttributeParameters("att");
                AttributeSelector.addEnumSelector((StringBuilder)qs, (String)"c", (String)"attribute", (AttributeSelector)attribute, StatAttribute::valueOf, (AttributeParameters)p);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"corporationID", (AttributeSelector)corporationID);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"kills", (AttributeSelector)kills);
                CorporationKillStat.setCIDOrdering(qs, contid, reverse);
                TypedQuery query = EveKitRefDataProvider.getFactory().getEntityManager().createQuery(qs.toString(), CorporationKillStat.class);
                p.fillParams(query);
                query.setMaxResults(maxresults);
                return query.getResultList();
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }
}

