/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model.faction;

import enterprises.orbital.evekit.account.EveKitRefDataProvider;
import enterprises.orbital.evekit.model.AttributeParameters;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.RefCachedData;
import enterprises.orbital.evekit.model.faction.AbstractKillStat;
import enterprises.orbital.evekit.model.faction.StatAttribute;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.NoResultException;
import javax.persistence.Table;
import javax.persistence.TypedQuery;

@Entity
@Table(name="evekit_eve_charkillstat")
@NamedQueries(value={@NamedQuery(name="CharacterKillStat.get", query="SELECT c FROM CharacterKillStat c WHERE c.attribute = :attr AND c.characterID = :charid AND c.lifeStart <= :point AND c.lifeEnd > :point")})
public class CharacterKillStat
extends AbstractKillStat {
    private static final Logger log = Logger.getLogger(CharacterKillStat.class.getName());
    private int characterID;

    protected CharacterKillStat() {
        super(StatAttribute.TOTAL, 0);
    }

    public CharacterKillStat(StatAttribute attribute, int kills, int characterID) {
        super(attribute, kills);
        this.characterID = characterID;
    }

    @Override
    public void prepareTransient() {
        this.fixDates();
    }

    @Override
    public boolean equivalent(RefCachedData sup) {
        if (!(sup instanceof CharacterKillStat)) {
            return false;
        }
        if (!super.equivalent(sup)) {
            return false;
        }
        CharacterKillStat other = (CharacterKillStat)sup;
        return this.characterID == other.characterID;
    }

    public int getCharacterID() {
        return this.characterID;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CharacterKillStat that = (CharacterKillStat)o;
        return this.characterID == that.characterID;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.characterID);
    }

    @Override
    public String toString() {
        return "CharacterKillStat{characterID=" + this.characterID + ", attribute=" + (Object)((Object)this.attribute) + ", kills=" + this.kills + '}';
    }

    public static CharacterKillStat get(long time, StatAttribute attr, int characterID) throws IOException {
        try {
            return (CharacterKillStat)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitRefDataProvider.getFactory().getEntityManager().createNamedQuery("CharacterKillStat.get", CharacterKillStat.class);
                getter.setParameter("point", (Object)time);
                getter.setParameter("attr", (Object)attr);
                getter.setParameter("charid", (Object)characterID);
                try {
                    return (CharacterKillStat)getter.getSingleResult();
                }
                catch (NoResultException e) {
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static List<CharacterKillStat> accessQuery(long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector attribute, AttributeSelector characterID, AttributeSelector kills) throws IOException {
        try {
            return (List)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                StringBuilder qs = new StringBuilder();
                qs.append("SELECT c FROM CharacterKillStat c WHERE 1=1");
                AttributeSelector.addLifelineSelector((StringBuilder)qs, (String)"c", (AttributeSelector)at);
                AttributeParameters p = new AttributeParameters("att");
                AttributeSelector.addEnumSelector((StringBuilder)qs, (String)"c", (String)"attribute", (AttributeSelector)attribute, StatAttribute::valueOf, (AttributeParameters)p);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"characterID", (AttributeSelector)characterID);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"kills", (AttributeSelector)kills);
                CharacterKillStat.setCIDOrdering(qs, contid, reverse);
                TypedQuery query = EveKitRefDataProvider.getFactory().getEntityManager().createQuery(qs.toString(), CharacterKillStat.class);
                p.fillParams(query);
                query.setMaxResults(maxresults);
                return query.getResultList();
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }
}

