/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model.alliance;

import enterprises.orbital.evekit.account.EveKitRefDataProvider;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.RefCachedData;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.NoResultException;
import javax.persistence.Table;
import javax.persistence.TypedQuery;

@Entity
@Table(name="evekit_eve_alliance_member")
@NamedQueries(value={@NamedQuery(name="AllianceMemberCorporation.get", query="SELECT c FROM AllianceMemberCorporation c WHERE c.allianceID = :allianceid AND c.corporationID = :corpid AND c.lifeStart <= :point AND c.lifeEnd > :point")})
public class AllianceMemberCorporation
extends RefCachedData {
    private static final Logger log = Logger.getLogger(AllianceMemberCorporation.class.getName());
    private long allianceID;
    private long corporationID;

    protected AllianceMemberCorporation() {
    }

    public AllianceMemberCorporation(long allianceID, long corporationID) {
        this.allianceID = allianceID;
        this.corporationID = corporationID;
    }

    @Override
    public void prepareTransient() {
        this.fixDates();
    }

    @Override
    public boolean equivalent(RefCachedData sup) {
        if (!(sup instanceof AllianceMemberCorporation)) {
            return false;
        }
        AllianceMemberCorporation other = (AllianceMemberCorporation)sup;
        return this.allianceID == other.allianceID && this.corporationID == other.corporationID;
    }

    public long getAllianceID() {
        return this.allianceID;
    }

    public long getCorporationID() {
        return this.corporationID;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.allianceID ^ this.allianceID >>> 32);
        result = 31 * result + (int)(this.corporationID ^ this.corporationID >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AllianceMemberCorporation other = (AllianceMemberCorporation)obj;
        if (this.allianceID != other.allianceID) {
            return false;
        }
        return this.corporationID == other.corporationID;
    }

    @Override
    public String toString() {
        return "AllianceMemberCorporation{allianceID=" + this.allianceID + ", corporationID=" + this.corporationID + '}';
    }

    public static AllianceMemberCorporation get(long time, long allianceID, long corporationID) throws IOException {
        try {
            return (AllianceMemberCorporation)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitRefDataProvider.getFactory().getEntityManager().createNamedQuery("AllianceMemberCorporation.get", AllianceMemberCorporation.class);
                getter.setParameter("point", (Object)time);
                getter.setParameter("allianceid", (Object)allianceID);
                getter.setParameter("corpid", (Object)corporationID);
                try {
                    return (AllianceMemberCorporation)getter.getSingleResult();
                }
                catch (NoResultException e) {
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static List<AllianceMemberCorporation> accessQuery(long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector allianceID, AttributeSelector corporationID) throws IOException {
        try {
            return (List)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                StringBuilder qs = new StringBuilder();
                qs.append("SELECT c FROM AllianceMemberCorporation c WHERE 1=1");
                AttributeSelector.addLifelineSelector((StringBuilder)qs, (String)"c", (AttributeSelector)at);
                AttributeSelector.addLongSelector((StringBuilder)qs, (String)"c", (String)"allianceID", (AttributeSelector)allianceID);
                AttributeSelector.addLongSelector((StringBuilder)qs, (String)"c", (String)"corporationID", (AttributeSelector)corporationID);
                AllianceMemberCorporation.setCIDOrdering(qs, contid, reverse);
                TypedQuery query = EveKitRefDataProvider.getFactory().getEntityManager().createQuery(qs.toString(), AllianceMemberCorporation.class);
                query.setMaxResults(maxresults);
                return query.getResultList();
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }
}

