/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model.alliance;

import enterprises.orbital.evekit.account.EveKitRefDataProvider;
import enterprises.orbital.evekit.model.AttributeParameters;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.RefCachedData;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.NoResultException;
import javax.persistence.Table;
import javax.persistence.TypedQuery;

@Entity
@Table(name="evekit_eve_alliance_icon")
@NamedQueries(value={@NamedQuery(name="AllianceIcon.get", query="SELECT c FROM AllianceIcon c WHERE c.allianceID = :allianceid AND c.lifeStart <= :point AND c.lifeEnd > :point")})
public class AllianceIcon
extends RefCachedData {
    private static final Logger log = Logger.getLogger(AllianceIcon.class.getName());
    private long allianceID;
    private String px64x64;
    private String px128x128;

    protected AllianceIcon() {
    }

    public AllianceIcon(long allianceID, String px64x64, String px128x128) {
        this.allianceID = allianceID;
        this.px64x64 = px64x64;
        this.px128x128 = px128x128;
    }

    @Override
    public void prepareTransient() {
        this.fixDates();
    }

    @Override
    public boolean equivalent(RefCachedData sup) {
        if (!(sup instanceof AllianceIcon)) {
            return false;
        }
        AllianceIcon other = (AllianceIcon)sup;
        return this.allianceID == other.allianceID && AllianceIcon.nullSafeObjectCompare(this.px64x64, other.px64x64) && AllianceIcon.nullSafeObjectCompare(this.px128x128, other.px128x128);
    }

    public long getAllianceID() {
        return this.allianceID;
    }

    public String getPx64x64() {
        return this.px64x64;
    }

    public String getPx128x128() {
        return this.px128x128;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AllianceIcon that = (AllianceIcon)o;
        return this.allianceID == that.allianceID && Objects.equals(this.px64x64, that.px64x64) && Objects.equals(this.px128x128, that.px128x128);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.allianceID, this.px64x64, this.px128x128);
    }

    @Override
    public String toString() {
        return "AllianceIcon{allianceID=" + this.allianceID + ", px64x64='" + this.px64x64 + '\'' + ", px128x128='" + this.px128x128 + '\'' + '}';
    }

    public static AllianceIcon get(long time, long allianceID) throws IOException {
        try {
            return (AllianceIcon)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitRefDataProvider.getFactory().getEntityManager().createNamedQuery("AllianceIcon.get", AllianceIcon.class);
                getter.setParameter("point", (Object)time);
                getter.setParameter("allianceid", (Object)allianceID);
                try {
                    return (AllianceIcon)getter.getSingleResult();
                }
                catch (NoResultException e) {
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static List<AllianceIcon> accessQuery(long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector allianceID, AttributeSelector px64x64, AttributeSelector px128x128) throws IOException {
        try {
            return (List)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                StringBuilder qs = new StringBuilder();
                qs.append("SELECT c FROM AllianceIcon c WHERE 1=1");
                AttributeSelector.addLifelineSelector((StringBuilder)qs, (String)"c", (AttributeSelector)at);
                AttributeParameters p = new AttributeParameters("att");
                AttributeSelector.addLongSelector((StringBuilder)qs, (String)"c", (String)"allianceID", (AttributeSelector)allianceID);
                AttributeSelector.addStringSelector((StringBuilder)qs, (String)"c", (String)"px64x64", (AttributeSelector)px64x64, (AttributeParameters)p);
                AttributeSelector.addStringSelector((StringBuilder)qs, (String)"c", (String)"px128x128", (AttributeSelector)px128x128, (AttributeParameters)p);
                AllianceIcon.setCIDOrdering(qs, contid, reverse);
                TypedQuery query = EveKitRefDataProvider.getFactory().getEntityManager().createQuery(qs.toString(), AllianceIcon.class);
                p.fillParams(query);
                query.setMaxResults(maxresults);
                return query.getResultList();
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }
}

