/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model;

import enterprises.orbital.db.ConnectionFactory;
import enterprises.orbital.evekit.account.EveKitRefDataProvider;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NoResultException;
import javax.persistence.Table;
import javax.persistence.TypedQuery;

@Entity
@Table(name="evekit_ref_model_type_map")
public class RefModelTypeMap {
    private static final Logger log = Logger.getLogger(RefModelTypeMap.class.getName());
    @Id
    public long cid;
    public String typeName;

    protected RefModelTypeMap() {
    }

    public RefModelTypeMap(long cid, String typeName) {
        this.cid = cid;
        this.typeName = typeName;
    }

    public long getCid() {
        return this.cid;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public static RefModelTypeMap update(final RefModelTypeMap data) {
        try {
            return (RefModelTypeMap)EveKitRefDataProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<RefModelTypeMap>(){

                public RefModelTypeMap run() throws Exception {
                    return (RefModelTypeMap)EveKitRefDataProvider.getFactory().getEntityManager().merge((Object)data);
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static RefModelTypeMap retrieve(final long cid) {
        try {
            return (RefModelTypeMap)EveKitRefDataProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<RefModelTypeMap>(){

                public RefModelTypeMap run() throws Exception {
                    TypedQuery getter = EveKitRefDataProvider.getFactory().getEntityManager().createQuery("SELECT c FROM RefModelTypeMap c WHERE c.cid = :cid", RefModelTypeMap.class);
                    getter.setParameter("cid", (Object)cid);
                    try {
                        return (RefModelTypeMap)getter.getSingleResult();
                    }
                    catch (NoResultException e) {
                        return null;
                    }
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static String retrieveType(long cid) {
        RefModelTypeMap result = RefModelTypeMap.retrieve(cid);
        return result != null ? result.getTypeName() : null;
    }

    public static void cleanup(final long cid) {
        try {
            EveKitRefDataProvider.getFactory().runTransaction(new ConnectionFactory.RunInVoidTransaction(){

                public void run() throws Exception {
                    RefModelTypeMap toRemove = RefModelTypeMap.retrieve(cid);
                    if (toRemove != null) {
                        EveKitRefDataProvider.getFactory().getEntityManager().remove((Object)toRemove);
                    }
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
        }
    }
}

