/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import enterprises.orbital.evekit.account.EveKitRefDataProvider;
import enterprises.orbital.evekit.model.RefModelTypeMap;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.NoResultException;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.TypedQuery;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="evekit_ref_cached_data", indexes={@Index(name="lifeStartIndex", columnList="lifeStart", unique=false), @Index(name="lifeEndIndex", columnList="lifeEnd", unique=false)})
@ApiModel(description="Reference model data common properties")
public abstract class RefCachedData {
    private static final Logger log = Logger.getLogger(RefCachedData.class.getName());
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ek_ref_seq")
    @SequenceGenerator(name="ek_ref_seq", initialValue=100000, allocationSize=10, sequenceName="ref_sequence")
    @ApiModelProperty(value="Unique ID")
    private long cid;
    @ApiModelProperty(value="EveKit release version")
    private short eveKitVersion = (short)2;
    @ApiModelProperty(value="Model lifeline start (milliseconds UTC)")
    protected long lifeStart;
    @ApiModelProperty(value="Model lifeline end (milliseconds UTC), MAX_LONG for live data")
    protected long lifeEnd;
    @Transient
    @ApiModelProperty(value="lifeStart Date")
    @JsonProperty(value="lifeStartDate")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date lifeStartDate;
    @Transient
    @ApiModelProperty(value="lifeEnd Date")
    @JsonProperty(value="lifeEndDate")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date lifeEndDate;

    public abstract void prepareTransient();

    protected Date assignDateField(long dateValue) {
        long MAX_PARSEABLE_DATE = 253370782800000L;
        return dateValue < 0L ? null : new Date(Math.min(dateValue, 253370782800000L));
    }

    protected void fixDates() {
        this.lifeStartDate = this.assignDateField(this.lifeStart);
        this.lifeEndDate = this.assignDateField(this.lifeEnd);
    }

    public static boolean nullSafeObjectCompare(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public final void setup(long start) {
        this.lifeStart = start;
        this.lifeEnd = Long.MAX_VALUE;
    }

    public final void dup(RefCachedData target) {
        target.eveKitVersion = this.eveKitVersion;
        target.lifeStart = this.lifeStart;
        target.lifeEnd = this.lifeEnd;
    }

    public final void evolve(RefCachedData other, long time) {
        this.setLifeEnd(time);
        if (other != null) {
            this.dup(other);
            other.lifeStart = time;
            other.setLifeEnd(Long.MAX_VALUE);
        }
    }

    public abstract boolean equivalent(RefCachedData var1);

    public long getCid() {
        return this.cid;
    }

    public short getEveKitVersion() {
        return this.eveKitVersion;
    }

    public void setEveKitVersion(short eveKitVersion) {
        this.eveKitVersion = eveKitVersion;
    }

    public void setLifeStart(long lifeStart) {
        this.lifeStart = lifeStart;
    }

    public long getLifeStart() {
        return this.lifeStart;
    }

    public long getLifeEnd() {
        return this.lifeEnd;
    }

    public void setLifeEnd(long lifeEnd) {
        this.lifeEnd = lifeEnd;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.cid ^ this.cid >>> 32);
        result = 31 * result + this.eveKitVersion;
        result = 31 * result + (int)(this.lifeEnd ^ this.lifeEnd >>> 32);
        result = 31 * result + (int)(this.lifeStart ^ this.lifeStart >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RefCachedData other = (RefCachedData)obj;
        if (this.cid != other.cid) {
            return false;
        }
        if (this.eveKitVersion != other.eveKitVersion) {
            return false;
        }
        if (this.lifeEnd != other.lifeEnd) {
            return false;
        }
        return this.lifeStart == other.lifeStart;
    }

    public String toString() {
        return "PublicCachedData [cid=" + this.cid + ", eveKitVersion=" + this.eveKitVersion + ", lifeStart=" + this.lifeStart + ", lifeEnd=" + this.lifeEnd + "]";
    }

    protected static void setCIDOrdering(StringBuilder qs, long contid, boolean reverse) {
        if (reverse) {
            qs.append(" and c.cid < ").append(contid);
            qs.append(" order by cid desc");
        } else {
            qs.append(" and c.cid > ").append(contid);
            qs.append(" order by cid asc");
        }
    }

    public static RefCachedData getByCIDandTable(long cid, String tableName) throws IOException {
        try {
            return (RefCachedData)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitRefDataProvider.getFactory().getEntityManager().createQuery("SELECT c FROM " + tableName + " c WHERE c.cid = :cid", RefCachedData.class);
                getter.setParameter("cid", (Object)cid);
                try {
                    return (RefCachedData)getter.getSingleResult();
                }
                catch (NoResultException e) {
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static RefCachedData getByCID(long cid) throws IOException {
        String type = RefModelTypeMap.retrieveType(cid);
        if (type == null) {
            return null;
        }
        return RefCachedData.getByCIDandTable(cid, type);
    }

    public static <A extends RefCachedData> A update(A data) throws IOException {
        try {
            return (A)((RefCachedData)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                RefCachedData result = (RefCachedData)EveKitRefDataProvider.getFactory().getEntityManager().merge((Object)data);
                String typeName = data.getClass().getSimpleName();
                RefModelTypeMap tn = new RefModelTypeMap(result.getCid(), typeName);
                if (RefModelTypeMap.update(tn) == null) {
                    return null;
                }
                return result;
            }));
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }
}

