/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model.sov;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import enterprises.orbital.evekit.account.EveKitRefDataProvider;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.RefCachedData;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.NoResultException;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.TypedQuery;

@Entity
@Table(name="evekit_sov_structure")
@NamedQueries(value={@NamedQuery(name="SovereigntyStructure.get", query="SELECT c FROM SovereigntyStructure c WHERE c.structureID = :structureid AND c.lifeStart <= :point AND c.lifeEnd > :point")})
public class SovereigntyStructure
extends RefCachedData {
    private static final Logger log = Logger.getLogger(SovereigntyStructure.class.getName());
    private int allianceID;
    private int systemID;
    private long structureID;
    private int structureTypeID;
    private float vulnerabilityOccupancyLevel;
    private long vulnerableStartTime;
    private long vulnerableEndTime;
    @Transient
    @ApiModelProperty(value="Vulnerable Start Time Date")
    @JsonProperty(value="vulnerableStartTimeDate")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date vulnerableStartTimeDate;
    @Transient
    @ApiModelProperty(value="Vulnerable End Time Date")
    @JsonProperty(value="vulnerableEndTimeDate")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date vulnerableEndTimeDate;

    protected SovereigntyStructure() {
    }

    public SovereigntyStructure(int allianceID, int systemID, long structureID, int structureTypeID, float vulnerabilityOccupancyLevel, long vulnerableStartTime, long vulnerableEndTime) {
        this.allianceID = allianceID;
        this.systemID = systemID;
        this.structureID = structureID;
        this.structureTypeID = structureTypeID;
        this.vulnerabilityOccupancyLevel = vulnerabilityOccupancyLevel;
        this.vulnerableStartTime = vulnerableStartTime;
        this.vulnerableEndTime = vulnerableEndTime;
    }

    @Override
    public void prepareDates() {
        this.fixDates();
        this.vulnerableStartTimeDate = this.assignDateField(this.vulnerableStartTime);
        this.vulnerableEndTimeDate = this.assignDateField(this.vulnerableEndTime);
    }

    @Override
    public boolean equivalent(RefCachedData sup) {
        if (!(sup instanceof SovereigntyStructure)) {
            return false;
        }
        SovereigntyStructure other = (SovereigntyStructure)sup;
        return this.allianceID == other.allianceID && this.systemID == other.systemID && this.structureID == other.structureID && this.structureTypeID == other.structureTypeID && this.vulnerabilityOccupancyLevel == other.vulnerabilityOccupancyLevel && this.vulnerableStartTime == other.vulnerableStartTime && this.vulnerableEndTime == other.vulnerableEndTime;
    }

    public int getAllianceID() {
        return this.allianceID;
    }

    public int getSystemID() {
        return this.systemID;
    }

    public long getStructureID() {
        return this.structureID;
    }

    public int getStructureTypeID() {
        return this.structureTypeID;
    }

    public float getVulnerabilityOccupancyLevel() {
        return this.vulnerabilityOccupancyLevel;
    }

    public long getVulnerableStartTime() {
        return this.vulnerableStartTime;
    }

    public long getVulnerableEndTime() {
        return this.vulnerableEndTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SovereigntyStructure that = (SovereigntyStructure)o;
        return this.allianceID == that.allianceID && this.systemID == that.systemID && this.structureID == that.structureID && this.structureTypeID == that.structureTypeID && Float.compare(that.vulnerabilityOccupancyLevel, this.vulnerabilityOccupancyLevel) == 0 && this.vulnerableStartTime == that.vulnerableStartTime && this.vulnerableEndTime == that.vulnerableEndTime;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.allianceID, this.systemID, this.structureID, this.structureTypeID, Float.valueOf(this.vulnerabilityOccupancyLevel), this.vulnerableStartTime, this.vulnerableEndTime);
    }

    @Override
    public String toString() {
        return "SovereigntyStructure{allianceID=" + this.allianceID + ", systemID=" + this.systemID + ", structureID=" + this.structureID + ", structureTypeID=" + this.structureTypeID + ", vulnerabilityOccupancyLevel=" + this.vulnerabilityOccupancyLevel + ", vulnerableStartTime=" + this.vulnerableStartTime + ", vulnerableEndTime=" + this.vulnerableEndTime + ", vulnerableStartTimeDate=" + this.vulnerableStartTimeDate + ", vulnerableEndTimeDate=" + this.vulnerableEndTimeDate + '}';
    }

    public static SovereigntyStructure get(long time, long structureID) throws IOException {
        try {
            return (SovereigntyStructure)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitRefDataProvider.getFactory().getEntityManager().createNamedQuery("SovereigntyStructure.get", SovereigntyStructure.class);
                getter.setParameter("point", (Object)time);
                getter.setParameter("structureid", (Object)structureID);
                try {
                    return (SovereigntyStructure)getter.getSingleResult();
                }
                catch (NoResultException e) {
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static List<SovereigntyStructure> accessQuery(long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector allianceID, AttributeSelector systemID, AttributeSelector structureID, AttributeSelector structureTypeID, AttributeSelector vulnerabilityOccupancyLevel, AttributeSelector vulnerableStartTime, AttributeSelector vulnerableEndTime) throws IOException {
        try {
            return (List)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                StringBuilder qs = new StringBuilder();
                qs.append("SELECT c FROM SovereigntyStructure c WHERE 1=1");
                AttributeSelector.addLifelineSelector((StringBuilder)qs, (String)"c", (AttributeSelector)at);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"allianceID", (AttributeSelector)allianceID);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"systemID", (AttributeSelector)systemID);
                AttributeSelector.addLongSelector((StringBuilder)qs, (String)"c", (String)"structureID", (AttributeSelector)structureID);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"structureTypeID", (AttributeSelector)structureTypeID);
                AttributeSelector.addFloatSelector((StringBuilder)qs, (String)"c", (String)"vulnerabilityOccupancyLevel", (AttributeSelector)vulnerabilityOccupancyLevel);
                AttributeSelector.addLongSelector((StringBuilder)qs, (String)"c", (String)"vulnerableStartTime", (AttributeSelector)vulnerableStartTime);
                AttributeSelector.addLongSelector((StringBuilder)qs, (String)"c", (String)"vulnerableEndTime", (AttributeSelector)vulnerableEndTime);
                SovereigntyStructure.setCIDOrdering(qs, contid, reverse);
                TypedQuery query = EveKitRefDataProvider.getFactory().getEntityManager().createQuery(qs.toString(), SovereigntyStructure.class);
                query.setMaxResults(maxresults);
                return query.getResultList();
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }
}

