/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model.server;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import enterprises.orbital.evekit.account.EveKitRefDataProvider;
import enterprises.orbital.evekit.model.AttributeParameters;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.RefCachedData;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.NoResultException;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.TypedQuery;

@Entity
@Table(name="evekit_server_server_status")
@NamedQueries(value={@NamedQuery(name="ServerStatus.get", query="SELECT c FROM ServerStatus c where c.lifeStart <= :point and c.lifeEnd > :point")})
public class ServerStatus
extends RefCachedData {
    private static final Logger log = Logger.getLogger(ServerStatus.class.getName());
    private int onlinePlayers;
    private long startTime;
    private String serverVersion;
    private boolean vip;
    @Transient
    @ApiModelProperty(value="StartTime Date")
    @JsonProperty(value="startTimeDate")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date startTimeDate;

    protected ServerStatus() {
    }

    public ServerStatus(int onlinePlayers, long startTime, String serverVersion, boolean vip) {
        this.onlinePlayers = onlinePlayers;
        this.startTime = startTime;
        this.serverVersion = serverVersion;
        this.vip = vip;
    }

    @Override
    public void prepareDates() {
        this.fixDates();
        this.startTimeDate = this.assignDateField(this.startTime);
    }

    @Override
    public boolean equivalent(RefCachedData sup) {
        if (!(sup instanceof ServerStatus)) {
            return false;
        }
        ServerStatus other = (ServerStatus)sup;
        return this.onlinePlayers == other.onlinePlayers && this.startTime == other.startTime && ServerStatus.nullSafeObjectCompare(this.serverVersion, other.serverVersion) && this.vip == other.vip;
    }

    public int getOnlinePlayers() {
        return this.onlinePlayers;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public boolean isVip() {
        return this.vip;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServerStatus that = (ServerStatus)o;
        return this.onlinePlayers == that.onlinePlayers && this.startTime == that.startTime && this.vip == that.vip && Objects.equals(this.serverVersion, that.serverVersion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.onlinePlayers, this.startTime, this.serverVersion, this.vip);
    }

    @Override
    public String toString() {
        return "ServerStatus{onlinePlayers=" + this.onlinePlayers + ", startTime=" + this.startTime + ", serverVersion='" + this.serverVersion + '\'' + ", vip=" + this.vip + ", startTimeDate=" + this.startTimeDate + '}';
    }

    public static ServerStatus get(long time) throws IOException {
        try {
            return (ServerStatus)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitRefDataProvider.getFactory().getEntityManager().createNamedQuery("ServerStatus.get", ServerStatus.class);
                getter.setParameter("point", (Object)time);
                try {
                    return (ServerStatus)getter.getSingleResult();
                }
                catch (NoResultException e) {
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static List<ServerStatus> accessQuery(long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector onlinePlayers, AttributeSelector startTime, AttributeSelector serverVersion, AttributeSelector vip) throws IOException {
        try {
            return (List)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                StringBuilder qs = new StringBuilder();
                qs.append("SELECT c FROM ServerStatus c WHERE 1=1");
                AttributeSelector.addLifelineSelector((StringBuilder)qs, (String)"c", (AttributeSelector)at);
                AttributeParameters p = new AttributeParameters("att");
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"onlinePlayers", (AttributeSelector)onlinePlayers);
                AttributeSelector.addLongSelector((StringBuilder)qs, (String)"c", (String)"startTime", (AttributeSelector)startTime);
                AttributeSelector.addStringSelector((StringBuilder)qs, (String)"c", (String)"serverVersion", (AttributeSelector)serverVersion, (AttributeParameters)p);
                AttributeSelector.addBooleanSelector((StringBuilder)qs, (String)"c", (String)"vip", (AttributeSelector)vip);
                ServerStatus.setCIDOrdering(qs, contid, reverse);
                TypedQuery query = EveKitRefDataProvider.getFactory().getEntityManager().createQuery(qs.toString(), ServerStatus.class);
                p.fillParams(query);
                query.setMaxResults(maxresults);
                return query.getResultList();
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }
}

