/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model.faction;

import enterprises.orbital.evekit.account.EveKitRefDataProvider;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.RefCachedData;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.NoResultException;
import javax.persistence.Table;
import javax.persistence.TypedQuery;

@Entity
@Table(name="evekit_eve_factionwar")
@NamedQueries(value={@NamedQuery(name="FactionWar.get", query="SELECT c FROM FactionWar c WHERE c.againstID = :aid AND c.factionID = :fid AND c.lifeStart <= :point AND c.lifeEnd > :point")})
public class FactionWar
extends RefCachedData {
    private static final Logger log = Logger.getLogger(FactionWar.class.getName());
    private int againstID;
    private int factionID;

    protected FactionWar() {
    }

    public FactionWar(int againstID, int factionID) {
        this.againstID = againstID;
        this.factionID = factionID;
    }

    @Override
    public void prepareDates() {
        this.fixDates();
    }

    @Override
    public boolean equivalent(RefCachedData sup) {
        if (!(sup instanceof FactionWar)) {
            return false;
        }
        FactionWar other = (FactionWar)sup;
        return this.againstID == other.againstID && this.factionID == other.factionID;
    }

    public int getAgainstID() {
        return this.againstID;
    }

    public int getFactionID() {
        return this.factionID;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FactionWar that = (FactionWar)o;
        return this.againstID == that.againstID && this.factionID == that.factionID;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.againstID, this.factionID);
    }

    @Override
    public String toString() {
        return "FactionWar{againstID=" + this.againstID + ", factionID=" + this.factionID + '}';
    }

    public static FactionWar get(long time, int againstID, int factionID) throws IOException {
        try {
            return (FactionWar)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitRefDataProvider.getFactory().getEntityManager().createNamedQuery("FactionWar.get", FactionWar.class);
                getter.setParameter("point", (Object)time);
                getter.setParameter("aid", (Object)againstID);
                getter.setParameter("fid", (Object)factionID);
                try {
                    return (FactionWar)getter.getSingleResult();
                }
                catch (NoResultException e) {
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static List<FactionWar> accessQuery(long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector againstID, AttributeSelector factionID) throws IOException {
        try {
            return (List)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                StringBuilder qs = new StringBuilder();
                qs.append("SELECT c FROM FactionWar c WHERE 1=1");
                AttributeSelector.addLifelineSelector((StringBuilder)qs, (String)"c", (AttributeSelector)at);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"againstID", (AttributeSelector)againstID);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"factionID", (AttributeSelector)factionID);
                FactionWar.setCIDOrdering(qs, contid, reverse);
                TypedQuery query = EveKitRefDataProvider.getFactory().getEntityManager().createQuery(qs.toString(), FactionWar.class);
                query.setMaxResults(maxresults);
                return query.getResultList();
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }
}

