/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model.faction;

import enterprises.orbital.evekit.account.EveKitRefDataProvider;
import enterprises.orbital.evekit.model.AttributeParameters;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.RefCachedData;
import enterprises.orbital.evekit.model.faction.AbstractVictoryPointStat;
import enterprises.orbital.evekit.model.faction.StatAttribute;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.NoResultException;
import javax.persistence.Table;
import javax.persistence.TypedQuery;

@Entity
@Table(name="evekit_eve_charvpstat")
@NamedQueries(value={@NamedQuery(name="CharacterVictoryPointStat.get", query="SELECT c FROM CharacterVictoryPointStat c WHERE c.attribute = :attr AND c.characterID = :charid AND c.lifeStart <= :point AND c.lifeEnd > :point")})
public class CharacterVictoryPointStat
extends AbstractVictoryPointStat {
    private static final Logger log = Logger.getLogger(CharacterVictoryPointStat.class.getName());
    private int characterID;

    protected CharacterVictoryPointStat() {
        super(StatAttribute.TOTAL, 0);
    }

    public CharacterVictoryPointStat(StatAttribute attribute, int victoryPoints, int characterID) {
        super(attribute, victoryPoints);
        this.characterID = characterID;
    }

    @Override
    public void prepareDates() {
        this.fixDates();
    }

    @Override
    public boolean equivalent(RefCachedData sup) {
        if (!(sup instanceof CharacterVictoryPointStat)) {
            return false;
        }
        if (!super.equivalent(sup)) {
            return false;
        }
        CharacterVictoryPointStat other = (CharacterVictoryPointStat)sup;
        return this.characterID == other.characterID;
    }

    public int getCharacterID() {
        return this.characterID;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CharacterVictoryPointStat that = (CharacterVictoryPointStat)o;
        return this.characterID == that.characterID;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.characterID);
    }

    @Override
    public String toString() {
        return "CharacterVictoryPointStat{characterID=" + this.characterID + ", attribute=" + (Object)((Object)this.attribute) + ", victoryPoints=" + this.victoryPoints + '}';
    }

    public static CharacterVictoryPointStat get(long time, StatAttribute attr, int characterID) throws IOException {
        try {
            return (CharacterVictoryPointStat)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitRefDataProvider.getFactory().getEntityManager().createNamedQuery("CharacterVictoryPointStat.get", CharacterVictoryPointStat.class);
                getter.setParameter("point", (Object)time);
                getter.setParameter("attr", (Object)attr);
                getter.setParameter("charid", (Object)characterID);
                try {
                    return (CharacterVictoryPointStat)getter.getSingleResult();
                }
                catch (NoResultException e) {
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static List<CharacterVictoryPointStat> accessQuery(long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector attribute, AttributeSelector characterID, AttributeSelector victoryPoints) throws IOException {
        try {
            return (List)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                StringBuilder qs = new StringBuilder();
                qs.append("SELECT c FROM CharacterVictoryPointStat c WHERE 1=1");
                AttributeSelector.addLifelineSelector((StringBuilder)qs, (String)"c", (AttributeSelector)at);
                AttributeParameters p = new AttributeParameters("att");
                AttributeSelector.addEnumSelector((StringBuilder)qs, (String)"c", (String)"attribute", (AttributeSelector)attribute, StatAttribute::valueOf, (AttributeParameters)p);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"characterID", (AttributeSelector)characterID);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"victoryPoints", (AttributeSelector)victoryPoints);
                CharacterVictoryPointStat.setCIDOrdering(qs, contid, reverse);
                TypedQuery query = EveKitRefDataProvider.getFactory().getEntityManager().createQuery(qs.toString(), CharacterVictoryPointStat.class);
                p.fillParams(query);
                query.setMaxResults(maxresults);
                return query.getResultList();
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }
}

