/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model.alliance;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import enterprises.orbital.evekit.account.EveKitRefDataProvider;
import enterprises.orbital.evekit.model.AttributeParameters;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.RefCachedData;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.NoResultException;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.TypedQuery;

@Entity
@Table(name="evekit_eve_alliance")
@NamedQueries(value={@NamedQuery(name="Alliance.get", query="SELECT c FROM Alliance c WHERE c.allianceID = :allianceid AND c.lifeStart <= :point AND c.lifeEnd > :point")})
public class Alliance
extends RefCachedData {
    private static final Logger log = Logger.getLogger(Alliance.class.getName());
    private long allianceID;
    private long executorCorpID;
    private int memberCount;
    private String name;
    private String shortName;
    private long startDate;
    @Transient
    @ApiModelProperty(value="startDate Date")
    @JsonProperty(value="startDateDate")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date startDateDate;
    private long creatorID;
    private long creatorCorpID;
    private int factionID;

    protected Alliance() {
    }

    public Alliance(long allianceID, long executorCorpID, int memberCount, String name, String shortName, long startDate, long creatorID, long creatorCorpID, int factionID) {
        this.allianceID = allianceID;
        this.executorCorpID = executorCorpID;
        this.memberCount = memberCount;
        this.name = name;
        this.shortName = shortName;
        this.startDate = startDate;
        this.creatorID = creatorID;
        this.creatorCorpID = creatorCorpID;
        this.factionID = factionID;
    }

    @Override
    public void prepareDates() {
        this.fixDates();
        this.startDateDate = this.assignDateField(this.startDate);
    }

    @Override
    public boolean equivalent(RefCachedData sup) {
        if (!(sup instanceof Alliance)) {
            return false;
        }
        Alliance other = (Alliance)sup;
        return this.allianceID == other.allianceID && this.executorCorpID == other.executorCorpID && this.memberCount == other.memberCount && Alliance.nullSafeObjectCompare(this.name, other.name) && Alliance.nullSafeObjectCompare(this.shortName, other.shortName) && this.startDate == other.startDate && this.creatorID == other.creatorID && this.creatorCorpID == other.creatorCorpID && this.factionID == other.factionID;
    }

    public long getAllianceID() {
        return this.allianceID;
    }

    public long getExecutorCorpID() {
        return this.executorCorpID;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public long getStartDate() {
        return this.startDate;
    }

    public long getCreatorID() {
        return this.creatorID;
    }

    public long getCreatorCorpID() {
        return this.creatorCorpID;
    }

    public int getFactionID() {
        return this.factionID;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Alliance alliance = (Alliance)o;
        return this.allianceID == alliance.allianceID && this.executorCorpID == alliance.executorCorpID && this.memberCount == alliance.memberCount && this.startDate == alliance.startDate && this.creatorID == alliance.creatorID && this.creatorCorpID == alliance.creatorCorpID && this.factionID == alliance.factionID && Objects.equals(this.name, alliance.name) && Objects.equals(this.shortName, alliance.shortName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.allianceID, this.executorCorpID, this.memberCount, this.name, this.shortName, this.startDate, this.creatorID, this.creatorCorpID, this.factionID);
    }

    @Override
    public String toString() {
        return "Alliance{allianceID=" + this.allianceID + ", executorCorpID=" + this.executorCorpID + ", memberCount=" + this.memberCount + ", name='" + this.name + '\'' + ", shortName='" + this.shortName + '\'' + ", startDate=" + this.startDate + ", startDateDate=" + this.startDateDate + ", creatorID=" + this.creatorID + ", creatorCorpID=" + this.creatorCorpID + ", factionID=" + this.factionID + '}';
    }

    public static Alliance get(long time, long allianceID) throws IOException {
        try {
            return (Alliance)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitRefDataProvider.getFactory().getEntityManager().createNamedQuery("Alliance.get", Alliance.class);
                getter.setParameter("point", (Object)time);
                getter.setParameter("allianceid", (Object)allianceID);
                try {
                    return (Alliance)getter.getSingleResult();
                }
                catch (NoResultException e) {
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static List<Alliance> accessQuery(long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector allianceID, AttributeSelector executorCorpID, AttributeSelector memberCount, AttributeSelector name, AttributeSelector shortName, AttributeSelector startDate, AttributeSelector creatorID, AttributeSelector creatorCorpID, AttributeSelector factionID) throws IOException {
        try {
            return (List)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                StringBuilder qs = new StringBuilder();
                qs.append("SELECT c FROM Alliance c WHERE 1=1");
                AttributeSelector.addLifelineSelector((StringBuilder)qs, (String)"c", (AttributeSelector)at);
                AttributeParameters p = new AttributeParameters("att");
                AttributeSelector.addLongSelector((StringBuilder)qs, (String)"c", (String)"allianceID", (AttributeSelector)allianceID);
                AttributeSelector.addLongSelector((StringBuilder)qs, (String)"c", (String)"executorCorpID", (AttributeSelector)executorCorpID);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"memberCount", (AttributeSelector)memberCount);
                AttributeSelector.addStringSelector((StringBuilder)qs, (String)"c", (String)"name", (AttributeSelector)name, (AttributeParameters)p);
                AttributeSelector.addStringSelector((StringBuilder)qs, (String)"c", (String)"shortName", (AttributeSelector)shortName, (AttributeParameters)p);
                AttributeSelector.addLongSelector((StringBuilder)qs, (String)"c", (String)"startDate", (AttributeSelector)startDate);
                AttributeSelector.addLongSelector((StringBuilder)qs, (String)"c", (String)"creatorID", (AttributeSelector)creatorID);
                AttributeSelector.addLongSelector((StringBuilder)qs, (String)"c", (String)"creatorCorpID", (AttributeSelector)creatorCorpID);
                AttributeSelector.addIntSelector((StringBuilder)qs, (String)"c", (String)"factionID", (AttributeSelector)factionID);
                Alliance.setCIDOrdering(qs, contid, reverse);
                TypedQuery query = EveKitRefDataProvider.getFactory().getEntityManager().createQuery(qs.toString(), Alliance.class);
                p.fillParams(query);
                query.setMaxResults(maxresults);
                return query.getResultList();
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }
}

