/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.ws.corporation;

import enterprises.orbital.evekit.account.AccountAccessMask;
import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.ESISyncEndpoint;
import enterprises.orbital.evekit.model.corporation.ContainerLog;
import enterprises.orbital.evekit.model.corporation.CorporationMedal;
import enterprises.orbital.evekit.model.corporation.CorporationMemberMedal;
import enterprises.orbital.evekit.model.corporation.CorporationSheet;
import enterprises.orbital.evekit.model.corporation.CorporationTitle;
import enterprises.orbital.evekit.model.corporation.CorporationTitleRole;
import enterprises.orbital.evekit.model.corporation.CustomsOffice;
import enterprises.orbital.evekit.model.corporation.Division;
import enterprises.orbital.evekit.model.corporation.Facility;
import enterprises.orbital.evekit.model.corporation.Fuel;
import enterprises.orbital.evekit.model.corporation.Member;
import enterprises.orbital.evekit.model.corporation.MemberLimit;
import enterprises.orbital.evekit.model.corporation.MemberRole;
import enterprises.orbital.evekit.model.corporation.MemberRoleHistory;
import enterprises.orbital.evekit.model.corporation.MemberTitle;
import enterprises.orbital.evekit.model.corporation.MemberTracking;
import enterprises.orbital.evekit.model.corporation.MiningExtraction;
import enterprises.orbital.evekit.model.corporation.MiningObservation;
import enterprises.orbital.evekit.model.corporation.MiningObserver;
import enterprises.orbital.evekit.model.corporation.Shareholder;
import enterprises.orbital.evekit.model.corporation.Starbase;
import enterprises.orbital.evekit.ws.AccountHandlerUtil;
import enterprises.orbital.evekit.ws.ServiceError;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/ws/v1/corp")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(tags={"Corporation"}, produces="application/json", consumes="application/json")
public class ModelCorporationWS {
    @Path(value="/container_log")
    @GET
    @ApiOperation(value="Get container log records")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested container log records", response=ContainerLog.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getContainerLogs(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="logTime") @DefaultValue(value="{ any: true }") @ApiParam(name="logTime", defaultValue="{ any: true }", value="Corporation container log time selector") AttributeSelector logTime, @QueryParam(value="action") @DefaultValue(value="{ any: true }") @ApiParam(name="action", defaultValue="{ any: true }", value="Corporation container log action selector") AttributeSelector action, @QueryParam(value="characterID") @DefaultValue(value="{ any: true }") @ApiParam(name="characterID", defaultValue="{ any: true }", value="Corporation container log character ID selector") AttributeSelector characterID, @QueryParam(value="locationFlag") @DefaultValue(value="{ any: true }") @ApiParam(name="locationFlag", defaultValue="{ any: true }", value="Corporation container log location flag selector") AttributeSelector locationFlag, @QueryParam(value="containerID") @DefaultValue(value="{ any: true }") @ApiParam(name="containerID", defaultValue="{ any: true }", value="Corporation container log container ID selector") AttributeSelector containerID, @QueryParam(value="containerTypeID") @DefaultValue(value="{ any: true }") @ApiParam(name="containerTypeID", defaultValue="{ any: true }", value="Corporation container log container type ID selector") AttributeSelector containerTypeID, @QueryParam(value="locationID") @DefaultValue(value="{ any: true }") @ApiParam(name="locationID", defaultValue="{ any: true }", value="Corporation container log location ID selector") AttributeSelector locationID, @QueryParam(value="newConfiguration") @DefaultValue(value="{ any: true }") @ApiParam(name="newConfiguration", defaultValue="{ any: true }", value="Corporation container log new configuration selector") AttributeSelector newConfiguration, @QueryParam(value="oldConfiguration") @DefaultValue(value="{ any: true }") @ApiParam(name="oldConfiguration", defaultValue="{ any: true }", value="Corporation container log old configuration selector") AttributeSelector oldConfiguration, @QueryParam(value="passwordType") @DefaultValue(value="{ any: true }") @ApiParam(name="passwordType", defaultValue="{ any: true }", value="Corporation container log password type selector") AttributeSelector passwordType, @QueryParam(value="quantity") @DefaultValue(value="{ any: true }") @ApiParam(name="quantity", defaultValue="{ any: true }", value="Corporation container log quantity selector") AttributeSelector quantity, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", defaultValue="{ any: true }", value="Corporation container log type ID selector") AttributeSelector typeID) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_CONTAINER_LOG, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<ContainerLog>(){

            @Override
            public List<ContainerLog> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean LOG_TIME = false;
                boolean ACTION = true;
                int CHARACTER_ID = 2;
                int LOCATION_FLAG = 3;
                int CONTAINER_ID = 4;
                int CONTAINER_TYPE_ID = 5;
                int LOCATION_ID = 6;
                int NEW_CONFIGURATION = 7;
                int OLD_CONFIGURATION = 8;
                int PASSWORD_TYPE = 9;
                int QUANTITY = 10;
                int TYPE_ID = 11;
                return ContainerLog.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5], (AttributeSelector)others[6], (AttributeSelector)others[7], (AttributeSelector)others[8], (AttributeSelector)others[9], (AttributeSelector)others[10], (AttributeSelector)others[11]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CORP_CONTAINER_LOGS, acct);
            }
        }, request, logTime, action, characterID, locationFlag, containerID, containerTypeID, locationID, newConfiguration, oldConfiguration, passwordType, quantity, typeID);
    }

    @Path(value="/medal")
    @GET
    @ApiOperation(value="Get corporation medals")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested corporation medals", response=CorporationMedal.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getCorporationMedals(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="medalID") @DefaultValue(value="{ any: true }") @ApiParam(name="medalID", defaultValue="{ any: true }", value="Corporation medal ID selector") AttributeSelector medalID, @QueryParam(value="description") @DefaultValue(value="{ any: true }") @ApiParam(name="description", defaultValue="{ any: true }", value="Corporation medal description selector") AttributeSelector description, @QueryParam(value="title") @DefaultValue(value="{ any: true }") @ApiParam(name="title", defaultValue="{ any: true }", value="Corporation medal title selector") AttributeSelector title, @QueryParam(value="created") @DefaultValue(value="{ any: true }") @ApiParam(name="created", defaultValue="{ any: true }", value="Corporation medal created date selector") AttributeSelector created, @QueryParam(value="creatorID") @DefaultValue(value="{ any: true }") @ApiParam(name="creatorID", defaultValue="{ any: true }", value="Corporation medal creator ID selector") AttributeSelector creatorID) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_CORPORATION_MEDALS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<CorporationMedal>(){

            @Override
            public List<CorporationMedal> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean MEDAL_ID = false;
                boolean DESCRIPTION = true;
                int TITLE = 2;
                int CREATED = 3;
                int CREATOR_ID = 4;
                return CorporationMedal.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CORP_MEDALS, acct);
            }
        }, request, medalID, description, title, created, creatorID);
    }

    @Path(value="/member_medal")
    @GET
    @ApiOperation(value="Get medals awarded to corporation members")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested medals awarded to corporation members", response=CorporationMemberMedal.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getMemberMedals(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="medalID") @DefaultValue(value="{ any: true }") @ApiParam(name="medalID", defaultValue="{ any: true }", value="Member medal ID selector") AttributeSelector medalID, @QueryParam(value="characterID") @DefaultValue(value="{ any: true }") @ApiParam(name="characterID", defaultValue="{ any: true }", value="Member medal character ID selector") AttributeSelector characterID, @QueryParam(value="issued") @DefaultValue(value="{ any: true }") @ApiParam(name="issued", defaultValue="{ any: true }", value="Member medal issued date selector") AttributeSelector issued, @QueryParam(value="issuerID") @DefaultValue(value="{ any: true }") @ApiParam(name="issuerID", defaultValue="{ any: true }", value="Member medal issuer ID selector") AttributeSelector issuerID, @QueryParam(value="reason") @DefaultValue(value="{ any: true }") @ApiParam(name="reason", defaultValue="{ any: true }", value="Member medal reason selector") AttributeSelector reason, @QueryParam(value="status") @DefaultValue(value="{ any: true }") @ApiParam(name="status", defaultValue="{ any: true }", value="Member medal status selector") AttributeSelector status) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_MEMBER_MEDALS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<CorporationMemberMedal>(){

            @Override
            public List<CorporationMemberMedal> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean MEDAL_ID = false;
                boolean CHARACTER_ID = true;
                int ISSUED = 2;
                int ISSUER_ID = 3;
                int REASON = 4;
                int STATUS = 5;
                return CorporationMemberMedal.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CORP_MEDALS, acct);
            }
        }, request, medalID, characterID, issued, issuerID, reason, status);
    }

    @Path(value="/sheet")
    @GET
    @ApiOperation(value="Get corporation sheet")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested corporation sheets", response=CorporationSheet.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getCorporationSheet(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="allianceID") @DefaultValue(value="{ any: true }") @ApiParam(name="allianceID", defaultValue="{ any: true }", value="Corporation alliance ID selector") AttributeSelector allianceID, @QueryParam(value="ceoID") @DefaultValue(value="{ any: true }") @ApiParam(name="ceoID", defaultValue="{ any: true }", value="Corporation CEO ID selector") AttributeSelector ceoID, @QueryParam(value="corporationID") @DefaultValue(value="{ any: true }") @ApiParam(name="corporationID", defaultValue="{ any: true }", value="Corporation ID selector") AttributeSelector corporationID, @QueryParam(value="corporationName") @DefaultValue(value="{ any: true }") @ApiParam(name="corporationName", defaultValue="{ any: true }", value="Corporation name selector") AttributeSelector corporationName, @QueryParam(value="description") @DefaultValue(value="{ any: true }") @ApiParam(name="description", defaultValue="{ any: true }", value="Corporation description selector") AttributeSelector description, @QueryParam(value="memberCount") @DefaultValue(value="{ any: true }") @ApiParam(name="memberCount", defaultValue="{ any: true }", value="Corporation member count selector") AttributeSelector memberCount, @QueryParam(value="shares") @DefaultValue(value="{ any: true }") @ApiParam(name="shares", defaultValue="{ any: true }", value="Corporation shares selector") AttributeSelector shares, @QueryParam(value="stationID") @DefaultValue(value="{ any: true }") @ApiParam(name="stationID", defaultValue="{ any: true }", value="Corporation station ID selector") AttributeSelector stationID, @QueryParam(value="taxRate") @DefaultValue(value="{ any: true }") @ApiParam(name="taxRate", defaultValue="{ any: true }", value="Corporation tax rate selector") AttributeSelector taxRate, @QueryParam(value="ticker") @DefaultValue(value="{ any: true }") @ApiParam(name="ticker", defaultValue="{ any: true }", value="Corporation ticker selector") AttributeSelector ticker, @QueryParam(value="url") @DefaultValue(value="{ any: true }") @ApiParam(name="url", defaultValue="{ any: true }", value="Corporation URL selector") AttributeSelector url, @QueryParam(value="dateFounded") @DefaultValue(value="{ any: true }") @ApiParam(name="dateFounded", defaultValue="{ any: true }", value="Corporation founding date selector") AttributeSelector dateFounded, @QueryParam(value="creatorID") @DefaultValue(value="{ any: true }") @ApiParam(name="creatorID", defaultValue="{ any: true }", value="Corporation creator ID selector") AttributeSelector creatorID, @QueryParam(value="factionID") @DefaultValue(value="{ any: true }") @ApiParam(name="factionID", defaultValue="{ any: true }", value="Corporation faction ID selector") AttributeSelector factionID, @QueryParam(value="px64x64") @DefaultValue(value="{ any: true }") @ApiParam(name="px64x64", defaultValue="{ any: true }", value="Corporation 64x64 image URL selector") AttributeSelector px64x64, @QueryParam(value="px128x128") @DefaultValue(value="{ any: true }") @ApiParam(name="px128x128", defaultValue="{ any: true }", value="Corporation 128x128 image URL selector") AttributeSelector px128x128, @QueryParam(value="px256x256") @DefaultValue(value="{ any: true }") @ApiParam(name="px256x256", defaultValue="{ any: true }", value="Corporation 256x256 image URL selector") AttributeSelector px256x256) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_CORPORATION_SHEET, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<CorporationSheet>(){

            @Override
            public List<CorporationSheet> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean ALLIANCE_ID = false;
                boolean CEO_ID = true;
                int CORPORATION_ID = 2;
                int CORPORATION_NAME = 3;
                int DESCRIPTION = 4;
                int MEMBER_COUNT = 5;
                int SHARES = 6;
                int STATION_ID = 7;
                int TAX_RATE = 8;
                int TICKER = 9;
                int URL2 = 10;
                int DATE_FOUNDED = 11;
                int CREATOR_ID = 12;
                int FACTION_ID = 13;
                int PX64X64 = 14;
                int PX128X128 = 15;
                int PX256X256 = 16;
                return CorporationSheet.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5], (AttributeSelector)others[6], (AttributeSelector)others[7], (AttributeSelector)others[8], (AttributeSelector)others[9], (AttributeSelector)others[10], (AttributeSelector)others[11], (AttributeSelector)others[12], (AttributeSelector)others[13], (AttributeSelector)others[14], (AttributeSelector)others[15], (AttributeSelector)others[16]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CORP_SHEET, acct);
            }
        }, request, allianceID, ceoID, corporationID, corporationName, description, memberCount, shares, stationID, taxRate, ticker, url, dateFounded, creatorID, factionID, px64x64, px128x128, px256x256);
    }

    @Path(value="/title")
    @GET
    @ApiOperation(value="Get corporation titles")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested corporation titles", response=CorporationTitle.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getCorporationTitles(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="titleID") @DefaultValue(value="{ any: true }") @ApiParam(name="titleID", defaultValue="{ any: true }", value="Corporation title ID selector") AttributeSelector titleID, @QueryParam(value="titleName") @DefaultValue(value="{ any: true }") @ApiParam(name="titleName", defaultValue="{ any: true }", value="Corporation title name selector") AttributeSelector titleName) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_CORPORATION_TITLES, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<CorporationTitle>(){

            @Override
            public List<CorporationTitle> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean TITLE_ID = false;
                boolean TITLE_NAME = true;
                return CorporationTitle.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CORP_TITLES, acct);
            }
        }, request, titleID, titleName);
    }

    @Path(value="/title_role")
    @GET
    @ApiOperation(value="Get corporation title roles")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested corporation title roles", response=CorporationTitleRole.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getCorporationTitleRoles(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="titleID") @DefaultValue(value="{ any: true }") @ApiParam(name="titleID", defaultValue="{ any: true }", value="Corporation title role ID selector") AttributeSelector titleID, @QueryParam(value="roleName") @DefaultValue(value="{ any: true }") @ApiParam(name="roleName", defaultValue="{ any: true }", value="Corporation title role name selector") AttributeSelector roleName, @QueryParam(value="grantable") @DefaultValue(value="{ any: true }") @ApiParam(name="grantable", defaultValue="{ any: true }", value="Corporation title role grantable selector") AttributeSelector grantable, @QueryParam(value="atHQ") @DefaultValue(value="{ any: true }") @ApiParam(name="atHQ", defaultValue="{ any: true }", value="Corporation title role at HQ selector") AttributeSelector atHQ, @QueryParam(value="atBase") @DefaultValue(value="{ any: true }") @ApiParam(name="atBase", defaultValue="{ any: true }", value="Corporation title role at base selector") AttributeSelector atBase, @QueryParam(value="atOther") @DefaultValue(value="{ any: true }") @ApiParam(name="atOther", defaultValue="{ any: true }", value="Corporation title role at other selector") AttributeSelector atOther) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_CORPORATION_TITLES, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<CorporationTitleRole>(){

            @Override
            public List<CorporationTitleRole> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean TITLE_ID = false;
                boolean ROLE_NAME = true;
                int GRANTABLE = 2;
                int AT_HQ = 3;
                int AT_BASE = 4;
                int AT_OTHER = 5;
                return CorporationTitleRole.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CORP_TITLES, acct);
            }
        }, request, titleID, roleName, grantable, atHQ, atBase, atOther);
    }

    @Path(value="/customs_office")
    @GET
    @ApiOperation(value="Get corporation customs offices")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested customs offices", response=CustomsOffice.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getCustomsOffices(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="orficeID") @DefaultValue(value="{ any: true }") @ApiParam(name="officeID", defaultValue="{ any: true }", value="Customs office ID selector") AttributeSelector officeID, @QueryParam(value="solarSystemID") @DefaultValue(value="{ any: true }") @ApiParam(name="solarSystemID", defaultValue="{ any: true }", value="Customs office solar system ID selector") AttributeSelector solarSystemID, @QueryParam(value="reinforceExitStart") @DefaultValue(value="{ any: true }") @ApiParam(name="reinforceExitStart", defaultValue="{ any: true }", value="Customs office reinforce exit timer start selector") AttributeSelector reinforceExitStart, @QueryParam(value="reinforceExitEnd") @DefaultValue(value="{ any: true }") @ApiParam(name="reinforceExitEnd", defaultValue="{ any: true }", value="Customs office reinforce exit timer end selector") AttributeSelector reinforceExitEnd, @QueryParam(value="allowAlliance") @DefaultValue(value="{ any: true }") @ApiParam(name="allowAlliance", defaultValue="{ any: true }", value="Customs office allow alliance selector") AttributeSelector allowAlliance, @QueryParam(value="allowStandings") @DefaultValue(value="{ any: true }") @ApiParam(name="allowStandings", defaultValue="{ any: true }", value="Customs office allow standings selector") AttributeSelector allowStandings, @QueryParam(value="standingLevel") @DefaultValue(value="{ any: true }") @ApiParam(name="standingLevel", defaultValue="{ any: true }", value="Customs office standing level selector") AttributeSelector standingLevel, @QueryParam(value="taxRateAlliance") @DefaultValue(value="{ any: true }") @ApiParam(name="taxRateAlliance", defaultValue="{ any: true }", value="Customs office tax rate alliance selector") AttributeSelector taxRateAlliance, @QueryParam(value="taxRateCorp") @DefaultValue(value="{ any: true }") @ApiParam(name="taxRateCorp", defaultValue="{ any: true }", value="Customs office tax rate corporation selector") AttributeSelector taxRateCorp, @QueryParam(value="taxRateStandingExcellent") @DefaultValue(value="{ any: true }") @ApiParam(name="taxRateStandingExcellent", defaultValue="{ any: true }", value="Customs office tax rate standing excellent selector") AttributeSelector taxRateStandingExcellent, @QueryParam(value="taxRateStandingGood") @DefaultValue(value="{ any: true }") @ApiParam(name="taxRateStandingGood", defaultValue="{ any: true }", value="Customs office tax rate standing good selector") AttributeSelector taxRateStandingGood, @QueryParam(value="taxRateStandingNeutral") @DefaultValue(value="{ any: true }") @ApiParam(name="taxRateStandingNeutral", defaultValue="{ any: true }", value="Customs office tax rate standing neutral selector") AttributeSelector taxRateStandingNeutral, @QueryParam(value="taxRateStandingBad") @DefaultValue(value="{ any: true }") @ApiParam(name="taxRateStandingBad", defaultValue="{ any: true }", value="Customs office tax rate standing bad selector") AttributeSelector taxRateStandingBad, @QueryParam(value="taxRateStandingTerrible") @DefaultValue(value="{ any: true }") @ApiParam(name="taxRateStandingTerrible", defaultValue="{ any: true }", value="Customs office tax rate standing terrible selector") AttributeSelector taxRateStandingTerrible) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_ASSETS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<CustomsOffice>(){

            @Override
            public List<CustomsOffice> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean OFFICE_ID = false;
                boolean SOLAR_SYSTEM_ID = true;
                int REINFORCE_EXIT_START = 2;
                int REINFORCE_EXIT_END = 3;
                int ALLOW_ALLIANCE = 4;
                int ALLOW_STANDINGS = 5;
                int STANDING_LEVEL = 6;
                int TAX_RATE_ALLIANCE = 7;
                int TAX_RATE_CORP = 8;
                int TAX_RATE_STANDING_EXCELLENT = 9;
                int TAX_RATE_STANDING_GOOD = 10;
                int TAX_RATE_STANDING_NEUTRAL = 11;
                int TAX_RATE_STANDING_BAD = 12;
                int TAX_RATE_STANDING_TERRIBLE = 13;
                return CustomsOffice.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5], (AttributeSelector)others[6], (AttributeSelector)others[7], (AttributeSelector)others[8], (AttributeSelector)others[9], (AttributeSelector)others[10], (AttributeSelector)others[11], (AttributeSelector)others[12], (AttributeSelector)others[13]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CORP_CUSTOMS, acct);
            }
        }, request, officeID, solarSystemID, reinforceExitStart, reinforceExitEnd, allowAlliance, allowStandings, standingLevel, taxRateAlliance, taxRateCorp, taxRateStandingExcellent, taxRateStandingGood, taxRateStandingNeutral, taxRateStandingBad, taxRateStandingTerrible);
    }

    @Path(value="/division")
    @GET
    @ApiOperation(value="Get corporation divisions")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested corporation divisions", response=Division.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getDivisions(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="wallet") @DefaultValue(value="{ any: true }") @ApiParam(name="wallet", defaultValue="{ any: true }", value="Division wallet indicator selector") AttributeSelector wallet, @QueryParam(value="division") @DefaultValue(value="{ any: true }") @ApiParam(name="division", defaultValue="{ any: true }", value="Division ID selector") AttributeSelector division, @QueryParam(value="name") @DefaultValue(value="{ any: true }") @ApiParam(name="name", defaultValue="{ any: true }", value="Division name selector") AttributeSelector name) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_CORPORATION_SHEET, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<Division>(){

            @Override
            public List<Division> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean WALLET = false;
                boolean DIVISION = true;
                int NAME = 2;
                return Division.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CORP_DIVISIONS, acct);
            }
        }, request, wallet, division, name);
    }

    @Path(value="/facility")
    @GET
    @ApiOperation(value="Get corporation facilities")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested corporation facilities", response=Facility.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getFacilities(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="facilityID") @DefaultValue(value="{ any: true }") @ApiParam(name="facilityID", defaultValue="{ any: true }", value="Facility ID selector") AttributeSelector facilityID, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", defaultValue="{ any: true }", value="Facility type ID selector") AttributeSelector typeID, @QueryParam(value="solarSystemID") @DefaultValue(value="{ any: true }") @ApiParam(name="solarSystemID", defaultValue="{ any: true }", value="Facility solar system ID selector") AttributeSelector solarSystemID) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_INDUSTRY_JOBS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<Facility>(){

            @Override
            public List<Facility> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean FACILITY_ID = false;
                boolean TYPE_ID = true;
                int SOLAR_SYSTEM_ID = 2;
                return Facility.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CORP_FACILITIES, acct);
            }
        }, request, facilityID, typeID, solarSystemID);
    }

    @Path(value="/fuel")
    @GET
    @ApiOperation(value="Get corporation starbase fuel levels")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested corporation starbase fuel levels", response=Fuel.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getFuel(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="starbaseID") @DefaultValue(value="{ any: true }") @ApiParam(name="starbaseID", defaultValue="{ any: true }", value="Fuel starbase ID selector") AttributeSelector starbaseID, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", defaultValue="{ any: true }", value="Fuel type ID selector") AttributeSelector typeID, @QueryParam(value="quantity") @DefaultValue(value="{ any: true }") @ApiParam(name="quantity", defaultValue="{ any: true }", value="Fuel quantity selector") AttributeSelector quantity) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_STARBASE_LIST, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<Fuel>(){

            @Override
            public List<Fuel> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean STARBASE_ID = false;
                boolean TYPE_ID = true;
                int QUANTITY = 2;
                return Fuel.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CORP_STARBASES, acct);
            }
        }, request, starbaseID, typeID, quantity);
    }

    @Path(value="/member_role")
    @GET
    @ApiOperation(value="Get corporation member roles")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested corporation member security roles", response=MemberRole.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getMemberRoles(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="characterID") @DefaultValue(value="{ any: true }") @ApiParam(name="characterID", defaultValue="{ any: true }", value="Member role character ID selector") AttributeSelector characterID, @QueryParam(value="roleName") @DefaultValue(value="{ any: true }") @ApiParam(name="roleName", defaultValue="{ any: true }", value="Member role name selector") AttributeSelector roleName, @QueryParam(value="grantable") @DefaultValue(value="{ any: true }") @ApiParam(name="grantable", defaultValue="{ any: true }", value="Member role grantable selector") AttributeSelector grantable, @QueryParam(value="atHQ") @DefaultValue(value="{ any: true }") @ApiParam(name="atHQ", defaultValue="{ any: true }", value="Member role at HQ selector") AttributeSelector atHQ, @QueryParam(value="atBase") @DefaultValue(value="{ any: true }") @ApiParam(name="atBase", defaultValue="{ any: true }", value="Member role at base selector") AttributeSelector atBase, @QueryParam(value="atOther") @DefaultValue(value="{ any: true }") @ApiParam(name="atOther", defaultValue="{ any: true }", value="Member role at other selector") AttributeSelector atOther) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_MEMBER_SECURITY, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<MemberRole>(){

            @Override
            public List<MemberRole> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean CHARACTER_ID = false;
                boolean ROLE_NAME = true;
                int GRANTABLE = 2;
                int AT_HQ = 3;
                int AT_BASE = 4;
                int AT_OTHER = 5;
                return MemberRole.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CORP_MEMBERSHIP, acct);
            }
        }, request, characterID, roleName, grantable, atHQ, atBase, atOther);
    }

    @Path(value="/member_role_history")
    @GET
    @ApiOperation(value="Get corporation member role history entries")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested corporation member role history entries", response=MemberRoleHistory.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getMemberRoleHistory(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="characterID") @DefaultValue(value="{ any: true }") @ApiParam(name="characterID", defaultValue="{ any: true }", value="Member role history character ID selector") AttributeSelector characterID, @QueryParam(value="changedAt") @DefaultValue(value="{ any: true }") @ApiParam(name="changedAt", defaultValue="{ any: true }", value="Member role history change time selector") AttributeSelector changedAt, @QueryParam(value="issuerID") @DefaultValue(value="{ any: true }") @ApiParam(name="issuerID", defaultValue="{ any: true }", value="Member role history issuer ID selector") AttributeSelector issuerID, @QueryParam(value="roleType") @DefaultValue(value="{ any: true }") @ApiParam(name="roleType", defaultValue="{ any: true }", value="Member role history role type selector") AttributeSelector roleType, @QueryParam(value="roleName") @DefaultValue(value="{ any: true }") @ApiParam(name="roleName", defaultValue="{ any: true }", value="Member role history roel name selector") AttributeSelector roleName, @QueryParam(value="old") @DefaultValue(value="{ any: true }") @ApiParam(name="old", defaultValue="{ any: true }", value="Member role history is old selector") AttributeSelector old) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_MEMBER_SECURITY_LOG, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<MemberRoleHistory>(){

            @Override
            public List<MemberRoleHistory> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean CHARACTER_ID = false;
                boolean CHANGED_AT = true;
                int ISSUER_ID = 2;
                int ROLE_TYPE = 3;
                int ROLE_NAME = 4;
                int OLD = 5;
                return MemberRoleHistory.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CORP_MEMBERSHIP, acct);
            }
        }, request, characterID, changedAt, issuerID, roleType, roleName, old);
    }

    @Path(value="/members")
    @GET
    @ApiOperation(value="Get corporation members")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested corporation members", response=Member.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getMembers(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="characterID") @DefaultValue(value="{ any: true }") @ApiParam(name="characterID", defaultValue="{ any: true }", value="Corporation character ID selector") AttributeSelector characterID) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_MEMBER_SECURITY, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<Member>(){

            @Override
            public List<Member> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean CHARACTER_ID = false;
                return Member.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CORP_MEMBERSHIP, acct);
            }
        }, request, characterID);
    }

    @Path(value="/member_limit")
    @GET
    @ApiOperation(value="Get corporation member limit information")
    @ApiResponses(value={@ApiResponse(code=200, message="list of corporation member limit information", response=MemberLimit.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getMemberLimit(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="memberLimit") @DefaultValue(value="{ any: true }") @ApiParam(name="memberLimit", defaultValue="{ any: true }", value="Corporation member limit selector") AttributeSelector memberLimit) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_MEMBER_TRACKING, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<MemberLimit>(){

            @Override
            public List<MemberLimit> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean MEMBER_LIMIT = false;
                return MemberLimit.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CORP_TRACK_MEMBERS, acct);
            }
        }, request, memberLimit);
    }

    @Path(value="/member_title")
    @GET
    @ApiOperation(value="Get corporation member titles")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested corporation member titles", response=MemberTitle.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getMemberTitles(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="characterID") @DefaultValue(value="{ any: true }") @ApiParam(name="characterID", defaultValue="{ any: true }", value="Corporation member title character ID selector") AttributeSelector characterID, @QueryParam(value="titleID") @DefaultValue(value="{ any: true }") @ApiParam(name="titleID", defaultValue="{ any: true }", value="Corporation member title ID selector") AttributeSelector titleID) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_MEMBER_SECURITY, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<MemberTitle>(){

            @Override
            public List<MemberTitle> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean CHARACTER_ID = false;
                boolean TITLE_ID = true;
                return MemberTitle.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CORP_TITLES, acct);
            }
        }, request, characterID, titleID);
    }

    @Path(value="/member_tracking")
    @GET
    @ApiOperation(value="Get member tracking information")
    @ApiResponses(value={@ApiResponse(code=200, message="list of member tracking information", response=MemberTracking.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getMemberTracking(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="characterID") @DefaultValue(value="{ any: true }") @ApiParam(name="characterID", defaultValue="{ any: true }", value="Member character ID selector") AttributeSelector characterID, @QueryParam(value="baseID") @DefaultValue(value="{ any: true }") @ApiParam(name="baseID", defaultValue="{ any: true }", value="Member base ID selector") AttributeSelector baseID, @QueryParam(value="locationID") @DefaultValue(value="{ any: true }") @ApiParam(name="locationID", defaultValue="{ any: true }", value="Member location ID selector") AttributeSelector locationID, @QueryParam(value="logoffDateTime") @DefaultValue(value="{ any: true }") @ApiParam(name="logoffDateTime", defaultValue="{ any: true }", value="Member logoff time selector") AttributeSelector logoffDateTime, @QueryParam(value="logonDateTime") @DefaultValue(value="{ any: true }") @ApiParam(name="logonDateTime", defaultValue="{ any: true }", value="Member logon time selector") AttributeSelector logonDateTime, @QueryParam(value="shipTypeID") @DefaultValue(value="{ any: true }") @ApiParam(name="shipTypeID", defaultValue="{ any: true }", value="Member ship type ID selector") AttributeSelector shipTypeID, @QueryParam(value="startDateTime") @DefaultValue(value="{ any: true }") @ApiParam(name="startDateTime", defaultValue="{ any: true }", value="Member start time selector") AttributeSelector startDateTime) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_MEMBER_TRACKING, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<MemberTracking>(){

            @Override
            public List<MemberTracking> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean CHARACTER_ID = false;
                boolean BASE_ID = true;
                int LOCATION_ID = 2;
                int LOGOFF_DATE_TIME = 3;
                int LOGON_DATE_TIME = 4;
                int SHIP_TYPE_ID = 5;
                int START_DATE_TIME = 6;
                return MemberTracking.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5], (AttributeSelector)others[6]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CORP_TRACK_MEMBERS, acct);
            }
        }, request, characterID, baseID, locationID, logoffDateTime, logonDateTime, shipTypeID, startDateTime);
    }

    @Path(value="/mining_extractions")
    @GET
    @ApiOperation(value="Get mining extractions information")
    @ApiResponses(value={@ApiResponse(code=200, message="list of mining extractions", response=MiningExtraction.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getMiningExtractions(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="moonID") @DefaultValue(value="{ any: true }") @ApiParam(name="moonID", defaultValue="{ any: true }", value="Moon ID selector") AttributeSelector moonID, @QueryParam(value="structureID") @DefaultValue(value="{ any: true }") @ApiParam(name="structureID", defaultValue="{ any: true }", value="Structure ID selector") AttributeSelector structureID, @QueryParam(value="extractionStartTime") @DefaultValue(value="{ any: true }") @ApiParam(name="extractionStartTime", defaultValue="{ any: true }", value="Extraction start time selector") AttributeSelector extractionStartTime, @QueryParam(value="chunkArrivalTime") @DefaultValue(value="{ any: true }") @ApiParam(name="chunkArrivalTime", defaultValue="{ any: true }", value="Chunk arrival time selector") AttributeSelector chunkArrivalTime, @QueryParam(value="naturalDecayTime") @DefaultValue(value="{ any: true }") @ApiParam(name="naturalDecayTime", defaultValue="{ any: true }", value="Natural decay time selector") AttributeSelector naturalDecayTime) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_MINING_LEDGER, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<MiningExtraction>(){

            @Override
            public List<MiningExtraction> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean MOON_ID = false;
                boolean STRUCTURE_ID = true;
                int EXTRACTION_START_TIME = 2;
                int CHUNK_ARRIVAL_TIME = 3;
                int NATURAL_DECAY_TIME = 4;
                return MiningExtraction.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CORP_MINING, acct);
            }
        }, request, moonID, structureID, extractionStartTime, chunkArrivalTime, naturalDecayTime);
    }

    @Path(value="/mining_observers")
    @GET
    @ApiOperation(value="Get mining observers information")
    @ApiResponses(value={@ApiResponse(code=200, message="list of mining observers", response=MiningObserver.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getMiningObservers(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="observerID") @DefaultValue(value="{ any: true }") @ApiParam(name="observerID", defaultValue="{ any: true }", value="Observer ID selector") AttributeSelector observerID, @QueryParam(value="observerType") @DefaultValue(value="{ any: true }") @ApiParam(name="observerType", defaultValue="{ any: true }", value="Observer type selector") AttributeSelector observerType, @QueryParam(value="lastUpdated") @DefaultValue(value="{ any: true }") @ApiParam(name="lastUpdated", defaultValue="{ any: true }", value="Last updated time selector") AttributeSelector lastUpdated) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_MINING_LEDGER, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<MiningObserver>(){

            @Override
            public List<MiningObserver> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean OBSERVER_ID = false;
                boolean OBSERVER_TYPE = true;
                int LAST_UPDATED = 2;
                return MiningObserver.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CORP_MINING, acct);
            }
        }, request, observerID, observerType, lastUpdated);
    }

    @Path(value="/mining_observations")
    @GET
    @ApiOperation(value="Get mining observations information")
    @ApiResponses(value={@ApiResponse(code=200, message="list of mining observations", response=MiningObservation.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getMiningObservations(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="observerID") @DefaultValue(value="{ any: true }") @ApiParam(name="observerID", defaultValue="{ any: true }", value="Observer ID selector") AttributeSelector observerID, @QueryParam(value="characterID") @DefaultValue(value="{ any: true }") @ApiParam(name="characterID", defaultValue="{ any: true }", value="Character ID selector") AttributeSelector characterID, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", defaultValue="{ any: true }", value="Type ID selector") AttributeSelector typeID, @QueryParam(value="recordedCorporationID") @DefaultValue(value="{ any: true }") @ApiParam(name="recordedCorporationID", defaultValue="{ any: true }", value="Recorded corporation ID selector") AttributeSelector recordedCorporationID, @QueryParam(value="quantity") @DefaultValue(value="{ any: true }") @ApiParam(name="quantity", defaultValue="{ any: true }", value="Quantity selector") AttributeSelector quantity, @QueryParam(value="lastUpdated") @DefaultValue(value="{ any: true }") @ApiParam(name="lastUpdated", defaultValue="{ any: true }", value="Last updated time selector") AttributeSelector lastUpdated) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_MINING_LEDGER, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<MiningObservation>(){

            @Override
            public List<MiningObservation> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean OBSERVER_ID = false;
                boolean CHARACTER_ID = true;
                int TYPE_ID = 2;
                int RECORDED_CORPORATION_ID = 3;
                int QUANTITY = 4;
                int LAST_UPDATED = 5;
                return MiningObservation.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CORP_MINING, acct);
            }
        }, request, observerID, characterID, typeID, recordedCorporationID, quantity, lastUpdated);
    }

    @Path(value="/shareholder")
    @GET
    @ApiOperation(value="Get corporation shareholders")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested corporation shareholders", response=Shareholder.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getShareholders(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="shareholderID") @DefaultValue(value="{ any: true }") @ApiParam(name="shareholderID", defaultValue="{ any: true }", value="Shareholder ID selector") AttributeSelector shareholderID, @QueryParam(value="shareholderType") @DefaultValue(value="{ any: true }") @ApiParam(name="shareholderType", defaultValue="{ any: true }", value="Shareholder type selector") AttributeSelector shareholderType, @QueryParam(value="shares") @DefaultValue(value="{ any: true }") @ApiParam(name="shares", defaultValue="{ any: true }", value="Shareholder shares selector") AttributeSelector shares) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_SHAREHOLDERS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<Shareholder>(){

            @Override
            public List<Shareholder> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean SHAREHOLDER_ID = false;
                boolean SHAREHOLDER_TYPE = true;
                int SHARES = 2;
                return Shareholder.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CORP_SHAREHOLDERS, acct);
            }
        }, request, shareholderID, shareholderType, shares);
    }

    @Path(value="/starbase")
    @GET
    @ApiOperation(value="Get corporation starbases")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested corporation starbases", response=Starbase.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getStarbases(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="starbaseID") @DefaultValue(value="{ any: true }") @ApiParam(name="starbaseID", defaultValue="{ any: true }", value="Starbase ID selector") AttributeSelector starbaseID, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", defaultValue="{ any: true }", value="Starbase type ID selector") AttributeSelector typeID, @QueryParam(value="systemID") @DefaultValue(value="{ any: true }") @ApiParam(name="systemID", defaultValue="{ any: true }", value="Starbase system ID selector") AttributeSelector systemID, @QueryParam(value="moonID") @DefaultValue(value="{ any: true }") @ApiParam(name="moonID", defaultValue="{ any: true }", value="Starbase moon ID selector") AttributeSelector moonID, @QueryParam(value="state") @DefaultValue(value="{ any: true }") @ApiParam(name="state", defaultValue="{ any: true }", value="Starbase state selector") AttributeSelector state, @QueryParam(value="unanchorAt") @DefaultValue(value="{ any: true }") @ApiParam(name="unanchorAt", defaultValue="{ any: true }", value="Starbase unanchor at timestamp selector") AttributeSelector unanchorAt, @QueryParam(value="reinforcedUntil") @DefaultValue(value="{ any: true }") @ApiParam(name="reinforcedUntil", defaultValue="{ any: true }", value="Starbase reinforced until timestamp selector") AttributeSelector reinforcedUntil, @QueryParam(value="onlinedSince") @DefaultValue(value="{ any: true }") @ApiParam(name="onlinedSince", defaultValue="{ any: true }", value="Starbase onlined since timestamp selector") AttributeSelector onlinedSince, @QueryParam(value="fuelBayView") @DefaultValue(value="{ any: true }") @ApiParam(name="fuelBayView", defaultValue="{ any: true }", value="Starbase fuel bay view selector") AttributeSelector fuelBayView, @QueryParam(value="fuelBayTake") @DefaultValue(value="{ any: true }") @ApiParam(name="fuelBayTake", defaultValue="{ any: true }", value="Starbase fuel bay take selector") AttributeSelector fuelBayTake, @QueryParam(value="anchor") @DefaultValue(value="{ any: true }") @ApiParam(name="anchor", defaultValue="{ any: true }", value="Starbase anchor selector") AttributeSelector anchor, @QueryParam(value="unanchor") @DefaultValue(value="{ any: true }") @ApiParam(name="unanchor", defaultValue="{ any: true }", value="Starbase unanchor selector") AttributeSelector unanchor, @QueryParam(value="online") @DefaultValue(value="{ any: true }") @ApiParam(name="online", defaultValue="{ any: true }", value="Starbase online selector") AttributeSelector online, @QueryParam(value="offline") @DefaultValue(value="{ any: true }") @ApiParam(name="offline", defaultValue="{ any: true }", value="Starbase offline selector") AttributeSelector offline, @QueryParam(value="allowCorporationMembers") @DefaultValue(value="{ any: true }") @ApiParam(name="allowCorporationMembers", defaultValue="{ any: true }", value="Starbase allow corporation members selector") AttributeSelector allowCorporationMembers, @QueryParam(value="allowAllianceMembers") @DefaultValue(value="{ any: true }") @ApiParam(name="allowAllianceMembers", defaultValue="{ any: true }", value="Starbase allow alliance members selector") AttributeSelector allowAllianceMembers, @QueryParam(value="useAllianceStandings") @DefaultValue(value="{ any: true }") @ApiParam(name="useAllianceStandings", defaultValue="{ any: true }", value="Starbase use alliance standings selector") AttributeSelector useAllianceStandings, @QueryParam(value="attackStandingThreshold") @DefaultValue(value="{ any: true }") @ApiParam(name="attackStandingThreshold", defaultValue="{ any: true }", value="Starbase attack standing threshold selector") AttributeSelector attackStandingThreshold, @QueryParam(value="attackSecurityStatusThreshold") @DefaultValue(value="{ any: true }") @ApiParam(name="attackSecurityStatusThreshold", defaultValue="{ any: true }", value="Starbase attack security status threshold selector") AttributeSelector attackSecurityStatusThreshold, @QueryParam(value="attackIfOtherSecurityStatusDropping") @DefaultValue(value="{ any: true }") @ApiParam(name="attackIfOtherSecurityStatusDropping", defaultValue="{ any: true }", value="Starbase attack if other security status dropping selector") AttributeSelector attackIfOtherSecurityStatusDropping, @QueryParam(value="attackIfAtWar") @DefaultValue(value="{ any: true }") @ApiParam(name="attackIfAtWar", defaultValue="{ any: true }", value="Starbase attack if at war selector") AttributeSelector attackIfAtWar) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_STARBASE_LIST, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<Starbase>(){

            @Override
            public List<Starbase> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean STARBASE_ID = false;
                boolean TYPE_ID = true;
                int SYSTEM_ID = 2;
                int MOON_ID = 3;
                int STATE = 4;
                int UNANCHOR_AT = 5;
                int REINFORCED_UNTIL = 6;
                int ONLINED_SINCE = 7;
                int FUEL_BAY_VIEW = 8;
                int FUEL_BAY_TAKE = 9;
                int ANCHOR = 10;
                int UNANCHOR = 11;
                int ONLINE = 12;
                int OFFLINE = 13;
                int ALLOW_CORPORATION_MEMBERS = 14;
                int ALLOW_ALLIANCE_MEMBERS = 15;
                int USE_ALLIANCE_STANDINGS = 16;
                int ATTACK_STANDING_THRESHOLD = 17;
                int ATTACK_SECURITY_STATUS_THRESHOLD = 18;
                int ATTACK_IF_OTHER_SECURITY_STATUS_DROPPING = 19;
                int ATTACK_IF_AT_WAR = 20;
                return Starbase.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5], (AttributeSelector)others[6], (AttributeSelector)others[7], (AttributeSelector)others[8], (AttributeSelector)others[9], (AttributeSelector)others[10], (AttributeSelector)others[11], (AttributeSelector)others[12], (AttributeSelector)others[13], (AttributeSelector)others[14], (AttributeSelector)others[15], (AttributeSelector)others[16], (AttributeSelector)others[17], (AttributeSelector)others[18], (AttributeSelector)others[19], (AttributeSelector)others[20]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CORP_STARBASES, acct);
            }
        }, request, starbaseID, typeID, systemID, moonID, state, unanchorAt, reinforcedUntil, onlinedSince, fuelBayView, fuelBayTake, anchor, unanchor, online, offline, allowCorporationMembers, allowAllianceMembers, useAllianceStandings, attackStandingThreshold, attackSecurityStatusThreshold, attackIfOtherSecurityStatusDropping, attackIfAtWar);
    }
}

