/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.ws.common;

import enterprises.orbital.evekit.account.AccountAccessMask;
import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.ESISyncEndpoint;
import enterprises.orbital.evekit.model.common.AccountBalance;
import enterprises.orbital.evekit.model.common.Asset;
import enterprises.orbital.evekit.model.common.Blueprint;
import enterprises.orbital.evekit.model.common.Bookmark;
import enterprises.orbital.evekit.model.common.Contact;
import enterprises.orbital.evekit.model.common.ContactLabel;
import enterprises.orbital.evekit.model.common.Contract;
import enterprises.orbital.evekit.model.common.ContractBid;
import enterprises.orbital.evekit.model.common.ContractItem;
import enterprises.orbital.evekit.model.common.FacWarStats;
import enterprises.orbital.evekit.model.common.IndustryJob;
import enterprises.orbital.evekit.model.common.Kill;
import enterprises.orbital.evekit.model.common.KillAttacker;
import enterprises.orbital.evekit.model.common.KillItem;
import enterprises.orbital.evekit.model.common.KillVictim;
import enterprises.orbital.evekit.model.common.Location;
import enterprises.orbital.evekit.model.common.MarketOrder;
import enterprises.orbital.evekit.model.common.Standing;
import enterprises.orbital.evekit.model.common.WalletJournal;
import enterprises.orbital.evekit.model.common.WalletTransaction;
import enterprises.orbital.evekit.ws.AccountHandlerUtil;
import enterprises.orbital.evekit.ws.ServiceError;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/ws/v1/common")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(tags={"Common"}, produces="application/json", consumes="application/json")
public class ModelCommonWS {
    @Path(value="/account_balance")
    @GET
    @ApiOperation(value="Get account balance(s)")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested account balances", response=AccountBalance.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getAccountBalance(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="division") @DefaultValue(value="{ any: true }") @ApiParam(name="division", defaultValue="{ any: true }", value="Division selector") AttributeSelector division, @QueryParam(value="balance") @DefaultValue(value="{ any: true }") @ApiParam(name="balance", defaultValue="{ any: true }", value="Balance selector") AttributeSelector balance) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_ACCOUNT_BALANCE, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<AccountBalance>(){

            @Override
            public List<AccountBalance> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean DIVISION = false;
                boolean BALANCE = true;
                return AccountBalance.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(acct.isCharacterType() ? ESISyncEndpoint.CHAR_WALLET_BALANCE : ESISyncEndpoint.CORP_WALLET_BALANCE, acct);
            }
        }, request, division, balance);
    }

    @Path(value="/asset")
    @GET
    @ApiOperation(value="Get assets")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested assets", response=Asset.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getAssets(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="itemID") @DefaultValue(value="{ any: true }") @ApiParam(name="itemID", defaultValue="{ any: true }", value="Asset item ID selector") AttributeSelector itemID, @QueryParam(value="locationID") @DefaultValue(value="{ any: true }") @ApiParam(name="locationID", defaultValue="{ any: true }", value="Asset location ID selector") AttributeSelector locationID, @QueryParam(value="locationType") @DefaultValue(value="{ any: true }") @ApiParam(name="locationType", defaultValue="{ any: true }", value="Asset location type selector") AttributeSelector locationType, @QueryParam(value="locationFlag") @DefaultValue(value="{ any: true }") @ApiParam(name="locationFlag", defaultValue="{ any: true }", value="Asset location flag selector") AttributeSelector locationFlag, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", defaultValue="{ any: true }", value="Asset type ID selector") AttributeSelector typeID, @QueryParam(value="quantity") @DefaultValue(value="{ any: true }") @ApiParam(name="quantity", defaultValue="{ any: true }", value="Asset quantity selector") AttributeSelector quantity, @QueryParam(value="singleton") @DefaultValue(value="{ any: true }") @ApiParam(name="singleton", defaultValue="{ any: true }", value="Asset is singleton selector") AttributeSelector singleton, @QueryParam(value="blueprintType") @DefaultValue(value="{ any: true }") @ApiParam(name="blueprintType", defaultValue="{ any: true }", value="Asset blueprint type selector") AttributeSelector blueprintType) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_ASSETS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<Asset>(){

            @Override
            public List<Asset> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean ITEM_ID = false;
                boolean LOCATION_ID = true;
                int LOCATION_TYPE = 2;
                int LOCATION_FLAG = 3;
                int TYPE_ID = 4;
                int QUANTITY = 5;
                int SINGLETON = 6;
                int BLUEPRINT_TYPE = 7;
                return Asset.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5], (AttributeSelector)others[6], (AttributeSelector)others[7]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(acct.isCharacterType() ? ESISyncEndpoint.CHAR_ASSETS : ESISyncEndpoint.CORP_ASSETS, acct);
            }
        }, request, itemID, locationID, locationType, locationFlag, typeID, quantity, singleton, blueprintType);
    }

    @Path(value="/blueprint")
    @GET
    @ApiOperation(value="Get blueprints")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested blueprints", response=Blueprint.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getBlueprints(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="itemID") @DefaultValue(value="{ any: true }") @ApiParam(name="itemID", defaultValue="{ any: true }", value="Blueprint item ID selector") AttributeSelector itemID, @QueryParam(value="locationID") @DefaultValue(value="{ any: true }") @ApiParam(name="locationID", defaultValue="{ any: true }", value="Blueprint location ID selector") AttributeSelector locationID, @QueryParam(value="locationFlag") @DefaultValue(value="{ any: true }") @ApiParam(name="locationFlag", defaultValue="{ any: true }", value="Blueprint location flag selector") AttributeSelector locationFlag, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", defaultValue="{ any: true }", value="Blueprint type ID selector") AttributeSelector typeID, @QueryParam(value="quantity") @DefaultValue(value="{ any: true }") @ApiParam(name="quantity", defaultValue="{ any: true }", value="Blueprint quantity selector") AttributeSelector quantity, @QueryParam(value="timeEfficiency") @DefaultValue(value="{ any: true }") @ApiParam(name="timeEfficiency", defaultValue="{ any: true }", value="Blueprint time efficiency selector") AttributeSelector timeEfficiency, @QueryParam(value="materialEfficiency") @DefaultValue(value="{ any: true }") @ApiParam(name="materialEfficiency", defaultValue="{ any: true }", value="Blueprint material efficiency selector") AttributeSelector materialEfficiency, @QueryParam(value="runs") @DefaultValue(value="{ any: true }") @ApiParam(name="runs", defaultValue="{ any: true }", value="Blueprint runs selector") AttributeSelector runs) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_BLUEPRINTS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<Blueprint>(){

            @Override
            public List<Blueprint> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean ITEM_ID = false;
                boolean LOCATION_ID = true;
                int LOCATION_FLAG = 2;
                int TYPE_ID = 3;
                int QUANTITY = 4;
                int TIME_EFFICIENCY = 5;
                int MATERIAL_EFFICIENCY = 6;
                int RUNS = 7;
                return Blueprint.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5], (AttributeSelector)others[6], (AttributeSelector)others[7]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(acct.isCharacterType() ? ESISyncEndpoint.CHAR_BLUEPRINTS : ESISyncEndpoint.CORP_BLUEPRINTS, acct);
            }
        }, request, itemID, locationID, locationFlag, typeID, quantity, timeEfficiency, materialEfficiency, runs);
    }

    @Path(value="/bookmark")
    @GET
    @ApiOperation(value="Get bookmarks")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested bookmarks", response=Bookmark.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getBookmarks(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="folderID") @DefaultValue(value="{ any: true }") @ApiParam(name="folderID", defaultValue="{ any: true }", value="Bookmark folder ID selector") AttributeSelector folderID, @QueryParam(value="folderName") @DefaultValue(value="{ any: true }") @ApiParam(name="folderName", defaultValue="{ any: true }", value="Bookmark folder name selector") AttributeSelector folderName, @QueryParam(value="folderCreatorID") @DefaultValue(value="{ any: true }") @ApiParam(name="folderCreatorID", defaultValue="{ any: true }", value="Bookmark folder creator ID selector") AttributeSelector folderCreatorID, @QueryParam(value="bookmarkID") @DefaultValue(value="{ any: true }") @ApiParam(name="bookmarkID", defaultValue="{ any: true }", value="Bookmark ID selector") AttributeSelector bookmarkID, @QueryParam(value="bookmarkCreatorID") @DefaultValue(value="{ any: true }") @ApiParam(name="bookmarkCreatorID", defaultValue="{ any: true }", value="Bookmark creator ID selector") AttributeSelector bookmarkCreatorID, @QueryParam(value="created") @DefaultValue(value="{ any: true }") @ApiParam(name="created", defaultValue="{ any: true }", value="Bookmark created selector") AttributeSelector created, @QueryParam(value="itemID") @DefaultValue(value="{ any: true }") @ApiParam(name="itemID", defaultValue="{ any: true }", value="Bookmark item ID selector") AttributeSelector itemID, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", defaultValue="{ any: true }", value="Bookmark type ID selector") AttributeSelector typeID, @QueryParam(value="locationID") @DefaultValue(value="{ any: true }") @ApiParam(name="locationID", defaultValue="{ any: true }", value="Bookmark location ID selector") AttributeSelector locationID, @QueryParam(value="x") @DefaultValue(value="{ any: true }") @ApiParam(name="x", defaultValue="{ any: true }", value="Bookmark x coordinate selector") AttributeSelector x, @QueryParam(value="y") @DefaultValue(value="{ any: true }") @ApiParam(name="y", defaultValue="{ any: true }", value="Bookmark y coordinate selector") AttributeSelector y, @QueryParam(value="z") @DefaultValue(value="{ any: true }") @ApiParam(name="z", defaultValue="{ any: true }", value="Bookmark z coordinate selector") AttributeSelector z, @QueryParam(value="memo") @DefaultValue(value="{ any: true }") @ApiParam(name="memo", defaultValue="{ any: true }", value="Bookmark memo selector") AttributeSelector memo, @QueryParam(value="note") @DefaultValue(value="{ any: true }") @ApiParam(name="note", defaultValue="{ any: true }", value="Bookmark note selector") AttributeSelector note) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_BOOKMARKS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<Bookmark>(){

            @Override
            public List<Bookmark> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean FOLDER_ID = false;
                boolean FOLDER_NAME = true;
                int FOLDER_CREATOR_ID = 2;
                int BOOKMARK_ID = 3;
                int BOOKMARK_CREATOR_ID = 4;
                int CREATED = 5;
                int ITEM_ID = 6;
                int TYPE_ID = 7;
                int LOCATION_ID = 8;
                int X = 9;
                int Y = 10;
                int Z = 11;
                int MEMO = 12;
                int NOTE = 13;
                return Bookmark.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5], (AttributeSelector)others[6], (AttributeSelector)others[7], (AttributeSelector)others[8], (AttributeSelector)others[9], (AttributeSelector)others[10], (AttributeSelector)others[11], (AttributeSelector)others[12], (AttributeSelector)others[13]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(acct.isCharacterType() ? ESISyncEndpoint.CHAR_BOOKMARKS : ESISyncEndpoint.CORP_BOOKMARKS, acct);
            }
        }, request, folderID, folderName, folderCreatorID, bookmarkID, bookmarkCreatorID, created, itemID, typeID, locationID, x, y, z, memo, note);
    }

    @Path(value="/contact")
    @GET
    @ApiOperation(value="Get contacts")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested contacts", response=Contact.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getContacts(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="list") @DefaultValue(value="{ any: true }") @ApiParam(name="list", defaultValue="{ any: true }", value="Contact list selector") AttributeSelector list, @QueryParam(value="contactID") @DefaultValue(value="{ any: true }") @ApiParam(name="contactID", defaultValue="{ any: true }", value="Contact ID selector") AttributeSelector contactID, @QueryParam(value="standing") @DefaultValue(value="{ any: true }") @ApiParam(name="standing", defaultValue="{ any: true }", value="Contact standing selector") AttributeSelector standing, @QueryParam(value="contactType") @DefaultValue(value="{ any: true }") @ApiParam(name="contactType", defaultValue="{ any: true }", value="Contact type selector") AttributeSelector contactType, @QueryParam(value="inWatchlist") @DefaultValue(value="{ any: true }") @ApiParam(name="inWatchlist", defaultValue="{ any: true }", value="Contact in watch list selector") AttributeSelector inWatchlist, @QueryParam(value="isBlocked") @DefaultValue(value="{ any: true }") @ApiParam(name="isBlocked", defaultValue="{ any: true }", value="Contact is blocked selector") AttributeSelector isBlocked, @QueryParam(value="labelID") @DefaultValue(value="{ any: true }") @ApiParam(name="labelID", defaultValue="{ any: true }", value="Contact label mask selector") AttributeSelector labelID) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_CONTACT_LIST, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<Contact>(){

            @Override
            public List<Contact> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean LIST = false;
                boolean CONTACT_ID = true;
                int STANDING = 2;
                int CONTACT_TYPE = 3;
                int IN_WATCH_LIST = 4;
                int IS_BLOCKED = 5;
                int LABEL_ID = 6;
                return Contact.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5], (AttributeSelector)others[6]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(acct.isCharacterType() ? ESISyncEndpoint.CHAR_CONTACTS : ESISyncEndpoint.CORP_CONTACTS, acct);
            }
        }, request, list, contactID, standing, contactType, inWatchlist, isBlocked, labelID);
    }

    @Path(value="/contact_label")
    @GET
    @ApiOperation(value="Get contact labels")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested contact labels", response=ContactLabel.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getContactLabels(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="list") @DefaultValue(value="{ any: true }") @ApiParam(name="list", defaultValue="{ any: true }", value="Contact list selector") AttributeSelector list, @QueryParam(value="labelID") @DefaultValue(value="{ any: true }") @ApiParam(name="labelID", defaultValue="{ any: true }", value="Contact label ID selector") AttributeSelector labelID, @QueryParam(value="name") @DefaultValue(value="{ any: true }") @ApiParam(name="name", defaultValue="{ any: true }", value="Contact label name selector") AttributeSelector name) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_CONTACT_LIST, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<ContactLabel>(){

            @Override
            public List<ContactLabel> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean LIST = false;
                boolean LABEL_ID = true;
                int NAME = 2;
                return ContactLabel.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_CONTACTS, acct);
            }
        }, request, list, labelID, name);
    }

    @Path(value="/contract")
    @GET
    @ApiOperation(value="Get contracts")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested contracts", response=Contract.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getContracts(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="contractID") @DefaultValue(value="{ any: true }") @ApiParam(name="contractID", defaultValue="{ any: true }", value="Contract ID selector") AttributeSelector contractID, @QueryParam(value="issuerID") @DefaultValue(value="{ any: true }") @ApiParam(name="issuerID", defaultValue="{ any: true }", value="Contract issuer ID selector") AttributeSelector issuerID, @QueryParam(value="issuerCorpID") @DefaultValue(value="{ any: true }") @ApiParam(name="issuerCorpID", defaultValue="{ any: true }", value="Contract issuer corporation ID selector") AttributeSelector issuerCorpID, @QueryParam(value="assigneeID") @DefaultValue(value="{ any: true }") @ApiParam(name="assigneeID", defaultValue="{ any: true }", value="Contract assignee ID selector") AttributeSelector assigneeID, @QueryParam(value="acceptorID") @DefaultValue(value="{ any: true }") @ApiParam(name="acceptorID", defaultValue="{ any: true }", value="Contract acceptor ID selector") AttributeSelector acceptorID, @QueryParam(value="startStationID") @DefaultValue(value="{ any: true }") @ApiParam(name="startStationID", defaultValue="{ any: true }", value="Contract start station ID selector") AttributeSelector startStationID, @QueryParam(value="endStationID") @DefaultValue(value="{ any: true }") @ApiParam(name="endStationID", defaultValue="{ any: true }", value="Contract end station ID selector") AttributeSelector endStationID, @QueryParam(value="type") @DefaultValue(value="{ any: true }") @ApiParam(name="type", defaultValue="{ any: true }", value="Contract type selector") AttributeSelector type, @QueryParam(value="status") @DefaultValue(value="{ any: true }") @ApiParam(name="status", defaultValue="{ any: true }", value="Contract status selector") AttributeSelector status, @QueryParam(value="title") @DefaultValue(value="{ any: true }") @ApiParam(name="title", defaultValue="{ any: true }", value="Contract title selector") AttributeSelector title, @QueryParam(value="forCorp") @DefaultValue(value="{ any: true }") @ApiParam(name="forCorp", defaultValue="{ any: true }", value="Contract for corporation selector") AttributeSelector forCorp, @QueryParam(value="availability") @DefaultValue(value="{ any: true }") @ApiParam(name="availability", defaultValue="{ any: true }", value="Contract availability selector") AttributeSelector availability, @QueryParam(value="dateIssued") @DefaultValue(value="{ any: true }") @ApiParam(name="dateIssued", defaultValue="{ any: true }", value="Contract date issued selector") AttributeSelector dateIssued, @QueryParam(value="dateExpired") @DefaultValue(value="{ any: true }") @ApiParam(name="dateExpired", defaultValue="{ any: true }", value="Contract date expired selector") AttributeSelector dateExpired, @QueryParam(value="dateAccepted") @DefaultValue(value="{ any: true }") @ApiParam(name="dateAccepted", defaultValue="{ any: true }", value="Contract date accepted selector") AttributeSelector dateAccepted, @QueryParam(value="numDays") @DefaultValue(value="{ any: true }") @ApiParam(name="numDays", defaultValue="{ any: true }", value="Contract duration (days) selector") AttributeSelector numDays, @QueryParam(value="dateCompleted") @DefaultValue(value="{ any: true }") @ApiParam(name="dateCompleted", defaultValue="{ any: true }", value="Contract date completed selector") AttributeSelector dateCompleted, @QueryParam(value="price") @DefaultValue(value="{ any: true }") @ApiParam(name="price", defaultValue="{ any: true }", value="Contract price selector") AttributeSelector price, @QueryParam(value="reward") @DefaultValue(value="{ any: true }") @ApiParam(name="reward", defaultValue="{ any: true }", value="Contract reward value selector") AttributeSelector reward, @QueryParam(value="collateral") @DefaultValue(value="{ any: true }") @ApiParam(name="collateral", defaultValue="{ any: true }", value="Contract collateral value selector") AttributeSelector collateral, @QueryParam(value="buyout") @DefaultValue(value="{ any: true }") @ApiParam(name="buyout", defaultValue="{ any: true }", value="Contract buyout price selector") AttributeSelector buyout, @QueryParam(value="volume") @DefaultValue(value="{ any: true }") @ApiParam(name="volume", defaultValue="{ any: true }", value="Contract volume selector") AttributeSelector volume) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_CONTRACTS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<Contract>(){

            @Override
            public List<Contract> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean CONTRACT_ID = false;
                boolean ISSUER_ID = true;
                int ISSUER_CORP_ID = 2;
                int ASSIGNEE_ID = 3;
                int ACCEPTOR_ID = 4;
                int START_STATION_ID = 5;
                int END_STATION_ID = 6;
                int TYPE = 7;
                int STATUS = 8;
                int TITLE = 9;
                int FOR_CORP = 10;
                int AVAILABILITY = 11;
                int DATE_ISSUED = 12;
                int DATE_EXPIRED = 13;
                int DATE_ACCEPTED = 14;
                int NUM_DAYS = 15;
                int DATE_COMPLETED = 16;
                int PRICE = 17;
                int REWARD = 18;
                int COLLATERAL = 19;
                int BUYOUT = 20;
                int VOLUME = 21;
                return Contract.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5], (AttributeSelector)others[6], (AttributeSelector)others[7], (AttributeSelector)others[8], (AttributeSelector)others[9], (AttributeSelector)others[10], (AttributeSelector)others[11], (AttributeSelector)others[12], (AttributeSelector)others[13], (AttributeSelector)others[14], (AttributeSelector)others[15], (AttributeSelector)others[16], (AttributeSelector)others[17], (AttributeSelector)others[18], (AttributeSelector)others[19], (AttributeSelector)others[20], (AttributeSelector)others[21]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(acct.isCharacterType() ? ESISyncEndpoint.CHAR_CONTRACTS : ESISyncEndpoint.CORP_CONTRACTS, acct);
            }
        }, request, contractID, issuerID, issuerCorpID, assigneeID, acceptorID, startStationID, endStationID, type, status, title, forCorp, availability, dateIssued, dateExpired, dateAccepted, numDays, dateCompleted, price, reward, collateral, buyout, volume);
    }

    @Path(value="/contract_bid")
    @GET
    @ApiOperation(value="Get contract bids")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested contract bids", response=ContractBid.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getContractBids(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="bidID") @DefaultValue(value="{ any: true }") @ApiParam(name="bidID", defaultValue="{ any: true }", value="Contract bid ID selector") AttributeSelector bidID, @QueryParam(value="contractID") @DefaultValue(value="{ any: true }") @ApiParam(name="contractID", defaultValue="{ any: true }", value="Contract ID selector") AttributeSelector contractID, @QueryParam(value="bidderID") @DefaultValue(value="{ any: true }") @ApiParam(name="bidderID", defaultValue="{ any: true }", value="Contract bid bidder ID selector") AttributeSelector bidderID, @QueryParam(value="dateBid") @DefaultValue(value="{ any: true }") @ApiParam(name="dateBid", defaultValue="{ any: true }", value="Contract bid date selector") AttributeSelector dateBid, @QueryParam(value="amount") @DefaultValue(value="{ any: true }") @ApiParam(name="amount", defaultValue="{ any: true }", value="Contract bid amount selector") AttributeSelector amount) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_CONTRACTS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<ContractBid>(){

            @Override
            public List<ContractBid> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean BID_ID = false;
                boolean CONTRACT_ID = true;
                int BIDDER_ID = 2;
                int DATE_BID = 3;
                int AMOUNT = 4;
                return ContractBid.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(acct.isCharacterType() ? ESISyncEndpoint.CHAR_CONTRACTS : ESISyncEndpoint.CORP_CONTRACTS, acct);
            }
        }, request, bidID, contractID, bidderID, dateBid, amount);
    }

    @Path(value="/contract_item")
    @GET
    @ApiOperation(value="Get contract items")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested contract items", response=ContractItem.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getContractItems(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="contractID") @DefaultValue(value="{ any: true }") @ApiParam(name="contractID", defaultValue="{ any: true }", value="Contract ID selector") AttributeSelector contractID, @QueryParam(value="recordID") @DefaultValue(value="{ any: true }") @ApiParam(name="recordID", defaultValue="{ any: true }", value="Contract item record ID selector") AttributeSelector recordID, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", defaultValue="{ any: true }", value="Contract item type ID selector") AttributeSelector typeID, @QueryParam(value="quantity") @DefaultValue(value="{ any: true }") @ApiParam(name="quantity", defaultValue="{ any: true }", value="Contract item quantity selector") AttributeSelector quantity, @QueryParam(value="rawQuantity") @DefaultValue(value="{ any: true }") @ApiParam(name="rawQuantity", defaultValue="{ any: true }", value="Contract item raw quantity selector") AttributeSelector rawQuantity, @QueryParam(value="singleton") @DefaultValue(value="{ any: true }") @ApiParam(name="singleton", defaultValue="{ any: true }", value="Contract item singleton selector") AttributeSelector singleton, @QueryParam(value="included") @DefaultValue(value="{ any: true }") @ApiParam(name="included", defaultValue="{ any: true }", value="Contract item included selector") AttributeSelector included) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_CONTRACTS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<ContractItem>(){

            @Override
            public List<ContractItem> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean CONTRACT_ID = false;
                boolean RECORD_ID = true;
                int TYPE_ID = 2;
                int QUANTITY = 3;
                int RAW_QUANTITY = 4;
                int SINGLETON = 5;
                int INCLUDED = 6;
                return ContractItem.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5], (AttributeSelector)others[6]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(acct.isCharacterType() ? ESISyncEndpoint.CHAR_CONTRACTS : ESISyncEndpoint.CORP_CONTRACTS, acct);
            }
        }, request, contractID, recordID, typeID, quantity, rawQuantity, singleton, included);
    }

    @Path(value="/fac_war_stats")
    @GET
    @ApiOperation(value="Get faction war statistics")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested faction war statistics", response=FacWarStats.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getFacWarStats(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="currentRank") @DefaultValue(value="{ any: true }") @ApiParam(name="currentRank", defaultValue="{ any: true }", value="Faction war statistics current rank selector") AttributeSelector currentRank, @QueryParam(value="enlisted") @DefaultValue(value="{ any: true }") @ApiParam(name="enlisted", defaultValue="{ any: true }", value="Faction war statistics enlisted indicator selector") AttributeSelector enlisted, @QueryParam(value="factionID") @DefaultValue(value="{ any: true }") @ApiParam(name="factionID", defaultValue="{ any: true }", value="Faction war statistics faction ID selector") AttributeSelector factionID, @QueryParam(value="highestRank") @DefaultValue(value="{ any: true }") @ApiParam(name="highestRank", defaultValue="{ any: true }", value="Faction war statistics highest rank selector") AttributeSelector highestRank, @QueryParam(value="killsLastWeek") @DefaultValue(value="{ any: true }") @ApiParam(name="killsLastWeek", defaultValue="{ any: true }", value="Faction war statistics kill last week selector") AttributeSelector killsLastWeek, @QueryParam(value="killsTotal") @DefaultValue(value="{ any: true }") @ApiParam(name="killsTotal", defaultValue="{ any: true }", value="Faction war statistics total kills selector") AttributeSelector killsTotal, @QueryParam(value="killsYesterday") @DefaultValue(value="{ any: true }") @ApiParam(name="killsYesterday", defaultValue="{ any: true }", value="Faction war statistics kills yesterday selector") AttributeSelector killsYesterday, @QueryParam(value="pilots") @DefaultValue(value="{ any: true }") @ApiParam(name="pilots", defaultValue="{ any: true }", value="Faction war statistics pilot count selector") AttributeSelector pilots, @QueryParam(value="victoryPointsLastWeek") @DefaultValue(value="{ any: true }") @ApiParam(name="victoryPointsLastWeek", defaultValue="{ any: true }", value="Faction war statistics victory points last week selector") AttributeSelector victoryPointsLastWeek, @QueryParam(value="victoryPointsTotal") @DefaultValue(value="{ any: true }") @ApiParam(name="victoryPointsTotal", defaultValue="{ any: true }", value="Faction war statistics victory points total selector") AttributeSelector victoryPointsTotal, @QueryParam(value="victoryPointsYesterday") @DefaultValue(value="{ any: true }") @ApiParam(name="victoryPointsYesterday", defaultValue="{ any: true }", value="Faction war statistics victory points yesterday selector") AttributeSelector victoryPointsYesterday) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_FAC_WAR_STATS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<FacWarStats>(){

            @Override
            public List<FacWarStats> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean CURRENT_RANK = false;
                boolean ENLISTED = true;
                int FACTION_ID = 2;
                int HIGHEST_RANK = 3;
                int KILLS_LAST_WEEK = 4;
                int KILLS_TOTAL = 5;
                int KILLS_YESTERDAY = 6;
                int PILOTS = 7;
                int VICTORY_POINTS_LAST_WEEK = 8;
                int VICTORY_POINTS_TOTAL = 9;
                int VICTORY_POINTS_YESTERDAY = 10;
                return FacWarStats.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5], (AttributeSelector)others[6], (AttributeSelector)others[7], (AttributeSelector)others[8], (AttributeSelector)others[9], (AttributeSelector)others[10]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(acct.isCharacterType() ? ESISyncEndpoint.CHAR_FACTION_WAR : ESISyncEndpoint.CORP_FACTION_WAR, acct);
            }
        }, request, currentRank, enlisted, factionID, highestRank, killsLastWeek, killsTotal, killsYesterday, pilots, victoryPointsLastWeek, victoryPointsTotal, victoryPointsYesterday);
    }

    @Path(value="/industry_job")
    @GET
    @ApiOperation(value="Get industry jobs")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested industry jobs", response=IndustryJob.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getIndustryJobs(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="jobID") @DefaultValue(value="{ any: true }") @ApiParam(name="jobID", defaultValue="{ any: true }", value="Industry job ID selector") AttributeSelector jobID, @QueryParam(value="installerID") @DefaultValue(value="{ any: true }") @ApiParam(name="installerID", defaultValue="{ any: true }", value="Industry job installer ID selector") AttributeSelector installerID, @QueryParam(value="facilityID") @DefaultValue(value="{ any: true }") @ApiParam(name="facilityID", defaultValue="{ any: true }", value="Industry job facility ID selector") AttributeSelector facilityID, @QueryParam(value="stationID") @DefaultValue(value="{ any: true }") @ApiParam(name="stationID", defaultValue="{ any: true }", value="Industry job station ID selector") AttributeSelector stationID, @QueryParam(value="activityID") @DefaultValue(value="{ any: true }") @ApiParam(name="activityID", defaultValue="{ any: true }", value="Industry job activity ID selector") AttributeSelector activityID, @QueryParam(value="blueprintID") @DefaultValue(value="{ any: true }") @ApiParam(name="blueprintID", defaultValue="{ any: true }", value="Industry job blueprint ID selector") AttributeSelector blueprintID, @QueryParam(value="blueprintTypeID") @DefaultValue(value="{ any: true }") @ApiParam(name="blueprintTypeID", defaultValue="{ any: true }", value="Industry job blueprint type ID selector") AttributeSelector blueprintTypeID, @QueryParam(value="blueprintLocationID") @DefaultValue(value="{ any: true }") @ApiParam(name="blueprintLocationID", defaultValue="{ any: true }", value="Industry job blueprint location ID selector") AttributeSelector blueprintLocationID, @QueryParam(value="outputLocationID") @DefaultValue(value="{ any: true }") @ApiParam(name="outputLocationID", defaultValue="{ any: true }", value="Industry job output location ID selector") AttributeSelector outputLocationID, @QueryParam(value="runs") @DefaultValue(value="{ any: true }") @ApiParam(name="runs", defaultValue="{ any: true }", value="Industry job runs selector") AttributeSelector runs, @QueryParam(value="cost") @DefaultValue(value="{ any: true }") @ApiParam(name="cost", defaultValue="{ any: true }", value="Industry job cost selector") AttributeSelector cost, @QueryParam(value="licensedRuns") @DefaultValue(value="{ any: true }") @ApiParam(name="licensedRuns", defaultValue="{ any: true }", value="Industry job licensed runs selector") AttributeSelector licensedRuns, @QueryParam(value="probability") @DefaultValue(value="{ any: true }") @ApiParam(name="probability", defaultValue="{ any: true }", value="Industry job probability selector") AttributeSelector probability, @QueryParam(value="productTypeID") @DefaultValue(value="{ any: true }") @ApiParam(name="productTypeID", defaultValue="{ any: true }", value="Industry job product type ID selector") AttributeSelector productTypeID, @QueryParam(value="status") @DefaultValue(value="{ any: true }") @ApiParam(name="status", defaultValue="{ any: true }", value="Industry job status selector") AttributeSelector status, @QueryParam(value="timeInSeconds") @DefaultValue(value="{ any: true }") @ApiParam(name="timeInSeconds", defaultValue="{ any: true }", value="Industry job time in seconds selector") AttributeSelector timeInSeconds, @QueryParam(value="startDate") @DefaultValue(value="{ any: true }") @ApiParam(name="startDate", defaultValue="{ any: true }", value="Industry job start date selector") AttributeSelector startDate, @QueryParam(value="endDate") @DefaultValue(value="{ any: true }") @ApiParam(name="endDate", defaultValue="{ any: true }", value="Industry job end date selector") AttributeSelector endDate, @QueryParam(value="pauseDate") @DefaultValue(value="{ any: true }") @ApiParam(name="pauseDate", defaultValue="{ any: true }", value="Industry job pause date selector") AttributeSelector pauseDate, @QueryParam(value="completedDate") @DefaultValue(value="{ any: true }") @ApiParam(name="completedDate", defaultValue="{ any: true }", value="Industry job completed date selector") AttributeSelector completedDate, @QueryParam(value="completedCharacterID") @DefaultValue(value="{ any: true }") @ApiParam(name="completedCharacterID", defaultValue="{ any: true }", value="Industry job completed character ID selector") AttributeSelector completedCharacterID, @QueryParam(value="successfulRuns") @DefaultValue(value="{ any: true }") @ApiParam(name="successfulRuns", defaultValue="{ any: true }", value="Industry job successful runs selector") AttributeSelector successfulRuns) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_INDUSTRY_JOBS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<IndustryJob>(){

            @Override
            public List<IndustryJob> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean JOB_ID = false;
                boolean INSTALLER_ID = true;
                int FACILITY_ID = 2;
                int STATION_ID = 3;
                int ACTIVITY_ID = 4;
                int BLUEPRINT_ID = 5;
                int BLUEPRINT_TYPE_ID = 6;
                int BLUEPRINT_LOCATION_ID = 7;
                int OUTPUT_LOCATION_ID = 8;
                int RUNS = 9;
                int COST = 10;
                int LICENSED_RUNS = 11;
                int PROBABILITY = 12;
                int PRODUCT_TYPE_ID = 13;
                int STATUS = 14;
                int TIME_IN_SECONDS = 15;
                int START_DATE = 16;
                int END_DATE = 17;
                int PAUSE_DATE = 18;
                int COMPLETED_DATE = 19;
                int COMPLETED_CHARACTER_ID = 20;
                int SUCCESSFUL_RUNS = 21;
                return IndustryJob.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5], (AttributeSelector)others[6], (AttributeSelector)others[7], (AttributeSelector)others[8], (AttributeSelector)others[9], (AttributeSelector)others[10], (AttributeSelector)others[11], (AttributeSelector)others[12], (AttributeSelector)others[13], (AttributeSelector)others[14], (AttributeSelector)others[15], (AttributeSelector)others[16], (AttributeSelector)others[17], (AttributeSelector)others[18], (AttributeSelector)others[19], (AttributeSelector)others[20], (AttributeSelector)others[21]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(acct.isCharacterType() ? ESISyncEndpoint.CHAR_INDUSTRY : ESISyncEndpoint.CORP_INDUSTRY, acct);
            }
        }, request, jobID, installerID, facilityID, stationID, activityID, blueprintID, blueprintTypeID, blueprintLocationID, outputLocationID, runs, cost, licensedRuns, probability, productTypeID, status, timeInSeconds, startDate, endDate, pauseDate, completedDate, completedCharacterID, successfulRuns);
    }

    @Path(value="/kill")
    @GET
    @ApiOperation(value="Get kills")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested kills", response=Kill.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getKills(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="killID") @DefaultValue(value="{ any: true }") @ApiParam(name="killID", defaultValue="{ any: true }", value="Kill ID selector") AttributeSelector killID, @QueryParam(value="killTime") @DefaultValue(value="{ any: true }") @ApiParam(name="killTime", defaultValue="{ any: true }", value="Kill time selector") AttributeSelector killTime, @QueryParam(value="moonID") @DefaultValue(value="{ any: true }") @ApiParam(name="moonID", defaultValue="{ any: true }", value="Kill moon ID selector") AttributeSelector moonID, @QueryParam(value="solarSystemID") @DefaultValue(value="{ any: true }") @ApiParam(name="solarSystemID", defaultValue="{ any: true }", value="Kill solar system ID selector") AttributeSelector solarSystemID, @QueryParam(value="warID") @DefaultValue(value="{ any: true }") @ApiParam(name="warID", defaultValue="{ any: true }", value="War ID selector") AttributeSelector warID) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_KILL_LOG, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<Kill>(){

            @Override
            public List<Kill> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean KILL_ID = false;
                boolean KILL_TIME = true;
                int MOON_ID = 2;
                int SOLAR_SYSTEM_ID = 3;
                int WAR_ID = 4;
                return Kill.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(acct.isCharacterType() ? ESISyncEndpoint.CHAR_KILL_MAIL : ESISyncEndpoint.CORP_KILL_MAIL, acct);
            }
        }, request, killID, killTime, moonID, solarSystemID, warID);
    }

    @Path(value="/kill_attacker")
    @GET
    @ApiOperation(value="Get kill attackers")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested kill attackers", response=KillAttacker.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getKillAttackers(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="killID") @DefaultValue(value="{ any: true }") @ApiParam(name="killID", defaultValue="{ any: true }", value="Kill ID selector") AttributeSelector killID, @QueryParam(value="attackerCharacterID") @DefaultValue(value="{ any: true }") @ApiParam(name="attackerCharacterID", defaultValue="{ any: true }", value="Kill attacker character ID selector") AttributeSelector attackerCharacterID, @QueryParam(value="allianceID") @DefaultValue(value="{ any: true }") @ApiParam(name="allianceID", defaultValue="{ any: true }", value="Kill attacker alliance ID selector") AttributeSelector allianceID, @QueryParam(value="attackerCorporationID") @DefaultValue(value="{ any: true }") @ApiParam(name="attackerCorporationID", defaultValue="{ any: true }", value="Kill attacker corporation ID selector") AttributeSelector attackerCorporationID, @QueryParam(value="damageDone") @DefaultValue(value="{ any: true }") @ApiParam(name="damageDone", defaultValue="{ any: true }", value="Kill attacker damage done selector") AttributeSelector damageDone, @QueryParam(value="factionID") @DefaultValue(value="{ any: true }") @ApiParam(name="factionID", defaultValue="{ any: true }", value="Kill attacker faction ID selector") AttributeSelector factionID, @QueryParam(value="securityStatus") @DefaultValue(value="{ any: true }") @ApiParam(name="securityStatus", defaultValue="{ any: true }", value="Kill attacker security status selector") AttributeSelector securityStatus, @QueryParam(value="shipTypeID") @DefaultValue(value="{ any: true }") @ApiParam(name="shipTypeID", defaultValue="{ any: true }", value="Kill attacker ship type ID selector") AttributeSelector shipTypeID, @QueryParam(value="weaponTypeID") @DefaultValue(value="{ any: true }") @ApiParam(name="weaponTypeID", defaultValue="{ any: true }", value="Kill attacker weapon type ID selector") AttributeSelector weaponTypeID, @QueryParam(value="finalBlow") @DefaultValue(value="{ any: true }") @ApiParam(name="finalBlow", defaultValue="{ any: true }", value="Kill attacker final blow selector") AttributeSelector finalBlow) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_KILL_LOG, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<KillAttacker>(){

            @Override
            public List<KillAttacker> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean KILL_ID = false;
                boolean ATTACKER_CHARACTER_ID = true;
                int ALLIANCE_ID = 2;
                int ATTACKER_CORPORATION_ID = 3;
                int DAMAGE_DONE = 4;
                int FACTION_ID = 5;
                int SECURITY_STATUS = 6;
                int SHIP_TYPE_ID = 7;
                int WEAPON_TYPE_ID = 8;
                int FINAL_BLOW = 9;
                return KillAttacker.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5], (AttributeSelector)others[6], (AttributeSelector)others[7], (AttributeSelector)others[8], (AttributeSelector)others[9]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(acct.isCharacterType() ? ESISyncEndpoint.CHAR_KILL_MAIL : ESISyncEndpoint.CORP_KILL_MAIL, acct);
            }
        }, request, killID, attackerCharacterID, allianceID, attackerCorporationID, damageDone, factionID, securityStatus, shipTypeID, weaponTypeID, finalBlow);
    }

    @Path(value="/kill_item")
    @GET
    @ApiOperation(value="Get kill items")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested kill items", response=KillItem.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getKillItems(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="killID") @DefaultValue(value="{ any: true }") @ApiParam(name="killID", defaultValue="{ any: true }", value="Kill ID selector") AttributeSelector killID, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", defaultValue="{ any: true }", value="Kill item type ID selector") AttributeSelector typeID, @QueryParam(value="flag") @DefaultValue(value="{ any: true }") @ApiParam(name="flag", defaultValue="{ any: true }", value="Kill item flag selector") AttributeSelector flag, @QueryParam(value="qtyDestroyed") @DefaultValue(value="{ any: true }") @ApiParam(name="qtyDestroyed", defaultValue="{ any: true }", value="Kill item quantity destroyed selector") AttributeSelector qtyDestroyed, @QueryParam(value="qtyDropped") @DefaultValue(value="{ any: true }") @ApiParam(name="qtyDropped", defaultValue="{ any: true }", value="Kill item quantity dropped selector") AttributeSelector qtyDropped, @QueryParam(value="singleton") @DefaultValue(value="{ any: true }") @ApiParam(name="singleton", defaultValue="{ any: true }", value="Kill item singleton selector") AttributeSelector singleton, @QueryParam(value="sequence") @DefaultValue(value="{ any: true }") @ApiParam(name="sequence", defaultValue="{ any: true }", value="Kill item sequence selector") AttributeSelector sequence, @QueryParam(value="containerSequence") @DefaultValue(value="{ any: true }") @ApiParam(name="containerSequence", defaultValue="{ any: true }", value="Kill item container sequence selector") AttributeSelector containerSequence) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_KILL_LOG, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<KillItem>(){

            @Override
            public List<KillItem> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean KILL_ID = false;
                boolean TYPE_ID = true;
                int FLAG = 2;
                int QTY_DESTROYED = 3;
                int QTY_DROPPED = 4;
                int SINGLETON = 5;
                int SEQUENCE = 6;
                int CONTAINER_SEQUENCE = 7;
                return KillItem.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5], (AttributeSelector)others[6], (AttributeSelector)others[7]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(acct.isCharacterType() ? ESISyncEndpoint.CHAR_KILL_MAIL : ESISyncEndpoint.CORP_KILL_MAIL, acct);
            }
        }, request, killID, typeID, flag, qtyDestroyed, qtyDropped, singleton, sequence, containerSequence);
    }

    @Path(value="/kill_victim")
    @GET
    @ApiOperation(value="Get kill victims")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested kill victims", response=KillVictim.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getKillVictims(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="killID") @DefaultValue(value="{ any: true }") @ApiParam(name="killID", defaultValue="{ any: true }", value="Kill ID selector") AttributeSelector killID, @QueryParam(value="allianceID") @DefaultValue(value="{ any: true }") @ApiParam(name="allianceID", defaultValue="{ any: true }", value="Kill victim alliance ID selector") AttributeSelector allianceID, @QueryParam(value="killCharacterID") @DefaultValue(value="{ any: true }") @ApiParam(name="killCharacterID", defaultValue="{ any: true }", value="Kill victim character ID selector") AttributeSelector killCharacterID, @QueryParam(value="killCorporationID") @DefaultValue(value="{ any: true }") @ApiParam(name="killCorporationID", defaultValue="{ any: true }", value="Kill victim corporation ID selector") AttributeSelector killCorporationID, @QueryParam(value="damageTaken") @DefaultValue(value="{ any: true }") @ApiParam(name="damageTaken", defaultValue="{ any: true }", value="Kill victim damage taken selector") AttributeSelector damageTaken, @QueryParam(value="factionID") @DefaultValue(value="{ any: true }") @ApiParam(name="factionID", defaultValue="{ any: true }", value="Kill victim faction ID selector") AttributeSelector factionID, @QueryParam(value="shipTypeID") @DefaultValue(value="{ any: true }") @ApiParam(name="shipTypeID", defaultValue="{ any: true }", value="Kill victim ship type ID selector") AttributeSelector shipTypeID, @QueryParam(value="x") @DefaultValue(value="{ any: true }") @ApiParam(name="x", defaultValue="{ any: true }", value="Kill X position selector") AttributeSelector x, @QueryParam(value="y") @DefaultValue(value="{ any: true }") @ApiParam(name="y", defaultValue="{ any: true }", value="Kill Y position selector") AttributeSelector y, @QueryParam(value="z") @DefaultValue(value="{ any: true }") @ApiParam(name="z", defaultValue="{ any: true }", value="Kill Z position selector") AttributeSelector z) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_KILL_LOG, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<KillVictim>(){

            @Override
            public List<KillVictim> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean KILL_ID = false;
                boolean ALLIANCE_ID = true;
                int KILL_CHARACTER_ID = 2;
                int KILL_CORPORATION_ID = 3;
                int DAMAGE_TAKEN = 4;
                int FACTION_ID = 5;
                int SHIP_TYPE_ID = 6;
                int X = 7;
                int Y = 8;
                int Z = 9;
                return KillVictim.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5], (AttributeSelector)others[6], (AttributeSelector)others[7], (AttributeSelector)others[8], (AttributeSelector)others[9]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(acct.isCharacterType() ? ESISyncEndpoint.CHAR_KILL_MAIL : ESISyncEndpoint.CORP_KILL_MAIL, acct);
            }
        }, request, killID, allianceID, killCharacterID, killCorporationID, damageTaken, factionID, shipTypeID, x, y, z);
    }

    @Path(value="/location")
    @GET
    @ApiOperation(value="Get locations")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested locations", response=Location.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getLocations(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="itemID") @DefaultValue(value="{ any: true }") @ApiParam(name="itemID", defaultValue="{ any: true }", value="Location item ID selector") AttributeSelector itemID, @QueryParam(value="itemName") @DefaultValue(value="{ any: true }") @ApiParam(name="itemName", defaultValue="{ any: true }", value="Location item name selector") AttributeSelector itemName, @QueryParam(value="x") @DefaultValue(value="{ any: true }") @ApiParam(name="x", defaultValue="{ any: true }", value="Location X position selector") AttributeSelector x, @QueryParam(value="y") @DefaultValue(value="{ any: true }") @ApiParam(name="y", defaultValue="{ any: true }", value="Location Y position selector") AttributeSelector y, @QueryParam(value="z") @DefaultValue(value="{ any: true }") @ApiParam(name="z", defaultValue="{ any: true }", value="Location Z position selector") AttributeSelector z) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_LOCATIONS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<Location>(){

            @Override
            public List<Location> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean ITEM_ID = false;
                boolean ITEM_NAME = true;
                int X = 2;
                int Y = 3;
                int Z = 4;
                return Location.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(acct.isCharacterType() ? ESISyncEndpoint.CHAR_ASSETS : ESISyncEndpoint.CORP_ASSETS, acct);
            }
        }, request, itemID, itemName, x, y, z);
    }

    @Path(value="/market_order")
    @GET
    @ApiOperation(value="Get market orders")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested market orders", response=MarketOrder.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getMarketOrders(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="orderID") @DefaultValue(value="{ any: true }") @ApiParam(name="orderID", defaultValue="{ any: true }", value="Market order ID selector") AttributeSelector orderID, @QueryParam(value="walletDivision") @DefaultValue(value="{ any: true }") @ApiParam(name="walletDivision", defaultValue="{ any: true }", value="Market order wallet division selector") AttributeSelector walletDivision, @QueryParam(value="bid") @DefaultValue(value="{ any: true }") @ApiParam(name="bid", defaultValue="{ any: true }", value="Market order bid indicator selector") AttributeSelector bid, @QueryParam(value="charID") @DefaultValue(value="{ any: true }") @ApiParam(name="charID", defaultValue="{ any: true }", value="Market order character ID selector") AttributeSelector charID, @QueryParam(value="duration") @DefaultValue(value="{ any: true }") @ApiParam(name="duration", defaultValue="{ any: true }", value="Market order duration selector") AttributeSelector duration, @QueryParam(value="escrow") @DefaultValue(value="{ any: true }") @ApiParam(name="escrow", defaultValue="{ any: true }", value="Market order escrow selector") AttributeSelector escrow, @QueryParam(value="issued") @DefaultValue(value="{ any: true }") @ApiParam(name="issued", defaultValue="{ any: true }", value="Market order issue date selector") AttributeSelector issued, @QueryParam(value="minVolume") @DefaultValue(value="{ any: true }") @ApiParam(name="minVolume", defaultValue="{ any: true }", value="Market order min volume selector") AttributeSelector minVolume, @QueryParam(value="orderState") @DefaultValue(value="{ any: true }") @ApiParam(name="orderState", defaultValue="{ any: true }", value="Market order state selector") AttributeSelector orderState, @QueryParam(value="price") @DefaultValue(value="{ any: true }") @ApiParam(name="price", defaultValue="{ any: true }", value="Market order price selector") AttributeSelector price, @QueryParam(value="orderRange") @DefaultValue(value="{ any: true }") @ApiParam(name="orderRange", defaultValue="{ any: true }", value="Market order range selector") AttributeSelector orderRange, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", defaultValue="{ any: true }", value="Market order type ID selector") AttributeSelector typeID, @QueryParam(value="volEntered") @DefaultValue(value="{ any: true }") @ApiParam(name="volEntered", defaultValue="{ any: true }", value="Market order volume entered selector") AttributeSelector volEntered, @QueryParam(value="volRemaining") @DefaultValue(value="{ any: true }") @ApiParam(name="volRemaining", defaultValue="{ any: true }", value="Market order volume remaining selector") AttributeSelector volRemaining, @QueryParam(value="regionID") @DefaultValue(value="{ any: true }") @ApiParam(name="regionID", defaultValue="{ any: true }", value="Market order region ID selector") AttributeSelector regionID, @QueryParam(value="locationID") @DefaultValue(value="{ any: true }") @ApiParam(name="locationID", defaultValue="{ any: true }", value="Market order location ID selector") AttributeSelector locationID, @QueryParam(value="isCorp") @DefaultValue(value="{ any: true }") @ApiParam(name="isCorp", defaultValue="{ any: true }", value="Market order is corporation selector") AttributeSelector isCorp) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_MARKET_ORDERS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<MarketOrder>(){

            @Override
            public List<MarketOrder> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean ORDER_ID = false;
                boolean WALLET_DIVISION = true;
                int BID = 2;
                int CHAR_ID = 3;
                int DURATION = 4;
                int ESCROW = 5;
                int ISSUED = 6;
                int MIN_VOLUME = 7;
                int ORDER_STATE = 8;
                int PRICE = 9;
                int ORDER_RANGE = 10;
                int TYPE_ID = 11;
                int VOL_ENTERED = 12;
                int VOL_REMAINING = 13;
                int REGION_ID = 14;
                int LOCATION_ID = 15;
                int IS_CORP = 16;
                return MarketOrder.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5], (AttributeSelector)others[6], (AttributeSelector)others[7], (AttributeSelector)others[8], (AttributeSelector)others[9], (AttributeSelector)others[10], (AttributeSelector)others[11], (AttributeSelector)others[12], (AttributeSelector)others[13], (AttributeSelector)others[14], (AttributeSelector)others[15], (AttributeSelector)others[16]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(acct.isCharacterType() ? ESISyncEndpoint.CHAR_MARKET : ESISyncEndpoint.CORP_MARKET, acct);
            }
        }, request, orderID, walletDivision, bid, charID, duration, escrow, issued, minVolume, orderState, price, orderRange, typeID, volEntered, volRemaining, regionID, locationID, isCorp);
    }

    @Path(value="/standing")
    @GET
    @ApiOperation(value="Get standings)")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested standings", response=Standing.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getStandings(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="standingEntity") @DefaultValue(value="{ any: true }") @ApiParam(name="standingEntity", defaultValue="{ any: true }", value="Standing entity selector") AttributeSelector standingEntity, @QueryParam(value="fromID") @DefaultValue(value="{ any: true }") @ApiParam(name="fromID", defaultValue="{ any: true }", value="Standing from ID selector") AttributeSelector fromID, @QueryParam(value="standing") @DefaultValue(value="{ any: true }") @ApiParam(name="standing", defaultValue="{ any: true }", value="Standing value selector") AttributeSelector standing) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_STANDINGS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<Standing>(){

            @Override
            public List<Standing> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean STANDING_ENTITY = false;
                boolean FROM_ID = true;
                int STANDING = 2;
                return Standing.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(acct.isCharacterType() ? ESISyncEndpoint.CHAR_STANDINGS : ESISyncEndpoint.CORP_STANDINGS, acct);
            }
        }, request, standingEntity, fromID, standing);
    }

    @Path(value="/wallet_journal")
    @GET
    @ApiOperation(value="Get wallet journal entries")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested wallet journal entries", response=WalletJournal.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getJournalEntries(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="division") @DefaultValue(value="{ any: true }") @ApiParam(name="division", defaultValue="{ any: true }", value="Wallet journal division selector") AttributeSelector division, @QueryParam(value="refID") @DefaultValue(value="{ any: true }") @ApiParam(name="refID", defaultValue="{ any: true }", value="Journal entry ref ID selector") AttributeSelector refID, @QueryParam(value="date") @DefaultValue(value="{ any: true }") @ApiParam(name="date", defaultValue="{ any: true }", value="Journal entry date selector") AttributeSelector date, @QueryParam(value="refType") @DefaultValue(value="{ any: true }") @ApiParam(name="refType", defaultValue="{ any: true }", value="Journal entry ref type selector") AttributeSelector refType, @QueryParam(value="firstPartyID") @DefaultValue(value="{ any: true }") @ApiParam(name="firstPartyID", defaultValue="{ any: true }", value="Journal entry first party ID selector") AttributeSelector firstPartyID, @QueryParam(value="secondPartyID") @DefaultValue(value="{ any: true }") @ApiParam(name="secondPartyID", defaultValue="{ any: true }", value="Journal entry second party ID selector") AttributeSelector secondPartyID, @QueryParam(value="argName1") @DefaultValue(value="{ any: true }") @ApiParam(name="argName1", defaultValue="{ any: true }", value="Journal entry argument name selector") AttributeSelector argName1, @QueryParam(value="argID1") @DefaultValue(value="{ any: true }") @ApiParam(name="argID1", defaultValue="{ any: true }", value="Journal entry argument ID selector") AttributeSelector argID1, @QueryParam(value="amount") @DefaultValue(value="{ any: true }") @ApiParam(name="amount", defaultValue="{ any: true }", value="Journal entry amount selector") AttributeSelector amount, @QueryParam(value="balance") @DefaultValue(value="{ any: true }") @ApiParam(name="balance", defaultValue="{ any: true }", value="Journal entry balance selector") AttributeSelector balance, @QueryParam(value="reason") @DefaultValue(value="{ any: true }") @ApiParam(name="reason", defaultValue="{ any: true }", value="Journal entry reason selector") AttributeSelector reason, @QueryParam(value="taxReceiverID") @DefaultValue(value="{ any: true }") @ApiParam(name="taxReceiverID", defaultValue="{ any: true }", value="Journal entry tax receiver ID selector") AttributeSelector taxReceiverID, @QueryParam(value="taxAmount") @DefaultValue(value="{ any: true }") @ApiParam(name="taxAmount", defaultValue="{ any: true }", value="Journal entry tax amount selector") AttributeSelector taxAmount, @QueryParam(value="contextID") @DefaultValue(value="{ any: true }") @ApiParam(name="contextID", defaultValue="{ any: true }", value="Context ID selector") AttributeSelector contextID, @QueryParam(value="contextType") @DefaultValue(value="{ any: true }") @ApiParam(name="contextType", defaultValue="{ any: true }", value="Context type selector") AttributeSelector contextType, @QueryParam(value="description") @DefaultValue(value="{ any: true }") @ApiParam(name="description", defaultValue="{ any: true }", value="Description selector") AttributeSelector description) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_WALLET_JOURNAL, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<WalletJournal>(){

            @Override
            public List<WalletJournal> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean DIVISION = false;
                boolean REF_ID = true;
                int DATE = 2;
                int REF_TYPE = 3;
                int FIRST_PARTY_ID = 4;
                int SECOND_PARTY_ID = 5;
                int ARG_NAME_1 = 6;
                int ARG_ID_1 = 7;
                int AMOUNT = 8;
                int BALANCE = 9;
                int REASON = 10;
                int TAX_RECEIVER_ID = 11;
                int TAX_AMOUNT = 12;
                int CONTEXT_ID = 13;
                int CONTEXT_TYPE = 14;
                int DESCRIPTION = 15;
                return WalletJournal.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5], (AttributeSelector)others[6], (AttributeSelector)others[7], (AttributeSelector)others[8], (AttributeSelector)others[9], (AttributeSelector)others[10], (AttributeSelector)others[11], (AttributeSelector)others[12], (AttributeSelector)others[13], (AttributeSelector)others[14], (AttributeSelector)others[15]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(acct.isCharacterType() ? ESISyncEndpoint.CHAR_WALLET_JOURNAL : ESISyncEndpoint.CORP_WALLET_JOURNAL, acct);
            }
        }, request, division, refID, date, refType, firstPartyID, secondPartyID, argName1, argID1, amount, balance, reason, taxReceiverID, taxAmount, contextID, contextType, description);
    }

    @Path(value="/wallet_transaction")
    @GET
    @ApiOperation(value="Get wallet transactions")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested wallet transactions", response=WalletTransaction.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getWalletTransactions(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="division") @DefaultValue(value="{ any: true }") @ApiParam(name="division", defaultValue="{ any: true }", value="Wallet division selector") AttributeSelector division, @QueryParam(value="transactionID") @DefaultValue(value="{ any: true }") @ApiParam(name="transactionID", defaultValue="{ any: true }", value="Transaction ID selector") AttributeSelector transactionID, @QueryParam(value="date") @DefaultValue(value="{ any: true }") @ApiParam(name="date", defaultValue="{ any: true }", value="Transaction date selector") AttributeSelector date, @QueryParam(value="quantity") @DefaultValue(value="{ any: true }") @ApiParam(name="quantity", defaultValue="{ any: true }", value="Transaction quantity selector") AttributeSelector quantity, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", defaultValue="{ any: true }", value="Transaction type ID selector") AttributeSelector typeID, @QueryParam(value="price") @DefaultValue(value="{ any: true }") @ApiParam(name="price", defaultValue="{ any: true }", value="Transaction price selector") AttributeSelector price, @QueryParam(value="clientID") @DefaultValue(value="{ any: true }") @ApiParam(name="clientID", defaultValue="{ any: true }", value="Transaction client ID selector") AttributeSelector clientID, @QueryParam(value="locationID") @DefaultValue(value="{ any: true }") @ApiParam(name="locationID", defaultValue="{ any: true }", value="Transaction location ID selector") AttributeSelector locationID, @QueryParam(value="isBuy") @DefaultValue(value="{ any: true }") @ApiParam(name="isBuy", defaultValue="{ any: true }", value="Transaction isBuy selector") AttributeSelector isBuy, @QueryParam(value="isPersonal") @DefaultValue(value="{ any: true }") @ApiParam(name="isPersonal", defaultValue="{ any: true }", value="Transaction isPersonal selector") AttributeSelector isPersonal, @QueryParam(value="journalTransactionID") @DefaultValue(value="{ any: true }") @ApiParam(name="journalTransactionID", defaultValue="{ any: true }", value="Journal transaction ID selector") AttributeSelector journalTransactionID) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_WALLET_TRANSACTIONS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<WalletTransaction>(){

            @Override
            public List<WalletTransaction> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean DIVISION = false;
                boolean TRANSACTION_ID = true;
                int DATE = 2;
                int QUANTITY = 3;
                int TYPE_ID = 4;
                int PRICE = 5;
                int CLIENT_ID = 6;
                int LOCATION_ID = 7;
                int IS_BUY = 8;
                int IS_PERSONAL = 9;
                int JOURNAL_TRANSACTION_ID = 10;
                return WalletTransaction.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5], (AttributeSelector)others[6], (AttributeSelector)others[7], (AttributeSelector)others[8], (AttributeSelector)others[9], (AttributeSelector)others[10]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(acct.isCharacterType() ? ESISyncEndpoint.CHAR_WALLET_TRANSACTIONS : ESISyncEndpoint.CORP_WALLET_TRANSACTIONS, acct);
            }
        }, request, division, transactionID, date, quantity, typeID, price, clientID, locationID, isBuy, isPersonal, journalTransactionID);
    }
}

