/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.ws.character;

import enterprises.orbital.base.OrbitalProperties;
import enterprises.orbital.evekit.account.AccountAccessMask;
import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.ESISyncEndpoint;
import enterprises.orbital.evekit.model.character.CalendarEventAttendee;
import enterprises.orbital.evekit.model.character.CharacterContactNotification;
import enterprises.orbital.evekit.model.character.CharacterLocation;
import enterprises.orbital.evekit.model.character.CharacterMailMessage;
import enterprises.orbital.evekit.model.character.CharacterMedal;
import enterprises.orbital.evekit.model.character.CharacterMedalGraphic;
import enterprises.orbital.evekit.model.character.CharacterNotification;
import enterprises.orbital.evekit.model.character.CharacterOnline;
import enterprises.orbital.evekit.model.character.CharacterRole;
import enterprises.orbital.evekit.model.character.CharacterSheet;
import enterprises.orbital.evekit.model.character.CharacterSheetAttributes;
import enterprises.orbital.evekit.model.character.CharacterSheetClone;
import enterprises.orbital.evekit.model.character.CharacterSheetJump;
import enterprises.orbital.evekit.model.character.CharacterSheetSkillPoints;
import enterprises.orbital.evekit.model.character.CharacterShip;
import enterprises.orbital.evekit.model.character.CharacterSkill;
import enterprises.orbital.evekit.model.character.CharacterTitle;
import enterprises.orbital.evekit.model.character.ChatChannel;
import enterprises.orbital.evekit.model.character.ChatChannelMember;
import enterprises.orbital.evekit.model.character.Fitting;
import enterprises.orbital.evekit.model.character.FittingItem;
import enterprises.orbital.evekit.model.character.Implant;
import enterprises.orbital.evekit.model.character.JumpClone;
import enterprises.orbital.evekit.model.character.JumpCloneImplant;
import enterprises.orbital.evekit.model.character.LoyaltyPoints;
import enterprises.orbital.evekit.model.character.MailLabel;
import enterprises.orbital.evekit.model.character.MailingList;
import enterprises.orbital.evekit.model.character.MiningLedger;
import enterprises.orbital.evekit.model.character.PlanetaryColony;
import enterprises.orbital.evekit.model.character.PlanetaryLink;
import enterprises.orbital.evekit.model.character.PlanetaryPin;
import enterprises.orbital.evekit.model.character.PlanetaryRoute;
import enterprises.orbital.evekit.model.character.ResearchAgent;
import enterprises.orbital.evekit.model.character.SkillInQueue;
import enterprises.orbital.evekit.model.character.UpcomingCalendarEvent;
import enterprises.orbital.evekit.ws.AccountHandlerUtil;
import enterprises.orbital.evekit.ws.ServiceError;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/ws/v1/char")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(tags={"Character"}, produces="application/json", consumes="application/json")
public class ModelCharacterWS {
    @Path(value="/calendar_events")
    @GET
    @ApiOperation(value="Get upcoming calendar events")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested upcoming calendar events", response=UpcomingCalendarEvent.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getUpcomingCalendarEvents(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="duration") @DefaultValue(value="{ any: true }") @ApiParam(name="duration", defaultValue="{ any: true }", value="Event duration selector") AttributeSelector duration, @QueryParam(value="eventDate") @DefaultValue(value="{ any: true }") @ApiParam(name="eventDate", defaultValue="{ any: true }", value="Event date selector (milliseconds UTC)") AttributeSelector eventDate, @QueryParam(value="eventID") @DefaultValue(value="{ any: true }") @ApiParam(name="eventID", defaultValue="{ any: true }", value="Event ID selector") AttributeSelector eventID, @QueryParam(value="eventText") @DefaultValue(value="{ any: true }") @ApiParam(name="eventText", defaultValue="{ any: true }", value="Event text selector") AttributeSelector eventText, @QueryParam(value="eventTitle") @DefaultValue(value="{ any: true }") @ApiParam(name="eventTitle", defaultValue="{ any: true }", value="Event title selector") AttributeSelector eventTitle, @QueryParam(value="ownerID") @DefaultValue(value="{ any: true }") @ApiParam(name="ownerID", defaultValue="{ any: true }", value="Owner ID selector") AttributeSelector ownerID, @QueryParam(value="ownerName") @DefaultValue(value="{ any: true }") @ApiParam(name="ownerName", defaultValue="{ any: true }", value="Owner name selector") AttributeSelector ownerName, @QueryParam(value="response") @DefaultValue(value="{ any: true }") @ApiParam(name="response", defaultValue="{ any: true }", value="Response text selector") AttributeSelector response, @QueryParam(value="importance") @DefaultValue(value="{ any: true }") @ApiParam(name="importance", defaultValue="{ any: true }", value="Importance selector") AttributeSelector importance, @QueryParam(value="ownerType") @DefaultValue(value="{ any: true }") @ApiParam(name="ownerType", defaultValue="{ any: true }", value="Event owner type selector") AttributeSelector ownerType) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_UPCOMING_CALENDAR_EVENTS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<UpcomingCalendarEvent>(){

            @Override
            public List<UpcomingCalendarEvent> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean DURATION = false;
                boolean EVENT_DATE = true;
                int EVENT_ID = 2;
                int EVENT_TEXT = 3;
                int EVENT_TITLE = 4;
                int OWNER_ID = 5;
                int OWNER_NAME = 6;
                int RESPONSE = 7;
                int IMPORTANCE = 8;
                int OWNER_TYPE = 9;
                return UpcomingCalendarEvent.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5], (AttributeSelector)others[6], (AttributeSelector)others[7], (AttributeSelector)others[8], (AttributeSelector)others[9]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_CALENDAR, acct);
            }
        }, request, duration, eventDate, eventID, eventText, eventTitle, ownerID, ownerName, response, importance, ownerType);
    }

    @Path(value="/calendar_event_attendees")
    @GET
    @ApiOperation(value="Get calendar event attendees")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested calendar event attendees", response=CalendarEventAttendee.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getCalendarEventAttendees(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="eventID") @DefaultValue(value="{ any: true }") @ApiParam(name="eventID", defaultValue="{ any: true }", value="Calendar event ID selector") AttributeSelector eventID, @QueryParam(value="characterID") @DefaultValue(value="{ any: true }") @ApiParam(name="characterID", defaultValue="{ any: true }", value="Attending character ID selector") AttributeSelector characterID, @QueryParam(value="response") @DefaultValue(value="{ any: true }") @ApiParam(name="response", defaultValue="{ any: true }", value="Attendee response selector") AttributeSelector response) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_CALENDAR_EVENT_ATTENDEES, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<CalendarEventAttendee>(){

            @Override
            public List<CalendarEventAttendee> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean EVENT_ID = false;
                boolean CHARACTER_ID = true;
                int RESPONSE = 2;
                return CalendarEventAttendee.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_CALENDAR, acct);
            }
        }, request, eventID, characterID, response);
    }

    @Path(value="/role")
    @GET
    @ApiOperation(value="Get character roles")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested character roles", response=CharacterRole.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getRoles(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="roleCategory") @DefaultValue(value="{ any: true }") @ApiParam(name="roleCategory", defaultValue="{ any: true }", value="Role category selector") AttributeSelector roleCategory, @QueryParam(value="roleName") @DefaultValue(value="{ any: true }") @ApiParam(name="roleName", defaultValue="{ any: true }", value="Role name selector") AttributeSelector roleName) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_CHARACTER_SHEET, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<CharacterRole>(){

            @Override
            public List<CharacterRole> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean ROLE_CATEGORY = false;
                boolean ROLE_NAME = true;
                return CharacterRole.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_CORP_ROLES, acct);
            }
        }, request, roleCategory, roleName);
    }

    @Path(value="/sheet")
    @GET
    @ApiOperation(value="Get character sheet")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested character sheets", response=CharacterSheet.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getCharacterSheets(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="characterID") @DefaultValue(value="{ any: true }") @ApiParam(name="characterID", defaultValue="{ any: true }", value="Character ID selector") AttributeSelector characterID, @QueryParam(value="name") @DefaultValue(value="{ any: true }") @ApiParam(name="name", defaultValue="{ any: true }", value="Name selector") AttributeSelector name, @QueryParam(value="corporationID") @DefaultValue(value="{ any: true }") @ApiParam(name="corporationID", defaultValue="{ any: true }", value="Corporation ID selector") AttributeSelector corporationID, @QueryParam(value="raceID") @DefaultValue(value="{ any: true }") @ApiParam(name="raceID", defaultValue="{ any: true }", value="Race selector") AttributeSelector raceID, @QueryParam(value="doB") @DefaultValue(value="{ any: true }") @ApiParam(name="doB", defaultValue="{ any: true }", value="Date of birth selector") AttributeSelector doB, @QueryParam(value="bloodlineID") @DefaultValue(value="{ any: true }") @ApiParam(name="bloodlineID", defaultValue="{ any: true }", value="Bloodline ID selector") AttributeSelector bloodlineID, @QueryParam(value="ancestryID") @DefaultValue(value="{ any: true }") @ApiParam(name="ancestryID", defaultValue="{ any: true }", value="Ancestry ID selector") AttributeSelector ancestryID, @QueryParam(value="gender") @DefaultValue(value="{ any: true }") @ApiParam(name="gender", defaultValue="{ any: true }", value="Gender selector") AttributeSelector gender, @QueryParam(value="allianceID") @DefaultValue(value="{ any: true }") @ApiParam(name="allianceID", defaultValue="{ any: true }", value="Alliance ID selector") AttributeSelector allianceID, @QueryParam(value="factionID") @DefaultValue(value="{ any: true }") @ApiParam(name="factionID", defaultValue="{ any: true }", value="Faction ID selector") AttributeSelector factionID, @QueryParam(value="description") @DefaultValue(value="{ any: true }") @ApiParam(name="description", defaultValue="{ any: true }", value="Description selector") AttributeSelector description, @QueryParam(value="securityStatus") @DefaultValue(value="{ any: true }") @ApiParam(name="securityStatus", defaultValue="{ any: true }", value="Security status selector") AttributeSelector securityStatus) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_CHARACTER_SHEET, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<CharacterSheet>(){

            @Override
            public List<CharacterSheet> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean CHARACTER_ID = false;
                boolean NAME = true;
                int CORPORATION_ID = 2;
                int RACE_ID = 3;
                int DOB = 4;
                int BLOODLINE_ID = 5;
                int ANCESTRY_ID = 6;
                int GENDER = 7;
                int ALLIANCE_ID = 8;
                int FACTION_ID = 9;
                int DESCRIPTION = 10;
                int SECURITY_STATUS = 11;
                return CharacterSheet.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5], (AttributeSelector)others[6], (AttributeSelector)others[7], (AttributeSelector)others[8], (AttributeSelector)others[9], (AttributeSelector)others[10], (AttributeSelector)others[11]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_SHEET, acct);
            }
        }, request, characterID, name, corporationID, raceID, doB, bloodlineID, ancestryID, gender, allianceID, factionID, description, securityStatus);
    }

    @Path(value="/sheet_attributes")
    @GET
    @ApiOperation(value="Get character sheet attributes")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested character sheet attributes", response=CharacterSheetAttributes.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getCharacterSheetAttributes(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="intelligence") @DefaultValue(value="{ any: true }") @ApiParam(name="intelligence", defaultValue="{ any: true }", value="Intelligence selector") AttributeSelector intelligence, @QueryParam(value="memory") @DefaultValue(value="{ any: true }") @ApiParam(name="memory", defaultValue="{ any: true }", value="Memory selector") AttributeSelector memory, @QueryParam(value="charisma") @DefaultValue(value="{ any: true }") @ApiParam(name="charisma", defaultValue="{ any: true }", value="Charisma selector") AttributeSelector charisma, @QueryParam(value="perception") @DefaultValue(value="{ any: true }") @ApiParam(name="perception", defaultValue="{ any: true }", value="Perception selector") AttributeSelector perception, @QueryParam(value="willpower") @DefaultValue(value="{ any: true }") @ApiParam(name="willpower", defaultValue="{ any: true }", value="Willpower selector") AttributeSelector willpower, @QueryParam(value="lastRemapDate") @DefaultValue(value="{ any: true }") @ApiParam(name="lastRemapDate", defaultValue="{ any: true }", value="Last remap date selector") AttributeSelector lastRemapDate, @QueryParam(value="accruedRemapCooldownDate") @DefaultValue(value="{ any: true }") @ApiParam(name="accruedRemapCooldownDate", defaultValue="{ any: true }", value="Accrued remap cooldown date selector") AttributeSelector accruedRemapCooldownDate, @QueryParam(value="bonusRemaps") @DefaultValue(value="{ any: true }") @ApiParam(name="bonusRemaps", defaultValue="{ any: true }", value="Bonus remaps selector") AttributeSelector bonusRemaps) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_CHARACTER_SHEET, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<CharacterSheetAttributes>(){

            @Override
            public List<CharacterSheetAttributes> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean INTELLIGENCE = false;
                boolean MEMORY = true;
                int CHARISMA = 2;
                int PERCEPTION = 3;
                int WILLPOWER = 4;
                int BONUS_REMAPS = 5;
                int LAST_REMAP_DATE = 6;
                int ACCRUED_REMAP_COOLDOWN_DATE = 7;
                return CharacterSheetAttributes.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5], (AttributeSelector)others[6], (AttributeSelector)others[7]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_SKILLS, acct);
            }
        }, request, intelligence, memory, charisma, perception, willpower, bonusRemaps, lastRemapDate, accruedRemapCooldownDate);
    }

    @Path(value="/clone_jump_timer")
    @GET
    @ApiOperation(value="Get character clone jump timers")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested clone jump timers", response=CharacterSheetClone.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getCloneJumpTimers(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="cloneJumpDate") @DefaultValue(value="{ any: true }") @ApiParam(name="cloneJumpDate", defaultValue="{ any: true }", value="Clone jump date selector") AttributeSelector cloneJumpDate, @QueryParam(value="homeStationID") @DefaultValue(value="{ any: true }") @ApiParam(name="homeStationID", defaultValue="{ any: true }", value="Home station ID selector") AttributeSelector homeStationID, @QueryParam(value="homeStationType") @DefaultValue(value="{ any: true }") @ApiParam(name="homeStationType", defaultValue="{ any: true }", value="Home station type selector") AttributeSelector homeStationType, @QueryParam(value="lastStationChangeDate") @DefaultValue(value="{ any: true }") @ApiParam(name="lastStationChangeDate", defaultValue="{ any: true }", value="Last station change date selector") AttributeSelector lastStationChangeDate) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_CHARACTER_SHEET, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<CharacterSheetClone>(){

            @Override
            public List<CharacterSheetClone> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean CLONE_JUMP_DATE = false;
                boolean HOME_STATION_ID = true;
                int HOME_STATION_TYPE = 2;
                int LAST_STATION_CHANGE_DATE = 3;
                return CharacterSheetClone.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_CLONES, acct);
            }
        }, request, cloneJumpDate, homeStationID, homeStationType, lastStationChangeDate);
    }

    @Path(value="/jump_timer")
    @GET
    @ApiOperation(value="Get character jump timers")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested character jump timers", response=CharacterSheetJump.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getJumpTimers(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="jumpActivation") @DefaultValue(value="{ any: true }") @ApiParam(name="jumpActivation", defaultValue="{ any: true }", value="Jump activation selector") AttributeSelector jumpActivation, @QueryParam(value="jumpFatigue") @DefaultValue(value="{ any: true }") @ApiParam(name="jumpFatigue", defaultValue="{ any: true }", value="Jump fatigue selector") AttributeSelector jumpFatigue, @QueryParam(value="jumpLastUpdate") @DefaultValue(value="{ any: true }") @ApiParam(name="jumpLastUpdate", defaultValue="{ any: true }", value="Jump last update time selector") AttributeSelector jumpLastUpdate) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_CHARACTER_SHEET, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<CharacterSheetJump>(){

            @Override
            public List<CharacterSheetJump> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean JUMP_ACTIVATION = false;
                boolean JUMP_FATIGUE = true;
                int JUMP_LAST_UPDATE = 2;
                return CharacterSheetJump.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_FATIGUE, acct);
            }
        }, request, jumpActivation, jumpFatigue, jumpLastUpdate);
    }

    @Path(value="/loyalty_points")
    @GET
    @ApiOperation(value="Get character loyalty points")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested character loyalty points", response=LoyaltyPoints.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getLoyaltyPoints(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="corporationID") @DefaultValue(value="{ any: true }") @ApiParam(name="corporationID", defaultValue="{ any: true }", value="Corporation ID selector") AttributeSelector corporationID, @QueryParam(value="loyaltyPoints") @DefaultValue(value="{ any: true }") @ApiParam(name="loyaltyPoints", defaultValue="{ any: true }", value="Loyalty points selector") AttributeSelector loyaltyPoints) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_CHARACTER_SHEET, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<LoyaltyPoints>(){

            @Override
            public List<LoyaltyPoints> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean CORPORATION_ID = false;
                boolean LOYALTY_POINTS = true;
                return LoyaltyPoints.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_LOYALTY, acct);
            }
        }, request, corporationID, loyaltyPoints);
    }

    @Path(value="/mining_ledger")
    @GET
    @ApiOperation(value="Get character mining ledger")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested character mining ledger entries", response=MiningLedger.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getMiningLedger(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="date") @DefaultValue(value="{ any: true }") @ApiParam(name="date", defaultValue="{ any: true }", value="Date selector") AttributeSelector date, @QueryParam(value="solarSystemID") @DefaultValue(value="{ any: true }") @ApiParam(name="solarSystemID", defaultValue="{ any: true }", value="Solar system ID selector") AttributeSelector solarSystemID, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", defaultValue="{ any: true }", value="Type ID selector") AttributeSelector typeID, @QueryParam(value="quantity") @DefaultValue(value="{ any: true }") @ApiParam(name="quantity", defaultValue="{ any: true }", value="Quantity selector") AttributeSelector quantity) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_MINING_LEDGER, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<MiningLedger>(){

            @Override
            public List<MiningLedger> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean DATE = false;
                boolean SOLAR_SYSTEM_ID = true;
                int TYPE_ID = 2;
                int QUANTITY = 3;
                return MiningLedger.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_MINING, acct);
            }
        }, request, date, solarSystemID, typeID, quantity);
    }

    @Path(value="/skill_points")
    @GET
    @ApiOperation(value="Get character skill points")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested character skill points", response=CharacterSheetSkillPoints.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getSkillPoints(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="totalSkillPoints") @DefaultValue(value="{ any: true }") @ApiParam(name="totalSkillPoints", defaultValue="{ any: true }", value="Total skill points selector") AttributeSelector totalSkillPoints, @QueryParam(value="unallocatedSkillPoints") @DefaultValue(value="{ any: true }") @ApiParam(name="unallocatedSkillPoints", defaultValue="{ any: true }", value="Unallocated skill points selector") AttributeSelector unallocatedSkillPoints) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_CHARACTER_SHEET, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<CharacterSheetSkillPoints>(){

            @Override
            public List<CharacterSheetSkillPoints> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean TOTAL_SKILL_POINTS = false;
                boolean UNALLOCATED_SKILL_POINTS = true;
                return CharacterSheetSkillPoints.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_SKILLS, acct);
            }
        }, request, totalSkillPoints, unallocatedSkillPoints);
    }

    @Path(value="/skill")
    @GET
    @ApiOperation(value="Get character skills")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested character skills", response=CharacterSkill.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getSkills(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", defaultValue="{ any: true }", value="Skill type ID selector") AttributeSelector typeID, @QueryParam(value="trainedSkillLevel") @DefaultValue(value="{ any: true }") @ApiParam(name="trainedSkillLevel", defaultValue="{ any: true }", value="Trained skill level selector") AttributeSelector trainedSkillLevel, @QueryParam(value="skillpoints") @DefaultValue(value="{ any: true }") @ApiParam(name="skillpoints", defaultValue="{ any: true }", value="Skill points selector") AttributeSelector skillpoints, @QueryParam(value="activeSkillLevel") @DefaultValue(value="{ any: true }") @ApiParam(name="activeSkillLevel", defaultValue="{ any: true }", value="Active skill level selector") AttributeSelector activeSkillLevel) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_CHARACTER_SHEET, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<CharacterSkill>(){

            @Override
            public List<CharacterSkill> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean TYPE_ID = false;
                boolean TRAINED_SKILL_LEVEL = true;
                boolean SKILLPOINTS = true;
                boolean ACTIVE_SKILL_LEVEL = true;
                return CharacterSkill.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[1], (AttributeSelector)others[1]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_SKILLS, acct);
            }
        }, request, typeID, trainedSkillLevel, skillpoints, activeSkillLevel);
    }

    @Path(value="/title")
    @GET
    @ApiOperation(value="Get character titles")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested character titles", response=CharacterTitle.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getTitles(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="titleID") @DefaultValue(value="{ any: true }") @ApiParam(name="titleID", defaultValue="{ any: true }", value="Character title ID selector") AttributeSelector titleID, @QueryParam(value="titleName") @DefaultValue(value="{ any: true }") @ApiParam(name="titleName", defaultValue="{ any: true }", value="Character title name selector") AttributeSelector titleName) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_CHARACTER_SHEET, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<CharacterTitle>(){

            @Override
            public List<CharacterTitle> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean TITLE_ID = false;
                boolean TITLE_NAME = true;
                return CharacterTitle.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_TITLES, acct);
            }
        }, request, titleID, titleName);
    }

    @Path(value="/fittings")
    @GET
    @ApiOperation(value="Get character ship fittings")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested ship fittings", response=Fitting.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getFittings(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="fittingID") @DefaultValue(value="{ any: true }") @ApiParam(name="fittingID", defaultValue="{ any: true }", value="Ship fitting ID selector") AttributeSelector fittingID, @QueryParam(value="name") @DefaultValue(value="{ any: true }") @ApiParam(name="name", defaultValue="{ any: true }", value="Ship fitting name selector") AttributeSelector name, @QueryParam(value="description") @DefaultValue(value="{ any: true }") @ApiParam(name="description", defaultValue="{ any: true }", value="Ship fitting description selector") AttributeSelector description, @QueryParam(value="shipTypeID") @DefaultValue(value="{ any: true }") @ApiParam(name="shipTypeID", defaultValue="{ any: true }", value="Ship fitting ship type ID selector") AttributeSelector shipTypeID) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_FITTINGS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<Fitting>(){

            @Override
            public List<Fitting> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean FITTING_ID = false;
                boolean NAME = true;
                int DESCRIPTION = 2;
                int SHIP_TYPE_ID = 3;
                return Fitting.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_FITTINGS, acct);
            }
        }, request, fittingID, name, description, shipTypeID);
    }

    @Path(value="/fitting_items")
    @GET
    @ApiOperation(value="Get character ship fitting items")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested ship fitting items", response=FittingItem.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getFittingItems(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="fittingID") @DefaultValue(value="{ any: true }") @ApiParam(name="fittingID", defaultValue="{ any: true }", value="Ship fitting item fitting ID selector") AttributeSelector fittingID, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", defaultValue="{ any: true }", value="Ship fitting item type ID selector") AttributeSelector typeID, @QueryParam(value="flag") @DefaultValue(value="{ any: true }") @ApiParam(name="flag", defaultValue="{ any: true }", value="Ship fitting item flag selector") AttributeSelector flag, @QueryParam(value="quantity") @DefaultValue(value="{ any: true }") @ApiParam(name="quantity", defaultValue="{ any: true }", value="Ship fitting item quantity selector") AttributeSelector quantity) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_FITTINGS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<FittingItem>(){

            @Override
            public List<FittingItem> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean FITTING_ID = false;
                boolean TYPE_ID = true;
                int FLAG = 2;
                int QUANTITY = 3;
                return FittingItem.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_FITTINGS, acct);
            }
        }, request, fittingID, typeID, flag, quantity);
    }

    @Path(value="/implant")
    @GET
    @ApiOperation(value="Get character implants")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested implants", response=Implant.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getImplants(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", defaultValue="{ any: true }", value="Implant type ID selector") AttributeSelector typeID) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_CHARACTER_SHEET, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<Implant>(){

            @Override
            public List<Implant> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean TYPE_ID = false;
                return Implant.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_IMPLANTS, acct);
            }
        }, request, typeID);
    }

    @Path(value="/jump_clone")
    @GET
    @ApiOperation(value="Get character jump clones")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested jump clones", response=JumpClone.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getJumpClones(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="jumpCloneID") @DefaultValue(value="{ any: true }") @ApiParam(name="jumpCloneID", defaultValue="{ any: true }", value="Jump clone ID selector") AttributeSelector jumpCloneID, @QueryParam(value="locationID") @DefaultValue(value="{ any: true }") @ApiParam(name="locationID", defaultValue="{ any: true }", value="Jump clone location ID selector") AttributeSelector locationID, @QueryParam(value="cloneName") @DefaultValue(value="{ any: true }") @ApiParam(name="cloneName", defaultValue="{ any: true }", value="Clone name selector selector") AttributeSelector cloneName, @QueryParam(value="locationType") @DefaultValue(value="{ any: true }") @ApiParam(name="locationType", defaultValue="{ any: true }", value="Location type selector") AttributeSelector locationType) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_CHARACTER_SHEET, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<JumpClone>(){

            @Override
            public List<JumpClone> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean JUMP_CLONE_ID = false;
                boolean LOCATION_ID = true;
                int CLONE_NAME = 2;
                int LOCATION_TYPE = 3;
                return JumpClone.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_CLONES, acct);
            }
        }, request, jumpCloneID, locationID, cloneName, locationType);
    }

    @Path(value="/jump_clone_implant")
    @GET
    @ApiOperation(value="Get character jump clone implants")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested jump clone implants", response=JumpCloneImplant.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getJumpCloneImplants(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="jumpCloneID") @DefaultValue(value="{ any: true }") @ApiParam(name="jumpCloneID", defaultValue="{ any: true }", value="Jump clone ID selector") AttributeSelector jumpCloneID, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", defaultValue="{ any: true }", value="Implant type ID selector") AttributeSelector typeID) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_CHARACTER_SHEET, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<JumpCloneImplant>(){

            @Override
            public List<JumpCloneImplant> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean JUMP_CLONE_ID = false;
                boolean TYPE_ID = true;
                return JumpCloneImplant.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_CLONES, acct);
            }
        }, request, jumpCloneID, typeID);
    }

    @Path(value="/medal")
    @GET
    @ApiOperation(value="Get character medals")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested character medals", response=CharacterMedal.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getMedals(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="description") @DefaultValue(value="{ any: true }") @ApiParam(name="description", defaultValue="{ any: true }", value="Medal description selector") AttributeSelector description, @QueryParam(value="medalID") @DefaultValue(value="{ any: true }") @ApiParam(name="medalID", defaultValue="{ any: true }", value="Medal ID selector") AttributeSelector medalID, @QueryParam(value="title") @DefaultValue(value="{ any: true }") @ApiParam(name="title", defaultValue="{ any: true }", value="Medal title selector") AttributeSelector title, @QueryParam(value="corporationID") @DefaultValue(value="{ any: true }") @ApiParam(name="corporationID", defaultValue="{ any: true }", value="Awarding corporation ID selector") AttributeSelector corporationID, @QueryParam(value="issued") @DefaultValue(value="{ any: true }") @ApiParam(name="issued", defaultValue="{ any: true }", value="Issue date selector") AttributeSelector issued, @QueryParam(value="issuerID") @DefaultValue(value="{ any: true }") @ApiParam(name="issuerID", defaultValue="{ any: true }", value="Issuer ID selector") AttributeSelector issuerID, @QueryParam(value="reason") @DefaultValue(value="{ any: true }") @ApiParam(name="reason", defaultValue="{ any: true }", value="Medal award reason selector") AttributeSelector reason, @QueryParam(value="status") @DefaultValue(value="{ any: true }") @ApiParam(name="status", defaultValue="{ any: true }", value="Medal status selector") AttributeSelector status) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_MEDALS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<CharacterMedal>(){

            @Override
            public List<CharacterMedal> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean DESCRIPTION = false;
                boolean MEDAL_ID = true;
                int TITLE = 2;
                int CORPORATION_ID = 3;
                int ISSUED = 4;
                int ISSUER_ID = 5;
                int REASON = 6;
                int STATUS = 7;
                return CharacterMedal.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5], (AttributeSelector)others[6], (AttributeSelector)others[7]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_MEDALS, acct);
            }
        }, request, description, medalID, title, corporationID, issued, issuerID, reason, status);
    }

    @Path(value="/medal_graphic")
    @GET
    @ApiOperation(value="Get character medal graphics")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested character medal graphics", response=CharacterMedalGraphic.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getMedalGraphics(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="medalID") @DefaultValue(value="{ any: true }") @ApiParam(name="medalID", defaultValue="{ any: true }", value="Medal ID selector") AttributeSelector medalID, @QueryParam(value="issued") @DefaultValue(value="{ any: true }") @ApiParam(name="issued", defaultValue="{ any: true }", value="Medal issued selector") AttributeSelector issued, @QueryParam(value="part") @DefaultValue(value="{ any: true }") @ApiParam(name="part", defaultValue="{ any: true }", value="Medal graphic part selector") AttributeSelector part, @QueryParam(value="layer") @DefaultValue(value="{ any: true }") @ApiParam(name="layer", defaultValue="{ any: true }", value="Medal graphic layer selector") AttributeSelector layer, @QueryParam(value="graphic") @DefaultValue(value="{ any: true }") @ApiParam(name="graphic", defaultValue="{ any: true }", value="Medal graphic name selector") AttributeSelector graphic, @QueryParam(value="color") @DefaultValue(value="{ any: true }") @ApiParam(name="color", defaultValue="{ any: true }", value="Medal graphic color selector") AttributeSelector color) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_MEDALS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<CharacterMedalGraphic>(){

            @Override
            public List<CharacterMedalGraphic> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean MEDAL_ID = false;
                boolean ISSUED = true;
                int PART = 2;
                int LAYER = 3;
                int GRAPHIC = 4;
                int COLOR = 5;
                return CharacterMedalGraphic.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_MEDALS, acct);
            }
        }, request, medalID, issued, part, layer, graphic, color);
    }

    @Path(value="/notification")
    @GET
    @ApiOperation(value="Get character notifications (not bodies)")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested notifications (excludes bodies)", response=CharacterNotification.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getNotifications(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="notificationID") @DefaultValue(value="{ any: true }") @ApiParam(name="notificationID", defaultValue="{ any: true }", value="Notification ID selector") AttributeSelector notificationID, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="type", defaultValue="{ any: true }", value="Notification type selector") AttributeSelector type, @QueryParam(value="senderID") @DefaultValue(value="{ any: true }") @ApiParam(name="senderID", defaultValue="{ any: true }", value="Notification sender ID selector") AttributeSelector senderID, @QueryParam(value="senderType") @DefaultValue(value="{ any: true }") @ApiParam(name="senderType", defaultValue="{ any: true }", value="Notification sender type selector") AttributeSelector senderType, @QueryParam(value="sentDate") @DefaultValue(value="{ any: true }") @ApiParam(name="sentDate", defaultValue="{ any: true }", value="Notification send date selector") AttributeSelector sentDate, @QueryParam(value="msgRead") @DefaultValue(value="{ any: true }") @ApiParam(name="msgRead", defaultValue="{ any: true }", value="Notification read selector") AttributeSelector msgRead, @QueryParam(value="text") @DefaultValue(value="{ any: true }") @ApiParam(name="text", defaultValue="{ any: true }", value="Notification text selector") AttributeSelector text) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_NOTIFICATIONS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<CharacterNotification>(){

            @Override
            public List<CharacterNotification> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean NOTIFICATION_ID = false;
                boolean TYPE = true;
                int SENDER_ID = 2;
                int SENDER_TYPE = 3;
                int SENT_DATE = 4;
                int MSG_READ = 5;
                int TEXT = 6;
                return CharacterNotification.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5], (AttributeSelector)others[6]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_NOTIFICATIONS, acct);
            }
        }, request, notificationID, type, senderID, senderType, sentDate, msgRead, text);
    }

    @Path(value="/channel")
    @GET
    @ApiOperation(value="Get character chat channels")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested chat channels", response=ChatChannel.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getChannels(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="channelID") @DefaultValue(value="{ any: true }") @ApiParam(name="channelID", defaultValue="{ any: true }", value="Channel ID selector") AttributeSelector channelID, @QueryParam(value="ownerID") @DefaultValue(value="{ any: true }") @ApiParam(name="ownerID", defaultValue="{ any: true }", value="Channel owner ID selector") AttributeSelector ownerID, @QueryParam(value="displayName") @DefaultValue(value="{ any: true }") @ApiParam(name="displayName", defaultValue="{ any: true }", value="Channel display name selector") AttributeSelector displayName, @QueryParam(value="comparisonKey") @DefaultValue(value="{ any: true }") @ApiParam(name="comparisonKey", defaultValue="{ any: true }", value="Channel comparison key selector") AttributeSelector comparisonKey, @QueryParam(value="hasPassword") @DefaultValue(value="{ any: true }") @ApiParam(name="hasPassword", defaultValue="{ any: true }", value="Channel has password selector") AttributeSelector hasPassword, @QueryParam(value="motd") @DefaultValue(value="{ any: true }") @ApiParam(name="motd", defaultValue="{ any: true }", value="Channel Message of the Day selector") AttributeSelector motd) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_CHAT_CHANNELS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<ChatChannel>(){

            @Override
            public List<ChatChannel> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean CHANNEL_ID = false;
                boolean OWNER_ID = true;
                int DISPLAY_NAME = 2;
                int COMPARISON_KEY = 3;
                int HAS_PASSWORD = 4;
                int MOTD = 5;
                return ChatChannel.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return OrbitalProperties.getCurrentTime();
            }
        }, request, channelID, ownerID, displayName, comparisonKey, hasPassword, motd);
    }

    @Path(value="/channel_member")
    @GET
    @ApiOperation(value="Get chat channel members")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested chat channel members", response=ChatChannelMember.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getChannelMembers(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="channelID") @DefaultValue(value="{ any: true }") @ApiParam(name="channelID", defaultValue="{ any: true }", value="Channel ID selector") AttributeSelector channelID, @QueryParam(value="category") @DefaultValue(value="{ any: true }") @ApiParam(name="category", defaultValue="{ any: true }", value="Member category selector") AttributeSelector category, @QueryParam(value="accessorID") @DefaultValue(value="{ any: true }") @ApiParam(name="accessorID", defaultValue="{ any: true }", value="Member accessor ID selector") AttributeSelector accessorID, @QueryParam(value="accessorType") @DefaultValue(value="{ any: true }") @ApiParam(name="accessorType", defaultValue="{ any: true }", value="Member accessor type selector") AttributeSelector accessorType, @QueryParam(value="untilWhen") @DefaultValue(value="{ any: true }") @ApiParam(name="untilWhen", defaultValue="{ any: true }", value="Member restriction \"until when\" date selector") AttributeSelector untilWhen, @QueryParam(value="reason") @DefaultValue(value="{ any: true }") @ApiParam(name="reason", defaultValue="{ any: true }", value="Member restriction reason selector") AttributeSelector reason) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_CHAT_CHANNELS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<ChatChannelMember>(){

            @Override
            public List<ChatChannelMember> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean CHANNEL_ID = false;
                boolean CATEGORY = true;
                int ACCESSOR_ID = 2;
                int ACCESSOR_TYPE = 3;
                int UNTIL_WHEN = 4;
                int REASON = 5;
                return ChatChannelMember.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return OrbitalProperties.getCurrentTime();
            }
        }, request, channelID, category, accessorID, accessorType, untilWhen, reason);
    }

    @Path(value="/contact_notification")
    @GET
    @ApiOperation(value="Get character contact notifications")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested character contact notifications", response=CharacterContactNotification.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getContactNotifications(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="notificationID") @DefaultValue(value="{ any: true }") @ApiParam(name="notificationID", defaultValue="{ any: true }", value="Notification ID selector") AttributeSelector notificationID, @QueryParam(value="senderID") @DefaultValue(value="{ any: true }") @ApiParam(name="senderID", defaultValue="{ any: true }", value="Contact notification sender ID selector") AttributeSelector senderID, @QueryParam(value="sentDate") @DefaultValue(value="{ any: true }") @ApiParam(name="sentDate", defaultValue="{ any: true }", value="Contact notification send date selector") AttributeSelector sentDate, @QueryParam(value="standingLevel") @DefaultValue(value="{ any: true }") @ApiParam(name="standingLevel", defaultValue="{ any: true }", value="Contact notification standing level selector") AttributeSelector standingLevel, @QueryParam(value="messageData") @DefaultValue(value="{ any: true }") @ApiParam(name="messageData", defaultValue="{ any: true }", value="Contact notification message data selector") AttributeSelector messageData) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_CONTACT_NOTIFICATIONS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<CharacterContactNotification>(){

            @Override
            public List<CharacterContactNotification> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean NOTIFICATION_ID = false;
                boolean SENDER_ID = true;
                int SENT_DATE = 2;
                int STANDING_LEVEL = 3;
                int MESSAGE_DATA = 4;
                return CharacterContactNotification.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_NOTIFICATIONS, acct);
            }
        }, request, notificationID, senderID, sentDate, standingLevel, messageData);
    }

    @Path(value="/mailing_list")
    @GET
    @ApiOperation(value="Get character mailing lists")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested character mailing lists", response=MailingList.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getMailingLists(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="displayName") @DefaultValue(value="{ any: true }") @ApiParam(name="displayName", defaultValue="{ any: true }", value="Mailing list display name selector") AttributeSelector displayName, @QueryParam(value="listID") @DefaultValue(value="{ any: true }") @ApiParam(name="listID", defaultValue="{ any: true }", value="Mailing list ID selector") AttributeSelector listID) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_MAILING_LISTS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<MailingList>(){

            @Override
            public List<MailingList> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean DISPLAY_NAME = false;
                boolean LIST_ID = true;
                return MailingList.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_MAIL, acct);
            }
        }, request, displayName, listID);
    }

    @Path(value="/mail_label")
    @GET
    @ApiOperation(value="Get character mail labels")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested character mail labels", response=MailLabel.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getMailLabels(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="labelID") @DefaultValue(value="{ any: true }") @ApiParam(name="labelID", defaultValue="{ any: true }", value="Mail label ID selector") AttributeSelector labelID, @QueryParam(value="unreadCount") @DefaultValue(value="{ any: true }") @ApiParam(name="unreadCount", defaultValue="{ any: true }", value="Mail label unread count selector") AttributeSelector unreadCount, @QueryParam(value="name") @DefaultValue(value="{ any: true }") @ApiParam(name="name", defaultValue="{ any: true }", value="Mail label name selector") AttributeSelector name, @QueryParam(value="color") @DefaultValue(value="{ any: true }") @ApiParam(name="color", defaultValue="{ any: true }", value="Mail label color selector") AttributeSelector color) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_MAIL, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<MailLabel>(){

            @Override
            public List<MailLabel> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean LABEL_ID = false;
                boolean UNREAD_COUNT = true;
                boolean NAME = true;
                boolean COLOR = true;
                return MailLabel.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[1], (AttributeSelector)others[1]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_MAIL, acct);
            }
        }, request, labelID, unreadCount, name, color);
    }

    @Path(value="/mail_message")
    @GET
    @ApiOperation(value="Get character mail messages")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested character mail messages", response=CharacterMailMessage.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getMailMessages(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="messageID") @DefaultValue(value="{ any: true }") @ApiParam(name="messageID", defaultValue="{ any: true }", value="Message ID selector") AttributeSelector messageID, @QueryParam(value="senderID") @DefaultValue(value="{ any: true }") @ApiParam(name="senderID", defaultValue="{ any: true }", value="Message sender ID selector") AttributeSelector senderID, @QueryParam(value="sentDate") @DefaultValue(value="{ any: true }") @ApiParam(name="sentDate", defaultValue="{ any: true }", value="Message send date selector") AttributeSelector sentDate, @QueryParam(value="title") @DefaultValue(value="{ any: true }") @ApiParam(name="title", defaultValue="{ any: true }", value="Message title selector") AttributeSelector title, @QueryParam(value="msgRead") @DefaultValue(value="{ any: true }") @ApiParam(name="msgRead", defaultValue="{ any: true }", value="Message read selector") AttributeSelector msgRead, @QueryParam(value="labelID") @DefaultValue(value="{ any: true }") @ApiParam(name="labelID", defaultValue="{ any: true }", value="Message label ID selector") AttributeSelector labelID, @QueryParam(value="recipientType") @DefaultValue(value="{ any: true }") @ApiParam(name="recipientType", defaultValue="{ any: true }", value="Message recipient type selector") AttributeSelector recipientType, @QueryParam(value="recipientID") @DefaultValue(value="{ any: true }") @ApiParam(name="recipientID", defaultValue="{ any: true }", value="Message recipient ID selector") AttributeSelector recipientID, @QueryParam(value="body") @DefaultValue(value="{ any: true }") @ApiParam(name="body", defaultValue="{ any: true }", value="Message body selector") AttributeSelector body) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_MAIL, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<CharacterMailMessage>(){

            @Override
            public List<CharacterMailMessage> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean MESSAGE_ID = false;
                boolean SENDER_ID = true;
                int SENT_DATE = 2;
                int TITLE = 3;
                int MSG_READ = 4;
                int LABEL_ID = 5;
                int RECIPIENT_TYPE = 6;
                int RECIPIENT_ID = 7;
                int BODY = 8;
                return CharacterMailMessage.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5], (AttributeSelector)others[6], (AttributeSelector)others[7], (AttributeSelector)others[8]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_MAIL, acct);
            }
        }, request, messageID, senderID, sentDate, title, msgRead, labelID, recipientType, recipientID, body);
    }

    @Path(value="/planetary_colony")
    @GET
    @ApiOperation(value="Get planetary colonies")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested planetary colonies", response=PlanetaryColony.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getPlanetaryColonies(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="planetID") @DefaultValue(value="{ any: true }") @ApiParam(name="planetID", defaultValue="{ any: true }", value="Planet ID selector") AttributeSelector planetID, @QueryParam(value="solarSystemID") @DefaultValue(value="{ any: true }") @ApiParam(name="solarSystemID", defaultValue="{ any: true }", value="Solar system ID selector") AttributeSelector solarSystemID, @QueryParam(value="planetType") @DefaultValue(value="{ any: true }") @ApiParam(name="planetType", defaultValue="{ any: true }", value="Planet type selector") AttributeSelector planetType, @QueryParam(value="ownerID") @DefaultValue(value="{ any: true }") @ApiParam(name="ownerID", defaultValue="{ any: true }", value="Colony owner ID selector") AttributeSelector ownerID, @QueryParam(value="lastUpdate") @DefaultValue(value="{ any: true }") @ApiParam(name="lastUpdate", defaultValue="{ any: true }", value="Colony last update selector") AttributeSelector lastUpdate, @QueryParam(value="upgradeLevel") @DefaultValue(value="{ any: true }") @ApiParam(name="upgradeLevel", defaultValue="{ any: true }", value="Colony upgrade level selector") AttributeSelector upgradeLevel, @QueryParam(value="numberOfPins") @DefaultValue(value="{ any: true }") @ApiParam(name="numberOfPins", defaultValue="{ any: true }", value="Colony number of pins selector") AttributeSelector numberOfPins) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_ASSETS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<PlanetaryColony>(){

            @Override
            public List<PlanetaryColony> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean PLANET_ID = false;
                boolean SOLAR_SYSTEM_ID = true;
                int PLANET_TYPE = 2;
                int OWNER_ID = 3;
                int LAST_UPDATE = 4;
                int UPGRADE_LEVEL = 5;
                int NUMBER_OF_PINS = 6;
                return PlanetaryColony.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5], (AttributeSelector)others[6]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_PLANETS, acct);
            }
        }, request, planetID, solarSystemID, planetType, ownerID, lastUpdate, upgradeLevel, numberOfPins);
    }

    @Path(value="/planetary_link")
    @GET
    @ApiOperation(value="Get planetary links")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested planetary links", response=PlanetaryLink.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getPlanetaryLinks(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="planetID") @DefaultValue(value="{ any: true }") @ApiParam(name="planetID", defaultValue="{ any: true }", value="Planet ID selector") AttributeSelector planetID, @QueryParam(value="sourcePinID") @DefaultValue(value="{ any: true }") @ApiParam(name="sourcePinID", defaultValue="{ any: true }", value="Link source pin ID selector") AttributeSelector sourcePinID, @QueryParam(value="destinationPinID") @DefaultValue(value="{ any: true }") @ApiParam(name="destinationPinID", defaultValue="{ any: true }", value="Link destination pin ID selector") AttributeSelector destinationPinID, @QueryParam(value="linkLevel") @DefaultValue(value="{ any: true }") @ApiParam(name="linkLevel", defaultValue="{ any: true }", value="Link level selector") AttributeSelector linkLevel) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_ASSETS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<PlanetaryLink>(){

            @Override
            public List<PlanetaryLink> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean PLANET_ID = false;
                boolean SOURCE_PIN_ID = true;
                int DESTINATION_PIN_ID = 2;
                int LINK_LEVEL = 3;
                return PlanetaryLink.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_PLANETS, acct);
            }
        }, request, planetID, sourcePinID, destinationPinID, linkLevel);
    }

    @Path(value="/planetary_pin")
    @GET
    @ApiOperation(value="Get planetary pins")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested planetary pins", response=PlanetaryPin.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getPlanetaryPins(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="planetID") @DefaultValue(value="{ any: true }") @ApiParam(name="planetID", defaultValue="{ any: true }", value="Planet ID selector") AttributeSelector planetID, @QueryParam(value="pinID") @DefaultValue(value="{ any: true }") @ApiParam(name="pinID", defaultValue="{ any: true }", value="Pin ID selector") AttributeSelector pinID, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", defaultValue="{ any: true }", value="Pin type ID selector") AttributeSelector typeID, @QueryParam(value="schematicID") @DefaultValue(value="{ any: true }") @ApiParam(name="schematicID", defaultValue="{ any: true }", value="Pin schematic ID selector") AttributeSelector schematicID, @QueryParam(value="lastCycleStart") @DefaultValue(value="{ any: true }") @ApiParam(name="lastCycleStart", defaultValue="{ any: true }", value="Pin last cycle start selector") AttributeSelector lastCycleStart, @QueryParam(value="cycleTime") @DefaultValue(value="{ any: true }") @ApiParam(name="cycleTime", defaultValue="{ any: true }", value="Pin cycle time selector") AttributeSelector cycleTime, @QueryParam(value="quantityPerCycle") @DefaultValue(value="{ any: true }") @ApiParam(name="quantityPerCycle", defaultValue="{ any: true }", value="Pin quantity per cycle selector") AttributeSelector quantityPerCycle, @QueryParam(value="installTime") @DefaultValue(value="{ any: true }") @ApiParam(name="installTime", defaultValue="{ any: true }", value="Pin install time selector") AttributeSelector installTime, @QueryParam(value="expiryTime") @DefaultValue(value="{ any: true }") @ApiParam(name="expiryTime", defaultValue="{ any: true }", value="Pin expiry time selector") AttributeSelector expiryTime, @QueryParam(value="productTypeID") @DefaultValue(value="{ any: true }") @ApiParam(name="productTypeID", defaultValue="{ any: true }", value="Pin product type ID selector") AttributeSelector productTypeID, @QueryParam(value="longitude") @DefaultValue(value="{ any: true }") @ApiParam(name="longitude", defaultValue="{ any: true }", value="Pin longitude selector") AttributeSelector longitude, @QueryParam(value="latitude") @DefaultValue(value="{ any: true }") @ApiParam(name="latitude", defaultValue="{ any: true }", value="Pin latitude selector") AttributeSelector latitude, @QueryParam(value="headRadius") @DefaultValue(value="{ any: true }") @ApiParam(name="headRadius", defaultValue="{ any: true }", value="Pin head radius selector") AttributeSelector headRadius, @QueryParam(value="headID") @DefaultValue(value="{ any: true }") @ApiParam(name="headID", defaultValue="{ any: true }", value="Pin head ID selector") AttributeSelector headID, @QueryParam(value="headLongitude") @DefaultValue(value="{ any: true }") @ApiParam(name="headLongitude", defaultValue="{ any: true }", value="Pin head longitude selector") AttributeSelector headLongitude, @QueryParam(value="headLatitude") @DefaultValue(value="{ any: true }") @ApiParam(name="headLatitude", defaultValue="{ any: true }", value="Pin head latitude selector") AttributeSelector headLatitude, @QueryParam(value="contentTypeID") @DefaultValue(value="{ any: true }") @ApiParam(name="contentTypeID", defaultValue="{ any: true }", value="Pin content type ID selector") AttributeSelector contentTypeID, @QueryParam(value="contentAmount") @DefaultValue(value="{ any: true }") @ApiParam(name="contentAmount", defaultValue="{ any: true }", value="Pin content amount selector") AttributeSelector contentAmount) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_ASSETS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<PlanetaryPin>(){

            @Override
            public List<PlanetaryPin> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean PLANET_ID = false;
                boolean PIN_ID = true;
                int TYPE_ID = 2;
                int SCHEMATIC_ID = 3;
                int LAST_CYCLE_START = 4;
                int CYCLE_TIME = 5;
                int QUANTITY_PER_CYCLE = 6;
                int INSTALL_TIME = 7;
                int EXPIRY_TIME = 8;
                int PRODUCT_TYPE_ID = 9;
                int LONGITUDE = 10;
                int LATITUDE = 11;
                int HEAD_RADIUS = 12;
                int HEAD_ID = 13;
                int HEAD_LONGITUDE = 14;
                int HEAD_LATITUDE = 15;
                int CONTENT_TYPE_ID = 16;
                int CONTENT_AMOUNT = 17;
                return PlanetaryPin.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5], (AttributeSelector)others[6], (AttributeSelector)others[7], (AttributeSelector)others[8], (AttributeSelector)others[9], (AttributeSelector)others[10], (AttributeSelector)others[11], (AttributeSelector)others[12], (AttributeSelector)others[13], (AttributeSelector)others[14], (AttributeSelector)others[15], (AttributeSelector)others[16], (AttributeSelector)others[17]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_PLANETS, acct);
            }
        }, request, planetID, pinID, typeID, schematicID, lastCycleStart, cycleTime, quantityPerCycle, installTime, expiryTime, productTypeID, longitude, latitude, headRadius, headID, headLongitude, headLatitude, contentTypeID, contentAmount);
    }

    @Path(value="/planetary_route")
    @GET
    @ApiOperation(value="Get planetary routes")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested planetary routes", response=PlanetaryRoute.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getPlanetaryRoutes(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="planetID") @DefaultValue(value="{ any: true }") @ApiParam(name="planetID", defaultValue="{ any: true }", value="Planet ID selector") AttributeSelector planetID, @QueryParam(value="routeID") @DefaultValue(value="{ any: true }") @ApiParam(name="routeID", defaultValue="{ any: true }", value="Route ID selector") AttributeSelector routeID, @QueryParam(value="sourcePinID") @DefaultValue(value="{ any: true }") @ApiParam(name="sourcePinID", defaultValue="{ any: true }", value="Route source pin ID selector") AttributeSelector sourcePinID, @QueryParam(value="destinationPinID") @DefaultValue(value="{ any: true }") @ApiParam(name="destinationPinID", defaultValue="{ any: true }", value="Route destination pin ID selector") AttributeSelector destinationPinID, @QueryParam(value="contentTypeID") @DefaultValue(value="{ any: true }") @ApiParam(name="contentTypeID", defaultValue="{ any: true }", value="Route content type ID selector") AttributeSelector contentTypeID, @QueryParam(value="quantity") @DefaultValue(value="{ any: true }") @ApiParam(name="quantity", defaultValue="{ any: true }", value="Route quantity selector") AttributeSelector quantity, @QueryParam(value="waypoint") @DefaultValue(value="{ any: true }") @ApiParam(name="waypoint", defaultValue="{ any: true }", value="Route waypoint selector") AttributeSelector waypoint) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_ASSETS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<PlanetaryRoute>(){

            @Override
            public List<PlanetaryRoute> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean PLANET_ID = false;
                boolean ROUTE_ID = true;
                int SOURCE_PIN_ID = 2;
                int DESTINATION_PIN_ID = 3;
                int CONTENT_TYPE_ID = 4;
                int QUANTITY = 5;
                int WAYPOINT = 6;
                return PlanetaryRoute.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5], (AttributeSelector)others[6]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_PLANETS, acct);
            }
        }, request, planetID, routeID, sourcePinID, destinationPinID, contentTypeID, quantity, waypoint);
    }

    @Path(value="/research_agent")
    @GET
    @ApiOperation(value="Get character research agents")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested research agents", response=ResearchAgent.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getResearchAgents(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="agentID") @DefaultValue(value="{ any: true }") @ApiParam(name="agentID", defaultValue="{ any: true }", value="Research agent ID selector") AttributeSelector agentID, @QueryParam(value="pointsPerDay") @DefaultValue(value="{ any: true }") @ApiParam(name="pointsPerDay", defaultValue="{ any: true }", value="Agent points per day selector") AttributeSelector pointsPerDay, @QueryParam(value="remainderPoints") @DefaultValue(value="{ any: true }") @ApiParam(name="remainderPoints", defaultValue="{ any: true }", value="Agent remainder points selector") AttributeSelector remainderPoints, @QueryParam(value="researchStartDate") @DefaultValue(value="{ any: true }") @ApiParam(name="researchStartDate", defaultValue="{ any: true }", value="Agent research start date selector") AttributeSelector researchStartDate, @QueryParam(value="skillTypeID") @DefaultValue(value="{ any: true }") @ApiParam(name="skillTypeID", defaultValue="{ any: true }", value="Agent skill type ID selector") AttributeSelector skillTypeID) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_RESEARCH, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<ResearchAgent>(){

            @Override
            public List<ResearchAgent> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean AGENT_ID = false;
                boolean POINTS_PER_DAY = true;
                int REMAINDER_POINTS = 2;
                int RESEARCH_START_DATE = 3;
                int SKILL_TYPE_ID = 4;
                return ResearchAgent.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_AGENTS, acct);
            }
        }, request, agentID, pointsPerDay, remainderPoints, researchStartDate, skillTypeID);
    }

    @Path(value="/skill_queue")
    @GET
    @ApiOperation(value="Get character skill queue")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested character skill queue entries", response=SkillInQueue.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getSkillsInQueue(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="endSP") @DefaultValue(value="{ any: true }") @ApiParam(name="endSP", defaultValue="{ any: true }", value="Skill ending skill points selector") AttributeSelector endSP, @QueryParam(value="endTime") @DefaultValue(value="{ any: true }") @ApiParam(name="endTime", defaultValue="{ any: true }", value="Skill training end time selector") AttributeSelector endTime, @QueryParam(value="level") @DefaultValue(value="{ any: true }") @ApiParam(name="level", defaultValue="{ any: true }", value="Skill training to level selector") AttributeSelector level, @QueryParam(value="queuePosition") @DefaultValue(value="{ any: true }") @ApiParam(name="queuePosition", defaultValue="{ any: true }", value="Queue position selector") AttributeSelector queuePosition, @QueryParam(value="startSP") @DefaultValue(value="{ any: true }") @ApiParam(name="startSP", defaultValue="{ any: true }", value="Starting skill points selector") AttributeSelector startSP, @QueryParam(value="startTime") @DefaultValue(value="{ any: true }") @ApiParam(name="startTime", defaultValue="{ any: true }", value="Training start time selector") AttributeSelector startTime, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", defaultValue="{ any: true }", value="Skill type ID selector") AttributeSelector typeID, @QueryParam(value="trainingStartSP") @DefaultValue(value="{ any: true }") @ApiParam(name="trainingStartSP", defaultValue="{ any: true }", value="Training start skill point selector") AttributeSelector trainingStartSP) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_SKILL_QUEUE, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<SkillInQueue>(){

            @Override
            public List<SkillInQueue> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean END_SP = false;
                boolean END_TIME = true;
                int LEVEL = 2;
                int QUEUE_POSITION = 3;
                int START_SP = 4;
                int START_TIME = 5;
                int TYPE_ID = 6;
                int TRAINING_START_SP = 7;
                return SkillInQueue.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3], (AttributeSelector)others[4], (AttributeSelector)others[5], (AttributeSelector)others[6], (AttributeSelector)others[7]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_SKILL_QUEUE, acct);
            }
        }, request, endSP, endTime, level, queuePosition, startSP, startTime, typeID, trainingStartSP);
    }

    @Path(value="/location")
    @GET
    @ApiOperation(value="Get character location")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested location data", response=CharacterLocation.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getLocation(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="solarSystemID") @DefaultValue(value="{ any: true }") @ApiParam(name="solarSystemID", defaultValue="{ any: true }", value="Solar system ID selector") AttributeSelector solarSystemID, @QueryParam(value="stationID") @DefaultValue(value="{ any: true }") @ApiParam(name="stationID", defaultValue="{ any: true }", value="Station ID selector") AttributeSelector stationID, @QueryParam(value="structureID") @DefaultValue(value="{ any: true }") @ApiParam(name="structureID", defaultValue="{ any: true }", value="Structure ID selector") AttributeSelector structureID) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_LOCATIONS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<CharacterLocation>(){

            @Override
            public List<CharacterLocation> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean SOLAR_SYSTEM_ID = false;
                boolean STATION_ID = true;
                int STRUCTURE_ID = 2;
                return CharacterLocation.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_LOCATION, acct);
            }
        }, request, solarSystemID, stationID, structureID);
    }

    @Path(value="/ship_type")
    @GET
    @ApiOperation(value="Get character ship type")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested ship type data", response=CharacterShip.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getShipType(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="shipTypeID") @DefaultValue(value="{ any: true }") @ApiParam(name="shipTypeID", defaultValue="{ any: true }", value="Ship type ID selector") AttributeSelector shipTypeID, @QueryParam(value="shipItemID") @DefaultValue(value="{ any: true }") @ApiParam(name="shipItemID", defaultValue="{ any: true }", value="Ship item ID selector") AttributeSelector shipItemID, @QueryParam(value="shipName") @DefaultValue(value="{ any: true }") @ApiParam(name="shipName", defaultValue="{ any: true }", value="Ship name selector") AttributeSelector shipName) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_LOCATIONS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<CharacterShip>(){

            @Override
            public List<CharacterShip> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean SHIP_TYPE_ID = false;
                boolean SHIP_ITEM_ID = true;
                int SHIP_NAME = 2;
                return CharacterShip.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_SHIP_TYPE, acct);
            }
        }, request, shipTypeID, shipItemID, shipName);
    }

    @Path(value="/online")
    @GET
    @ApiOperation(value="Get character online data")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested online data", response=CharacterOnline.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getOnline(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="online") @DefaultValue(value="{ any: true }") @ApiParam(name="online", defaultValue="{ any: true }", value="Online selector") AttributeSelector online, @QueryParam(value="lastLogin") @DefaultValue(value="{ any: true }") @ApiParam(name="lastLogin", defaultValue="{ any: true }", value="Last login selector") AttributeSelector lastLogin, @QueryParam(value="lastLogout") @DefaultValue(value="{ any: true }") @ApiParam(name="lastLogout", defaultValue="{ any: true }", value="Last logout selector") AttributeSelector lastLogout, @QueryParam(value="logins") @DefaultValue(value="{ any: true }") @ApiParam(name="logins", defaultValue="{ any: true }", value="Logins selector") AttributeSelector logins) {
        return AccountHandlerUtil.handleStandardListRequest(accessKey, accessCred, AccountAccessMask.ACCESS_ACCOUNT_STATUS, at, contid, maxresults, reverse, new AccountHandlerUtil.QueryCaller<CharacterOnline>(){

            @Override
            public List<CharacterOnline> getList(SynchronizedEveAccount acct, long contid, int maxresults, boolean reverse, AttributeSelector at, AttributeSelector ... others) throws IOException {
                boolean ONLINE = false;
                boolean LAST_LOGIN = true;
                int LAST_LOGOUT = 2;
                int LOGINS = 3;
                return CharacterOnline.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)others[0], (AttributeSelector)others[1], (AttributeSelector)others[2], (AttributeSelector)others[3]);
            }

            @Override
            public long getExpiry(SynchronizedEveAccount acct) {
                return AccountHandlerUtil.handleStandardExpiry(ESISyncEndpoint.CHAR_ONLINE, acct);
            }
        }, request, online, lastLogin, lastLogout, logins);
    }
}

