/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.ws;

import enterprises.orbital.base.OrbitalProperties;
import enterprises.orbital.evekit.account.AccessKeyNotFoundException;
import enterprises.orbital.evekit.account.AccountAccessMask;
import enterprises.orbital.evekit.account.SynchronizedAccountAccessKey;
import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.CachedData;
import enterprises.orbital.evekit.model.ESISyncEndpoint;
import enterprises.orbital.evekit.ws.AccountHandlerUtil;
import enterprises.orbital.evekit.ws.ServiceError;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;

public class ServiceUtil {
    private static final Logger log = Logger.getLogger(ServiceUtil.class.getName());
    private static final String PROP_MIN_CACHE_DELAY = "enterprises.orbital.evekit.model.min_cache_delay";
    private static final long DEF_MIN_CACHE_DELAY = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES);
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
    public static final long DEFAULT_EXPIRY_INTERVAL = TimeUnit.MILLISECONDS.convert(24L, TimeUnit.HOURS);
    private static String versionString = "2.0";
    private static final Map<Pair<AccountAccessMask, Boolean>, Set<ESISyncEndpoint>> accessMap;

    public static AccessConfig start(int accessKey, String accessCred, AttributeSelector at, AccountAccessMask mask) {
        AccessConfig cfg = new AccessConfig(accessKey, accessCred, at, mask);
        AuthenticationResult check = ServiceUtil.authenticate(cfg.accessKey, cfg.accessCred, cfg.when, cfg.at, cfg.mask);
        if (check.isFail()) {
            cfg.response = check.response;
            cfg.fail = true;
        } else {
            cfg.key = check.key;
            cfg.owner = check.key.getSyncAccount();
        }
        return cfg;
    }

    public static AccessConfig start(int accessKey, String accessCred, AttributeSelector at, Collection<AccountAccessMask> mask) {
        assert (!mask.isEmpty());
        AccessConfig cfg = new AccessConfig(accessKey, accessCred, at, mask.iterator().next());
        AuthenticationResult check = ServiceUtil.authenticate(cfg.accessKey, cfg.accessCred, cfg.when, cfg.at, mask);
        if (check.isFail()) {
            cfg.response = check.response;
            cfg.fail = true;
        } else {
            cfg.key = check.key;
            cfg.owner = check.key.getSyncAccount();
        }
        return cfg;
    }

    public static <A extends CachedData> Response finishRef(long when, long expiry, Collection<A> result, HttpServletRequest request) {
        ServiceUtil.auditRefAccess(ServiceUtil.getSource(request), ServiceUtil.getRequestURI(request));
        Response.ResponseBuilder rBuilder = Response.ok();
        if (result != null) {
            rBuilder = rBuilder.entity(result);
        }
        return ServiceUtil.stamp(rBuilder, when, expiry).build();
    }

    public static Response finish(AccessConfig cfg, Object result, HttpServletRequest request) {
        long expiry = cfg.presetExpiry == -1L ? ServiceUtil.computeExpiry(cfg.when, cfg.owner, cfg.mask) : cfg.presetExpiry;
        ServiceUtil.auditAccess(cfg.key, cfg.mask, ServiceUtil.getSource(request), ServiceUtil.getRequestURI(request));
        Response.ResponseBuilder rBuilder = Response.ok();
        if (result != null) {
            rBuilder = rBuilder.entity(result);
        }
        return ServiceUtil.stamp(rBuilder, cfg.when, expiry).build();
    }

    public static <A extends CachedData> Response finish(AccessConfig cfg, Collection<A> result, HttpServletRequest request) {
        long expiry = cfg.presetExpiry == -1L ? ServiceUtil.computeExpiry(cfg.when, cfg.owner, cfg.mask) : cfg.presetExpiry;
        ServiceUtil.auditAccess(cfg.key, cfg.mask, ServiceUtil.getSource(request), ServiceUtil.getRequestURI(request));
        Response.ResponseBuilder rBuilder = Response.ok();
        if (result != null) {
            rBuilder = rBuilder.entity(result);
        }
        return ServiceUtil.stamp(rBuilder, cfg.when, expiry).build();
    }

    public static String getSource(HttpServletRequest request) {
        return request == null ? "INTERNAL" : request.getRemoteAddr();
    }

    public static String getRequestURI(HttpServletRequest request) {
        return request == null ? "INTERNAL" : request.getRequestURI();
    }

    public static AuthenticationResult authenticate(int id, String hash, long when, AttributeSelector at) {
        SynchronizedAccountAccessKey key;
        try {
            key = SynchronizedAccountAccessKey.checkHash((long)id, (String)hash);
            if (key == null) {
                ServiceError errMsg = new ServiceError(Response.Status.UNAUTHORIZED.getStatusCode(), "Access credential invalid");
                return new AuthenticationResult(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)errMsg).build());
            }
        }
        catch (AccessKeyNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Access key with the given ID not found");
            return new AuthenticationResult(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build());
        }
        catch (Exception e) {
            ServiceError errMsg = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Error verifying access key.  If this problem persists, please contact the site admin.");
            return new AuthenticationResult(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build());
        }
        if (key.getExpiry() > 0L && key.getExpiry() <= when) {
            ServiceError errMsg = new ServiceError(Response.Status.FORBIDDEN.getStatusCode(), "Access key expired, contact key owner for renewal");
            return new AuthenticationResult(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)errMsg).build());
        }
        if (key.getLimit() > 0L) {
            switch (at.type()) {
                case SET: {
                    long next;
                    Set start = at.getLongValues();
                    HashSet<Long> keep = new HashSet<Long>();
                    Iterator iterator = start.iterator();
                    while (iterator.hasNext()) {
                        next = (Long)iterator.next();
                        if (next <= key.getLimit()) continue;
                        keep.add(next);
                    }
                    at.values.clear();
                    iterator = keep.iterator();
                    while (iterator.hasNext()) {
                        next = (Long)iterator.next();
                        at.values.add(String.valueOf(next));
                    }
                    break;
                }
                case RANGE: {
                    if (at.getLongStart() > key.getLimit()) break;
                    at.start = String.valueOf(key.getLimit() + 1L);
                    break;
                }
                default: {
                    at.any = false;
                    at.values.clear();
                    at.start = String.valueOf(key.getLimit() + 1L);
                    at.end = String.valueOf(Long.MAX_VALUE);
                }
            }
        }
        return new AuthenticationResult(key);
    }

    public static AuthenticationResult authenticate(int id, String hash, long when, AttributeSelector at, AccountAccessMask desiredOp) {
        AuthenticationResult result = ServiceUtil.authenticate(id, hash, when, at);
        if (result.isFail()) {
            return result;
        }
        if (!desiredOp.checkAccess(result.key.getAccessMask())) {
            ServiceError errMsg = new ServiceError(Response.Status.FORBIDDEN.getStatusCode(), "Access key not authorized to access the requested model type, contact key owner");
            return new AuthenticationResult(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)errMsg).build());
        }
        return result;
    }

    public static AuthenticationResult authenticate(int id, String hash, long when, AttributeSelector at, Collection<AccountAccessMask> desiredOp) {
        AuthenticationResult result = ServiceUtil.authenticate(id, hash, when, at);
        if (result.isFail()) {
            return result;
        }
        for (AccountAccessMask nextMask : desiredOp) {
            if (!nextMask.checkAccess(result.key.getAccessMask())) continue;
            return result;
        }
        ServiceError errMsg = new ServiceError(Response.Status.FORBIDDEN.getStatusCode(), "Access key not authorized to access the requested model object, contact key owner");
        return new AuthenticationResult(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)errMsg).build());
    }

    protected static String getServerTime(long tm) {
        return dateFormat.format(new Date(tm));
    }

    public static Response.ResponseBuilder stamp(Response.ResponseBuilder result, long when, long expiry) {
        if (expiry <= 0L && expiry != Long.MIN_VALUE) {
            expiry = when + DEFAULT_EXPIRY_INTERVAL;
        }
        if (expiry > 0L) {
            result = result.expires(new Date(expiry));
        } else {
            CacheControl noC = new CacheControl();
            noC.setNoCache(true);
            result = result.cacheControl(noC);
        }
        return result.header("Date", (Object)ServiceUtil.getServerTime(when)).header("EveKit-Version", (Object)versionString);
    }

    protected static String join(String delim, String ... args) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            builder.append(args[i]);
            if (i + 1 >= args.length) continue;
            builder.append(delim);
        }
        return builder.toString();
    }

    public static void auditAccess(SynchronizedAccountAccessKey key, AccountAccessMask op, String src, String path) {
        log.fine(ServiceUtil.join(", ", "AUDIT", "RESOURCEACCESS", "FROM", src, "USER", key.getSyncAccount().getUserAccount().getUid(), "ACCT", String.valueOf(key.getSyncAccount().getAid()), "KEY", String.valueOf(key.getAccessKey()), "OP", op == null ? "NA" : op.toString(), "PATH", path));
    }

    public static void auditAccess(SynchronizedAccountAccessKey key, Collection<AccountAccessMask> op, String src, String path) {
        log.fine(ServiceUtil.join(", ", "AUDIT", "RESOURCEACCESS", "FROM", src, "USER", key.getSyncAccount().getUserAccount().getUid(), "ACCT", String.valueOf(key.getSyncAccount().getAid()), "KEY", String.valueOf(key.getAccessKey()), "OP", Arrays.toString(op.toArray()).replace(", ", "|"), "PATH", path));
    }

    public static void auditRefAccess(String src, String path) {
        log.fine(ServiceUtil.join(", ", "AUDIT", "REFRESOURCEACCESS", "FROM", src, "PATH", path));
    }

    public static void updateLifeline(long start, CachedData ... data) {
        long end = Long.MAX_VALUE;
        for (CachedData next : data) {
            end = Math.min(end, next.getLifeEnd());
        }
        for (CachedData next : data) {
            next.setLifeStart(start);
            next.setLifeEnd(end);
        }
    }

    public static <A extends CachedData> void updateLifeline(long start, Collection<A> data) {
        long end = Long.MAX_VALUE;
        for (CachedData next : data) {
            end = Math.min(end, next.getLifeEnd());
        }
        for (CachedData next : data) {
            next.setLifeStart(start);
            next.setLifeEnd(end);
        }
    }

    private static Set<ESISyncEndpoint> makeEPSet(ESISyncEndpoint ... n) {
        return new HashSet<ESISyncEndpoint>(Arrays.asList(n));
    }

    public static long computeExpiry(long when, SynchronizedEveAccount acct, AccountAccessMask type) throws IllegalArgumentException {
        Set<ESISyncEndpoint> endpoints = accessMap.get(Pair.of((Object)type, (Object)acct.isCharacterType()));
        if (endpoints == null || endpoints.isEmpty()) {
            return when;
        }
        return endpoints.stream().map(x -> AccountHandlerUtil.handleStandardExpiry(x, acct)).min(Long::compare).get();
    }

    public static void sanitizeAttributeSelector(AttributeSelector as) {
        if (as.start != null && as.start.length() > 200) {
            as.start = as.start.substring(0, 200);
        }
        if (as.end != null && as.end.length() > 200) {
            as.end = as.end.substring(0, 200);
        }
        if (as.values.size() > 0) {
            HashSet<String> newSet = new HashSet<String>();
            Iterator i = as.values.iterator();
            for (int j = 0; j < 500 && i.hasNext(); ++j) {
                String next = (String)i.next();
                if (next.length() > 200) {
                    next = next.substring(0, 200);
                }
                newSet.add(next);
            }
            as.values = newSet;
        }
    }

    public static void sanitizeAttributeSelector(AttributeSelector ... as) {
        for (AttributeSelector next : as) {
            ServiceUtil.sanitizeAttributeSelector(next);
        }
    }

    static {
        HashMap<Pair<AccountAccessMask, Boolean>, Set<ESISyncEndpoint>> map = new HashMap<Pair<AccountAccessMask, Boolean>, Set<ESISyncEndpoint>>();
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_UPCOMING_CALENDAR_EVENTS, (Object)true), ServiceUtil.makeEPSet(ESISyncEndpoint.CHAR_CALENDAR));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_CALENDAR_EVENT_ATTENDEES, (Object)true), ServiceUtil.makeEPSet(ESISyncEndpoint.CHAR_CALENDAR));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_CHARACTER_SHEET, (Object)true), ServiceUtil.makeEPSet(ESISyncEndpoint.CHAR_CORP_ROLES, ESISyncEndpoint.CHAR_SHEET, ESISyncEndpoint.CHAR_SKILLS, ESISyncEndpoint.CHAR_CLONES, ESISyncEndpoint.CHAR_FATIGUE, ESISyncEndpoint.CHAR_TITLES, ESISyncEndpoint.CHAR_IMPLANTS, ESISyncEndpoint.CHAR_CLONES));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_FITTINGS, (Object)true), ServiceUtil.makeEPSet(ESISyncEndpoint.CHAR_FITTINGS));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_MEDALS, (Object)true), ServiceUtil.makeEPSet(ESISyncEndpoint.CHAR_MEDALS));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_NOTIFICATIONS, (Object)true), ServiceUtil.makeEPSet(ESISyncEndpoint.CHAR_NOTIFICATIONS));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_CONTACT_NOTIFICATIONS, (Object)true), ServiceUtil.makeEPSet(ESISyncEndpoint.CHAR_NOTIFICATIONS));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_MAILING_LISTS, (Object)true), ServiceUtil.makeEPSet(ESISyncEndpoint.CHAR_MAIL));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_MAIL, (Object)true), ServiceUtil.makeEPSet(ESISyncEndpoint.CHAR_MAIL));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_RESEARCH, (Object)true), ServiceUtil.makeEPSet(ESISyncEndpoint.CHAR_AGENTS));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_SKILL_QUEUE, (Object)true), ServiceUtil.makeEPSet(ESISyncEndpoint.CHAR_SKILL_QUEUE));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_ACCOUNT_STATUS, (Object)true), ServiceUtil.makeEPSet(ESISyncEndpoint.CHAR_ONLINE));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_CONTAINER_LOG, (Object)false), ServiceUtil.makeEPSet(ESISyncEndpoint.CORP_CONTAINER_LOGS));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_CORPORATION_MEDALS, (Object)false), ServiceUtil.makeEPSet(ESISyncEndpoint.CORP_MEDALS));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_CORPORATION_SHEET, (Object)false), ServiceUtil.makeEPSet(ESISyncEndpoint.CORP_SHEET, ESISyncEndpoint.CORP_DIVISIONS));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_CORPORATION_TITLES, (Object)false), ServiceUtil.makeEPSet(ESISyncEndpoint.CORP_TITLES));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_MEMBER_MEDALS, (Object)false), ServiceUtil.makeEPSet(ESISyncEndpoint.CORP_MEDALS));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_MEMBER_SECURITY, (Object)false), ServiceUtil.makeEPSet(ESISyncEndpoint.CORP_MEMBERSHIP, ESISyncEndpoint.CORP_TITLES));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_MEMBER_SECURITY_LOG, (Object)false), ServiceUtil.makeEPSet(ESISyncEndpoint.CORP_MEMBERSHIP));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_MEMBER_TRACKING, (Object)false), ServiceUtil.makeEPSet(ESISyncEndpoint.CORP_TRACK_MEMBERS));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_SHAREHOLDERS, (Object)false), ServiceUtil.makeEPSet(ESISyncEndpoint.CORP_SHAREHOLDERS));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_STARBASE_LIST, (Object)false), ServiceUtil.makeEPSet(ESISyncEndpoint.CORP_STARBASES));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_ACCOUNT_BALANCE, (Object)true), ServiceUtil.makeEPSet(ESISyncEndpoint.CHAR_WALLET_BALANCE));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_ACCOUNT_BALANCE, (Object)false), ServiceUtil.makeEPSet(ESISyncEndpoint.CORP_WALLET_BALANCE));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_ASSETS, (Object)true), ServiceUtil.makeEPSet(ESISyncEndpoint.CHAR_PLANETS, ESISyncEndpoint.CHAR_ASSETS));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_ASSETS, (Object)false), ServiceUtil.makeEPSet(ESISyncEndpoint.CORP_CUSTOMS, ESISyncEndpoint.CORP_ASSETS));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_BLUEPRINTS, (Object)true), ServiceUtil.makeEPSet(ESISyncEndpoint.CHAR_BLUEPRINTS));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_BLUEPRINTS, (Object)false), ServiceUtil.makeEPSet(ESISyncEndpoint.CORP_BLUEPRINTS));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_BOOKMARKS, (Object)true), ServiceUtil.makeEPSet(ESISyncEndpoint.CHAR_BOOKMARKS));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_BOOKMARKS, (Object)false), ServiceUtil.makeEPSet(ESISyncEndpoint.CORP_BOOKMARKS));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_CONTACT_LIST, (Object)true), ServiceUtil.makeEPSet(ESISyncEndpoint.CHAR_CONTACTS));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_CONTACT_LIST, (Object)false), ServiceUtil.makeEPSet(ESISyncEndpoint.CORP_CONTACTS));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_CONTRACTS, (Object)true), ServiceUtil.makeEPSet(ESISyncEndpoint.CHAR_CONTRACTS));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_CONTRACTS, (Object)false), ServiceUtil.makeEPSet(ESISyncEndpoint.CORP_CONTRACTS));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_FAC_WAR_STATS, (Object)true), ServiceUtil.makeEPSet(ESISyncEndpoint.CHAR_FACTION_WAR));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_FAC_WAR_STATS, (Object)false), ServiceUtil.makeEPSet(ESISyncEndpoint.CORP_FACTION_WAR));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_INDUSTRY_JOBS, (Object)true), ServiceUtil.makeEPSet(ESISyncEndpoint.CHAR_INDUSTRY));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_INDUSTRY_JOBS, (Object)false), ServiceUtil.makeEPSet(ESISyncEndpoint.CORP_FACILITIES, ESISyncEndpoint.CORP_INDUSTRY));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_KILL_LOG, (Object)true), ServiceUtil.makeEPSet(ESISyncEndpoint.CHAR_KILL_MAIL));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_KILL_LOG, (Object)false), ServiceUtil.makeEPSet(ESISyncEndpoint.CORP_KILL_MAIL));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_LOCATIONS, (Object)true), ServiceUtil.makeEPSet(ESISyncEndpoint.CHAR_LOCATION, ESISyncEndpoint.CHAR_SHIP_TYPE, ESISyncEndpoint.CHAR_ASSETS));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_LOCATIONS, (Object)false), ServiceUtil.makeEPSet(ESISyncEndpoint.CORP_ASSETS));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_MARKET_ORDERS, (Object)true), ServiceUtil.makeEPSet(ESISyncEndpoint.CHAR_MARKET));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_MARKET_ORDERS, (Object)false), ServiceUtil.makeEPSet(ESISyncEndpoint.CORP_MARKET));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_STANDINGS, (Object)true), ServiceUtil.makeEPSet(ESISyncEndpoint.CHAR_STANDINGS));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_STANDINGS, (Object)false), ServiceUtil.makeEPSet(ESISyncEndpoint.CORP_STANDINGS));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_WALLET_JOURNAL, (Object)true), ServiceUtil.makeEPSet(ESISyncEndpoint.CHAR_WALLET_JOURNAL));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_WALLET_JOURNAL, (Object)false), ServiceUtil.makeEPSet(ESISyncEndpoint.CORP_WALLET_JOURNAL));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_WALLET_TRANSACTIONS, (Object)true), ServiceUtil.makeEPSet(ESISyncEndpoint.CHAR_WALLET_TRANSACTIONS));
        map.put(Pair.of((Object)AccountAccessMask.ACCESS_WALLET_TRANSACTIONS, (Object)false), ServiceUtil.makeEPSet(ESISyncEndpoint.CORP_WALLET_TRANSACTIONS));
        accessMap = map;
    }

    public static class AccessConfig {
        public int accessKey;
        public String accessCred;
        public long when;
        public AttributeSelector at;
        public AccountAccessMask mask;
        public boolean fail = false;
        public Response response;
        public SynchronizedEveAccount owner;
        public SynchronizedAccountAccessKey key;
        public long presetExpiry = -1L;

        public AccessConfig(int accessKey, String accessCred, AttributeSelector at, AccountAccessMask mask) {
            this.accessKey = accessKey;
            this.accessCred = accessCred;
            this.when = OrbitalProperties.getCurrentTime() + OrbitalProperties.getLongGlobalProperty((String)ServiceUtil.PROP_MIN_CACHE_DELAY, (long)DEF_MIN_CACHE_DELAY);
            this.at = at;
            this.mask = mask;
        }
    }

    public static class AuthenticationResult {
        public SynchronizedAccountAccessKey key;
        public Response response;

        public boolean isFail() {
            return this.response != null;
        }

        public AuthenticationResult(SynchronizedAccountAccessKey k) {
            this.key = k;
        }

        public AuthenticationResult(Response r) {
            this.response = r;
        }
    }
}

