/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.ws;

import enterprises.orbital.base.OrbitalProperties;
import enterprises.orbital.base.PersistentProperty;
import enterprises.orbital.evekit.account.AccountAccessMask;
import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.CachedData;
import enterprises.orbital.evekit.model.ESIEndpointSyncTracker;
import enterprises.orbital.evekit.model.ESISyncEndpoint;
import enterprises.orbital.evekit.model.TrackerNotFoundException;
import enterprises.orbital.evekit.ws.ServiceError;
import enterprises.orbital.evekit.ws.ServiceUtil;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;

public class AccountHandlerUtil {
    private static final Logger log = Logger.getLogger(AccountHandlerUtil.class.getName());
    private static final String PROP_RESULT_LIMIT = "enterprises.orbital.evekit.sync_model_ws.max_results";
    private static final int DEF_RESULT_LIMIT = 1000;
    private static final Map<ESISyncEndpoint, Long> modelExpiry = Stream.of(new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_WALLET_BALANCE, TimeUnit.MILLISECONDS.convert(120L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CORP_WALLET_BALANCE, TimeUnit.MILLISECONDS.convert(300L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_AGENTS, TimeUnit.MILLISECONDS.convert(3600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_WALLET_JOURNAL, TimeUnit.MILLISECONDS.convert(3600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CORP_WALLET_JOURNAL, TimeUnit.MILLISECONDS.convert(3600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_WALLET_TRANSACTIONS, TimeUnit.MILLISECONDS.convert(3600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CORP_WALLET_TRANSACTIONS, TimeUnit.MILLISECONDS.convert(3600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_ASSETS, TimeUnit.MILLISECONDS.convert(3600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CORP_ASSETS, TimeUnit.MILLISECONDS.convert(3600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_BLUEPRINTS, TimeUnit.MILLISECONDS.convert(3600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CORP_BLUEPRINTS, TimeUnit.MILLISECONDS.convert(3600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_MARKET, TimeUnit.MILLISECONDS.convert(1200L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CORP_MARKET, TimeUnit.MILLISECONDS.convert(1200L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_STANDINGS, TimeUnit.MILLISECONDS.convert(3600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CORP_STANDINGS, TimeUnit.MILLISECONDS.convert(3600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_CONTRACTS, TimeUnit.MILLISECONDS.convert(300L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CORP_CONTRACTS, TimeUnit.MILLISECONDS.convert(300L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_INDUSTRY, TimeUnit.MILLISECONDS.convert(300L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CORP_INDUSTRY, TimeUnit.MILLISECONDS.convert(300L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CORP_CONTAINER_LOGS, TimeUnit.MILLISECONDS.convert(600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_LOCATION, TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_SHIP_TYPE, TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_ONLINE, TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_BOOKMARKS, TimeUnit.MILLISECONDS.convert(3600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CORP_BOOKMARKS, TimeUnit.MILLISECONDS.convert(3600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_KILL_MAIL, TimeUnit.MILLISECONDS.convert(120L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CORP_KILL_MAIL, TimeUnit.MILLISECONDS.convert(300L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_SHEET, TimeUnit.MILLISECONDS.convert(3600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_SKILLS, TimeUnit.MILLISECONDS.convert(120L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_CLONES, TimeUnit.MILLISECONDS.convert(120L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_FATIGUE, TimeUnit.MILLISECONDS.convert(300L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_SKILL_QUEUE, TimeUnit.MILLISECONDS.convert(120L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_IMPLANTS, TimeUnit.MILLISECONDS.convert(300L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_MAIL, TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_CONTACTS, TimeUnit.MILLISECONDS.convert(300L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CORP_CONTACTS, TimeUnit.MILLISECONDS.convert(300L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_FACTION_WAR, TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CORP_FACTION_WAR, TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_PLANETS, TimeUnit.MILLISECONDS.convert(600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_CALENDAR, TimeUnit.MILLISECONDS.convert(600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_CORP_ROLES, TimeUnit.MILLISECONDS.convert(3600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_NOTIFICATIONS, TimeUnit.MILLISECONDS.convert(600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_MEDALS, TimeUnit.MILLISECONDS.convert(3600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_TITLES, TimeUnit.MILLISECONDS.convert(3600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CORP_MEDALS, TimeUnit.MILLISECONDS.convert(3600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CORP_SHEET, TimeUnit.MILLISECONDS.convert(3600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CORP_TRACK_MEMBERS, TimeUnit.MILLISECONDS.convert(3600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CORP_SHAREHOLDERS, TimeUnit.MILLISECONDS.convert(3600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CORP_DIVISIONS, TimeUnit.MILLISECONDS.convert(3600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CORP_TITLES, TimeUnit.MILLISECONDS.convert(3600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CORP_MEMBERSHIP, TimeUnit.MILLISECONDS.convert(3600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CORP_CUSTOMS, TimeUnit.MILLISECONDS.convert(3600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CORP_FACILITIES, TimeUnit.MILLISECONDS.convert(3600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CORP_STARBASES, TimeUnit.MILLISECONDS.convert(3600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_FITTINGS, TimeUnit.MILLISECONDS.convert(300L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_LOYALTY, TimeUnit.MILLISECONDS.convert(3600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CHAR_MINING, TimeUnit.MILLISECONDS.convert(600L, TimeUnit.SECONDS)), new AbstractMap.SimpleEntry<ESISyncEndpoint, Long>(ESISyncEndpoint.CORP_MINING, TimeUnit.MILLISECONDS.convert(3600L, TimeUnit.SECONDS))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));

    private static Response handleIllegalSelector() {
        ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
    }

    private static Response handleIOError(IOException e) {
        log.log(Level.WARNING, "Error retrieving values", e);
        ServiceError errMsg = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Internal error retrieving value.  If this error persists, please contact the site administrator");
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
    }

    public static long handleStandardExpiry(ESISyncEndpoint ep, SynchronizedEveAccount acct) {
        long shift = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.MINUTES);
        long def = OrbitalProperties.getCurrentTime() + shift;
        try {
            return Math.max(def, ESIEndpointSyncTracker.getLatestFinishedTracker((SynchronizedEveAccount)acct, (ESISyncEndpoint)ep).getSyncEnd() + modelExpiry.get(ep) + shift);
        }
        catch (TrackerNotFoundException | IOException e) {
            log.log(Level.WARNING, "Error retrieving last tracker finish time", e);
            return def;
        }
    }

    public static <A extends CachedData> Response handleStandardListRequest(int accessKey, String accessCred, AccountAccessMask mask, AttributeSelector at, long contid, int maxresults, boolean reverse, QueryCaller<A> query, HttpServletRequest request, AttributeSelector ... sels) {
        ServiceUtil.sanitizeAttributeSelector(at);
        ServiceUtil.sanitizeAttributeSelector(sels);
        maxresults = Math.min(PersistentProperty.getIntegerPropertyWithFallback((String)PROP_RESULT_LIMIT, (int)1000), maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, mask);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List<A> results = query.getList(cfg.owner, contid, maxresults, reverse, at, sels);
            for (CachedData next : results) {
                next.prepareTransient();
            }
            cfg.presetExpiry = query.getExpiry(cfg.owner);
            return ServiceUtil.finish(cfg, results, request);
        }
        catch (NumberFormatException e) {
            return AccountHandlerUtil.handleIllegalSelector();
        }
        catch (IOException e) {
            return AccountHandlerUtil.handleIOError(e);
        }
    }

    public static interface QueryCaller<A extends CachedData> {
        public List<A> getList(SynchronizedEveAccount var1, long var2, int var4, boolean var5, AttributeSelector var6, AttributeSelector ... var7) throws IOException;

        public long getExpiry(SynchronizedEveAccount var1);
    }
}

