/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.ws.common;

import enterprises.orbital.evekit.account.AccountAccessMask;
import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.CachedData;
import enterprises.orbital.evekit.model.common.AccountBalance;
import enterprises.orbital.evekit.model.common.Asset;
import enterprises.orbital.evekit.model.common.Blueprint;
import enterprises.orbital.evekit.model.common.Bookmark;
import enterprises.orbital.evekit.model.common.Contact;
import enterprises.orbital.evekit.model.common.ContactLabel;
import enterprises.orbital.evekit.model.common.Contract;
import enterprises.orbital.evekit.model.common.ContractBid;
import enterprises.orbital.evekit.model.common.ContractItem;
import enterprises.orbital.evekit.model.common.FacWarStats;
import enterprises.orbital.evekit.model.common.IndustryJob;
import enterprises.orbital.evekit.model.common.Kill;
import enterprises.orbital.evekit.model.common.KillAttacker;
import enterprises.orbital.evekit.model.common.KillItem;
import enterprises.orbital.evekit.model.common.KillVictim;
import enterprises.orbital.evekit.model.common.Location;
import enterprises.orbital.evekit.model.common.MarketOrder;
import enterprises.orbital.evekit.model.common.Standing;
import enterprises.orbital.evekit.model.common.WalletJournal;
import enterprises.orbital.evekit.model.common.WalletTransaction;
import enterprises.orbital.evekit.ws.ServiceError;
import enterprises.orbital.evekit.ws.ServiceUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/ws/v1/common")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(tags={"Common"}, produces="application/json", consumes="application/json")
public class ModelCommonWS {
    @Path(value="/account_balance")
    @GET
    @ApiOperation(value="Get account balance(s)")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested account balances", response=AccountBalance.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getAccountBalance(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="accountID") @DefaultValue(value="{ any: true }") @ApiParam(name="accountID", required=false, defaultValue="{ any: true }", value="Account ID selector") AttributeSelector accountID, @QueryParam(value="accountKey") @DefaultValue(value="{ any: true }") @ApiParam(name="accountKey", required=false, defaultValue="{ any: true }", value="Account key selector") AttributeSelector accountKey) {
        ServiceUtil.sanitizeAttributeSelector(at, accountID, accountKey);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_ACCOUNT_BALANCE);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = AccountBalance.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)accountID, (AttributeSelector)accountKey);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/asset")
    @GET
    @ApiOperation(value="Get assets")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested assets", response=Asset.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getAssets(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="itemID") @DefaultValue(value="{ any: true }") @ApiParam(name="itemID", required=false, defaultValue="{ any: true }", value="Asset item ID selector") AttributeSelector itemID, @QueryParam(value="locationID") @DefaultValue(value="{ any: true }") @ApiParam(name="locationID", required=false, defaultValue="{ any: true }", value="Asset location ID selector") AttributeSelector locationID, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", required=false, defaultValue="{ any: true }", value="Asset type ID selector") AttributeSelector typeID, @QueryParam(value="quantity") @DefaultValue(value="{ any: true }") @ApiParam(name="quantity", required=false, defaultValue="{ any: true }", value="Asset quantity selector") AttributeSelector quantity, @QueryParam(value="flag") @DefaultValue(value="{ any: true }") @ApiParam(name="flag", required=false, defaultValue="{ any: true }", value="Asset flag selector") AttributeSelector flag, @QueryParam(value="singleton") @DefaultValue(value="{ any: true }") @ApiParam(name="singleton", required=false, defaultValue="{ any: true }", value="Asset is singleton selector") AttributeSelector singleton, @QueryParam(value="rawQuantity") @DefaultValue(value="{ any: true }") @ApiParam(name="rawQuantity", required=false, defaultValue="{ any: true }", value="Asset raw quantity selector") AttributeSelector rawQuantity, @QueryParam(value="container") @DefaultValue(value="{ any: true }") @ApiParam(name="container", required=false, defaultValue="{ any: true }", value="Asset container selector") AttributeSelector container) {
        ServiceUtil.sanitizeAttributeSelector(at, itemID, locationID, typeID, quantity, flag, singleton, rawQuantity, container);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_ASSETS);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = Asset.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)itemID, (AttributeSelector)locationID, (AttributeSelector)typeID, (AttributeSelector)quantity, (AttributeSelector)flag, (AttributeSelector)singleton, (AttributeSelector)rawQuantity, (AttributeSelector)container);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/blueprint")
    @GET
    @ApiOperation(value="Get blueprints")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested blueprints", response=Blueprint.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getBlueprints(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="itemID") @DefaultValue(value="{ any: true }") @ApiParam(name="itemID", required=false, defaultValue="{ any: true }", value="Blueprint item ID selector") AttributeSelector itemID, @QueryParam(value="locationID") @DefaultValue(value="{ any: true }") @ApiParam(name="locationID", required=false, defaultValue="{ any: true }", value="Blueprint location ID selector") AttributeSelector locationID, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", required=false, defaultValue="{ any: true }", value="Blueprint type ID selector") AttributeSelector typeID, @QueryParam(value="typeName") @DefaultValue(value="{ any: true }") @ApiParam(name="typeName", required=false, defaultValue="{ any: true }", value="Blueprint type name selector") AttributeSelector typeName, @QueryParam(value="flagID") @DefaultValue(value="{ any: true }") @ApiParam(name="flagID", required=false, defaultValue="{ any: true }", value="Blueprint flag ID selector") AttributeSelector flagID, @QueryParam(value="quantity") @DefaultValue(value="{ any: true }") @ApiParam(name="quantity", required=false, defaultValue="{ any: true }", value="Blueprint quantity selector") AttributeSelector quantity, @QueryParam(value="timeEfficiency") @DefaultValue(value="{ any: true }") @ApiParam(name="timeEfficiency", required=false, defaultValue="{ any: true }", value="Blueprint time efficiency selector") AttributeSelector timeEfficiency, @QueryParam(value="materialEfficiency") @DefaultValue(value="{ any: true }") @ApiParam(name="materialEfficiency", required=false, defaultValue="{ any: true }", value="Blueprint material efficiency selector") AttributeSelector materialEfficiency, @QueryParam(value="runs") @DefaultValue(value="{ any: true }") @ApiParam(name="runs", required=false, defaultValue="{ any: true }", value="Blueprint runs selector") AttributeSelector runs) {
        ServiceUtil.sanitizeAttributeSelector(at, itemID, locationID, typeID, typeName, flagID, quantity, timeEfficiency, materialEfficiency, runs);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_BLUEPRINTS);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = Blueprint.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)itemID, (AttributeSelector)locationID, (AttributeSelector)typeID, (AttributeSelector)typeName, (AttributeSelector)flagID, (AttributeSelector)quantity, (AttributeSelector)timeEfficiency, (AttributeSelector)materialEfficiency, (AttributeSelector)runs);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/bookmark")
    @GET
    @ApiOperation(value="Get bookmarks")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested bookmarks", response=Bookmark.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getBookmarks(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="folderID") @DefaultValue(value="{ any: true }") @ApiParam(name="folderID", required=false, defaultValue="{ any: true }", value="Bookmark folder ID selector") AttributeSelector folderID, @QueryParam(value="folderName") @DefaultValue(value="{ any: true }") @ApiParam(name="folderName", required=false, defaultValue="{ any: true }", value="Bookmark folder name selector") AttributeSelector folderName, @QueryParam(value="folderCreatorID") @DefaultValue(value="{ any: true }") @ApiParam(name="folderCreatorID", required=false, defaultValue="{ any: true }", value="Bookmark folder creator ID selector") AttributeSelector folderCreatorID, @QueryParam(value="bookmarkID") @DefaultValue(value="{ any: true }") @ApiParam(name="bookmarkID", required=false, defaultValue="{ any: true }", value="Bookmark ID selector") AttributeSelector bookmarkID, @QueryParam(value="bookmarkCreatorID") @DefaultValue(value="{ any: true }") @ApiParam(name="bookmarkCreatorID", required=false, defaultValue="{ any: true }", value="Bookmark creator ID selector") AttributeSelector bookmarkCreatorID, @QueryParam(value="created") @DefaultValue(value="{ any: true }") @ApiParam(name="created", required=false, defaultValue="{ any: true }", value="Bookmark created selector") AttributeSelector created, @QueryParam(value="itemID") @DefaultValue(value="{ any: true }") @ApiParam(name="itemID", required=false, defaultValue="{ any: true }", value="Bookmark item ID selector") AttributeSelector itemID, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", required=false, defaultValue="{ any: true }", value="Bookmark type ID selector") AttributeSelector typeID, @QueryParam(value="locationID") @DefaultValue(value="{ any: true }") @ApiParam(name="locationID", required=false, defaultValue="{ any: true }", value="Bookmark location ID selector") AttributeSelector locationID, @QueryParam(value="x") @DefaultValue(value="{ any: true }") @ApiParam(name="x", required=false, defaultValue="{ any: true }", value="Bookmark x coordinate selector") AttributeSelector x, @QueryParam(value="y") @DefaultValue(value="{ any: true }") @ApiParam(name="y", required=false, defaultValue="{ any: true }", value="Bookmark y coordinate selector") AttributeSelector y, @QueryParam(value="z") @DefaultValue(value="{ any: true }") @ApiParam(name="z", required=false, defaultValue="{ any: true }", value="Bookmark z coordinate selector") AttributeSelector z, @QueryParam(value="memo") @DefaultValue(value="{ any: true }") @ApiParam(name="memo", required=false, defaultValue="{ any: true }", value="Bookmark memo selector") AttributeSelector memo, @QueryParam(value="note") @DefaultValue(value="{ any: true }") @ApiParam(name="note", required=false, defaultValue="{ any: true }", value="Bookmark note selector") AttributeSelector note) {
        ServiceUtil.sanitizeAttributeSelector(at, folderID, folderName, folderCreatorID, bookmarkID, bookmarkCreatorID, created, itemID, typeID, locationID, x, y, z, memo, note);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_BOOKMARKS);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = Bookmark.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)folderID, (AttributeSelector)folderName, (AttributeSelector)folderCreatorID, (AttributeSelector)bookmarkID, (AttributeSelector)bookmarkCreatorID, (AttributeSelector)created, (AttributeSelector)itemID, (AttributeSelector)typeID, (AttributeSelector)locationID, (AttributeSelector)x, (AttributeSelector)y, (AttributeSelector)z, (AttributeSelector)memo, (AttributeSelector)note);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/contact")
    @GET
    @ApiOperation(value="Get contacts")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested contacts", response=Contact.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getContacts(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="list") @DefaultValue(value="{ any: true }") @ApiParam(name="list", required=false, defaultValue="{ any: true }", value="Contact list selector") AttributeSelector list, @QueryParam(value="contactID") @DefaultValue(value="{ any: true }") @ApiParam(name="contactID", required=false, defaultValue="{ any: true }", value="Contact ID selector") AttributeSelector contactID, @QueryParam(value="contactName") @DefaultValue(value="{ any: true }") @ApiParam(name="contactName", required=false, defaultValue="{ any: true }", value="Contact name selector") AttributeSelector contactName, @QueryParam(value="standing") @DefaultValue(value="{ any: true }") @ApiParam(name="standing", required=false, defaultValue="{ any: true }", value="Contact standing selector") AttributeSelector standing, @QueryParam(value="contactTypeID") @DefaultValue(value="{ any: true }") @ApiParam(name="contactTypeID", required=false, defaultValue="{ any: true }", value="Contact type ID selector") AttributeSelector contactTypeID, @QueryParam(value="inWatchlist") @DefaultValue(value="{ any: true }") @ApiParam(name="inWatchlist", required=false, defaultValue="{ any: true }", value="Contact in watch list selector") AttributeSelector inWatchlist, @QueryParam(value="labelMask") @DefaultValue(value="{ any: true }") @ApiParam(name="labelMask", required=false, defaultValue="{ any: true }", value="Contact label mask selector") AttributeSelector labelMask) {
        ServiceUtil.sanitizeAttributeSelector(at, list, contactID, contactName, standing, contactTypeID, inWatchlist, labelMask);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_CONTACT_LIST);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = Contact.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)list, (AttributeSelector)contactID, (AttributeSelector)contactName, (AttributeSelector)standing, (AttributeSelector)contactTypeID, (AttributeSelector)inWatchlist, (AttributeSelector)labelMask);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/contact_label")
    @GET
    @ApiOperation(value="Get contact labels")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested contact labels", response=ContactLabel.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getContactLabels(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="list") @DefaultValue(value="{ any: true }") @ApiParam(name="list", required=false, defaultValue="{ any: true }", value="Contact list selector") AttributeSelector list, @QueryParam(value="labelID") @DefaultValue(value="{ any: true }") @ApiParam(name="labelID", required=false, defaultValue="{ any: true }", value="Contact label ID selector") AttributeSelector labelID, @QueryParam(value="name") @DefaultValue(value="{ any: true }") @ApiParam(name="name", required=false, defaultValue="{ any: true }", value="Contact label name selector") AttributeSelector name) {
        ServiceUtil.sanitizeAttributeSelector(at, list, labelID, name);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_CONTACT_LIST);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = ContactLabel.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)list, (AttributeSelector)labelID, (AttributeSelector)name);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/contract")
    @GET
    @ApiOperation(value="Get contracts")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested contracts", response=Contract.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getContracts(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="contractID") @DefaultValue(value="{ any: true }") @ApiParam(name="contractID", required=false, defaultValue="{ any: true }", value="Contract ID selector") AttributeSelector contractID, @QueryParam(value="issuerID") @DefaultValue(value="{ any: true }") @ApiParam(name="issuerID", required=false, defaultValue="{ any: true }", value="Contract issuer ID selector") AttributeSelector issuerID, @QueryParam(value="issuerCorpID") @DefaultValue(value="{ any: true }") @ApiParam(name="issuerCorpID", required=false, defaultValue="{ any: true }", value="Contract issuer corporation ID selector") AttributeSelector issuerCorpID, @QueryParam(value="assigneeID") @DefaultValue(value="{ any: true }") @ApiParam(name="assigneeID", required=false, defaultValue="{ any: true }", value="Contract assignee ID selector") AttributeSelector assigneeID, @QueryParam(value="acceptorID") @DefaultValue(value="{ any: true }") @ApiParam(name="acceptorID", required=false, defaultValue="{ any: true }", value="Contract acceptor ID selector") AttributeSelector acceptorID, @QueryParam(value="startStationID") @DefaultValue(value="{ any: true }") @ApiParam(name="startStationID", required=false, defaultValue="{ any: true }", value="Contract start station ID selector") AttributeSelector startStationID, @QueryParam(value="endStationID") @DefaultValue(value="{ any: true }") @ApiParam(name="endStationID", required=false, defaultValue="{ any: true }", value="Contract end station ID selector") AttributeSelector endStationID, @QueryParam(value="type") @DefaultValue(value="{ any: true }") @ApiParam(name="type", required=false, defaultValue="{ any: true }", value="Contract type selector") AttributeSelector type, @QueryParam(value="status") @DefaultValue(value="{ any: true }") @ApiParam(name="status", required=false, defaultValue="{ any: true }", value="Contract status selector") AttributeSelector status, @QueryParam(value="title") @DefaultValue(value="{ any: true }") @ApiParam(name="title", required=false, defaultValue="{ any: true }", value="Contract title selector") AttributeSelector title, @QueryParam(value="forCorp") @DefaultValue(value="{ any: true }") @ApiParam(name="forCorp", required=false, defaultValue="{ any: true }", value="Contract for corporation selector") AttributeSelector forCorp, @QueryParam(value="availability") @DefaultValue(value="{ any: true }") @ApiParam(name="availability", required=false, defaultValue="{ any: true }", value="Contract availability selector") AttributeSelector availability, @QueryParam(value="dateIssued") @DefaultValue(value="{ any: true }") @ApiParam(name="dateIssued", required=false, defaultValue="{ any: true }", value="Contract date issued selector") AttributeSelector dateIssued, @QueryParam(value="dateExpired") @DefaultValue(value="{ any: true }") @ApiParam(name="dateExpired", required=false, defaultValue="{ any: true }", value="Contract date expired selector") AttributeSelector dateExpired, @QueryParam(value="dateAccepted") @DefaultValue(value="{ any: true }") @ApiParam(name="dateAccepted", required=false, defaultValue="{ any: true }", value="Contract date accepted selector") AttributeSelector dateAccepted, @QueryParam(value="numDays") @DefaultValue(value="{ any: true }") @ApiParam(name="numDays", required=false, defaultValue="{ any: true }", value="Contract duration (days) selector") AttributeSelector numDays, @QueryParam(value="dateCompleted") @DefaultValue(value="{ any: true }") @ApiParam(name="dateCompleted", required=false, defaultValue="{ any: true }", value="Contract date completed selector") AttributeSelector dateCompleted, @QueryParam(value="price") @DefaultValue(value="{ any: true }") @ApiParam(name="price", required=false, defaultValue="{ any: true }", value="Contract price selector") AttributeSelector price, @QueryParam(value="reward") @DefaultValue(value="{ any: true }") @ApiParam(name="reward", required=false, defaultValue="{ any: true }", value="Contract reward value selector") AttributeSelector reward, @QueryParam(value="collateral") @DefaultValue(value="{ any: true }") @ApiParam(name="collateral", required=false, defaultValue="{ any: true }", value="Contract collateral value selector") AttributeSelector collateral, @QueryParam(value="buyout") @DefaultValue(value="{ any: true }") @ApiParam(name="buyout", required=false, defaultValue="{ any: true }", value="Contract buyout price selector") AttributeSelector buyout, @QueryParam(value="volume") @DefaultValue(value="{ any: true }") @ApiParam(name="volume", required=false, defaultValue="{ any: true }", value="Contract volume selector") AttributeSelector volume) {
        ServiceUtil.sanitizeAttributeSelector(at, contractID, issuerID, issuerCorpID, assigneeID, acceptorID, startStationID, endStationID, type, status, title, forCorp, availability, dateIssued, dateExpired, dateAccepted, numDays, dateCompleted, price, reward, collateral, buyout, volume);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_CONTRACTS);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = Contract.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)contractID, (AttributeSelector)issuerID, (AttributeSelector)issuerCorpID, (AttributeSelector)assigneeID, (AttributeSelector)acceptorID, (AttributeSelector)startStationID, (AttributeSelector)endStationID, (AttributeSelector)type, (AttributeSelector)status, (AttributeSelector)title, (AttributeSelector)forCorp, (AttributeSelector)availability, (AttributeSelector)dateIssued, (AttributeSelector)dateExpired, (AttributeSelector)dateAccepted, (AttributeSelector)numDays, (AttributeSelector)dateCompleted, (AttributeSelector)price, (AttributeSelector)reward, (AttributeSelector)collateral, (AttributeSelector)buyout, (AttributeSelector)volume);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/contract_bid")
    @GET
    @ApiOperation(value="Get contract bids")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested contract bids", response=ContractBid.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getContractBids(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="bidID") @DefaultValue(value="{ any: true }") @ApiParam(name="bidID", required=false, defaultValue="{ any: true }", value="Contract bid ID selector") AttributeSelector bidID, @QueryParam(value="contractID") @DefaultValue(value="{ any: true }") @ApiParam(name="contractID", required=false, defaultValue="{ any: true }", value="Contract ID selector") AttributeSelector contractID, @QueryParam(value="bidderID") @DefaultValue(value="{ any: true }") @ApiParam(name="bidderID", required=false, defaultValue="{ any: true }", value="Contract bid bidder ID selector") AttributeSelector bidderID, @QueryParam(value="dateBid") @DefaultValue(value="{ any: true }") @ApiParam(name="dateBid", required=false, defaultValue="{ any: true }", value="Contract bid date selector") AttributeSelector dateBid, @QueryParam(value="amount") @DefaultValue(value="{ any: true }") @ApiParam(name="amount", required=false, defaultValue="{ any: true }", value="Contract bid amount selector") AttributeSelector amount) {
        ServiceUtil.sanitizeAttributeSelector(at, bidID, contractID, bidderID, dateBid, amount);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_CONTRACTS);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = ContractBid.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)bidID, (AttributeSelector)contractID, (AttributeSelector)bidderID, (AttributeSelector)dateBid, (AttributeSelector)amount);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/contract_item")
    @GET
    @ApiOperation(value="Get contract items")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested contract items", response=ContractItem.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getContractItems(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="contractID") @DefaultValue(value="{ any: true }") @ApiParam(name="contractID", required=false, defaultValue="{ any: true }", value="Contract ID selector") AttributeSelector contractID, @QueryParam(value="recordID") @DefaultValue(value="{ any: true }") @ApiParam(name="recordID", required=false, defaultValue="{ any: true }", value="Contract item record ID selector") AttributeSelector recordID, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", required=false, defaultValue="{ any: true }", value="Contract item type ID selector") AttributeSelector typeID, @QueryParam(value="quantity") @DefaultValue(value="{ any: true }") @ApiParam(name="quantity", required=false, defaultValue="{ any: true }", value="Contract item quantity selector") AttributeSelector quantity, @QueryParam(value="rawQuantity") @DefaultValue(value="{ any: true }") @ApiParam(name="rawQuantity", required=false, defaultValue="{ any: true }", value="Contract item raw quantity selector") AttributeSelector rawQuantity, @QueryParam(value="singleton") @DefaultValue(value="{ any: true }") @ApiParam(name="singleton", required=false, defaultValue="{ any: true }", value="Contract item singleton selector") AttributeSelector singleton, @QueryParam(value="included") @DefaultValue(value="{ any: true }") @ApiParam(name="included", required=false, defaultValue="{ any: true }", value="Contract item included selector") AttributeSelector included) {
        ServiceUtil.sanitizeAttributeSelector(at, contractID, recordID, typeID, quantity, rawQuantity, singleton, included);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_CONTRACTS);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = ContractItem.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)contractID, (AttributeSelector)recordID, (AttributeSelector)typeID, (AttributeSelector)quantity, (AttributeSelector)rawQuantity, (AttributeSelector)singleton, (AttributeSelector)included);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/fac_war_stats")
    @GET
    @ApiOperation(value="Get faction war statistics")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested faction war statistics", response=FacWarStats.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getFacWarStats(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="currentRank") @DefaultValue(value="{ any: true }") @ApiParam(name="currentRank", required=false, defaultValue="{ any: true }", value="Faction war statistics current rank selector") AttributeSelector currentRank, @QueryParam(value="enlisted") @DefaultValue(value="{ any: true }") @ApiParam(name="enlisted", required=false, defaultValue="{ any: true }", value="Faction war statistics enlisted indicator selector") AttributeSelector enlisted, @QueryParam(value="factionID") @DefaultValue(value="{ any: true }") @ApiParam(name="factionID", required=false, defaultValue="{ any: true }", value="Faction war statistics faction ID selector") AttributeSelector factionID, @QueryParam(value="factionName") @DefaultValue(value="{ any: true }") @ApiParam(name="factionName", required=false, defaultValue="{ any: true }", value="Faction war statistics faction name selector") AttributeSelector factionName, @QueryParam(value="highestRank") @DefaultValue(value="{ any: true }") @ApiParam(name="highestRank", required=false, defaultValue="{ any: true }", value="Faction war statistics highest rank selector") AttributeSelector highestRank, @QueryParam(value="killsLastWeek") @DefaultValue(value="{ any: true }") @ApiParam(name="killsLastWeek", required=false, defaultValue="{ any: true }", value="Faction war statistics kill last week selector") AttributeSelector killsLastWeek, @QueryParam(value="killsTotal") @DefaultValue(value="{ any: true }") @ApiParam(name="killsTotal", required=false, defaultValue="{ any: true }", value="Faction war statistics total kills selector") AttributeSelector killsTotal, @QueryParam(value="killsYesterday") @DefaultValue(value="{ any: true }") @ApiParam(name="killsYesterday", required=false, defaultValue="{ any: true }", value="Faction war statistics kills yesterday selector") AttributeSelector killsYesterday, @QueryParam(value="pilots") @DefaultValue(value="{ any: true }") @ApiParam(name="pilots", required=false, defaultValue="{ any: true }", value="Faction war statistics pilot count selector") AttributeSelector pilots, @QueryParam(value="victoryPointsLastWeek") @DefaultValue(value="{ any: true }") @ApiParam(name="victoryPointsLastWeek", required=false, defaultValue="{ any: true }", value="Faction war statistics victory points last week selector") AttributeSelector victoryPointsLastWeek, @QueryParam(value="victoryPointsTotal") @DefaultValue(value="{ any: true }") @ApiParam(name="victoryPointsTotal", required=false, defaultValue="{ any: true }", value="Faction war statistics victory points total selector") AttributeSelector victoryPointsTotal, @QueryParam(value="victoryPointsYesterday") @DefaultValue(value="{ any: true }") @ApiParam(name="victoryPointsYesterday", required=false, defaultValue="{ any: true }", value="Faction war statistics victory points yesterday selector") AttributeSelector victoryPointsYesterday) {
        ServiceUtil.sanitizeAttributeSelector(at, currentRank, enlisted, factionID, factionName, highestRank, killsLastWeek, killsTotal, killsYesterday, pilots, victoryPointsLastWeek, victoryPointsTotal, victoryPointsYesterday);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_FAC_WAR_STATS);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = FacWarStats.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)currentRank, (AttributeSelector)enlisted, (AttributeSelector)factionID, (AttributeSelector)factionName, (AttributeSelector)highestRank, (AttributeSelector)killsLastWeek, (AttributeSelector)killsTotal, (AttributeSelector)killsYesterday, (AttributeSelector)pilots, (AttributeSelector)victoryPointsLastWeek, (AttributeSelector)victoryPointsTotal, (AttributeSelector)victoryPointsYesterday);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/industry_job")
    @GET
    @ApiOperation(value="Get industry jobs")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested industry jobs", response=IndustryJob.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getIndustryJobs(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="jobID") @DefaultValue(value="{ any: true }") @ApiParam(name="jobID", required=false, defaultValue="{ any: true }", value="Industry job ID selector") AttributeSelector jobID, @QueryParam(value="installerID") @DefaultValue(value="{ any: true }") @ApiParam(name="installerID", required=false, defaultValue="{ any: true }", value="Industry job installer ID selector") AttributeSelector installerID, @QueryParam(value="installerName") @DefaultValue(value="{ any: true }") @ApiParam(name="installerName", required=false, defaultValue="{ any: true }", value="Industry job installer name selector") AttributeSelector installerName, @QueryParam(value="facilityID") @DefaultValue(value="{ any: true }") @ApiParam(name="facilityID", required=false, defaultValue="{ any: true }", value="Industry job facility ID selector") AttributeSelector facilityID, @QueryParam(value="solarSystemID") @DefaultValue(value="{ any: true }") @ApiParam(name="solarSystemID", required=false, defaultValue="{ any: true }", value="Industry job solar system ID selector") AttributeSelector solarSystemID, @QueryParam(value="solarSystemName") @DefaultValue(value="{ any: true }") @ApiParam(name="solarSystemName", required=false, defaultValue="{ any: true }", value="Industry job solar system name selector") AttributeSelector solarSystemName, @QueryParam(value="stationID") @DefaultValue(value="{ any: true }") @ApiParam(name="stationID", required=false, defaultValue="{ any: true }", value="Industry job station ID selector") AttributeSelector stationID, @QueryParam(value="activityID") @DefaultValue(value="{ any: true }") @ApiParam(name="activityID", required=false, defaultValue="{ any: true }", value="Industry job activity ID selector") AttributeSelector activityID, @QueryParam(value="blueprintID") @DefaultValue(value="{ any: true }") @ApiParam(name="blueprintID", required=false, defaultValue="{ any: true }", value="Industry job blueprint ID selector") AttributeSelector blueprintID, @QueryParam(value="blueprintTypeID") @DefaultValue(value="{ any: true }") @ApiParam(name="blueprintTypeID", required=false, defaultValue="{ any: true }", value="Industry job blueprint type ID selector") AttributeSelector blueprintTypeID, @QueryParam(value="blueprintTypeName") @DefaultValue(value="{ any: true }") @ApiParam(name="blueprintTypeName", required=false, defaultValue="{ any: true }", value="Industry job blueprint type name selector") AttributeSelector blueprintTypeName, @QueryParam(value="blueprintLocationID") @DefaultValue(value="{ any: true }") @ApiParam(name="blueprintLocationID", required=false, defaultValue="{ any: true }", value="Industry job blueprint location ID selector") AttributeSelector blueprintLocationID, @QueryParam(value="outputLocationID") @DefaultValue(value="{ any: true }") @ApiParam(name="outputLocationID", required=false, defaultValue="{ any: true }", value="Industry job output location ID selector") AttributeSelector outputLocationID, @QueryParam(value="runs") @DefaultValue(value="{ any: true }") @ApiParam(name="runs", required=false, defaultValue="{ any: true }", value="Industry job runs selector") AttributeSelector runs, @QueryParam(value="cost") @DefaultValue(value="{ any: true }") @ApiParam(name="cost", required=false, defaultValue="{ any: true }", value="Industry job cost selector") AttributeSelector cost, @QueryParam(value="teamID") @DefaultValue(value="{ any: true }") @ApiParam(name="teamID", required=false, defaultValue="{ any: true }", value="Industry job team ID selector") AttributeSelector teamID, @QueryParam(value="licensedRuns") @DefaultValue(value="{ any: true }") @ApiParam(name="licensedRuns", required=false, defaultValue="{ any: true }", value="Industry job licensed runs selector") AttributeSelector licensedRuns, @QueryParam(value="probability") @DefaultValue(value="{ any: true }") @ApiParam(name="probability", required=false, defaultValue="{ any: true }", value="Industry job probability selector") AttributeSelector probability, @QueryParam(value="productTypeID") @DefaultValue(value="{ any: true }") @ApiParam(name="productTypeID", required=false, defaultValue="{ any: true }", value="Industry job product type ID selector") AttributeSelector productTypeID, @QueryParam(value="productTypeName") @DefaultValue(value="{ any: true }") @ApiParam(name="productTypeName", required=false, defaultValue="{ any: true }", value="Industry job product type name selector") AttributeSelector productTypeName, @QueryParam(value="status") @DefaultValue(value="{ any: true }") @ApiParam(name="status", required=false, defaultValue="{ any: true }", value="Industry job status selector") AttributeSelector status, @QueryParam(value="timeInSeconds") @DefaultValue(value="{ any: true }") @ApiParam(name="timeInSeconds", required=false, defaultValue="{ any: true }", value="Industry job time in seconds selector") AttributeSelector timeInSeconds, @QueryParam(value="startDate") @DefaultValue(value="{ any: true }") @ApiParam(name="startDate", required=false, defaultValue="{ any: true }", value="Industry job start date selector") AttributeSelector startDate, @QueryParam(value="endDate") @DefaultValue(value="{ any: true }") @ApiParam(name="endDate", required=false, defaultValue="{ any: true }", value="Industry job end date selector") AttributeSelector endDate, @QueryParam(value="pauseDate") @DefaultValue(value="{ any: true }") @ApiParam(name="pauseDate", required=false, defaultValue="{ any: true }", value="Industry job pause date selector") AttributeSelector pauseDate, @QueryParam(value="completedDate") @DefaultValue(value="{ any: true }") @ApiParam(name="completedDate", required=false, defaultValue="{ any: true }", value="Industry job completed date selector") AttributeSelector completedDate, @QueryParam(value="completedCharacterID") @DefaultValue(value="{ any: true }") @ApiParam(name="completedCharacterID", required=false, defaultValue="{ any: true }", value="Industry job completed character ID selector") AttributeSelector completedCharacterID, @QueryParam(value="successfulRuns") @DefaultValue(value="{ any: true }") @ApiParam(name="successfulRuns", required=false, defaultValue="{ any: true }", value="Industry job successful runs selector") AttributeSelector successfulRuns) {
        ServiceUtil.sanitizeAttributeSelector(at, jobID, installerID, installerName, facilityID, solarSystemID, solarSystemName, stationID, activityID, blueprintID, blueprintTypeID, blueprintTypeName, blueprintLocationID, outputLocationID, runs, cost, teamID, licensedRuns, probability, productTypeID, productTypeName, status, timeInSeconds, startDate, endDate, pauseDate, completedDate, completedCharacterID, successfulRuns);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_INDUSTRY_JOBS);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = IndustryJob.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)jobID, (AttributeSelector)installerID, (AttributeSelector)installerName, (AttributeSelector)facilityID, (AttributeSelector)solarSystemID, (AttributeSelector)solarSystemName, (AttributeSelector)stationID, (AttributeSelector)activityID, (AttributeSelector)blueprintID, (AttributeSelector)blueprintTypeID, (AttributeSelector)blueprintTypeName, (AttributeSelector)blueprintLocationID, (AttributeSelector)outputLocationID, (AttributeSelector)runs, (AttributeSelector)cost, (AttributeSelector)teamID, (AttributeSelector)licensedRuns, (AttributeSelector)probability, (AttributeSelector)productTypeID, (AttributeSelector)productTypeName, (AttributeSelector)status, (AttributeSelector)timeInSeconds, (AttributeSelector)startDate, (AttributeSelector)endDate, (AttributeSelector)pauseDate, (AttributeSelector)completedDate, (AttributeSelector)completedCharacterID, (AttributeSelector)successfulRuns);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/kill")
    @GET
    @ApiOperation(value="Get kills")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested kills", response=Kill.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getKills(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="killID") @DefaultValue(value="{ any: true }") @ApiParam(name="killID", required=false, defaultValue="{ any: true }", value="Kill ID selector") AttributeSelector killID, @QueryParam(value="killTime") @DefaultValue(value="{ any: true }") @ApiParam(name="killTime", required=false, defaultValue="{ any: true }", value="Kill time selector") AttributeSelector killTime, @QueryParam(value="moonID") @DefaultValue(value="{ any: true }") @ApiParam(name="moonID", required=false, defaultValue="{ any: true }", value="Kill moon ID selector") AttributeSelector moonID, @QueryParam(value="solarSystemID") @DefaultValue(value="{ any: true }") @ApiParam(name="solarSystemID", required=false, defaultValue="{ any: true }", value="Kill solar system ID selector") AttributeSelector solarSystemID) {
        ServiceUtil.sanitizeAttributeSelector(at, killID, killTime, moonID, solarSystemID);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_KILL_LOG);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = Kill.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)killID, (AttributeSelector)killTime, (AttributeSelector)moonID, (AttributeSelector)solarSystemID);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/kill_attacker")
    @GET
    @ApiOperation(value="Get kill attackers")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested kill attackers", response=KillAttacker.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getKillAttackers(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="killID") @DefaultValue(value="{ any: true }") @ApiParam(name="killID", required=false, defaultValue="{ any: true }", value="Kill ID selector") AttributeSelector killID, @QueryParam(value="attackerCharacterID") @DefaultValue(value="{ any: true }") @ApiParam(name="attackerCharacterID", required=false, defaultValue="{ any: true }", value="Kill attacker character ID selector") AttributeSelector attackerCharacterID, @QueryParam(value="allianceID") @DefaultValue(value="{ any: true }") @ApiParam(name="allianceID", required=false, defaultValue="{ any: true }", value="Kill attacker alliance ID selector") AttributeSelector allianceID, @QueryParam(value="allianceName") @DefaultValue(value="{ any: true }") @ApiParam(name="allianceName", required=false, defaultValue="{ any: true }", value="Kill attacker alliance name selector") AttributeSelector allianceName, @QueryParam(value="attackerCharacterName") @DefaultValue(value="{ any: true }") @ApiParam(name="attackerCharacterName", required=false, defaultValue="{ any: true }", value="Kill attacker character name selector") AttributeSelector attackerCharacterName, @QueryParam(value="attackerCorporationID") @DefaultValue(value="{ any: true }") @ApiParam(name="attackerCorporationID", required=false, defaultValue="{ any: true }", value="Kill attacker corporation ID selector") AttributeSelector attackerCorporationID, @QueryParam(value="attackerCorporationName") @DefaultValue(value="{ any: true }") @ApiParam(name="attackerCorporationName", required=false, defaultValue="{ any: true }", value="Kill attacker corporation name selector") AttributeSelector attackerCorporationName, @QueryParam(value="damageDone") @DefaultValue(value="{ any: true }") @ApiParam(name="damageDone", required=false, defaultValue="{ any: true }", value="Kill attacker damage done selector") AttributeSelector damageDone, @QueryParam(value="factionID") @DefaultValue(value="{ any: true }") @ApiParam(name="factionID", required=false, defaultValue="{ any: true }", value="Kill attacker faction ID selector") AttributeSelector factionID, @QueryParam(value="factionName") @DefaultValue(value="{ any: true }") @ApiParam(name="factionName", required=false, defaultValue="{ any: true }", value="Kill attacker faction name selector") AttributeSelector factionName, @QueryParam(value="securityStatus") @DefaultValue(value="{ any: true }") @ApiParam(name="securityStatus", required=false, defaultValue="{ any: true }", value="Kill attacker security status selector") AttributeSelector securityStatus, @QueryParam(value="shipTypeID") @DefaultValue(value="{ any: true }") @ApiParam(name="shipTypeID", required=false, defaultValue="{ any: true }", value="Kill attacker ship type ID selector") AttributeSelector shipTypeID, @QueryParam(value="weaponTypeID") @DefaultValue(value="{ any: true }") @ApiParam(name="weaponTypeID", required=false, defaultValue="{ any: true }", value="Kill attacker weapon type ID selector") AttributeSelector weaponTypeID, @QueryParam(value="finalBlow") @DefaultValue(value="{ any: true }") @ApiParam(name="finalBlow", required=false, defaultValue="{ any: true }", value="Kill attacker final blow selector") AttributeSelector finalBlow) {
        ServiceUtil.sanitizeAttributeSelector(at, killID, attackerCharacterID, allianceID, allianceName, attackerCharacterName, attackerCorporationID, attackerCorporationName, damageDone, factionID, factionName, securityStatus, shipTypeID, weaponTypeID, finalBlow);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_KILL_LOG);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = KillAttacker.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)killID, (AttributeSelector)attackerCharacterID, (AttributeSelector)allianceID, (AttributeSelector)allianceName, (AttributeSelector)attackerCharacterName, (AttributeSelector)attackerCorporationID, (AttributeSelector)attackerCorporationName, (AttributeSelector)damageDone, (AttributeSelector)factionID, (AttributeSelector)factionName, (AttributeSelector)securityStatus, (AttributeSelector)shipTypeID, (AttributeSelector)weaponTypeID, (AttributeSelector)finalBlow);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/kill_item")
    @GET
    @ApiOperation(value="Get kill items")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested kill items", response=KillItem.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getKillItems(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="killID") @DefaultValue(value="{ any: true }") @ApiParam(name="killID", required=false, defaultValue="{ any: true }", value="Kill ID selector") AttributeSelector killID, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", required=false, defaultValue="{ any: true }", value="Kill item type ID selector") AttributeSelector typeID, @QueryParam(value="flag") @DefaultValue(value="{ any: true }") @ApiParam(name="flag", required=false, defaultValue="{ any: true }", value="Kill item flag selector") AttributeSelector flag, @QueryParam(value="qtyDestroyed") @DefaultValue(value="{ any: true }") @ApiParam(name="qtyDestroyed", required=false, defaultValue="{ any: true }", value="Kill item quantity destroyed selector") AttributeSelector qtyDestroyed, @QueryParam(value="qtyDropped") @DefaultValue(value="{ any: true }") @ApiParam(name="qtyDropped", required=false, defaultValue="{ any: true }", value="Kill item quantity dropped selector") AttributeSelector qtyDropped, @QueryParam(value="singleton") @DefaultValue(value="{ any: true }") @ApiParam(name="singleton", required=false, defaultValue="{ any: true }", value="Kill item singleton selector") AttributeSelector singleton, @QueryParam(value="sequence") @DefaultValue(value="{ any: true }") @ApiParam(name="sequence", required=false, defaultValue="{ any: true }", value="Kill item sequence selector") AttributeSelector sequence, @QueryParam(value="containerSequence") @DefaultValue(value="{ any: true }") @ApiParam(name="containerSequence", required=false, defaultValue="{ any: true }", value="Kill item container sequence selector") AttributeSelector containerSequence) {
        ServiceUtil.sanitizeAttributeSelector(at, killID, typeID, flag, qtyDestroyed, qtyDropped, singleton, sequence, containerSequence);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_KILL_LOG);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = KillItem.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)killID, (AttributeSelector)typeID, (AttributeSelector)flag, (AttributeSelector)qtyDestroyed, (AttributeSelector)qtyDropped, (AttributeSelector)singleton, (AttributeSelector)sequence, (AttributeSelector)containerSequence);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/kill_victim")
    @GET
    @ApiOperation(value="Get kill victims")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested kill victims", response=KillVictim.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getKillVictims(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="killID") @DefaultValue(value="{ any: true }") @ApiParam(name="killID", required=false, defaultValue="{ any: true }", value="Kill ID selector") AttributeSelector killID, @QueryParam(value="allianceID") @DefaultValue(value="{ any: true }") @ApiParam(name="allianceID", required=false, defaultValue="{ any: true }", value="Kill victim alliance ID selector") AttributeSelector allianceID, @QueryParam(value="allianceName") @DefaultValue(value="{ any: true }") @ApiParam(name="allianceName", required=false, defaultValue="{ any: true }", value="Kill victim alliance name selector") AttributeSelector allianceName, @QueryParam(value="killCharacterID") @DefaultValue(value="{ any: true }") @ApiParam(name="killCharacterID", required=false, defaultValue="{ any: true }", value="Kill victim character ID selector") AttributeSelector killCharacterID, @QueryParam(value="killCharacterName") @DefaultValue(value="{ any: true }") @ApiParam(name="killCharacterName", required=false, defaultValue="{ any: true }", value="Kill victim character name selector") AttributeSelector killCharacterName, @QueryParam(value="killCorporationID") @DefaultValue(value="{ any: true }") @ApiParam(name="killCorporationID", required=false, defaultValue="{ any: true }", value="Kill victim corporation ID selector") AttributeSelector killCorporationID, @QueryParam(value="killCorporationName") @DefaultValue(value="{ any: true }") @ApiParam(name="killCorporationName", required=false, defaultValue="{ any: true }", value="Kill victim corporation name selector") AttributeSelector killCorporationName, @QueryParam(value="damageTaken") @DefaultValue(value="{ any: true }") @ApiParam(name="damageTaken", required=false, defaultValue="{ any: true }", value="Kill victim damage taken selector") AttributeSelector damageTaken, @QueryParam(value="factionID") @DefaultValue(value="{ any: true }") @ApiParam(name="factionID", required=false, defaultValue="{ any: true }", value="Kill victim faction ID selector") AttributeSelector factionID, @QueryParam(value="factionName") @DefaultValue(value="{ any: true }") @ApiParam(name="factionName", required=false, defaultValue="{ any: true }", value="Kill victim faction name selector") AttributeSelector factionName, @QueryParam(value="shipTypeID") @DefaultValue(value="{ any: true }") @ApiParam(name="shipTypeID", required=false, defaultValue="{ any: true }", value="Kill victim ship type ID selector") AttributeSelector shipTypeID) {
        ServiceUtil.sanitizeAttributeSelector(at, killID, allianceID, allianceName, killCharacterID, killCharacterName, killCorporationID, killCorporationName, damageTaken, factionID, factionName, shipTypeID);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_KILL_LOG);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = KillVictim.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)killID, (AttributeSelector)allianceID, (AttributeSelector)allianceName, (AttributeSelector)killCharacterID, (AttributeSelector)killCharacterName, (AttributeSelector)killCorporationID, (AttributeSelector)killCorporationName, (AttributeSelector)damageTaken, (AttributeSelector)factionID, (AttributeSelector)factionName, (AttributeSelector)shipTypeID);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/location")
    @GET
    @ApiOperation(value="Get locations")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested locations", response=Location.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getLocations(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="itemID") @DefaultValue(value="{ any: true }") @ApiParam(name="itemID", required=false, defaultValue="{ any: true }", value="Location item ID selector") AttributeSelector itemID, @QueryParam(value="itemName") @DefaultValue(value="{ any: true }") @ApiParam(name="itemName", required=false, defaultValue="{ any: true }", value="Location item name selector") AttributeSelector itemName, @QueryParam(value="x") @DefaultValue(value="{ any: true }") @ApiParam(name="x", required=false, defaultValue="{ any: true }", value="Location X position selector") AttributeSelector x, @QueryParam(value="y") @DefaultValue(value="{ any: true }") @ApiParam(name="y", required=false, defaultValue="{ any: true }", value="Location Y position selector") AttributeSelector y, @QueryParam(value="z") @DefaultValue(value="{ any: true }") @ApiParam(name="z", required=false, defaultValue="{ any: true }", value="Location Z position selector") AttributeSelector z) {
        ServiceUtil.sanitizeAttributeSelector(at, itemID, itemName, x, y, z);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_LOCATIONS);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = Location.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)itemID, (AttributeSelector)itemName, (AttributeSelector)x, (AttributeSelector)y, (AttributeSelector)z);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/market_order")
    @GET
    @ApiOperation(value="Get market orders")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested market orders", response=MarketOrder.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getMarketOrders(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="orderID") @DefaultValue(value="{ any: true }") @ApiParam(name="orderID", required=false, defaultValue="{ any: true }", value="Market order ID selector") AttributeSelector orderID, @QueryParam(value="accountKey") @DefaultValue(value="{ any: true }") @ApiParam(name="accountKey", required=false, defaultValue="{ any: true }", value="Market order account key selector") AttributeSelector accountKey, @QueryParam(value="bid") @DefaultValue(value="{ any: true }") @ApiParam(name="bid", required=false, defaultValue="{ any: true }", value="Market order bid indicator selector") AttributeSelector bid, @QueryParam(value="charID") @DefaultValue(value="{ any: true }") @ApiParam(name="charID", required=false, defaultValue="{ any: true }", value="Market order character ID selector") AttributeSelector charID, @QueryParam(value="duration") @DefaultValue(value="{ any: true }") @ApiParam(name="duration", required=false, defaultValue="{ any: true }", value="Market order duration selector") AttributeSelector duration, @QueryParam(value="escrow") @DefaultValue(value="{ any: true }") @ApiParam(name="escrow", required=false, defaultValue="{ any: true }", value="Market order escrow selector") AttributeSelector escrow, @QueryParam(value="issued") @DefaultValue(value="{ any: true }") @ApiParam(name="issued", required=false, defaultValue="{ any: true }", value="Market order issue date selector") AttributeSelector issued, @QueryParam(value="minVolume") @DefaultValue(value="{ any: true }") @ApiParam(name="minVolume", required=false, defaultValue="{ any: true }", value="Market order min volume selector") AttributeSelector minVolume, @QueryParam(value="orderState") @DefaultValue(value="{ any: true }") @ApiParam(name="orderState", required=false, defaultValue="{ any: true }", value="Market order state selector") AttributeSelector orderState, @QueryParam(value="price") @DefaultValue(value="{ any: true }") @ApiParam(name="price", required=false, defaultValue="{ any: true }", value="Market order price selector") AttributeSelector price, @QueryParam(value="orderRange") @DefaultValue(value="{ any: true }") @ApiParam(name="orderRange", required=false, defaultValue="{ any: true }", value="Market order range selector") AttributeSelector orderRange, @QueryParam(value="stationID") @DefaultValue(value="{ any: true }") @ApiParam(name="stationID", required=false, defaultValue="{ any: true }", value="Market order station ID selector") AttributeSelector stationID, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", required=false, defaultValue="{ any: true }", value="Market order type ID selector") AttributeSelector typeID, @QueryParam(value="volEntered") @DefaultValue(value="{ any: true }") @ApiParam(name="volEntered", required=false, defaultValue="{ any: true }", value="Market order volume entered selector") AttributeSelector volEntered, @QueryParam(value="volRemaining") @DefaultValue(value="{ any: true }") @ApiParam(name="volRemaining", required=false, defaultValue="{ any: true }", value="Market order volume remaining selector") AttributeSelector volRemaining) {
        ServiceUtil.sanitizeAttributeSelector(at, orderID, accountKey, bid, charID, duration, escrow, issued, minVolume, orderState, price, orderRange, stationID, typeID, volEntered, volRemaining);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_MARKET_ORDERS);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = MarketOrder.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)orderID, (AttributeSelector)accountKey, (AttributeSelector)bid, (AttributeSelector)charID, (AttributeSelector)duration, (AttributeSelector)escrow, (AttributeSelector)issued, (AttributeSelector)minVolume, (AttributeSelector)orderState, (AttributeSelector)price, (AttributeSelector)orderRange, (AttributeSelector)stationID, (AttributeSelector)typeID, (AttributeSelector)volEntered, (AttributeSelector)volRemaining);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/standing")
    @GET
    @ApiOperation(value="Get standings)")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested standings", response=Standing.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getStandings(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="standingEntity") @DefaultValue(value="{ any: true }") @ApiParam(name="standingEntity", required=false, defaultValue="{ any: true }", value="Standing entity selector") AttributeSelector standingEntity, @QueryParam(value="fromID") @DefaultValue(value="{ any: true }") @ApiParam(name="fromID", required=false, defaultValue="{ any: true }", value="Standing from ID selector") AttributeSelector fromID, @QueryParam(value="fromName") @DefaultValue(value="{ any: true }") @ApiParam(name="fromName", required=false, defaultValue="{ any: true }", value="Standing from name selector") AttributeSelector fromName, @QueryParam(value="standing") @DefaultValue(value="{ any: true }") @ApiParam(name="standing", required=false, defaultValue="{ any: true }", value="Standing value selector") AttributeSelector standing) {
        ServiceUtil.sanitizeAttributeSelector(at, standingEntity, fromID, fromName, standing);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_STANDINGS);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = Standing.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)standingEntity, (AttributeSelector)fromID, (AttributeSelector)fromName, (AttributeSelector)standing);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/wallet_journal")
    @GET
    @ApiOperation(value="Get wallet journal entries")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested wallet journal entries", response=WalletJournal.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getJournalEntries(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="accountKey") @DefaultValue(value="{ any: true }") @ApiParam(name="accountKey", required=false, defaultValue="{ any: true }", value="Wallet journal account key selector") AttributeSelector accountKey, @QueryParam(value="refID") @DefaultValue(value="{ any: true }") @ApiParam(name="refID", required=false, defaultValue="{ any: true }", value="Journal entry ref ID selector") AttributeSelector refID, @QueryParam(value="date") @DefaultValue(value="{ any: true }") @ApiParam(name="date", required=false, defaultValue="{ any: true }", value="Journal entry date selector") AttributeSelector date, @QueryParam(value="refTypeID") @DefaultValue(value="{ any: true }") @ApiParam(name="refTypeID", required=false, defaultValue="{ any: true }", value="Journal entry ref type ID selector") AttributeSelector refTypeID, @QueryParam(value="ownerName1") @DefaultValue(value="{ any: true }") @ApiParam(name="ownerName1", required=false, defaultValue="{ any: true }", value="Journal entry first owner name selector") AttributeSelector ownerName1, @QueryParam(value="ownerID1") @DefaultValue(value="{ any: true }") @ApiParam(name="ownerID1", required=false, defaultValue="{ any: true }", value="Journal entry first owner ID selector") AttributeSelector ownerID1, @QueryParam(value="ownerName2") @DefaultValue(value="{ any: true }") @ApiParam(name="ownerName2", required=false, defaultValue="{ any: true }", value="Journal entry second owner name selector") AttributeSelector ownerName2, @QueryParam(value="ownerID2") @DefaultValue(value="{ any: true }") @ApiParam(name="ownerID2", required=false, defaultValue="{ any: true }", value="Journal entry second owner ID selector") AttributeSelector ownerID2, @QueryParam(value="argName1") @DefaultValue(value="{ any: true }") @ApiParam(name="argName1", required=false, defaultValue="{ any: true }", value="Journal entry argument name selector") AttributeSelector argName1, @QueryParam(value="argID1") @DefaultValue(value="{ any: true }") @ApiParam(name="argID1", required=false, defaultValue="{ any: true }", value="Journal entry argument ID selector") AttributeSelector argID1, @QueryParam(value="amount") @DefaultValue(value="{ any: true }") @ApiParam(name="amount", required=false, defaultValue="{ any: true }", value="Journal entry amount selector") AttributeSelector amount, @QueryParam(value="balance") @DefaultValue(value="{ any: true }") @ApiParam(name="balance", required=false, defaultValue="{ any: true }", value="Journal entry balance selector") AttributeSelector balance, @QueryParam(value="reason") @DefaultValue(value="{ any: true }") @ApiParam(name="reason", required=false, defaultValue="{ any: true }", value="Journal entry reason selector") AttributeSelector reason, @QueryParam(value="taxReceiverID") @DefaultValue(value="{ any: true }") @ApiParam(name="taxReceiverID", required=false, defaultValue="{ any: true }", value="Journal entry tax receiver ID selector") AttributeSelector taxReceiverID, @QueryParam(value="taxAmount") @DefaultValue(value="{ any: true }") @ApiParam(name="taxAmount", required=false, defaultValue="{ any: true }", value="Journal entry tax amount selector") AttributeSelector taxAmount, @QueryParam(value="owner1TypeID") @DefaultValue(value="{ any: true }") @ApiParam(name="owner1TypeID", required=false, defaultValue="{ any: true }", value="First owner type ID selector") AttributeSelector owner1TypeID, @QueryParam(value="owner2TypeID") @DefaultValue(value="{ any: true }") @ApiParam(name="owner2TypeID", required=false, defaultValue="{ any: true }", value="Second owner type ID selector") AttributeSelector owner2TypeID) {
        ServiceUtil.sanitizeAttributeSelector(at, accountKey, refID, date, refTypeID, ownerName1, ownerID1, ownerName2, ownerID2, argName1, argID1, amount, balance, reason, taxReceiverID, taxAmount, owner1TypeID, owner2TypeID);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_WALLET_JOURNAL);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = WalletJournal.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)accountKey, (AttributeSelector)refID, (AttributeSelector)date, (AttributeSelector)refTypeID, (AttributeSelector)ownerName1, (AttributeSelector)ownerID1, (AttributeSelector)ownerName2, (AttributeSelector)ownerID2, (AttributeSelector)argName1, (AttributeSelector)argID1, (AttributeSelector)amount, (AttributeSelector)balance, (AttributeSelector)reason, (AttributeSelector)taxReceiverID, (AttributeSelector)taxAmount, (AttributeSelector)owner1TypeID, (AttributeSelector)owner2TypeID);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/wallet_transaction")
    @GET
    @ApiOperation(value="Get wallet transactions")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested wallet transactions", response=WalletTransaction.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getWalletTransactions(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="accountKey") @DefaultValue(value="{ any: true }") @ApiParam(name="accountKey", required=false, defaultValue="{ any: true }", value="Wallet account key selector") AttributeSelector accountKey, @QueryParam(value="transactionID") @DefaultValue(value="{ any: true }") @ApiParam(name="transactionID", required=false, defaultValue="{ any: true }", value="Transaction ID selector") AttributeSelector transactionID, @QueryParam(value="date") @DefaultValue(value="{ any: true }") @ApiParam(name="date", required=false, defaultValue="{ any: true }", value="Transaction date selector") AttributeSelector date, @QueryParam(value="quantity") @DefaultValue(value="{ any: true }") @ApiParam(name="quantity", required=false, defaultValue="{ any: true }", value="Transaction quantity selector") AttributeSelector quantity, @QueryParam(value="typeName") @DefaultValue(value="{ any: true }") @ApiParam(name="typeName", required=false, defaultValue="{ any: true }", value="Transaction type name selector") AttributeSelector typeName, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", required=false, defaultValue="{ any: true }", value="Transaction type ID selector") AttributeSelector typeID, @QueryParam(value="price") @DefaultValue(value="{ any: true }") @ApiParam(name="price", required=false, defaultValue="{ any: true }", value="Transaction price selector") AttributeSelector price, @QueryParam(value="clientID") @DefaultValue(value="{ any: true }") @ApiParam(name="clientID", required=false, defaultValue="{ any: true }", value="Transaction client ID selector") AttributeSelector clientID, @QueryParam(value="clientName") @DefaultValue(value="{ any: true }") @ApiParam(name="clientName", required=false, defaultValue="{ any: true }", value="Transaction client name selector") AttributeSelector clientName, @QueryParam(value="stationID") @DefaultValue(value="{ any: true }") @ApiParam(name="stationID", required=false, defaultValue="{ any: true }", value="Transaction station ID selector") AttributeSelector stationID, @QueryParam(value="stationName") @DefaultValue(value="{ any: true }") @ApiParam(name="stationName", required=false, defaultValue="{ any: true }", value="Transaction station name selector") AttributeSelector stationName, @QueryParam(value="transactionType") @DefaultValue(value="{ any: true }") @ApiParam(name="transactionType", required=false, defaultValue="{ any: true }", value="Transaction type selector") AttributeSelector transactionType, @QueryParam(value="transactionFor") @DefaultValue(value="{ any: true }") @ApiParam(name="transactionFor", required=false, defaultValue="{ any: true }", value="Transaction for selector") AttributeSelector transactionFor, @QueryParam(value="journalTransactionID") @DefaultValue(value="{ any: true }") @ApiParam(name="journalTransactionID", required=false, defaultValue="{ any: true }", value="Journal transaction ID selector") AttributeSelector journalTransactionID, @QueryParam(value="clientTypeID") @DefaultValue(value="{ any: true }") @ApiParam(name="clientTypeID", required=false, defaultValue="{ any: true }", value="Client type ID selector") AttributeSelector clientTypeID, @QueryParam(value="characterID") @DefaultValue(value="{ any: true }") @ApiParam(name="characterID", required=false, defaultValue="{ any: true }", value="Character ID selector") AttributeSelector characterID, @QueryParam(value="characterName") @DefaultValue(value="{ any: true }") @ApiParam(name="characterName", required=false, defaultValue="{ any: true }", value="Character name selector") AttributeSelector characterName) {
        ServiceUtil.sanitizeAttributeSelector(at, accountKey, transactionID, date, quantity, typeName, typeID, price, clientID, clientName, stationID, stationName, transactionType, transactionFor, journalTransactionID, clientTypeID, characterID, characterName);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_WALLET_TRANSACTIONS);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = WalletTransaction.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)accountKey, (AttributeSelector)transactionID, (AttributeSelector)date, (AttributeSelector)quantity, (AttributeSelector)typeName, (AttributeSelector)typeID, (AttributeSelector)price, (AttributeSelector)clientID, (AttributeSelector)clientName, (AttributeSelector)stationID, (AttributeSelector)stationName, (AttributeSelector)transactionType, (AttributeSelector)transactionFor, (AttributeSelector)journalTransactionID, (AttributeSelector)clientTypeID, (AttributeSelector)characterID, (AttributeSelector)characterName);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }
}

