/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.ws.common;

import enterprises.orbital.evekit.account.AccountAccessMask;
import enterprises.orbital.evekit.account.SynchronizedAccountAccessKey;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.CachedData;
import enterprises.orbital.evekit.model.MetaDataCountException;
import enterprises.orbital.evekit.model.MetaDataLimitException;
import enterprises.orbital.evekit.ws.ServiceError;
import enterprises.orbital.evekit.ws.ServiceUtil;
import enterprises.orbital.evekit.ws.common.MetaData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/ws/v1/meta")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(tags={"Meta"}, produces="application/json", consumes="application/json")
public class ModelMetaWS {
    protected static Response limitCheck(SynchronizedAccountAccessKey key, CachedData target) {
        long limit;
        if (key.getLimit() > 0L && (limit = key.getLimit()) >= target.getLifeEnd()) {
            ServiceError errMsg = new ServiceError(Response.Status.FORBIDDEN.getStatusCode(), "Access key not authorized to access the requested model object, contact key owner");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)errMsg).build();
        }
        return null;
    }

    @Path(value="/meta/{cid}/{key}")
    @GET
    @ApiOperation(value="Get meta data value.  A value of null indicates key was not set on this object.")
    @ApiResponses(value={@ApiResponse(code=200, message="Meta data pair for the given model object with the given key", response=MetaData.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key or model object not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getMetaDataValue(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @PathParam(value="cid") @ApiParam(name="cid", required=true, value="Model object ID") long cid, @PathParam(value="key") @ApiParam(name="key", required=true, value="Meta-data key") String key) {
        CachedData target = CachedData.get((long)cid);
        if (target == null) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "No model object found with the given ID");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        Collection masks = AccountAccessMask.createMaskSet((byte[])target.getAccessMask());
        AttributeSelector at = new AttributeSelector("{ any: true }");
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, masks);
        if (cfg.fail) {
            return cfg.response;
        }
        Response limitCheck = ModelMetaWS.limitCheck(cfg.key, target);
        if (limitCheck != null) {
            return limitCheck;
        }
        MetaData result = new MetaData(key, target.getMetaData(key));
        cfg.presetExpiry = Long.MIN_VALUE;
        return ServiceUtil.finish(cfg, result, request);
    }

    @Path(value="/meta/{cid}")
    @GET
    @ApiOperation(value="Get all meta data values for the given model object.")
    @ApiResponses(value={@ApiResponse(code=200, message="list of meta data values for the given model object", response=MetaData.class, responseContainer="array"), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key or model object not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getMetaDataValues(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @PathParam(value="cid") @ApiParam(name="cid", required=true, value="Model object ID") long cid) {
        CachedData target = CachedData.get((long)cid);
        if (target == null) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "No model object found with the given ID");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        Collection masks = AccountAccessMask.createMaskSet((byte[])target.getAccessMask());
        AttributeSelector at = new AttributeSelector("{ any: true }");
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, masks);
        if (cfg.fail) {
            return cfg.response;
        }
        Response limitCheck = ModelMetaWS.limitCheck(cfg.key, target);
        if (limitCheck != null) {
            return limitCheck;
        }
        ArrayList<MetaData> result = new ArrayList<MetaData>();
        for (Map.Entry datum : target.getAllMetaData()) {
            result.add(new MetaData((String)datum.getKey(), (String)datum.getValue()));
        }
        cfg.presetExpiry = Long.MIN_VALUE;
        return ServiceUtil.finish(cfg, result, request);
    }

    @Path(value="/meta/{cid}")
    @DELETE
    @ApiOperation(value="Delete all meta data values for the given model object.")
    @ApiResponses(value={@ApiResponse(code=200, message="data deleted successfully"), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key or model object not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response removeMetaDataValues(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @PathParam(value="cid") @ApiParam(name="cid", required=true, value="Model object ID") long cid) {
        CachedData target = CachedData.get((long)cid);
        if (target == null) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "No model object found with the given ID");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        Collection masks = AccountAccessMask.createMaskSet((byte[])target.getAccessMask());
        AttributeSelector at = new AttributeSelector("{ any: true }");
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, masks);
        if (cfg.fail) {
            return cfg.response;
        }
        Response limitCheck = ModelMetaWS.limitCheck(cfg.key, target);
        if (limitCheck != null) {
            return limitCheck;
        }
        for (Map.Entry datum : target.getAllMetaData()) {
            target.deleteMetaData((String)datum.getKey());
        }
        CachedData.updateData((CachedData)target);
        cfg.presetExpiry = Long.MIN_VALUE;
        return ServiceUtil.finish(cfg, null, request);
    }

    @Path(value="/meta/{cid}/{key}/{value}")
    @PUT
    @ApiOperation(value="Set meta data value.  If a value already exists for this key, then it is silently over-written.  Null keys or values are not allowed.")
    @ApiResponses(value={@ApiResponse(code=200, message="Meta data value set"), @ApiResponse(code=400, message="invalid key or value, or meta-data constraints exceeded", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key or model object not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response setMetaDataValue(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @PathParam(value="cid") @ApiParam(name="cid", required=true, value="Model object ID") long cid, @PathParam(value="key") @ApiParam(name="key", required=true, value="Meta-data key") String key, @PathParam(value="value") @ApiParam(name="value", required=true, value="Meta-data value") String value) {
        CachedData target = CachedData.get((long)cid);
        if (target == null) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "No model object found with the given ID");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        Collection masks = AccountAccessMask.createMaskSet((byte[])target.getAccessMask());
        AttributeSelector at = new AttributeSelector("{ any: true }");
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, masks);
        if (cfg.fail) {
            return cfg.response;
        }
        Response limitCheck = ModelMetaWS.limitCheck(cfg.key, target);
        if (limitCheck != null) {
            return limitCheck;
        }
        try {
            target.setMetaData(key, value);
            CachedData.updateData((CachedData)target);
        }
        catch (MetaDataCountException | MetaDataLimitException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
        cfg.presetExpiry = Long.MIN_VALUE;
        return ServiceUtil.finish(cfg, null, request);
    }

    @Path(value="/meta/{cid}/{key}")
    @DELETE
    @ApiOperation(value="Delete meta data value.")
    @ApiResponses(value={@ApiResponse(code=200, message="Meta value deleted"), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key or model object not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response removeMetaDataValue(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @PathParam(value="cid") @ApiParam(name="cid", required=true, value="Model object ID") long cid, @PathParam(value="key") @ApiParam(name="key", required=true, value="Meta-data key") String key) {
        CachedData target = CachedData.get((long)cid);
        if (target == null) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "No model object found with the given ID");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        Collection masks = AccountAccessMask.createMaskSet((byte[])target.getAccessMask());
        AttributeSelector at = new AttributeSelector("{ any: true }");
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, masks);
        if (cfg.fail) {
            return cfg.response;
        }
        Response limitCheck = ModelMetaWS.limitCheck(cfg.key, target);
        if (limitCheck != null) {
            return limitCheck;
        }
        target.deleteMetaData(key);
        CachedData.updateData((CachedData)target);
        cfg.presetExpiry = Long.MIN_VALUE;
        return ServiceUtil.finish(cfg, null, request);
    }
}

