/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.ws.character;

import enterprises.orbital.evekit.account.AccountAccessMask;
import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.CachedData;
import enterprises.orbital.evekit.model.character.CalendarEventAttendee;
import enterprises.orbital.evekit.model.character.Capsuleer;
import enterprises.orbital.evekit.model.character.CharacterContactNotification;
import enterprises.orbital.evekit.model.character.CharacterMailMessage;
import enterprises.orbital.evekit.model.character.CharacterMailMessageBody;
import enterprises.orbital.evekit.model.character.CharacterMedal;
import enterprises.orbital.evekit.model.character.CharacterNotification;
import enterprises.orbital.evekit.model.character.CharacterNotificationBody;
import enterprises.orbital.evekit.model.character.CharacterRole;
import enterprises.orbital.evekit.model.character.CharacterSheet;
import enterprises.orbital.evekit.model.character.CharacterSheetBalance;
import enterprises.orbital.evekit.model.character.CharacterSheetClone;
import enterprises.orbital.evekit.model.character.CharacterSheetJump;
import enterprises.orbital.evekit.model.character.CharacterSkill;
import enterprises.orbital.evekit.model.character.CharacterSkillInTraining;
import enterprises.orbital.evekit.model.character.CharacterTitle;
import enterprises.orbital.evekit.model.character.ChatChannel;
import enterprises.orbital.evekit.model.character.ChatChannelMember;
import enterprises.orbital.evekit.model.character.Implant;
import enterprises.orbital.evekit.model.character.JumpClone;
import enterprises.orbital.evekit.model.character.JumpCloneImplant;
import enterprises.orbital.evekit.model.character.MailingList;
import enterprises.orbital.evekit.model.character.PlanetaryColony;
import enterprises.orbital.evekit.model.character.PlanetaryLink;
import enterprises.orbital.evekit.model.character.PlanetaryPin;
import enterprises.orbital.evekit.model.character.PlanetaryRoute;
import enterprises.orbital.evekit.model.character.ResearchAgent;
import enterprises.orbital.evekit.model.character.SkillInQueue;
import enterprises.orbital.evekit.model.character.UpcomingCalendarEvent;
import enterprises.orbital.evekit.model.common.AccountStatus;
import enterprises.orbital.evekit.ws.ServiceError;
import enterprises.orbital.evekit.ws.ServiceUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/ws/v1/char")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(tags={"Character"}, produces="application/json", consumes="application/json")
public class ModelCharacterWS {
    @Path(value="/account_status")
    @GET
    @ApiOperation(value="Get account status(es)")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested account statuses", response=AccountStatus.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getAccountStatus(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="paidUntil") @DefaultValue(value="{ any: true }") @ApiParam(name="paidUntil", required=false, defaultValue="{ any: true }", value="Account status paid until selector") AttributeSelector paidUntil, @QueryParam(value="createDate") @DefaultValue(value="{ any: true }") @ApiParam(name="createDate", required=false, defaultValue="{ any: true }", value="Account status create date selector") AttributeSelector createDate, @QueryParam(value="logonCount") @DefaultValue(value="{ any: true }") @ApiParam(name="logonCount", required=false, defaultValue="{ any: true }", value="Account status logon count selector") AttributeSelector logonCount, @QueryParam(value="logonMinutes") @DefaultValue(value="{ any: true }") @ApiParam(name="logonMinutes", required=false, defaultValue="{ any: true }", value="Account status logon minutes selector") AttributeSelector logonMinutes, @QueryParam(value="multiCharacterTraining") @DefaultValue(value="{ any: true }") @ApiParam(name="multiCharacterTraining", required=false, defaultValue="{ any: true }", value="Account status multi-character training selector") AttributeSelector multiCharacterTraining) {
        ServiceUtil.sanitizeAttributeSelector(at, paidUntil, createDate, logonCount, logonMinutes, multiCharacterTraining);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_ACCOUNT_STATUS);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = AccountStatus.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)paidUntil, (AttributeSelector)createDate, (AttributeSelector)logonCount, (AttributeSelector)logonMinutes, (AttributeSelector)multiCharacterTraining);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/calendar_events")
    @GET
    @ApiOperation(value="Get upcoming calendar events")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested upcoming calendar events", response=UpcomingCalendarEvent.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getUpcomingCalendarEvents(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="duration") @DefaultValue(value="{ any: true }") @ApiParam(name="duration", required=false, defaultValue="{ any: true }", value="Event duration selector") AttributeSelector duration, @QueryParam(value="eventDate") @DefaultValue(value="{ any: true }") @ApiParam(name="eventDate", required=false, defaultValue="{ any: true }", value="Event date selector (milliseconds UTC)") AttributeSelector eventDate, @QueryParam(value="eventID") @DefaultValue(value="{ any: true }") @ApiParam(name="eventID", required=false, defaultValue="{ any: true }", value="Event ID selector") AttributeSelector eventID, @QueryParam(value="eventText") @DefaultValue(value="{ any: true }") @ApiParam(name="eventText", required=false, defaultValue="{ any: true }", value="Event text selector") AttributeSelector eventText, @QueryParam(value="eventTitle") @DefaultValue(value="{ any: true }") @ApiParam(name="eventTitle", required=false, defaultValue="{ any: true }", value="Event title selector") AttributeSelector eventTitle, @QueryParam(value="ownerID") @DefaultValue(value="{ any: true }") @ApiParam(name="ownerID", required=false, defaultValue="{ any: true }", value="Owner ID selector") AttributeSelector ownerID, @QueryParam(value="ownerName") @DefaultValue(value="{ any: true }") @ApiParam(name="ownerName", required=false, defaultValue="{ any: true }", value="Owner name selector") AttributeSelector ownerName, @QueryParam(value="response") @DefaultValue(value="{ any: true }") @ApiParam(name="response", required=false, defaultValue="{ any: true }", value="Response text selector") AttributeSelector response, @QueryParam(value="important") @DefaultValue(value="{ any: true }") @ApiParam(name="important", required=false, defaultValue="{ any: true }", value="Important flag selector") AttributeSelector important, @QueryParam(value="ownerTypeID") @DefaultValue(value="{ any: true }") @ApiParam(name="ownerTypeID", required=false, defaultValue="{ any: true }", value="Event owner type ID selector") AttributeSelector ownerTypeID) {
        ServiceUtil.sanitizeAttributeSelector(at, duration, eventDate, eventID, eventText, eventTitle, ownerID, ownerName, response, important, ownerTypeID);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_UPCOMING_CALENDAR_EVENTS);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = UpcomingCalendarEvent.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)duration, (AttributeSelector)eventDate, (AttributeSelector)eventID, (AttributeSelector)eventText, (AttributeSelector)eventTitle, (AttributeSelector)ownerID, (AttributeSelector)ownerName, (AttributeSelector)response, (AttributeSelector)important, (AttributeSelector)ownerTypeID);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/calendar_event_attendees")
    @GET
    @ApiOperation(value="Get calendar event attendees")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested calendar event attendees", response=CalendarEventAttendee.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getCalendarEventAttendees(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="eventID") @DefaultValue(value="{ any: true }") @ApiParam(name="eventID", required=false, defaultValue="{ any: true }", value="Calendar event ID selector") AttributeSelector eventID, @QueryParam(value="characterID") @DefaultValue(value="{ any: true }") @ApiParam(name="characterID", required=false, defaultValue="{ any: true }", value="Attending character ID selector") AttributeSelector characterID, @QueryParam(value="characterName") @DefaultValue(value="{ any: true }") @ApiParam(name="characterName", required=false, defaultValue="{ any: true }", value="Attending character name selector") AttributeSelector characterName, @QueryParam(value="response") @DefaultValue(value="{ any: true }") @ApiParam(name="response", required=false, defaultValue="{ any: true }", value="Attendee response selector") AttributeSelector response) {
        ServiceUtil.sanitizeAttributeSelector(at, eventID, characterID, characterName, response);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_CALENDAR_EVENT_ATTENDEES);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = CalendarEventAttendee.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)eventID, (AttributeSelector)characterID, (AttributeSelector)characterName, (AttributeSelector)response);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/role")
    @GET
    @ApiOperation(value="Get character roles")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested character roles", response=CharacterRole.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getRoles(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="roleCategory") @DefaultValue(value="{ any: true }") @ApiParam(name="roleCategory", required=false, defaultValue="{ any: true }", value="Role category selector") AttributeSelector roleCategory, @QueryParam(value="roleID") @DefaultValue(value="{ any: true }") @ApiParam(name="roleID", required=false, defaultValue="{ any: true }", value="Role ID selector") AttributeSelector roleID, @QueryParam(value="roleName") @DefaultValue(value="{ any: true }") @ApiParam(name="roleName", required=false, defaultValue="{ any: true }", value="Role name selector") AttributeSelector roleName) {
        ServiceUtil.sanitizeAttributeSelector(at, roleCategory, roleID, roleName);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_CHARACTER_SHEET);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = CharacterRole.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)roleCategory, (AttributeSelector)roleID, (AttributeSelector)roleName);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/sheet")
    @GET
    @ApiOperation(value="Get character sheet")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested character sheets", response=CharacterSheet.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getCharacterSheets(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="characterID") @DefaultValue(value="{ any: true }") @ApiParam(name="characterID", required=false, defaultValue="{ any: true }", value="Character ID selector") AttributeSelector characterID, @QueryParam(value="name") @DefaultValue(value="{ any: true }") @ApiParam(name="name", required=false, defaultValue="{ any: true }", value="Name selector") AttributeSelector name, @QueryParam(value="corporationID") @DefaultValue(value="{ any: true }") @ApiParam(name="corporationID", required=false, defaultValue="{ any: true }", value="Corporation ID selector") AttributeSelector corporationID, @QueryParam(value="corporationName") @DefaultValue(value="{ any: true }") @ApiParam(name="corporationName", required=false, defaultValue="{ any: true }", value="Corporation name selector") AttributeSelector corporationName, @QueryParam(value="race") @DefaultValue(value="{ any: true }") @ApiParam(name="race", required=false, defaultValue="{ any: true }", value="Race selector") AttributeSelector race, @QueryParam(value="doB") @DefaultValue(value="{ any: true }") @ApiParam(name="doB", required=false, defaultValue="{ any: true }", value="Date of birth selector") AttributeSelector doB, @QueryParam(value="bloodlineID") @DefaultValue(value="{ any: true }") @ApiParam(name="bloodlineID", required=false, defaultValue="{ any: true }", value="Bloodline ID selector") AttributeSelector bloodlineID, @QueryParam(value="bloodline") @DefaultValue(value="{ any: true }") @ApiParam(name="bloodline", required=false, defaultValue="{ any: true }", value="Bloodline selector") AttributeSelector bloodline, @QueryParam(value="ancestryID") @DefaultValue(value="{ any: true }") @ApiParam(name="ancestryID", required=false, defaultValue="{ any: true }", value="Ancestry ID selector") AttributeSelector ancestryID, @QueryParam(value="ancestry") @DefaultValue(value="{ any: true }") @ApiParam(name="ancestry", required=false, defaultValue="{ any: true }", value="Ancestry selector") AttributeSelector ancestry, @QueryParam(value="gender") @DefaultValue(value="{ any: true }") @ApiParam(name="gender", required=false, defaultValue="{ any: true }", value="Gender selector") AttributeSelector gender, @QueryParam(value="allianceName") @DefaultValue(value="{ any: true }") @ApiParam(name="allianceName", required=false, defaultValue="{ any: true }", value="Alliance name selector") AttributeSelector allianceName, @QueryParam(value="allianceID") @DefaultValue(value="{ any: true }") @ApiParam(name="allianceID", required=false, defaultValue="{ any: true }", value="Alliance ID selector") AttributeSelector allianceID, @QueryParam(value="factionName") @DefaultValue(value="{ any: true }") @ApiParam(name="factionName", required=false, defaultValue="{ any: true }", value="Faction name selector") AttributeSelector factionName, @QueryParam(value="factionID") @DefaultValue(value="{ any: true }") @ApiParam(name="factionID", required=false, defaultValue="{ any: true }", value="Faction ID selector") AttributeSelector factionID, @QueryParam(value="intelligence") @DefaultValue(value="{ any: true }") @ApiParam(name="intelligence", required=false, defaultValue="{ any: true }", value="Intelligence selector") AttributeSelector intelligence, @QueryParam(value="memory") @DefaultValue(value="{ any: true }") @ApiParam(name="memory", required=false, defaultValue="{ any: true }", value="Memory selector") AttributeSelector memory, @QueryParam(value="charisma") @DefaultValue(value="{ any: true }") @ApiParam(name="charisma", required=false, defaultValue="{ any: true }", value="Charisma selector") AttributeSelector charisma, @QueryParam(value="perception") @DefaultValue(value="{ any: true }") @ApiParam(name="perception", required=false, defaultValue="{ any: true }", value="Perception selector") AttributeSelector perception, @QueryParam(value="willpower") @DefaultValue(value="{ any: true }") @ApiParam(name="willpower", required=false, defaultValue="{ any: true }", value="Willpower selector") AttributeSelector willpower, @QueryParam(value="homeStationID") @DefaultValue(value="{ any: true }") @ApiParam(name="homeStationID", required=false, defaultValue="{ any: true }", value="Home station ID selector") AttributeSelector homeStationID, @QueryParam(value="lastRespecDate") @DefaultValue(value="{ any: true }") @ApiParam(name="lastRespecDate", required=false, defaultValue="{ any: true }", value="Last respec date selector") AttributeSelector lastRespecDate, @QueryParam(value="lastTimedRespec") @DefaultValue(value="{ any: true }") @ApiParam(name="lastTimedRespec", required=false, defaultValue="{ any: true }", value="Last timed respec selector") AttributeSelector lastTimedRespec, @QueryParam(value="freeRespecs") @DefaultValue(value="{ any: true }") @ApiParam(name="freeRespecs", required=false, defaultValue="{ any: true }", value="Free respecs selector") AttributeSelector freeRespecs, @QueryParam(value="freeSkillPoints") @DefaultValue(value="{ any: true }") @ApiParam(name="freeSkillPoints", required=false, defaultValue="{ any: true }", value="Free skill points selector") AttributeSelector freeSkillPoints, @QueryParam(value="remoteStationDate") @DefaultValue(value="{ any: true }") @ApiParam(name="remoteStationDate", required=false, defaultValue="{ any: true }", value="Remote station date selector") AttributeSelector remoteStationDate) {
        ServiceUtil.sanitizeAttributeSelector(at, characterID, name, corporationID, corporationName, race, doB, bloodlineID, bloodline, ancestryID, ancestry, gender, allianceName, allianceID, factionName, factionID, intelligence, memory, charisma, perception, willpower, homeStationID, lastRespecDate, lastTimedRespec, freeRespecs, freeSkillPoints, remoteStationDate);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_CHARACTER_SHEET);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = CharacterSheet.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)characterID, (AttributeSelector)name, (AttributeSelector)corporationID, (AttributeSelector)corporationName, (AttributeSelector)race, (AttributeSelector)doB, (AttributeSelector)bloodlineID, (AttributeSelector)bloodline, (AttributeSelector)ancestryID, (AttributeSelector)ancestry, (AttributeSelector)gender, (AttributeSelector)allianceName, (AttributeSelector)allianceID, (AttributeSelector)factionName, (AttributeSelector)factionID, (AttributeSelector)intelligence, (AttributeSelector)memory, (AttributeSelector)charisma, (AttributeSelector)perception, (AttributeSelector)willpower, (AttributeSelector)homeStationID, (AttributeSelector)lastRespecDate, (AttributeSelector)lastTimedRespec, (AttributeSelector)freeRespecs, (AttributeSelector)freeSkillPoints, (AttributeSelector)remoteStationDate);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/balance")
    @GET
    @ApiOperation(value="Get character sheet balance")
    @ApiResponses(value={@ApiResponse(code=200, message="list of character sheet balances", response=CharacterSheetBalance.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getBalances(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="balance") @DefaultValue(value="{ any: true }") @ApiParam(name="balance", required=false, defaultValue="{ any: true }", value="Balance selector") AttributeSelector balance) {
        ServiceUtil.sanitizeAttributeSelector(at, balance);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_CHARACTER_SHEET);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = CharacterSheetBalance.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)balance);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/clone_jump_timer")
    @GET
    @ApiOperation(value="Get character clone jump timers")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested clone jump timers", response=CharacterSheetClone.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getCloneJumpTimers(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="cloneJumpDate") @DefaultValue(value="{ any: true }") @ApiParam(name="cloneJumpDate", required=false, defaultValue="{ any: true }", value="Clone jump date selector") AttributeSelector cloneJumpDate) {
        ServiceUtil.sanitizeAttributeSelector(at, cloneJumpDate);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_CHARACTER_SHEET);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = CharacterSheetClone.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)cloneJumpDate);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/jump_timer")
    @GET
    @ApiOperation(value="Get character jump timers")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested character jump timers", response=CharacterSheetJump.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getJumpTimers(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="jumpActivation") @DefaultValue(value="{ any: true }") @ApiParam(name="jumpActivation", required=false, defaultValue="{ any: true }", value="Jump activation selector") AttributeSelector jumpActivation, @QueryParam(value="jumpFatigue") @DefaultValue(value="{ any: true }") @ApiParam(name="jumpFatigue", required=false, defaultValue="{ any: true }", value="Jump fatigue selector") AttributeSelector jumpFatigue, @QueryParam(value="jumpLastUpdate") @DefaultValue(value="{ any: true }") @ApiParam(name="jumpLastUpdate", required=false, defaultValue="{ any: true }", value="Jump last update time selector") AttributeSelector jumpLastUpdate) {
        ServiceUtil.sanitizeAttributeSelector(at, jumpActivation, jumpFatigue, jumpLastUpdate);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_CHARACTER_SHEET);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = CharacterSheetJump.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)jumpActivation, (AttributeSelector)jumpFatigue, (AttributeSelector)jumpLastUpdate);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/skill")
    @GET
    @ApiOperation(value="Get character skills")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested character skills", response=CharacterSkill.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getSkills(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", required=false, defaultValue="{ any: true }", value="Skill type ID selector") AttributeSelector typeID, @QueryParam(value="level") @DefaultValue(value="{ any: true }") @ApiParam(name="level", required=false, defaultValue="{ any: true }", value="Skill level selector") AttributeSelector level, @QueryParam(value="skillpoints") @DefaultValue(value="{ any: true }") @ApiParam(name="skillpoints", required=false, defaultValue="{ any: true }", value="Skill points selector") AttributeSelector skillpoints, @QueryParam(value="published") @DefaultValue(value="{ any: true }") @ApiParam(name="published", required=false, defaultValue="{ any: true }", value="Published skill selector") AttributeSelector published) {
        ServiceUtil.sanitizeAttributeSelector(at, typeID, level, skillpoints, published);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_CHARACTER_SHEET);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = CharacterSkill.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)typeID, (AttributeSelector)level, (AttributeSelector)skillpoints, (AttributeSelector)published);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/title")
    @GET
    @ApiOperation(value="Get character titles")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested character titles", response=CharacterTitle.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getTitles(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="titleID") @DefaultValue(value="{ any: true }") @ApiParam(name="titleID", required=false, defaultValue="{ any: true }", value="Character title ID selector") AttributeSelector titleID, @QueryParam(value="titleName") @DefaultValue(value="{ any: true }") @ApiParam(name="titleName", required=false, defaultValue="{ any: true }", value="Character title name selector") AttributeSelector titleName) {
        ServiceUtil.sanitizeAttributeSelector(at, titleID, titleName);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_CHARACTER_SHEET);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = CharacterTitle.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)titleID, (AttributeSelector)titleName);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/implant")
    @GET
    @ApiOperation(value="Get character implants")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested implants", response=Implant.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getImplants(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", required=false, defaultValue="{ any: true }", value="Implant type ID selector") AttributeSelector typeID, @QueryParam(value="typeName") @DefaultValue(value="{ any: true }") @ApiParam(name="typeName", required=false, defaultValue="{ any: true }", value="Implant type name selector") AttributeSelector typeName) {
        ServiceUtil.sanitizeAttributeSelector(at, typeID, typeName);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_CHARACTER_SHEET);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = Implant.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)typeID, (AttributeSelector)typeName);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/jump_clone")
    @GET
    @ApiOperation(value="Get character jump clones")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested jump clones", response=JumpClone.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getJumpClones(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="jumpCloneID") @DefaultValue(value="{ any: true }") @ApiParam(name="jumpCloneID", required=false, defaultValue="{ any: true }", value="Jump clone ID selector") AttributeSelector jumpCloneID, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", required=false, defaultValue="{ any: true }", value="Jump clone type ID selector") AttributeSelector typeID, @QueryParam(value="locationID") @DefaultValue(value="{ any: true }") @ApiParam(name="locationID", required=false, defaultValue="{ any: true }", value="Jump clone location ID selector") AttributeSelector locationID, @QueryParam(value="cloneName") @DefaultValue(value="{ any: true }") @ApiParam(name="cloneName", required=false, defaultValue="{ any: true }", value="Clone name selector selector") AttributeSelector cloneName) {
        ServiceUtil.sanitizeAttributeSelector(at, jumpCloneID, typeID, locationID, cloneName);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_CHARACTER_SHEET);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = JumpClone.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)jumpCloneID, (AttributeSelector)typeID, (AttributeSelector)locationID, (AttributeSelector)cloneName);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/jump_clone_implant")
    @GET
    @ApiOperation(value="Get character jump clone implants")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested jump clone implants", response=JumpCloneImplant.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getJumpCloneImplants(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="jumpCloneID") @DefaultValue(value="{ any: true }") @ApiParam(name="jumpCloneID", required=false, defaultValue="{ any: true }", value="Jump clone ID selector") AttributeSelector jumpCloneID, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", required=false, defaultValue="{ any: true }", value="Implant type ID selector") AttributeSelector typeID, @QueryParam(value="typeName") @DefaultValue(value="{ any: true }") @ApiParam(name="typeName", required=false, defaultValue="{ any: true }", value="Implant type name selector") AttributeSelector typeName) {
        ServiceUtil.sanitizeAttributeSelector(at, jumpCloneID, typeID, typeName);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_CHARACTER_SHEET);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = JumpCloneImplant.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)jumpCloneID, (AttributeSelector)typeID, (AttributeSelector)typeName);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/medal")
    @GET
    @ApiOperation(value="Get character medals")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested character medals", response=CharacterMedal.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getMedals(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="description") @DefaultValue(value="{ any: true }") @ApiParam(name="description", required=false, defaultValue="{ any: true }", value="Medal description selector") AttributeSelector description, @QueryParam(value="medalID") @DefaultValue(value="{ any: true }") @ApiParam(name="medalID", required=false, defaultValue="{ any: true }", value="Medal ID selector") AttributeSelector medalID, @QueryParam(value="title") @DefaultValue(value="{ any: true }") @ApiParam(name="title", required=false, defaultValue="{ any: true }", value="Medal title selector") AttributeSelector title, @QueryParam(value="corporationID") @DefaultValue(value="{ any: true }") @ApiParam(name="corporationID", required=false, defaultValue="{ any: true }", value="Awarding corporation ID selector") AttributeSelector corporationID, @QueryParam(value="issued") @DefaultValue(value="{ any: true }") @ApiParam(name="issued", required=false, defaultValue="{ any: true }", value="Issue date selector") AttributeSelector issued, @QueryParam(value="issuerID") @DefaultValue(value="{ any: true }") @ApiParam(name="issuerID", required=false, defaultValue="{ any: true }", value="Issuer ID selector") AttributeSelector issuerID, @QueryParam(value="reason") @DefaultValue(value="{ any: true }") @ApiParam(name="reason", required=false, defaultValue="{ any: true }", value="Medal award reason selector") AttributeSelector reason, @QueryParam(value="status") @DefaultValue(value="{ any: true }") @ApiParam(name="status", required=false, defaultValue="{ any: true }", value="Medal status selector") AttributeSelector status) {
        ServiceUtil.sanitizeAttributeSelector(at, description, medalID, title, corporationID, issued, issuerID, reason, status);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_MEDALS);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = CharacterMedal.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)description, (AttributeSelector)medalID, (AttributeSelector)title, (AttributeSelector)corporationID, (AttributeSelector)issued, (AttributeSelector)issuerID, (AttributeSelector)reason, (AttributeSelector)status);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/notification")
    @GET
    @ApiOperation(value="Get character notifications (not bodies)")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested notifications (excludes bodies)", response=CharacterNotification.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getNotifications(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="notificationID") @DefaultValue(value="{ any: true }") @ApiParam(name="notificationID", required=false, defaultValue="{ any: true }", value="Notification ID selector") AttributeSelector notificationID, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", required=false, defaultValue="{ any: true }", value="Notification type ID selector") AttributeSelector typeID, @QueryParam(value="senderID") @DefaultValue(value="{ any: true }") @ApiParam(name="senderID", required=false, defaultValue="{ any: true }", value="Notification sender ID selector") AttributeSelector senderID, @QueryParam(value="sentDate") @DefaultValue(value="{ any: true }") @ApiParam(name="sentDate", required=false, defaultValue="{ any: true }", value="Notification send date selector") AttributeSelector sentDate, @QueryParam(value="msgRead") @DefaultValue(value="{ any: true }") @ApiParam(name="msgRead", required=false, defaultValue="{ any: true }", value="Notification read selector") AttributeSelector msgRead) {
        ServiceUtil.sanitizeAttributeSelector(at, notificationID, typeID, senderID, sentDate, msgRead);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_NOTIFICATIONS);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = CharacterNotification.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)notificationID, (AttributeSelector)typeID, (AttributeSelector)senderID, (AttributeSelector)sentDate, (AttributeSelector)msgRead);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/notification_body")
    @GET
    @ApiOperation(value="Get character notification bodies")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested notification bodies", response=CharacterNotificationBody.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getNotificationBodies(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="notificationID") @DefaultValue(value="{ any: true }") @ApiParam(name="notificationID", required=false, defaultValue="{ any: true }", value="Notification ID selector") AttributeSelector notificationID, @QueryParam(value="retrieved") @DefaultValue(value="{ any: true }") @ApiParam(name="retrieved", required=false, defaultValue="{ any: true }", value="Body retrieved selector") AttributeSelector retrieved, @QueryParam(value="text") @DefaultValue(value="{ any: true }") @ApiParam(name="text", required=false, defaultValue="{ any: true }", value="Notification text selector") AttributeSelector text, @QueryParam(value="missing") @DefaultValue(value="{ any: true }") @ApiParam(name="missing", required=false, defaultValue="{ any: true }", value="Notification missing selector") AttributeSelector missing) {
        ServiceUtil.sanitizeAttributeSelector(at, notificationID, retrieved, text, missing);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_NOTIFICATIONS);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = CharacterNotificationBody.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)notificationID, (AttributeSelector)retrieved, (AttributeSelector)text, (AttributeSelector)missing);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/channel")
    @GET
    @ApiOperation(value="Get character chat channels")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested chat channels", response=ChatChannel.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getChannels(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="channelID") @DefaultValue(value="{ any: true }") @ApiParam(name="channelID", required=false, defaultValue="{ any: true }", value="Channel ID selector") AttributeSelector channelID, @QueryParam(value="ownerID") @DefaultValue(value="{ any: true }") @ApiParam(name="ownerID", required=false, defaultValue="{ any: true }", value="Channel owner ID selector") AttributeSelector ownerID, @QueryParam(value="ownerName") @DefaultValue(value="{ any: true }") @ApiParam(name="ownerName", required=false, defaultValue="{ any: true }", value="Channel owner name selector") AttributeSelector ownerName, @QueryParam(value="displayName") @DefaultValue(value="{ any: true }") @ApiParam(name="displayName", required=false, defaultValue="{ any: true }", value="Channel display name selector") AttributeSelector displayName, @QueryParam(value="comparisonKey") @DefaultValue(value="{ any: true }") @ApiParam(name="comparisonKey", required=false, defaultValue="{ any: true }", value="Channel comparison key selector") AttributeSelector comparisonKey, @QueryParam(value="hasPassword") @DefaultValue(value="{ any: true }") @ApiParam(name="hasPassword", required=false, defaultValue="{ any: true }", value="Channel has password selector") AttributeSelector hasPassword, @QueryParam(value="motd") @DefaultValue(value="{ any: true }") @ApiParam(name="motd", required=false, defaultValue="{ any: true }", value="Channel Message of the Day selector") AttributeSelector motd) {
        ServiceUtil.sanitizeAttributeSelector(at, channelID, ownerID, ownerName, displayName, comparisonKey, hasPassword, motd);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_CHAT_CHANNELS);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = ChatChannel.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)channelID, (AttributeSelector)ownerID, (AttributeSelector)ownerName, (AttributeSelector)displayName, (AttributeSelector)comparisonKey, (AttributeSelector)hasPassword, (AttributeSelector)motd);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/channel_member")
    @GET
    @ApiOperation(value="Get chat channel members")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested chat channel members", response=ChatChannelMember.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getChannelMembers(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="channelID") @DefaultValue(value="{ any: true }") @ApiParam(name="channelID", required=false, defaultValue="{ any: true }", value="Channel ID selector") AttributeSelector channelID, @QueryParam(value="category") @DefaultValue(value="{ any: true }") @ApiParam(name="category", required=false, defaultValue="{ any: true }", value="Member category selector") AttributeSelector category, @QueryParam(value="accessorID") @DefaultValue(value="{ any: true }") @ApiParam(name="accessorID", required=false, defaultValue="{ any: true }", value="Member accessor ID selector") AttributeSelector accessorID, @QueryParam(value="accessorName") @DefaultValue(value="{ any: true }") @ApiParam(name="accessorName", required=false, defaultValue="{ any: true }", value="Member accessor name selector") AttributeSelector accessorName, @QueryParam(value="untilWhen") @DefaultValue(value="{ any: true }") @ApiParam(name="untilWhen", required=false, defaultValue="{ any: true }", value="Member restriction \"until when\" date selector") AttributeSelector untilWhen, @QueryParam(value="reason") @DefaultValue(value="{ any: true }") @ApiParam(name="reason", required=false, defaultValue="{ any: true }", value="Member restriction reason selector") AttributeSelector reason) {
        ServiceUtil.sanitizeAttributeSelector(at, channelID, category, accessorID, accessorName, untilWhen, reason);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_CHAT_CHANNELS);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = ChatChannelMember.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)channelID, (AttributeSelector)category, (AttributeSelector)accessorID, (AttributeSelector)accessorName, (AttributeSelector)untilWhen, (AttributeSelector)reason);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/contact_notification")
    @GET
    @ApiOperation(value="Get character contact notifications")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested character contact notifications", response=CharacterContactNotification.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getContactNotifications(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="notificationID") @DefaultValue(value="{ any: true }") @ApiParam(name="notificationID", required=false, defaultValue="{ any: true }", value="Notification ID selector") AttributeSelector notificationID, @QueryParam(value="senderID") @DefaultValue(value="{ any: true }") @ApiParam(name="senderID", required=false, defaultValue="{ any: true }", value="Contact notification sender ID selector") AttributeSelector senderID, @QueryParam(value="senderName") @DefaultValue(value="{ any: true }") @ApiParam(name="senderName", required=false, defaultValue="{ any: true }", value="Contact notification sender name selector") AttributeSelector senderName, @QueryParam(value="sentDate") @DefaultValue(value="{ any: true }") @ApiParam(name="sentDate", required=false, defaultValue="{ any: true }", value="Contact notification send date selector") AttributeSelector sentDate, @QueryParam(value="messageData") @DefaultValue(value="{ any: true }") @ApiParam(name="messageData", required=false, defaultValue="{ any: true }", value="Contact notification message data selector") AttributeSelector messageData) {
        ServiceUtil.sanitizeAttributeSelector(at, notificationID, senderID, senderName, sentDate, messageData);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_CONTACT_NOTIFICATIONS);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = CharacterContactNotification.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)notificationID, (AttributeSelector)senderID, (AttributeSelector)senderName, (AttributeSelector)sentDate, (AttributeSelector)messageData);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/mailing_list")
    @GET
    @ApiOperation(value="Get character mailing lists")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested character mailing lists", response=MailingList.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getMailingLists(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="displayName") @DefaultValue(value="{ any: true }") @ApiParam(name="displayName", required=false, defaultValue="{ any: true }", value="Mailing list display name selector") AttributeSelector displayName, @QueryParam(value="listID") @DefaultValue(value="{ any: true }") @ApiParam(name="listID", required=false, defaultValue="{ any: true }", value="Mailing list ID selector") AttributeSelector listID) {
        ServiceUtil.sanitizeAttributeSelector(at, displayName, listID);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_MAILING_LISTS);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = MailingList.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)displayName, (AttributeSelector)listID);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/mail_message")
    @GET
    @ApiOperation(value="Get character mail messages (not bodies)")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested character mail messages (not bodies)", response=CharacterMailMessage.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getMailMessages(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="messageID") @DefaultValue(value="{ any: true }") @ApiParam(name="messageID", required=false, defaultValue="{ any: true }", value="Message ID selector") AttributeSelector messageID, @QueryParam(value="senderID") @DefaultValue(value="{ any: true }") @ApiParam(name="senderID", required=false, defaultValue="{ any: true }", value="Message sender ID selector") AttributeSelector senderID, @QueryParam(value="senderName") @DefaultValue(value="{ any: true }") @ApiParam(name="senderName", required=false, defaultValue="{ any: true }", value="Message sender name selector") AttributeSelector senderName, @QueryParam(value="toCharacterID") @DefaultValue(value="{ any: true }") @ApiParam(name="toCharacterID", required=false, defaultValue="{ any: true }", value="Message destination character ID selector") AttributeSelector toCharacterID, @QueryParam(value="sentDate") @DefaultValue(value="{ any: true }") @ApiParam(name="sentDate", required=false, defaultValue="{ any: true }", value="Message send date selector") AttributeSelector sentDate, @QueryParam(value="title") @DefaultValue(value="{ any: true }") @ApiParam(name="title", required=false, defaultValue="{ any: true }", value="Message title selector") AttributeSelector title, @QueryParam(value="toCorpOrAllianceID") @DefaultValue(value="{ any: true }") @ApiParam(name="toCorpOrAllianceID", required=false, defaultValue="{ any: true }", value="Message corporation or alliance ID selector") AttributeSelector toCorpOrAllianceID, @QueryParam(value="toListID") @DefaultValue(value="{ any: true }") @ApiParam(name="toListID", required=false, defaultValue="{ any: true }", value="Message destination list ID selector") AttributeSelector toListID, @QueryParam(value="msgRead") @DefaultValue(value="{ any: true }") @ApiParam(name="msgRead", required=false, defaultValue="{ any: true }", value="Message read selector") AttributeSelector msgRead, @QueryParam(value="senderTypeID") @DefaultValue(value="{ any: true }") @ApiParam(name="senderTypeID", required=false, defaultValue="{ any: true }", value="Message sender type ID selector") AttributeSelector senderTypeID) {
        ServiceUtil.sanitizeAttributeSelector(at, messageID, senderID, senderName, toCharacterID, sentDate, title, toCorpOrAllianceID, toListID, msgRead, senderTypeID);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_MAIL);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = CharacterMailMessage.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)messageID, (AttributeSelector)senderID, (AttributeSelector)senderName, (AttributeSelector)toCharacterID, (AttributeSelector)sentDate, (AttributeSelector)title, (AttributeSelector)toCorpOrAllianceID, (AttributeSelector)toListID, (AttributeSelector)msgRead, (AttributeSelector)senderTypeID);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/mail_message_body")
    @GET
    @ApiOperation(value="Get character mail message bodies")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested character mail message bodies", response=CharacterMailMessageBody.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getMailMessageBodies(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="messageID") @DefaultValue(value="{ any: true }") @ApiParam(name="messageID", required=false, defaultValue="{ any: true }", value="Mail message ID selector") AttributeSelector messageID, @QueryParam(value="retrieved") @DefaultValue(value="{ any: true }") @ApiParam(name="retrieved", required=false, defaultValue="{ any: true }", value="Mail message body retrieved selector") AttributeSelector retrieved, @QueryParam(value="body") @DefaultValue(value="{ any: true }") @ApiParam(name="body", required=false, defaultValue="{ any: true }", value="Mail message body selector") AttributeSelector body) {
        ServiceUtil.sanitizeAttributeSelector(at, messageID, retrieved, body);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_MAIL);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = CharacterMailMessageBody.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)messageID, (AttributeSelector)retrieved, (AttributeSelector)body);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/planetary_colony")
    @GET
    @ApiOperation(value="Get planetary colonies")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested planetary colonies", response=PlanetaryColony.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getPlanetaryColonies(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="planetID") @DefaultValue(value="{ any: true }") @ApiParam(name="planetID", required=false, defaultValue="{ any: true }", value="Planet ID selector") AttributeSelector planetID, @QueryParam(value="solarSystemID") @DefaultValue(value="{ any: true }") @ApiParam(name="solarSystemID", required=false, defaultValue="{ any: true }", value="Solar system ID selector") AttributeSelector solarSystemID, @QueryParam(value="solarSystemName") @DefaultValue(value="{ any: true }") @ApiParam(name="solarSystemName", required=false, defaultValue="{ any: true }", value="Solar system name selector") AttributeSelector solarSystemName, @QueryParam(value="planetName") @DefaultValue(value="{ any: true }") @ApiParam(name="planetName", required=false, defaultValue="{ any: true }", value="Planet name selector") AttributeSelector planetName, @QueryParam(value="planetTypeID") @DefaultValue(value="{ any: true }") @ApiParam(name="planetTypeID", required=false, defaultValue="{ any: true }", value="Planet type ID selector") AttributeSelector planetTypeID, @QueryParam(value="planetTypeName") @DefaultValue(value="{ any: true }") @ApiParam(name="planetTypeName", required=false, defaultValue="{ any: true }", value="Planet type name selector") AttributeSelector planetTypeName, @QueryParam(value="ownerID") @DefaultValue(value="{ any: true }") @ApiParam(name="ownerID", required=false, defaultValue="{ any: true }", value="Colony owner ID selector") AttributeSelector ownerID, @QueryParam(value="ownerName") @DefaultValue(value="{ any: true }") @ApiParam(name="ownerName", required=false, defaultValue="{ any: true }", value="Colony owner name selector") AttributeSelector ownerName, @QueryParam(value="lastUpdate") @DefaultValue(value="{ any: true }") @ApiParam(name="lastUpdate", required=false, defaultValue="{ any: true }", value="Colony last update selector") AttributeSelector lastUpdate, @QueryParam(value="upgradeLevel") @DefaultValue(value="{ any: true }") @ApiParam(name="upgradeLevel", required=false, defaultValue="{ any: true }", value="Colony upgrade level selector") AttributeSelector upgradeLevel, @QueryParam(value="numberOfPins") @DefaultValue(value="{ any: true }") @ApiParam(name="numberOfPins", required=false, defaultValue="{ any: true }", value="Colony number of pins selector") AttributeSelector numberOfPins) {
        ServiceUtil.sanitizeAttributeSelector(at, planetID, solarSystemID, solarSystemName, planetName, planetTypeID, planetTypeName, ownerID, ownerName, lastUpdate, upgradeLevel, numberOfPins);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_ASSETS);
        if (cfg.fail) {
            return cfg.response;
        }
        cfg.presetExpiry = Capsuleer.getCapsuleer((SynchronizedEveAccount)cfg.owner).getPlanetaryColoniesExpiry();
        try {
            List result = PlanetaryColony.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)planetID, (AttributeSelector)solarSystemID, (AttributeSelector)solarSystemName, (AttributeSelector)planetName, (AttributeSelector)planetTypeID, (AttributeSelector)planetTypeName, (AttributeSelector)ownerID, (AttributeSelector)ownerName, (AttributeSelector)lastUpdate, (AttributeSelector)upgradeLevel, (AttributeSelector)numberOfPins);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/planetary_link")
    @GET
    @ApiOperation(value="Get planetary links")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested planetary links", response=PlanetaryLink.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getPlanetaryLinks(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="planetID") @DefaultValue(value="{ any: true }") @ApiParam(name="planetID", required=false, defaultValue="{ any: true }", value="Planet ID selector") AttributeSelector planetID, @QueryParam(value="sourcePinID") @DefaultValue(value="{ any: true }") @ApiParam(name="sourcePinID", required=false, defaultValue="{ any: true }", value="Link source pin ID selector") AttributeSelector sourcePinID, @QueryParam(value="destinationPinID") @DefaultValue(value="{ any: true }") @ApiParam(name="destinationPinID", required=false, defaultValue="{ any: true }", value="Link destination pin ID selector") AttributeSelector destinationPinID, @QueryParam(value="linkLevel") @DefaultValue(value="{ any: true }") @ApiParam(name="linkLevel", required=false, defaultValue="{ any: true }", value="Link level selector") AttributeSelector linkLevel) {
        ServiceUtil.sanitizeAttributeSelector(at, planetID, sourcePinID, destinationPinID, linkLevel);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_ASSETS);
        if (cfg.fail) {
            return cfg.response;
        }
        cfg.presetExpiry = Capsuleer.getCapsuleer((SynchronizedEveAccount)cfg.owner).getPlanetaryColoniesExpiry();
        try {
            List result = PlanetaryLink.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)planetID, (AttributeSelector)sourcePinID, (AttributeSelector)destinationPinID, (AttributeSelector)linkLevel);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/planetary_pin")
    @GET
    @ApiOperation(value="Get planetary pins")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested planetary pins", response=PlanetaryPin.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getPlanetaryPins(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="planetID") @DefaultValue(value="{ any: true }") @ApiParam(name="planetID", required=false, defaultValue="{ any: true }", value="Planet ID selector") AttributeSelector planetID, @QueryParam(value="pinID") @DefaultValue(value="{ any: true }") @ApiParam(name="pinID", required=false, defaultValue="{ any: true }", value="Pin ID selector") AttributeSelector pinID, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", required=false, defaultValue="{ any: true }", value="Pin type ID selector") AttributeSelector typeID, @QueryParam(value="typeName") @DefaultValue(value="{ any: true }") @ApiParam(name="typeName", required=false, defaultValue="{ any: true }", value="Pin type name selector") AttributeSelector typeName, @QueryParam(value="schematicID") @DefaultValue(value="{ any: true }") @ApiParam(name="schematicID", required=false, defaultValue="{ any: true }", value="Pin schematic ID selector") AttributeSelector schematicID, @QueryParam(value="lastLaunchTime") @DefaultValue(value="{ any: true }") @ApiParam(name="lastLaunchTime", required=false, defaultValue="{ any: true }", value="Pin last launch time selector") AttributeSelector lastLaunchTime, @QueryParam(value="cycleTime") @DefaultValue(value="{ any: true }") @ApiParam(name="cycleTime", required=false, defaultValue="{ any: true }", value="Pin cycle time selector") AttributeSelector cycleTime, @QueryParam(value="quantityPerCycle") @DefaultValue(value="{ any: true }") @ApiParam(name="quantityPerCycle", required=false, defaultValue="{ any: true }", value="Pin quantity per cycle selector") AttributeSelector quantityPerCycle, @QueryParam(value="installTime") @DefaultValue(value="{ any: true }") @ApiParam(name="installTime", required=false, defaultValue="{ any: true }", value="Pin install time selector") AttributeSelector installTime, @QueryParam(value="expiryTime") @DefaultValue(value="{ any: true }") @ApiParam(name="expiryTime", required=false, defaultValue="{ any: true }", value="Pin expiry time selector") AttributeSelector expiryTime, @QueryParam(value="contentTypeID") @DefaultValue(value="{ any: true }") @ApiParam(name="contentTypeID", required=false, defaultValue="{ any: true }", value="Pin content type ID selector") AttributeSelector contentTypeID, @QueryParam(value="contentTypeName") @DefaultValue(value="{ any: true }") @ApiParam(name="contentTypeName", required=false, defaultValue="{ any: true }", value="Pin content type name selector") AttributeSelector contentTypeName, @QueryParam(value="contentQuantity") @DefaultValue(value="{ any: true }") @ApiParam(name="contentQuantity", required=false, defaultValue="{ any: true }", value="Pin content quantity selector") AttributeSelector contentQuantity, @QueryParam(value="longitude") @DefaultValue(value="{ any: true }") @ApiParam(name="longitude", required=false, defaultValue="{ any: true }", value="Pin longitude selector") AttributeSelector longitude, @QueryParam(value="latitude") @DefaultValue(value="{ any: true }") @ApiParam(name="latitude", required=false, defaultValue="{ any: true }", value="Pin latitude selector") AttributeSelector latitude) {
        ServiceUtil.sanitizeAttributeSelector(at, planetID, pinID, typeID, typeName, schematicID, lastLaunchTime, cycleTime, quantityPerCycle, installTime, expiryTime, contentTypeID, contentTypeName, contentQuantity, longitude, latitude);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_ASSETS);
        if (cfg.fail) {
            return cfg.response;
        }
        cfg.presetExpiry = Capsuleer.getCapsuleer((SynchronizedEveAccount)cfg.owner).getPlanetaryColoniesExpiry();
        try {
            List result = PlanetaryPin.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)planetID, (AttributeSelector)pinID, (AttributeSelector)typeID, (AttributeSelector)typeName, (AttributeSelector)schematicID, (AttributeSelector)lastLaunchTime, (AttributeSelector)cycleTime, (AttributeSelector)quantityPerCycle, (AttributeSelector)installTime, (AttributeSelector)expiryTime, (AttributeSelector)contentTypeID, (AttributeSelector)contentTypeName, (AttributeSelector)contentQuantity, (AttributeSelector)longitude, (AttributeSelector)latitude);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/planetary_route")
    @GET
    @ApiOperation(value="Get planetary routes")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested planetary routes", response=PlanetaryRoute.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getPlanetaryRoutes(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="planetID") @DefaultValue(value="{ any: true }") @ApiParam(name="planetID", required=false, defaultValue="{ any: true }", value="Planet ID selector") AttributeSelector planetID, @QueryParam(value="routeID") @DefaultValue(value="{ any: true }") @ApiParam(name="routeID", required=false, defaultValue="{ any: true }", value="Route ID selector") AttributeSelector routeID, @QueryParam(value="sourcePinID") @DefaultValue(value="{ any: true }") @ApiParam(name="sourcePinID", required=false, defaultValue="{ any: true }", value="Route source pin ID selector") AttributeSelector sourcePinID, @QueryParam(value="destinationPinID") @DefaultValue(value="{ any: true }") @ApiParam(name="destinationPinID", required=false, defaultValue="{ any: true }", value="Route destination pin ID selector") AttributeSelector destinationPinID, @QueryParam(value="contentTypeID") @DefaultValue(value="{ any: true }") @ApiParam(name="contentTypeID", required=false, defaultValue="{ any: true }", value="Route content type ID selector") AttributeSelector contentTypeID, @QueryParam(value="contentTypeName") @DefaultValue(value="{ any: true }") @ApiParam(name="contentTypeName", required=false, defaultValue="{ any: true }", value="Route content type name selector") AttributeSelector contentTypeName, @QueryParam(value="quantity") @DefaultValue(value="{ any: true }") @ApiParam(name="quantity", required=false, defaultValue="{ any: true }", value="Route quantity selector") AttributeSelector quantity, @QueryParam(value="waypoint1") @DefaultValue(value="{ any: true }") @ApiParam(name="waypoint1", required=false, defaultValue="{ any: true }", value="Route waypoint 1 selector") AttributeSelector waypoint1, @QueryParam(value="waypoint2") @DefaultValue(value="{ any: true }") @ApiParam(name="waypoint2", required=false, defaultValue="{ any: true }", value="Route waypoint 2 selector") AttributeSelector waypoint2, @QueryParam(value="waypoint3") @DefaultValue(value="{ any: true }") @ApiParam(name="waypoint3", required=false, defaultValue="{ any: true }", value="Route waypoint 3 selector") AttributeSelector waypoint3, @QueryParam(value="waypoint4") @DefaultValue(value="{ any: true }") @ApiParam(name="waypoint4", required=false, defaultValue="{ any: true }", value="Route waypoint 4 selector") AttributeSelector waypoint4, @QueryParam(value="waypoint5") @DefaultValue(value="{ any: true }") @ApiParam(name="waypoint5", required=false, defaultValue="{ any: true }", value="Route waypoint 5 selector") AttributeSelector waypoint5) {
        ServiceUtil.sanitizeAttributeSelector(at, planetID, routeID, sourcePinID, destinationPinID, contentTypeID, contentTypeName, quantity, waypoint1, waypoint2, waypoint3, waypoint4, waypoint5);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_ASSETS);
        if (cfg.fail) {
            return cfg.response;
        }
        cfg.presetExpiry = Capsuleer.getCapsuleer((SynchronizedEveAccount)cfg.owner).getPlanetaryColoniesExpiry();
        try {
            List result = PlanetaryRoute.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)planetID, (AttributeSelector)routeID, (AttributeSelector)sourcePinID, (AttributeSelector)destinationPinID, (AttributeSelector)contentTypeID, (AttributeSelector)contentTypeName, (AttributeSelector)quantity, (AttributeSelector)waypoint1, (AttributeSelector)waypoint2, (AttributeSelector)waypoint3, (AttributeSelector)waypoint4, (AttributeSelector)waypoint5);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/research_agent")
    @GET
    @ApiOperation(value="Get character research agents")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested research agents", response=ResearchAgent.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getResearchAgents(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="agentID") @DefaultValue(value="{ any: true }") @ApiParam(name="agentID", required=false, defaultValue="{ any: true }", value="Research agent ID selector") AttributeSelector agentID, @QueryParam(value="currentPoints") @DefaultValue(value="{ any: true }") @ApiParam(name="currentPoints", required=false, defaultValue="{ any: true }", value="Agent current points selector") AttributeSelector currentPoints, @QueryParam(value="pointsPerDay") @DefaultValue(value="{ any: true }") @ApiParam(name="pointsPerDay", required=false, defaultValue="{ any: true }", value="Agent points per day selector") AttributeSelector pointsPerDay, @QueryParam(value="remainderPoints") @DefaultValue(value="{ any: true }") @ApiParam(name="remainderPoints", required=false, defaultValue="{ any: true }", value="Agent remainder points selector") AttributeSelector remainderPoints, @QueryParam(value="researchStartDate") @DefaultValue(value="{ any: true }") @ApiParam(name="researchStartDate", required=false, defaultValue="{ any: true }", value="Agent research start date selector") AttributeSelector researchStartDate, @QueryParam(value="skillTypeID") @DefaultValue(value="{ any: true }") @ApiParam(name="skillTypeID", required=false, defaultValue="{ any: true }", value="Agent skill type ID selector") AttributeSelector skillTypeID) {
        ServiceUtil.sanitizeAttributeSelector(at, agentID, currentPoints, pointsPerDay, remainderPoints, researchStartDate, skillTypeID);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_RESEARCH);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = ResearchAgent.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)agentID, (AttributeSelector)currentPoints, (AttributeSelector)pointsPerDay, (AttributeSelector)remainderPoints, (AttributeSelector)researchStartDate, (AttributeSelector)skillTypeID);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/skill_in_training")
    @GET
    @ApiOperation(value="Get character skill in training")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested skills in training", response=CharacterSkillInTraining.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getSkillsInTraining(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="skillInTraining") @DefaultValue(value="{ any: true }") @ApiParam(name="skillInTraining", required=false, defaultValue="{ any: true }", value="Skill in training selector") AttributeSelector skillInTraining, @QueryParam(value="currentTrainingQueueTime") @DefaultValue(value="{ any: true }") @ApiParam(name="currentTrainingQueueTime", required=false, defaultValue="{ any: true }", value="Current taining queue time selector") AttributeSelector currentTrainingQueueTime, @QueryParam(value="trainingStartTime") @DefaultValue(value="{ any: true }") @ApiParam(name="trainingStartTime", required=false, defaultValue="{ any: true }", value="Training start time selector") AttributeSelector trainingStartTime, @QueryParam(value="trainingEndTime") @DefaultValue(value="{ any: true }") @ApiParam(name="trainingEndTime", required=false, defaultValue="{ any: true }", value="Training end time selector") AttributeSelector trainingEndTime, @QueryParam(value="trainingStartSP") @DefaultValue(value="{ any: true }") @ApiParam(name="trainingStartSP", required=false, defaultValue="{ any: true }", value="Training start skill points selector") AttributeSelector trainingStartSP, @QueryParam(value="trainingDestinationSP") @DefaultValue(value="{ any: true }") @ApiParam(name="trainingDestinationSP", required=false, defaultValue="{ any: true }", value="Training destination skill points selector") AttributeSelector trainingDestinationSP, @QueryParam(value="trainingToLevel") @DefaultValue(value="{ any: true }") @ApiParam(name="trainingToLevel", required=false, defaultValue="{ any: true }", value="Training to level selector") AttributeSelector trainingToLevel, @QueryParam(value="skillTypeID") @DefaultValue(value="{ any: true }") @ApiParam(name="skillTypeID", required=false, defaultValue="{ any: true }", value="Skill type ID selector") AttributeSelector skillTypeID) {
        ServiceUtil.sanitizeAttributeSelector(at, skillInTraining, currentTrainingQueueTime, trainingStartTime, trainingEndTime, trainingStartSP, trainingDestinationSP, trainingToLevel, skillTypeID);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_SKILL_IN_TRAINING);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = CharacterSkillInTraining.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)skillInTraining, (AttributeSelector)currentTrainingQueueTime, (AttributeSelector)trainingStartTime, (AttributeSelector)trainingEndTime, (AttributeSelector)trainingStartSP, (AttributeSelector)trainingDestinationSP, (AttributeSelector)trainingToLevel, (AttributeSelector)skillTypeID);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }

    @Path(value="/skill_queue")
    @GET
    @ApiOperation(value="Get character skill queue")
    @ApiResponses(value={@ApiResponse(code=200, message="list of requested character skill queue entries", response=SkillInQueue.class, responseContainer="array"), @ApiResponse(code=400, message="invalid attribute selector", response=ServiceError.class), @ApiResponse(code=401, message="access key credential is invalid", response=ServiceError.class), @ApiResponse(code=403, message="access key not permitted to access the requested data, or not permitted to access the requested time in the model lifeline", response=ServiceError.class), @ApiResponse(code=404, message="access key not found", response=ServiceError.class), @ApiResponse(code=500, message="internal service error", response=ServiceError.class)})
    public Response getSkillsInQueue(@Context HttpServletRequest request, @QueryParam(value="accessKey") @ApiParam(name="accessKey", required=true, value="Model access key") int accessKey, @QueryParam(value="accessCred") @ApiParam(name="accessCred", required=true, value="Model access credential") String accessCred, @QueryParam(value="at") @DefaultValue(value="{ values: [ \"9223372036854775806\" ] }") @ApiParam(name="at", required=false, defaultValue="{ values: [ \"9223372036854775806\" ] }", value="Model lifeline selector (defaults to current live data)") AttributeSelector at, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Continuation ID for paged results") long contid, @QueryParam(value="maxresults") @DefaultValue(value="1000") @ApiParam(name="maxresults", required=false, defaultValue="1000", value="Maximum number of results to retrieve") int maxresults, @QueryParam(value="reverse") @DefaultValue(value="false") @ApiParam(name="reverse", required=false, defaultValue="false", value="If true, page backwards (results less than contid) with results in descending order (by cid)") boolean reverse, @QueryParam(value="endSP") @DefaultValue(value="{ any: true }") @ApiParam(name="endSP", required=false, defaultValue="{ any: true }", value="Skill ending skill points selector") AttributeSelector endSP, @QueryParam(value="endTime") @DefaultValue(value="{ any: true }") @ApiParam(name="endTime", required=false, defaultValue="{ any: true }", value="Skill training end time selector") AttributeSelector endTime, @QueryParam(value="level") @DefaultValue(value="{ any: true }") @ApiParam(name="level", required=false, defaultValue="{ any: true }", value="Skill training to level selector") AttributeSelector level, @QueryParam(value="queuePosition") @DefaultValue(value="{ any: true }") @ApiParam(name="queuePosition", required=false, defaultValue="{ any: true }", value="Queue position selector") AttributeSelector queuePosition, @QueryParam(value="startSP") @DefaultValue(value="{ any: true }") @ApiParam(name="startSP", required=false, defaultValue="{ any: true }", value="Starting skill points selector") AttributeSelector startSP, @QueryParam(value="startTime") @DefaultValue(value="{ any: true }") @ApiParam(name="startTime", required=false, defaultValue="{ any: true }", value="Training start time selector") AttributeSelector startTime, @QueryParam(value="typeID") @DefaultValue(value="{ any: true }") @ApiParam(name="typeID", required=false, defaultValue="{ any: true }", value="Skill type ID selector") AttributeSelector typeID) {
        ServiceUtil.sanitizeAttributeSelector(at, endSP, endTime, level, queuePosition, startSP, startTime, typeID);
        maxresults = Math.min(1000, maxresults);
        ServiceUtil.AccessConfig cfg = ServiceUtil.start(accessKey, accessCred, at, AccountAccessMask.ACCESS_SKILL_QUEUE);
        if (cfg.fail) {
            return cfg.response;
        }
        try {
            List result = SkillInQueue.accessQuery((SynchronizedEveAccount)cfg.owner, (long)contid, (int)maxresults, (boolean)reverse, (AttributeSelector)at, (AttributeSelector)endSP, (AttributeSelector)endTime, (AttributeSelector)level, (AttributeSelector)queuePosition, (AttributeSelector)startSP, (AttributeSelector)startTime, (AttributeSelector)typeID);
            for (CachedData next : result) {
                next.prepareDates();
            }
            return ServiceUtil.finish(cfg, result, request);
        }
        catch (NumberFormatException e) {
            ServiceError errMsg = new ServiceError(Response.Status.BAD_REQUEST.getStatusCode(), "An attribute selector contained an illegal value");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
    }
}

