/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import enterprises.orbital.base.OrbitalProperties;
import enterprises.orbital.evekit.account.EveKitRefDataProvider;
import enterprises.orbital.evekit.model.ESIRefSyncEndpoint;
import enterprises.orbital.evekit.model.ESISyncState;
import enterprises.orbital.evekit.model.TrackerNotFoundException;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.NoResultException;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TypedQuery;

@Entity
@Table(name="evekit_esi_ref_sync_tracker", indexes={@Index(name="scheduledIndex", columnList="scheduled"), @Index(name="syncStartIndex", columnList="syncStart"), @Index(name="syncEndIndex", columnList="syncEnd")})
@NamedQueries(value={@NamedQuery(name="ESIRefEndpointSyncTracker.get", query="SELECT c FROM ESIRefEndpointSyncTracker c where c.tid = :tid"), @NamedQuery(name="ESIRefEndpointSyncTracker.getUnfinished", query="SELECT c FROM ESIRefEndpointSyncTracker c where c.endpoint = :endpoint and c.syncEnd = -1"), @NamedQuery(name="ESIRefEndpointSyncTracker.getAllUnfinished", query="SELECT c FROM ESIRefEndpointSyncTracker c where c.syncEnd = -1"), @NamedQuery(name="ESIRefEndpointSyncTracker.getLastFinished", query="SELECT c FROM ESIRefEndpointSyncTracker c where c.endpoint = :endpoint and c.syncEnd <> -1 order by c.syncEnd desc"), @NamedQuery(name="ESIRefEndpointSyncTracker.getHistory", query="SELECT c FROM ESIRefEndpointSyncTracker c where c.syncEnd <> -1 and c.syncStart < :start order by c.syncStart desc")})
@ApiModel(description="ESI reference endpoint synchronization tracker")
public class ESIRefEndpointSyncTracker {
    private static final Logger log = Logger.getLogger(ESIRefEndpointSyncTracker.class.getName());
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ek_seq")
    @SequenceGenerator(name="ek_seq", initialValue=100000, allocationSize=10, sequenceName="account_sequence")
    @ApiModelProperty(value="Uniquer tracker ID")
    @JsonProperty(value="tid")
    protected long tid;
    @ApiModelProperty(value="endpoint")
    @JsonProperty(value="endpoint")
    @Enumerated(value=EnumType.STRING)
    protected ESIRefSyncEndpoint endpoint;
    @ApiModelProperty(value="Scheduled tracker start time (milliseconds UTC)")
    @JsonProperty(value="scheduled")
    protected long scheduled;
    @ApiModelProperty(value="Tracker start time (milliseconds UTC)")
    @JsonProperty(value="syncStart")
    protected long syncStart = -1L;
    @ApiModelProperty(value="Tracker end time (milliseconds UTC)")
    @JsonProperty(value="syncEnd")
    protected long syncEnd = -1L;
    @ApiModelProperty(value="status")
    @JsonProperty(value="status")
    private ESISyncState status = ESISyncState.NOT_PROCESSED;
    @ApiModelProperty(value="status detail message")
    @JsonProperty(value="detail")
    private String detail;

    public void setSyncStart(long syncStart) {
        this.syncStart = syncStart;
    }

    public void setSyncEnd(long syncEnd) {
        this.syncEnd = syncEnd;
    }

    public void setStatus(ESISyncState status) {
        this.status = status;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public long getTid() {
        return this.tid;
    }

    public ESIRefSyncEndpoint getEndpoint() {
        return this.endpoint;
    }

    public long getScheduled() {
        return this.scheduled;
    }

    public long getSyncStart() {
        return this.syncStart;
    }

    public long getSyncEnd() {
        return this.syncEnd;
    }

    public ESISyncState getStatus() {
        return this.status;
    }

    public String getDetail() {
        return this.detail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ESIRefEndpointSyncTracker that = (ESIRefEndpointSyncTracker)o;
        return this.tid == that.tid && this.scheduled == that.scheduled && this.syncStart == that.syncStart && this.syncEnd == that.syncEnd && this.endpoint == that.endpoint && this.status == that.status && Objects.equals(this.detail, that.detail);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tid, this.endpoint, this.scheduled, this.syncStart, this.syncEnd, this.status, this.detail});
    }

    public String toString() {
        return "ESIRefEndpointSyncTracker{tid=" + this.tid + ", endpoint=" + (Object)((Object)this.endpoint) + ", scheduled=" + this.scheduled + ", syncStart=" + this.syncStart + ", syncEnd=" + this.syncEnd + ", status=" + (Object)((Object)this.status) + ", detail='" + this.detail + '\'' + '}';
    }

    public boolean isRefreshed() {
        return this.status != ESISyncState.NOT_PROCESSED;
    }

    public static ESIRefEndpointSyncTracker finishTracker(ESIRefEndpointSyncTracker tracker) throws IOException {
        tracker.setSyncEnd(OrbitalProperties.getCurrentTime());
        return EveKitRefDataProvider.update(tracker);
    }

    public static ESIRefEndpointSyncTracker get(long tid) throws IOException, TrackerNotFoundException {
        try {
            return (ESIRefEndpointSyncTracker)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitRefDataProvider.getFactory().getEntityManager().createNamedQuery("ESIRefEndpointSyncTracker.get", ESIRefEndpointSyncTracker.class);
                getter.setParameter("tid", (Object)tid);
                try {
                    return (ESIRefEndpointSyncTracker)getter.getSingleResult();
                }
                catch (NoResultException e) {
                    throw new TrackerNotFoundException();
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e.getCause() instanceof TrackerNotFoundException) {
                throw (TrackerNotFoundException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static ESIRefEndpointSyncTracker getUnfinishedTracker(ESIRefSyncEndpoint endpoint) throws IOException, TrackerNotFoundException {
        try {
            return (ESIRefEndpointSyncTracker)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitRefDataProvider.getFactory().getEntityManager().createNamedQuery("ESIRefEndpointSyncTracker.getUnfinished", ESIRefEndpointSyncTracker.class);
                getter.setParameter("endpoint", (Object)endpoint);
                try {
                    return (ESIRefEndpointSyncTracker)getter.getSingleResult();
                }
                catch (NoResultException e) {
                    throw new TrackerNotFoundException();
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e.getCause() instanceof TrackerNotFoundException) {
                throw (TrackerNotFoundException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static ESIRefEndpointSyncTracker getOrCreateUnfinishedTracker(ESIRefSyncEndpoint endpoint, long scheduled) throws IOException {
        try {
            return (ESIRefEndpointSyncTracker)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                try {
                    return ESIRefEndpointSyncTracker.getUnfinishedTracker(endpoint);
                }
                catch (TrackerNotFoundException e) {
                    ESIRefEndpointSyncTracker tracker = new ESIRefEndpointSyncTracker();
                    tracker.endpoint = endpoint;
                    tracker.scheduled = scheduled;
                    return EveKitRefDataProvider.update(tracker);
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static ESIRefEndpointSyncTracker getLatestFinishedTracker(ESIRefSyncEndpoint endpoint) throws IOException, TrackerNotFoundException {
        try {
            return (ESIRefEndpointSyncTracker)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitRefDataProvider.getFactory().getEntityManager().createNamedQuery("ESIRefEndpointSyncTracker.getLastFinished", ESIRefEndpointSyncTracker.class);
                getter.setParameter("endpoint", (Object)endpoint);
                getter.setMaxResults(1);
                try {
                    return (ESIRefEndpointSyncTracker)getter.getSingleResult();
                }
                catch (NoResultException e) {
                    throw new TrackerNotFoundException();
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e.getCause() instanceof TrackerNotFoundException) {
                throw (TrackerNotFoundException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static List<ESIRefEndpointSyncTracker> getHistory(long contid, int maxResults) throws IOException {
        try {
            return (List)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitRefDataProvider.getFactory().getEntityManager().createNamedQuery("ESIRefEndpointSyncTracker.getHistory", ESIRefEndpointSyncTracker.class);
                getter.setParameter("start", (Object)(contid < 0L ? Long.MAX_VALUE : contid));
                getter.setMaxResults(maxResults);
                return getter.getResultList();
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static List<ESIRefEndpointSyncTracker> getAllUnfinishedTrackers() throws IOException {
        try {
            return (List)EveKitRefDataProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitRefDataProvider.getFactory().getEntityManager().createNamedQuery("ESIRefEndpointSyncTracker.getAllUnfinished", ESIRefEndpointSyncTracker.class);
                return getter.getResultList();
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }
}

