/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import enterprises.orbital.base.OrbitalProperties;
import enterprises.orbital.evekit.account.EveKitUserAccountProvider;
import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.ESISyncEndpoint;
import enterprises.orbital.evekit.model.ESISyncState;
import enterprises.orbital.evekit.model.TrackerNotFoundException;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.NoResultException;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TypedQuery;

@Entity
@Table(name="evekit_esi_sync_tracker", indexes={@Index(name="scheduledIndex", columnList="scheduled"), @Index(name="syncStartIndex", columnList="syncStart"), @Index(name="syncEndIndex", columnList="syncEnd")})
@NamedQueries(value={@NamedQuery(name="ESIEndpointSyncTracker.get", query="SELECT c FROM ESIEndpointSyncTracker c where c.tid = :tid"), @NamedQuery(name="ESIEndpointSyncTracker.getUnfinished", query="SELECT c FROM ESIEndpointSyncTracker c where c.account = :account and c.endpoint = :endpoint and c.syncEnd = -1"), @NamedQuery(name="ESIEndpointSyncTracker.getLastFinished", query="SELECT c FROM ESIEndpointSyncTracker c where c.account = :account and c.endpoint = :endpoint and c.syncEnd <> -1 order by c.syncEnd desc"), @NamedQuery(name="ESIEndpointSyncTracker.getHistory", query="SELECT c FROM ESIEndpointSyncTracker c where c.account = :account and c.endpoint = :endpoint and c.syncEnd <> -1 and c.syncStart < :start order by c.syncStart desc")})
@ApiModel(description="ESI endpoint synchronization tracker")
public class ESIEndpointSyncTracker {
    private static final Logger log = Logger.getLogger(ESIEndpointSyncTracker.class.getName());
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ek_seq")
    @SequenceGenerator(name="ek_seq", initialValue=100000, allocationSize=10, sequenceName="account_sequence")
    @ApiModelProperty(value="Uniquer tracker ID")
    @JsonProperty(value="tid")
    protected long tid;
    @ManyToOne
    @JoinColumn(name="aid", referencedColumnName="aid")
    @JsonProperty(value="account")
    protected SynchronizedEveAccount account;
    @ApiModelProperty(value="endpoint")
    @JsonProperty(value="endpoint")
    @Enumerated(value=EnumType.STRING)
    protected ESISyncEndpoint endpoint;
    @ApiModelProperty(value="Scheduled tracker start time (milliseconds UTC)")
    @JsonProperty(value="scheduled")
    protected long scheduled;
    @ApiModelProperty(value="Tracker start time (milliseconds UTC)")
    @JsonProperty(value="syncStart")
    protected long syncStart = -1L;
    @ApiModelProperty(value="Tracker end time (milliseconds UTC)")
    @JsonProperty(value="syncEnd")
    protected long syncEnd = -1L;
    @ApiModelProperty(value="status")
    @JsonProperty(value="status")
    private ESISyncState status = ESISyncState.NOT_PROCESSED;
    @ApiModelProperty(value="status detail message")
    @JsonProperty(value="detail")
    private String detail;

    public void setSyncStart(long syncStart) {
        this.syncStart = syncStart;
    }

    public void setSyncEnd(long syncEnd) {
        this.syncEnd = syncEnd;
    }

    public void setStatus(ESISyncState status) {
        this.status = status;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public long getTid() {
        return this.tid;
    }

    public SynchronizedEveAccount getAccount() {
        return this.account;
    }

    public ESISyncEndpoint getEndpoint() {
        return this.endpoint;
    }

    public long getScheduled() {
        return this.scheduled;
    }

    public long getSyncStart() {
        return this.syncStart;
    }

    public long getSyncEnd() {
        return this.syncEnd;
    }

    public ESISyncState getStatus() {
        return this.status;
    }

    public String getDetail() {
        return this.detail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ESIEndpointSyncTracker that = (ESIEndpointSyncTracker)o;
        if (this.tid != that.tid) {
            return false;
        }
        if (this.scheduled != that.scheduled) {
            return false;
        }
        if (this.syncStart != that.syncStart) {
            return false;
        }
        if (this.syncEnd != that.syncEnd) {
            return false;
        }
        if (!this.account.equals(that.account)) {
            return false;
        }
        if (this.endpoint != that.endpoint) {
            return false;
        }
        if (this.status != that.status) {
            return false;
        }
        return this.detail != null ? this.detail.equals(that.detail) : that.detail == null;
    }

    public int hashCode() {
        int result = (int)(this.tid ^ this.tid >>> 32);
        result = 31 * result + this.account.hashCode();
        result = 31 * result + this.endpoint.hashCode();
        result = 31 * result + (int)(this.scheduled ^ this.scheduled >>> 32);
        return result;
    }

    public String toString() {
        return "ESIEndpointSyncTracker{tid=" + this.tid + ", account=" + this.account + ", endpoint=" + (Object)((Object)this.endpoint) + ", scheduled=" + this.scheduled + ", syncStart=" + this.syncStart + ", syncEnd=" + this.syncEnd + ", status=" + (Object)((Object)this.status) + ", detail='" + this.detail + '\'' + '}';
    }

    public static ESIEndpointSyncTracker finishTracker(ESIEndpointSyncTracker tracker) throws IOException {
        tracker.setSyncEnd(OrbitalProperties.getCurrentTime());
        return EveKitUserAccountProvider.update(tracker);
    }

    public static ESIEndpointSyncTracker get(long tid) throws IOException, TrackerNotFoundException {
        try {
            return (ESIEndpointSyncTracker)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery("ESIEndpointSyncTracker.get", ESIEndpointSyncTracker.class);
                getter.setParameter("tid", (Object)tid);
                try {
                    return (ESIEndpointSyncTracker)getter.getSingleResult();
                }
                catch (NoResultException e) {
                    throw new TrackerNotFoundException();
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e.getCause() instanceof TrackerNotFoundException) {
                throw (TrackerNotFoundException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static ESIEndpointSyncTracker getUnfinishedTracker(SynchronizedEveAccount account, ESISyncEndpoint endpoint) throws IOException, TrackerNotFoundException {
        try {
            return (ESIEndpointSyncTracker)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery("ESIEndpointSyncTracker.getUnfinished", ESIEndpointSyncTracker.class);
                getter.setParameter("account", (Object)account);
                getter.setParameter("endpoint", (Object)endpoint);
                try {
                    return (ESIEndpointSyncTracker)getter.getSingleResult();
                }
                catch (NoResultException e) {
                    throw new TrackerNotFoundException();
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e.getCause() instanceof TrackerNotFoundException) {
                throw (TrackerNotFoundException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static ESIEndpointSyncTracker getOrCreateUnfinishedTracker(SynchronizedEveAccount account, ESISyncEndpoint endpoint, long scheduled) throws IOException {
        try {
            return (ESIEndpointSyncTracker)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                try {
                    return ESIEndpointSyncTracker.getUnfinishedTracker(account, endpoint);
                }
                catch (TrackerNotFoundException e) {
                    ESIEndpointSyncTracker tracker = new ESIEndpointSyncTracker();
                    tracker.account = account;
                    tracker.endpoint = endpoint;
                    tracker.scheduled = scheduled;
                    return EveKitUserAccountProvider.update(tracker);
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static ESIEndpointSyncTracker getLatestFinishedTracker(SynchronizedEveAccount account, ESISyncEndpoint endpoint) throws IOException, TrackerNotFoundException {
        try {
            return (ESIEndpointSyncTracker)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery("ESIEndpointSyncTracker.getLastFinished", ESIEndpointSyncTracker.class);
                getter.setParameter("account", (Object)account);
                getter.setParameter("endpoint", (Object)endpoint);
                getter.setMaxResults(1);
                try {
                    return (ESIEndpointSyncTracker)getter.getSingleResult();
                }
                catch (NoResultException e) {
                    throw new TrackerNotFoundException();
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e.getCause() instanceof TrackerNotFoundException) {
                throw (TrackerNotFoundException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static List<ESIEndpointSyncTracker> getHistory(SynchronizedEveAccount account, ESISyncEndpoint endpoint, long contid, int maxResults) throws IOException {
        try {
            return (List)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery("ESIEndpointSyncTracker.getHistory", ESIEndpointSyncTracker.class);
                getter.setParameter("account", (Object)account);
                getter.setParameter("endpoint", (Object)endpoint);
                getter.setParameter("start", (Object)(contid < 0L ? Long.MAX_VALUE : contid));
                getter.setMaxResults(maxResults);
                return getter.getResultList();
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }
}

