/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model;

import com.google.gson.Gson;
import enterprises.orbital.evekit.model.AttributeParameters;
import java.util.HashSet;
import java.util.Set;

public class AttributeSelector {
    public boolean any;
    public String like;
    public Set<String> values = new HashSet<String>();
    public String start;
    public String end;
    public Long atStart;
    public Long atEnd;
    public String atStartIQ;
    public String atEndIQ;

    private AttributeSelector() {
    }

    public AttributeSelector(String json) {
        Gson gson = new Gson();
        AttributeSelector convert = (AttributeSelector)gson.fromJson(json, AttributeSelector.class);
        this.copy(convert);
    }

    public void copy(AttributeSelector other) {
        this.any = other.any;
        this.like = other.like;
        this.values.addAll(other.values);
        this.start = other.start;
        this.end = other.end;
    }

    public SelectorType type() {
        if (this.any) {
            return SelectorType.WILDCARD;
        }
        if (this.like != null) {
            return SelectorType.LIKE;
        }
        if (!this.values.isEmpty()) {
            return SelectorType.SET;
        }
        if (this.start != null && this.end != null) {
            return SelectorType.RANGE;
        }
        return SelectorType.WILDCARD;
    }

    public String getLikeValue() {
        return this.like;
    }

    public Set<String> getStringValues() {
        return this.values;
    }

    public Set<Long> getLongValues() {
        HashSet<Long> result = new HashSet<Long>();
        for (String next : this.values) {
            result.add(Long.parseLong(next));
        }
        return result;
    }

    public Set<Integer> getIntValues() {
        HashSet<Integer> result = new HashSet<Integer>();
        for (String next : this.values) {
            result.add(Integer.parseInt(next));
        }
        return result;
    }

    public Set<Double> getDoubleValues() {
        HashSet<Double> result = new HashSet<Double>();
        for (String next : this.values) {
            result.add(Double.parseDouble(next));
        }
        return result;
    }

    public Set<Float> getFloatValues() {
        HashSet<Float> result = new HashSet<Float>();
        for (String next : this.values) {
            result.add(Float.valueOf(Float.parseFloat(next)));
        }
        return result;
    }

    public String getStringStart() {
        return this.start;
    }

    public String getStringEnd() {
        return this.end;
    }

    public long getLongStart() {
        return Long.parseLong(this.start);
    }

    public long getLongEnd() {
        return Long.parseLong(this.end);
    }

    public int getIntStart() {
        return Integer.parseInt(this.start);
    }

    public int getIntEnd() {
        return Integer.parseInt(this.end);
    }

    public double getDoubleStart() {
        return Double.parseDouble(this.start);
    }

    public double getDoubleEnd() {
        return Double.parseDouble(this.end);
    }

    public float getFloatStart() {
        return Float.parseFloat(this.start);
    }

    public float getFloatEnd() {
        return Float.parseFloat(this.end);
    }

    public static void addLifelineSelector(StringBuilder builder, String target, AttributeSelector at) {
        switch (at.type()) {
            case SET: {
                builder.append(" AND (");
                for (long l : at.getLongValues()) {
                    builder.append("(").append(target).append(".lifeStart <= ").append(l).append(" AND ").append(target).append(".lifeEnd > ").append(l).append(") OR");
                }
                builder.setLength(builder.length() - 3);
                builder.append(")");
                break;
            }
            case RANGE: {
                long max = at.getLongEnd();
                long min = at.getLongStart();
                builder.append(" AND ").append(target).append(".lifeStart <= ").append(max);
                builder.append(" AND ").append(target).append(".lifeEnd > ").append(min);
                break;
            }
        }
    }

    public static void addIntSelector(StringBuilder builder, String target, String column, AttributeSelector as) {
        switch (as.type()) {
            case SET: {
                builder.append(" AND ").append(target).append(".").append(column).append(" IN (");
                for (int l : as.getIntValues()) {
                    builder.append(l).append(", ");
                }
                builder.setLength(builder.length() - 2);
                builder.append(")");
                break;
            }
            case RANGE: {
                builder.append(" AND ").append(target).append(".").append(column).append(" >= ").append(as.getIntStart()).append(" AND ").append(target).append(".").append(column).append(" <= ").append(as.getIntEnd());
                break;
            }
        }
    }

    public static void addLongSelector(StringBuilder builder, String target, String column, AttributeSelector as) {
        switch (as.type()) {
            case SET: {
                builder.append(" AND ").append(target).append(".").append(column).append(" IN (");
                for (long l : as.getLongValues()) {
                    builder.append(l).append(", ");
                }
                builder.setLength(builder.length() - 2);
                builder.append(")");
                break;
            }
            case RANGE: {
                builder.append(" AND ").append(target).append(".").append(column).append(" >= ").append(as.getLongStart()).append(" AND ").append(target).append(".").append(column).append(" <= ").append(as.getLongEnd());
                break;
            }
        }
    }

    public static void addDoubleSelector(StringBuilder builder, String target, String column, AttributeSelector as) {
        switch (as.type()) {
            case SET: {
                builder.append(" AND ").append(target).append(".").append(column).append(" IN (");
                for (double l : as.getDoubleValues()) {
                    builder.append(l).append(", ");
                }
                builder.setLength(builder.length() - 2);
                builder.append(")");
                break;
            }
            case RANGE: {
                builder.append(" AND ").append(target).append(".").append(column).append(" >= ").append(as.getDoubleStart()).append(" AND ").append(target).append(".").append(column).append(" <= ").append(as.getDoubleEnd());
                break;
            }
        }
    }

    public static void addFloatSelector(StringBuilder builder, String target, String column, AttributeSelector as) {
        switch (as.type()) {
            case SET: {
                builder.append(" AND ").append(target).append(".").append(column).append(" IN (");
                for (float l : as.getFloatValues()) {
                    builder.append(l).append(", ");
                }
                builder.setLength(builder.length() - 2);
                builder.append(")");
                break;
            }
            case RANGE: {
                builder.append(" AND ").append(target).append(".").append(column).append(" >= ").append(as.getFloatStart()).append(" AND ").append(target).append(".").append(column).append(" <= ").append(as.getFloatEnd());
                break;
            }
        }
    }

    public static void addStringSelector(StringBuilder builder, String target, String column, AttributeSelector as, AttributeParameters p) {
        switch (as.type()) {
            case SET: {
                builder.append(" AND ").append(target).append(".").append(column).append(" IN (");
                for (String l : as.getStringValues()) {
                    String next = ":" + p.addStringParam(l);
                    builder.append(next).append(", ");
                }
                builder.setLength(builder.length() - 2);
                builder.append(")");
                break;
            }
            case RANGE: {
                String minParam = ":" + p.addStringParam(as.getStringStart());
                String maxParam = ":" + p.addStringParam(as.getStringEnd());
                builder.append(" AND ").append(target).append(".").append(column).append(" >= ").append(minParam).append(" AND ").append(target).append(".").append(column).append(" <= ").append(maxParam);
                break;
            }
            case LIKE: {
                String likeParam = ":" + p.addStringParam(as.getLikeValue());
                builder.append(" AND ").append(target).append(".").append(column).append(" LIKE ").append(likeParam);
                break;
            }
        }
    }

    public static <A extends Enum<?>> void addEnumSelector(StringBuilder builder, String target, String column, AttributeSelector as, EnumMapper<A> mapper, AttributeParameters p) {
        switch (as.type()) {
            case SET: {
                builder.append(" AND ").append(target).append(".").append(column).append(" IN (");
                for (String l : as.getStringValues()) {
                    String next = ":" + p.addEnumParam((Enum<?>)mapper.mapEnumValue(l));
                    builder.append(next).append(", ");
                }
                builder.setLength(builder.length() - 2);
                builder.append(")");
                break;
            }
        }
    }

    public static void addBooleanSelector(StringBuilder builder, String target, String column, AttributeSelector as) {
        switch (as.type()) {
            case SET: {
                boolean value = Boolean.valueOf(as.getStringValues().iterator().next());
                builder.append(" AND ").append(target).append(".").append(column).append(" = ").append(value);
                break;
            }
        }
    }

    public static void addSetLongSelector(StringBuilder builder, String target, String column, AttributeSelector as) {
        switch (as.type()) {
            case SET: {
                builder.append(" AND SOME ELEMENTS(").append(target).append(".").append(column).append(") IN (");
                for (long next : as.getLongValues()) {
                    builder.append(next).append(", ");
                }
                builder.setLength(builder.length() - 2);
                builder.append(")");
                break;
            }
            case RANGE: {
                long min = as.getLongStart();
                long max = as.getLongEnd();
                builder.append(" AND SOME ELEMENTS(").append(target).append(".").append(column).append(") BETWEEN ").append(min).append(" AND ").append(max);
                break;
            }
        }
    }

    public static interface EnumMapper<A extends Enum<?>> {
        public A mapEnumValue(String var1);
    }

    public static enum SelectorType {
        WILDCARD,
        SET,
        RANGE,
        LIKE,
        AT;

    }
}

