/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.TypedQuery;

public class AttributeParameters {
    private String prefix;
    private int count = 0;
    private Map<String, String> stringParams = new HashMap<String, String>();
    private Map<String, Integer> integerParams = new HashMap<String, Integer>();
    private Map<String, Long> longParams = new HashMap<String, Long>();
    private Map<String, Enum<?>> enumParams = new HashMap();

    public AttributeParameters(String prefix) {
        this.prefix = prefix;
    }

    protected String getNextParam() {
        String next = this.prefix + this.count;
        ++this.count;
        return next;
    }

    public String addStringParam(String value) {
        String next = this.getNextParam();
        this.stringParams.put(next, value);
        return next;
    }

    public String addEnumParam(Enum<?> value) {
        String next = this.getNextParam();
        this.enumParams.put(next, value);
        return next;
    }

    public String addIntegerParam(int value) {
        String next = this.getNextParam();
        this.integerParams.put(next, value);
        return next;
    }

    public String addLongParam(long value) {
        String next = this.getNextParam();
        this.longParams.put(next, value);
        return next;
    }

    public void fillParams(TypedQuery<?> query) {
        for (Map.Entry<String, String> entry : this.stringParams.entrySet()) {
            query.setParameter(entry.getKey(), (Object)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.integerParams.entrySet()) {
            query.setParameter(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.longParams.entrySet()) {
            query.setParameter(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.longParams.entrySet()) {
            query.setParameter(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.enumParams.entrySet()) {
            query.setParameter(entry.getKey(), entry.getValue());
        }
    }
}

