/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.scribejava.core.model.OAuth2AccessToken;
import enterprises.orbital.base.OrbitalProperties;
import enterprises.orbital.evekit.account.AccountCreationException;
import enterprises.orbital.evekit.account.AccountNotFoundException;
import enterprises.orbital.evekit.account.AccountUpdateException;
import enterprises.orbital.evekit.account.EveKitUserAccount;
import enterprises.orbital.evekit.account.EveKitUserAccountProvider;
import enterprises.orbital.evekit.account.SynchronizedAccountAccessKey;
import enterprises.orbital.evekit.model.SyncTracker;
import enterprises.orbital.oauth.EVEAuthHandler;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.NoResultException;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.TypedQuery;

@Entity
@Table(name="evekit_sync_accounts", indexes={@Index(name="accountIndex", columnList="uid"), @Index(name="nameIndex", columnList="name"), @Index(name="autoIndex", columnList="autoSynchronized"), @Index(name="deleteableIndex", columnList="markedForDelete")})
@NamedQueries(value={@NamedQuery(name="SynchronizedEveAccount.findByAcctAndName", query="SELECT c FROM SynchronizedEveAccount c where c.userAccount = :account and c.name = :name and c.markedForDelete = -1"), @NamedQuery(name="SynchronizedEveAccount.findByAcctAndNameIncludeMarked", query="SELECT c FROM SynchronizedEveAccount c where c.userAccount = :account and c.name = :name"), @NamedQuery(name="SynchronizedEveAccount.findByAcctAndId", query="SELECT c FROM SynchronizedEveAccount c where c.userAccount = :account and c.aid = :aid and c.markedForDelete = -1"), @NamedQuery(name="SynchronizedEveAccount.findByAcctAndIdIncludeMarked", query="SELECT c FROM SynchronizedEveAccount c where c.userAccount = :account and c.aid = :aid"), @NamedQuery(name="SynchronizedEveAccount.findByAcct", query="SELECT c FROM SynchronizedEveAccount c where c.userAccount = :account and c.markedForDelete = -1"), @NamedQuery(name="SynchronizedEveAccount.findByAcctIncludeMarked", query="SELECT c FROM SynchronizedEveAccount c where c.userAccount = :account"), @NamedQuery(name="SynchronizedEveAccount.findAllMarkedForDelete", query="SELECT c FROM SynchronizedEveAccount c where c.markedForDelete > -1"), @NamedQuery(name="SynchronizedEveAccount.findAllAutoSync", query="SELECT c FROM SynchronizedEveAccount c where c.autoSynchronized = true and c.markedForDelete = -1"), @NamedQuery(name="SynchronizedEveAccount.findAllAutoSyncIncludeMarked", query="SELECT c FROM SynchronizedEveAccount c where c.autoSynchronized = true")})
@ApiModel(description="EveKit synchronized account")
public class SynchronizedEveAccount {
    private static final Logger log = Logger.getLogger(SynchronizedEveAccount.class.getName());
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ek_seq")
    @SequenceGenerator(name="ek_seq", initialValue=100000, allocationSize=10, sequenceName="account_sequence")
    @ApiModelProperty(value="Unique account ID")
    @JsonProperty(value="aid")
    protected long aid;
    @ManyToOne
    @JoinColumn(name="uid", referencedColumnName="uid")
    @JsonProperty(value="userAccount")
    private EveKitUserAccount userAccount;
    @ApiModelProperty(value="Date (milliseconds UTC) when this account was created")
    @JsonProperty(value="created")
    private long created = -1L;
    @ApiModelProperty(value="Account name")
    @JsonProperty(value="name")
    private String name;
    @ApiModelProperty(value="True if this is a character account, false for a corporation account")
    @JsonProperty(value="characterType")
    private boolean characterType;
    @ApiModelProperty(value="True if this account will auto-synchronize")
    @JsonProperty(value="autoSynchronized")
    private boolean autoSynchronized;
    @ApiModelProperty(value="Character ID to use for accessing the EVE XML API")
    @JsonProperty(value="eveCharacterID")
    private long eveCharacterID = -1L;
    @ApiModelProperty(value="Character name of character used for access")
    @JsonProperty(value="eveCharacterName")
    private String eveCharacterName;
    @ApiModelProperty(value="Corporation ID of character used for access")
    @JsonProperty(value="eveCorporationID")
    private long eveCorporationID = -1L;
    @ApiModelProperty(value="Corporation Name of character used for access")
    @JsonProperty(value="eveCorporationName")
    private String eveCorporationName;
    @Transient
    @ApiModelProperty(value="Date (milliseconds UTC) when this account was last synchronized")
    @JsonProperty(value="lastSynchronized")
    private long lastSynchronized = -1L;
    @ApiModelProperty(value="If greater than 0, then the date (milliseconds UTC) when this account was marked for deletion")
    @JsonProperty(value="markedForDelete")
    private long markedForDelete = -1L;
    @ApiModelProperty(value="EVE XML API access key")
    @JsonProperty(value="eveKey")
    private int eveKey = -1;
    @ApiModelProperty(value="EVE XML API access vcode")
    @JsonProperty(value="eveVCode")
    private String eveVCode;
    @Lob
    @Column(length=102400)
    @JsonProperty(value="scopes")
    private String scopes;
    private String accessToken;
    @JsonProperty(value="accessTokenExpiry")
    private long accessTokenExpiry = -1L;
    private String refreshToken;
    @Transient
    @ApiModelProperty(value="Valid")
    @JsonProperty(value="valid")
    private boolean valid;
    @Transient
    private Set<String> scopeSet;

    public SynchronizedEveAccount() {
    }

    public SynchronizedEveAccount(EveKitUserAccount user, String name, boolean ischar, boolean autoSynchronized) {
        this.userAccount = user;
        this.name = name;
        this.characterType = ischar;
        this.autoSynchronized = autoSynchronized;
    }

    public EveKitUserAccount getUserAccount() {
        return this.userAccount;
    }

    public long getAid() {
        return this.aid;
    }

    public long getCreated() {
        return this.created;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isCharacterType() {
        return this.characterType;
    }

    public boolean isAutoSynchronized() {
        return this.autoSynchronized;
    }

    public void setAutoSynchronized(boolean autoSynchronized) {
        this.autoSynchronized = autoSynchronized;
    }

    public long getEveCharacterID() {
        return this.eveCharacterID;
    }

    public String getEveCharacterName() {
        return this.eveCharacterName;
    }

    public long getEveCorporationID() {
        return this.eveCorporationID;
    }

    public String getEveCorporationName() {
        return this.eveCorporationName;
    }

    public long getLastSynchronized() {
        return this.lastSynchronized;
    }

    public void setLastSynchronized(long lastSynchronized) {
        this.lastSynchronized = lastSynchronized;
    }

    public long getMarkedForDelete() {
        return this.markedForDelete;
    }

    public void setMarkedForDelete(long markedForDelete) {
        this.markedForDelete = markedForDelete;
    }

    public int getEveKey() {
        return this.eveKey;
    }

    public String getEveVCode() {
        return this.eveVCode;
    }

    public String getScopes() {
        return this.scopes;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public long getAccessTokenExpiry() {
        return this.accessTokenExpiry;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public boolean isValid() {
        return this.valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasScope(String scopeName) {
        if (this.scopes == null) {
            return false;
        }
        if (this.scopeSet == null) {
            SynchronizedEveAccount synchronizedEveAccount = this;
            synchronized (synchronizedEveAccount) {
                if (this.scopeSet == null) {
                    this.scopeSet = new HashSet<String>();
                    for (String scopeEntry : this.scopes.split(" ")) {
                        this.scopeSet.add(scopeEntry);
                    }
                }
            }
        }
        return this.scopeSet.contains(scopeName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SynchronizedEveAccount that = (SynchronizedEveAccount)o;
        if (this.aid != that.aid) {
            return false;
        }
        if (this.created != that.created) {
            return false;
        }
        if (this.characterType != that.characterType) {
            return false;
        }
        return this.userAccount.equals(that.userAccount);
    }

    public int hashCode() {
        int result = (int)(this.aid ^ this.aid >>> 32);
        result = 31 * result + this.userAccount.hashCode();
        result = 31 * result + (int)(this.created ^ this.created >>> 32);
        result = 31 * result + (this.characterType ? 1 : 0);
        return result;
    }

    public String toString() {
        return "SynchronizedEveAccount{aid=" + this.aid + ", userAccount=" + this.userAccount + ", created=" + this.created + ", name='" + this.name + '\'' + ", characterType=" + this.characterType + ", autoSynchronized=" + this.autoSynchronized + ", eveCharacterID=" + this.eveCharacterID + ", eveCharacterName='" + this.eveCharacterName + '\'' + ", eveCorporationID=" + this.eveCorporationID + ", eveCorporationName='" + this.eveCorporationName + '\'' + ", lastSynchronized=" + this.lastSynchronized + ", markedForDelete=" + this.markedForDelete + ", eveKey=" + this.eveKey + ", eveVCode='" + this.eveVCode + '\'' + ", scopes='" + this.scopes + '\'' + ", accessToken='" + this.accessToken + '\'' + ", accessTokenExpiry=" + this.accessTokenExpiry + ", refreshToken='" + this.refreshToken + '\'' + ", valid=" + this.valid + '}';
    }

    public boolean hasXMLKey() {
        return this.eveKey != -1;
    }

    public boolean hasESIKey() {
        return this.accessToken != null;
    }

    public void updateValid() {
        this.valid = this.refreshToken != null && !this.refreshToken.isEmpty();
    }

    public static SynchronizedEveAccount createSynchronizedEveAccount(EveKitUserAccount userAccount, String name, boolean isChar, boolean autoSync) throws AccountCreationException, IOException {
        try {
            return (SynchronizedEveAccount)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                try {
                    SynchronizedEveAccount.getSynchronizedAccount(userAccount, name, true);
                    throw new AccountCreationException("Account with name " + String.valueOf(name) + " already exists");
                }
                catch (AccountNotFoundException e) {
                    SynchronizedEveAccount result = new SynchronizedEveAccount(userAccount, name, isChar, autoSync);
                    result.created = OrbitalProperties.getCurrentTime();
                    return (SynchronizedEveAccount)EveKitUserAccountProvider.getFactory().getEntityManager().merge((Object)result);
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof AccountCreationException) {
                throw (AccountCreationException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static SynchronizedEveAccount getSynchronizedAccount(EveKitUserAccount owner, String name, boolean includeMarkedForDelete) throws AccountNotFoundException, IOException {
        try {
            return (SynchronizedEveAccount)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery(includeMarkedForDelete ? "SynchronizedEveAccount.findByAcctAndNameIncludeMarked" : "SynchronizedEveAccount.findByAcctAndName", SynchronizedEveAccount.class);
                getter.setParameter("account", (Object)owner);
                getter.setParameter("name", (Object)name);
                try {
                    return (SynchronizedEveAccount)getter.getSingleResult();
                }
                catch (NoResultException e) {
                    throw new AccountNotFoundException();
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof AccountNotFoundException) {
                throw (AccountNotFoundException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static SynchronizedEveAccount getSynchronizedAccount(EveKitUserAccount owner, long id, boolean includeMarkedForDelete) throws AccountNotFoundException, IOException {
        try {
            return (SynchronizedEveAccount)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery(includeMarkedForDelete ? "SynchronizedEveAccount.findByAcctAndIdIncludeMarked" : "SynchronizedEveAccount.findByAcctAndId", SynchronizedEveAccount.class);
                getter.setParameter("account", (Object)owner);
                getter.setParameter("aid", (Object)id);
                try {
                    return (SynchronizedEveAccount)getter.getSingleResult();
                }
                catch (NoResultException e) {
                    throw new AccountNotFoundException();
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof AccountNotFoundException) {
                throw (AccountNotFoundException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static List<SynchronizedEveAccount> getAllAccounts(EveKitUserAccount owner, boolean includeMarkedForDelete) throws IOException {
        try {
            return (List)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery(includeMarkedForDelete ? "SynchronizedEveAccount.findByAcctIncludeMarked" : "SynchronizedEveAccount.findByAcct", SynchronizedEveAccount.class);
                getter.setParameter("account", (Object)owner);
                return getter.getResultList();
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static SynchronizedEveAccount deleteAccount(EveKitUserAccount owner, long id) throws AccountNotFoundException, IOException {
        try {
            return (SynchronizedEveAccount)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                SynchronizedEveAccount acct = SynchronizedEveAccount.getSynchronizedAccount(owner, id, false);
                if (acct == null) {
                    throw new AccountNotFoundException("Account not found for deletion: owner=" + String.valueOf(owner) + " id=" + id);
                }
                if (acct.getMarkedForDelete() > 0L) {
                    return acct;
                }
                acct.setMarkedForDelete(OrbitalProperties.getCurrentTime());
                return (SynchronizedEveAccount)EveKitUserAccountProvider.getFactory().getEntityManager().merge((Object)acct);
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof AccountNotFoundException) {
                throw (AccountNotFoundException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static SynchronizedEveAccount restoreAccount(EveKitUserAccount owner, long id) throws AccountNotFoundException, IOException {
        try {
            return (SynchronizedEveAccount)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                SynchronizedEveAccount acct = SynchronizedEveAccount.getSynchronizedAccount(owner, id, true);
                if (acct == null) {
                    throw new AccountNotFoundException("Account not found for restoring: owner=" + String.valueOf(owner) + " id=" + id);
                }
                acct.setMarkedForDelete(-1L);
                return (SynchronizedEveAccount)EveKitUserAccountProvider.getFactory().getEntityManager().merge((Object)acct);
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof AccountNotFoundException) {
                throw (AccountNotFoundException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static SynchronizedEveAccount updateAccount(EveKitUserAccount owner, long id, String name, boolean autoSync) throws AccountUpdateException, AccountNotFoundException, IOException {
        try {
            return (SynchronizedEveAccount)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                SynchronizedEveAccount result = SynchronizedEveAccount.getSynchronizedAccount(owner, id, false);
                if (result == null) {
                    throw new AccountNotFoundException("No account owned by " + String.valueOf(owner) + " with id: " + id);
                }
                if (!name.equals(result.getName())) {
                    try {
                        SynchronizedEveAccount.getSynchronizedAccount(owner, name, true);
                        throw new AccountUpdateException("Account with target name \"" + String.valueOf(name) + "\" already exists");
                    }
                    catch (AccountNotFoundException e) {
                        result.setName(name);
                    }
                }
                result.setAutoSynchronized(autoSync);
                return SynchronizedEveAccount.update(result);
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof AccountUpdateException) {
                throw (AccountUpdateException)e.getCause();
            }
            if (e.getCause() instanceof AccountNotFoundException) {
                throw (AccountNotFoundException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static SynchronizedEveAccount clearXMLCredential(EveKitUserAccount owner, long id) throws AccountNotFoundException, IOException {
        try {
            return (SynchronizedEveAccount)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                SynchronizedEveAccount result = SynchronizedEveAccount.getSynchronizedAccount(owner, id, false);
                if (result == null) {
                    throw new AccountNotFoundException("No account owned by " + String.valueOf(owner) + " with id: " + id);
                }
                result.eveKey = -1;
                result.eveVCode = null;
                if (!result.hasESIKey()) {
                    result.eveCharacterID = -1L;
                    result.eveCharacterName = null;
                    result.eveCorporationID = -1L;
                    result.eveCorporationName = null;
                }
                return SynchronizedEveAccount.update(result);
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof AccountNotFoundException) {
                throw (AccountNotFoundException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static SynchronizedEveAccount clearESICredential(EveKitUserAccount owner, long id) throws AccountNotFoundException, IOException {
        try {
            return (SynchronizedEveAccount)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                SynchronizedEveAccount result = SynchronizedEveAccount.getSynchronizedAccount(owner, id, false);
                if (result == null) {
                    throw new AccountNotFoundException("No account owned by " + String.valueOf(owner) + " with id: " + id);
                }
                result.accessToken = null;
                result.accessTokenExpiry = -1L;
                result.refreshToken = null;
                result.scopes = null;
                if (!result.hasXMLKey()) {
                    result.eveCharacterID = -1L;
                    result.eveCharacterName = null;
                    result.eveCorporationID = -1L;
                    result.eveCorporationName = null;
                }
                return SynchronizedEveAccount.update(result);
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof AccountNotFoundException) {
                throw (AccountNotFoundException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static SynchronizedEveAccount setXMLCredential(EveKitUserAccount owner, long id, int key, String vcode, long characterID, String characterName, long corporationID, String corporationName) throws AccountUpdateException, AccountNotFoundException, IOException {
        try {
            return (SynchronizedEveAccount)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                SynchronizedEveAccount result = SynchronizedEveAccount.getSynchronizedAccount(owner, id, false);
                if (result == null) {
                    throw new AccountNotFoundException("No account owned by " + String.valueOf(owner) + " with id: " + id);
                }
                if (!(!result.hasESIKey() && !result.hasXMLKey() || characterID == result.eveCharacterID && characterName.equals(result.eveCharacterName) && corporationID == result.eveCorporationID && corporationName.equals(result.eveCorporationName))) {
                    throw new AccountUpdateException("New char/corp information inconsistent with existing ESI credential");
                }
                result.eveKey = key;
                result.eveVCode = vcode;
                result.eveCharacterID = characterID;
                result.eveCharacterName = characterName;
                result.eveCorporationID = corporationID;
                result.eveCorporationName = corporationName;
                return SynchronizedEveAccount.update(result);
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof AccountUpdateException) {
                throw (AccountUpdateException)e.getCause();
            }
            if (e.getCause() instanceof AccountNotFoundException) {
                throw (AccountNotFoundException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static SynchronizedEveAccount setESICredential(EveKitUserAccount owner, long id, String accessToken, long accessTokenExpiry, String refreshToken, String scopes, long characterID, String characterName, long corporationID, String corporationName) throws AccountUpdateException, AccountNotFoundException, IOException {
        try {
            return (SynchronizedEveAccount)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                SynchronizedEveAccount result = SynchronizedEveAccount.getSynchronizedAccount(owner, id, false);
                if (result == null) {
                    throw new AccountNotFoundException("No account owned by " + String.valueOf(owner) + " with id: " + id);
                }
                if (!(!result.hasXMLKey() && !result.hasESIKey() || characterID == result.eveCharacterID && characterName.equals(result.eveCharacterName) && corporationID == result.eveCorporationID && corporationName.equals(result.eveCorporationName))) {
                    throw new AccountUpdateException("New char/corp information inconsistent with existing XML credential");
                }
                result.accessToken = accessToken;
                result.accessTokenExpiry = accessTokenExpiry;
                result.refreshToken = refreshToken;
                result.scopes = scopes;
                result.eveCharacterID = characterID;
                result.eveCharacterName = characterName;
                result.eveCorporationID = corporationID;
                result.eveCorporationName = corporationName;
                return SynchronizedEveAccount.update(result);
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof AccountUpdateException) {
                throw (AccountUpdateException)e.getCause();
            }
            if (e.getCause() instanceof AccountNotFoundException) {
                throw (AccountNotFoundException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static List<SynchronizedEveAccount> getAllAutoSyncAccounts(boolean includeMarkedForDelete) throws IOException {
        try {
            return (List)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery(includeMarkedForDelete ? "SynchronizedEveAccount.findAllAutoSyncIncludeMarked" : "SynchronizedEveAccount.findAllAutoSync", SynchronizedEveAccount.class);
                return getter.getResultList();
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static List<SynchronizedEveAccount> getAllMarkedForDelete() throws IOException {
        try {
            return (List)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery("SynchronizedEveAccount.findAllMarkedForDelete", SynchronizedEveAccount.class);
                return getter.getResultList();
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static void remove(SynchronizedEveAccount toRemove) throws IOException {
        try {
            long lastRemoved = 0L;
            while ((lastRemoved = ((Long)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                long removed = 0L;
                TypedQuery query = EveKitUserAccountProvider.getFactory().getEntityManager().createQuery("SELECT c FROM SyncTracker c where c.account = :account", SyncTracker.class);
                query.setParameter("account", (Object)toRemove);
                query.setMaxResults(1000);
                for (SyncTracker next : query.getResultList()) {
                    EveKitUserAccountProvider.getFactory().getEntityManager().remove((Object)next);
                    ++removed;
                }
                return removed;
            })).longValue()) > 0L) {
            }
            EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                TypedQuery query = EveKitUserAccountProvider.getFactory().getEntityManager().createQuery("SELECT c FROM SynchronizedAccountAccessKey c where c.account = :account", SynchronizedAccountAccessKey.class);
                query.setParameter("account", (Object)toRemove);
                for (SynchronizedAccountAccessKey next : query.getResultList()) {
                    EveKitUserAccountProvider.getFactory().getEntityManager().remove((Object)next);
                }
            });
            EveKitUserAccountProvider.getFactory().runTransaction(() -> EveKitUserAccountProvider.getFactory().getEntityManager().remove((Object)SynchronizedEveAccount.getSynchronizedAccount(toRemove.getUserAccount(), toRemove.getAid(), true)));
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static SynchronizedEveAccount update(SynchronizedEveAccount data) throws IOException {
        try {
            return (SynchronizedEveAccount)EveKitUserAccountProvider.getFactory().runTransaction(() -> (SynchronizedEveAccount)EveKitUserAccountProvider.getFactory().getEntityManager().merge((Object)data));
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public String refreshToken(long expiryWindow, String eveClientID, String eveSecretKey) throws IOException {
        SynchronizedEveAccount account = this;
        if (this.getAccessTokenExpiry() - OrbitalProperties.getCurrentTime() < expiryWindow) {
            String refreshToken = this.getRefreshToken();
            if (refreshToken == null) {
                throw new IOException("No valid refresh token for account: " + this.getAid());
            }
            OAuth2AccessToken newToken = EVEAuthHandler.doRefresh((String)eveClientID, (String)eveSecretKey, (String)refreshToken);
            if (newToken == null) {
                refreshToken = null;
                SynchronizedEveAccount.update(this);
                throw new IOException("Failed to refresh token for credential: " + this.getAid());
            }
            this.accessToken = newToken.getAccessToken();
            this.accessTokenExpiry = OrbitalProperties.getCurrentTime() + TimeUnit.MILLISECONDS.convert(newToken.getExpiresIn().intValue(), TimeUnit.SECONDS);
            refreshToken = newToken.getRefreshToken();
            account = SynchronizedEveAccount.update(account);
        }
        return account.getAccessToken();
    }
}

