/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.account;

import enterprises.orbital.base.OrbitalProperties;
import enterprises.orbital.base.Stamper;
import enterprises.orbital.evekit.account.EveKitUserAccount;
import enterprises.orbital.evekit.account.EveKitUserAccountProvider;
import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.NoResultException;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TypedQuery;

@Entity
@Table(name="esi_temp_token", indexes={@Index(name="keyIndex", columnList="kid", unique=true), @Index(name="credIndex", columnList="stateKey", unique=true)})
@NamedQueries(value={@NamedQuery(name="NewESIToken.findByID", query="SELECT c FROM NewESIToken c where c.kid = :kid"), @NamedQuery(name="NewESIToken.findByCred", query="SELECT c FROM NewESIToken c where c.stateKey = :cred"), @NamedQuery(name="NewESIToken.getExpired", query="SELECT c FROM NewESIToken c where c.expiry <= :expiry")})
public class NewESIToken {
    protected static final Logger log = Logger.getLogger(NewESIToken.class.getName());
    public static final String PROP_TEMP_TOKEN_LIFETIME = "enterprises.orbital.evekit.tempTokenLifetime";
    public static final long DEF_TEMP_TOKEN_LIFETIME = TimeUnit.MILLISECONDS.convert(10L, TimeUnit.MINUTES);
    private static boolean cleanerStarted = false;
    protected static ThreadLocal<ByteBuffer> assembly = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            return ByteBuffer.allocate(550);
        }
    };
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ek_seq")
    @SequenceGenerator(name="ek_seq", initialValue=100000, allocationSize=10, sequenceName="account_sequence")
    private long kid;
    @ManyToOne
    @JoinColumn(name="uid", referencedColumnName="uid")
    private EveKitUserAccount user;
    @ManyToOne
    @JoinColumn(name="aid", referencedColumnName="aid")
    private SynchronizedEveAccount account;
    private long createTime;
    private long expiry;
    @Lob
    @Column(length=102400)
    private String scopes;
    private long randomSeed;
    @Lob
    @Column(length=102400)
    private String stateKey;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        Class<NewESIToken> clazz = NewESIToken.class;
        synchronized (NewESIToken.class) {
            if (cleanerStarted) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            new Thread(() -> {
                while (true) {
                    try {
                        while (true) {
                            long now = OrbitalProperties.getCurrentTime();
                            NewESIToken.cleanExpired(now);
                            Thread.sleep(TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES));
                        }
                    }
                    catch (Throwable e) {
                        log.log(Level.WARNING, "caught error in state cleanup loop (ignoring)", e);
                        continue;
                    }
                    break;
                }
            }).start();
            cleanerStarted = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public long getKid() {
        return this.kid;
    }

    public EveKitUserAccount getUser() {
        return this.user;
    }

    public SynchronizedEveAccount getAccount() {
        return this.account;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getExpiry() {
        return this.expiry;
    }

    public String getScopes() {
        return this.scopes;
    }

    public long getRandomSeed() {
        return this.randomSeed;
    }

    public String getStateKey() {
        return this.stateKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewESIToken that = (NewESIToken)o;
        if (this.kid != that.kid) {
            return false;
        }
        if (this.createTime != that.createTime) {
            return false;
        }
        if (this.expiry != that.expiry) {
            return false;
        }
        if (this.randomSeed != that.randomSeed) {
            return false;
        }
        if (!this.user.equals(that.user)) {
            return false;
        }
        if (!this.account.equals(that.account)) {
            return false;
        }
        if (!this.scopes.equals(that.scopes)) {
            return false;
        }
        return this.stateKey.equals(that.stateKey);
    }

    public int hashCode() {
        int result = (int)(this.kid ^ this.kid >>> 32);
        result = 31 * result + this.user.hashCode();
        result = 31 * result + this.account.hashCode();
        result = 31 * result + (int)(this.createTime ^ this.createTime >>> 32);
        result = 31 * result + (int)(this.expiry ^ this.expiry >>> 32);
        result = 31 * result + this.scopes.hashCode();
        result = 31 * result + (int)(this.randomSeed ^ this.randomSeed >>> 32);
        result = 31 * result + this.stateKey.hashCode();
        return result;
    }

    public String toString() {
        return "NewESIToken{kid=" + this.kid + ", user=" + this.user + ", account=" + this.account + ", createTime=" + this.createTime + ", expiry=" + this.expiry + ", scopes='" + this.scopes + '\'' + ", randomSeed=" + this.randomSeed + ", stateKey='" + this.stateKey + '\'' + '}';
    }

    public static NewESIToken createKey(EveKitUserAccount user, SynchronizedEveAccount account, long createTime, long expiry, String scopes) throws IOException {
        NewESIToken.init();
        try {
            NewESIToken newKey = (NewESIToken)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                long seed = new Random(OrbitalProperties.getCurrentTime()).nextLong();
                NewESIToken result = new NewESIToken();
                result.user = user;
                result.account = account;
                result.createTime = createTime;
                result.expiry = expiry;
                result.scopes = scopes;
                result.randomSeed = seed;
                return (NewESIToken)EveKitUserAccountProvider.getFactory().getEntityManager().merge((Object)result);
            });
            return (NewESIToken)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery("NewESIToken.findByID", NewESIToken.class);
                getter.setParameter("kid", (Object)newKey.kid);
                NewESIToken result = (NewESIToken)getter.getSingleResult();
                result.stateKey = NewESIToken.generateHash(result);
                return (NewESIToken)EveKitUserAccountProvider.getFactory().getEntityManager().merge((Object)result);
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static NewESIToken getKeyByID(long kid) throws IOException {
        try {
            return (NewESIToken)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery("NewESIToken.findByID", NewESIToken.class);
                getter.setParameter("kid", (Object)kid);
                try {
                    return (NewESIToken)getter.getSingleResult();
                }
                catch (NoResultException e) {
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static NewESIToken getKeyByState(String state) throws IOException {
        try {
            return (NewESIToken)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery("NewESIToken.findByCred", NewESIToken.class);
                getter.setParameter("cred", (Object)state);
                try {
                    return (NewESIToken)getter.getSingleResult();
                }
                catch (NoResultException e) {
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static void cleanExpired(long limit) throws IOException {
        try {
            EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery("NewESIToken.getExpired", NewESIToken.class);
                getter.setParameter("expiry", (Object)limit);
                for (NewESIToken next : getter.getResultList()) {
                    EveKitUserAccountProvider.getFactory().getEntityManager().remove((Object)next);
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static void deleteKey(long kid) throws IOException {
        try {
            EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                NewESIToken key = NewESIToken.getKeyByID(kid);
                if (key != null) {
                    EveKitUserAccountProvider.getFactory().getEntityManager().remove((Object)key);
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    private static String generateHash(NewESIToken ref) {
        ByteBuffer assemble = assembly.get();
        assemble.clear();
        assemble.putLong(ref.kid);
        assemble.putLong(ref.getRandomSeed());
        assemble.limit(assemble.position());
        assemble.rewind();
        return Stamper.digest((ByteBuffer)assemble);
    }
}

