/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.account;

import enterprises.orbital.db.ConnectionFactory;
import enterprises.orbital.evekit.account.EveKitUserAccountProvider;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="evekit_sequence")
public class GeneralSequenceNumber {
    private static final Logger log = Logger.getLogger(GeneralSequenceNumber.class.getName());
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ek_seq")
    @SequenceGenerator(name="ek_seq", initialValue=100000, allocationSize=10, sequenceName="account_sequence")
    private long value;

    public long getValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.value ^ this.value >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeneralSequenceNumber other = (GeneralSequenceNumber)obj;
        return this.value == other.value;
    }

    public static GeneralSequenceNumber create() {
        try {
            return (GeneralSequenceNumber)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<GeneralSequenceNumber>(){

                public GeneralSequenceNumber run() throws Exception {
                    GeneralSequenceNumber result = new GeneralSequenceNumber();
                    return (GeneralSequenceNumber)EveKitUserAccountProvider.getFactory().getEntityManager().merge((Object)result);
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }
}

