/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import enterprises.orbital.base.OrbitalProperties;
import enterprises.orbital.evekit.account.AuthSourceNotFoundException;
import enterprises.orbital.evekit.account.EveKitUserAccount;
import enterprises.orbital.evekit.account.EveKitUserAccountProvider;
import enterprises.orbital.oauth.UserAccount;
import enterprises.orbital.oauth.UserAuthSource;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.NoResultException;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TypedQuery;

@Entity
@Table(name="evekit_auth_source", indexes={@Index(name="accountIndex", columnList="uid", unique=false), @Index(name="sourceAndScreenIndex", columnList="source, screenName", unique=false)})
@NamedQueries(value={@NamedQuery(name="EveKitUserAuthSource.findByAcctAndSource", query="SELECT c FROM EveKitUserAuthSource c where c.account = :account and c.source = :source"), @NamedQuery(name="EveKitUserAuthSource.allSourcesByAcct", query="SELECT c FROM EveKitUserAuthSource c where c.account = :account order by c.last desc"), @NamedQuery(name="EveKitUserAuthSource.all", query="SELECT c FROM EveKitUserAuthSource c"), @NamedQuery(name="EveKitUserAuthSource.allBySourceAndScreenname", query="SELECT c FROM EveKitUserAuthSource c where c.source = :source and c.screenName = :screenname")})
@ApiModel(description="Authentication source for a user")
@JsonSerialize(typing=JsonSerialize.Typing.DYNAMIC)
public class EveKitUserAuthSource
implements UserAuthSource {
    private static final Logger log = Logger.getLogger(EveKitUserAuthSource.class.getName());
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ek_seq")
    @SequenceGenerator(name="ek_seq", initialValue=100000, allocationSize=10, sequenceName="account_sequence")
    @ApiModelProperty(value="Unique source ID")
    @JsonProperty(value="sid")
    protected long sid;
    @ManyToOne
    @JoinColumn(name="uid", referencedColumnName="uid")
    @JsonProperty(value="account")
    private EveKitUserAccount account;
    @ApiModelProperty(value="Name of authentication source")
    @JsonProperty(value="source")
    private String source;
    @ApiModelProperty(value="Screen name for this source")
    @JsonProperty(value="screenName")
    private String screenName;
    @ApiModelProperty(value="Source specific authentication details")
    @JsonProperty(value="details")
    @Lob
    @Column(length=102400)
    private String details;
    @ApiModelProperty(value="Last time (milliseconds UTC) this source was used to authenticate")
    @JsonProperty(value="last")
    private long last = -1L;

    public EveKitUserAccount getUserAccount() {
        return this.account;
    }

    public EveKitUserAccount getOwner() {
        return this.account;
    }

    public String getSource() {
        return this.source;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public void setScreenName(String screenName) {
        this.screenName = screenName;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public long getLast() {
        return this.last;
    }

    public void setLast(long last) {
        this.last = last;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.account == null ? 0 : this.account.hashCode());
        result = 31 * result + (this.details == null ? 0 : this.details.hashCode());
        result = 31 * result + (int)(this.last ^ this.last >>> 32);
        result = 31 * result + (this.screenName == null ? 0 : this.screenName.hashCode());
        result = 31 * result + (int)(this.sid ^ this.sid >>> 32);
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EveKitUserAuthSource other = (EveKitUserAuthSource)obj;
        if (this.account == null ? other.account != null : !this.account.equals(other.account)) {
            return false;
        }
        if (this.details == null ? other.details != null : !this.details.equals(other.details)) {
            return false;
        }
        if (this.last != other.last) {
            return false;
        }
        if (this.screenName == null ? other.screenName != null : !this.screenName.equals(other.screenName)) {
            return false;
        }
        if (this.sid != other.sid) {
            return false;
        }
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }

    public String toString() {
        return "EveKitUserAuthSource [sid=" + this.sid + ", account=" + this.account + ", source=" + this.source + ", screenName=" + this.screenName + ", details=" + this.details + ", last=" + this.last + "]";
    }

    public static EveKitUserAuthSource getSource(EveKitUserAccount acct, String source) throws AuthSourceNotFoundException, IOException {
        try {
            return (EveKitUserAuthSource)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery("EveKitUserAuthSource.findByAcctAndSource", EveKitUserAuthSource.class);
                getter.setParameter("account", (Object)acct);
                getter.setParameter("source", (Object)source);
                try {
                    return (EveKitUserAuthSource)getter.getSingleResult();
                }
                catch (NoResultException e) {
                    throw new AuthSourceNotFoundException();
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof AuthSourceNotFoundException) {
                throw (AuthSourceNotFoundException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static List<EveKitUserAuthSource> getAllSources(EveKitUserAccount acct) throws IOException {
        try {
            return (List)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery("EveKitUserAuthSource.allSourcesByAcct", EveKitUserAuthSource.class);
                getter.setParameter("account", (Object)acct);
                return getter.getResultList();
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static EveKitUserAuthSource getLastUsedSource(EveKitUserAccount acct) throws IOException {
        try {
            return (EveKitUserAuthSource)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery("EveKitUserAuthSource.allSourcesByAcct", EveKitUserAuthSource.class);
                getter.setParameter("account", (Object)acct);
                getter.setMaxResults(1);
                List results = getter.getResultList();
                return results.isEmpty() ? null : (EveKitUserAuthSource)results.get(0);
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static List<EveKitUserAuthSource> getAll() throws IOException {
        try {
            return (List)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery("EveKitUserAuthSource.all", EveKitUserAuthSource.class);
                return getter.getResultList();
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static EveKitUserAuthSource getBySourceScreenname(String source, String screenName) throws IOException {
        try {
            return (EveKitUserAuthSource)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery("EveKitUserAuthSource.allBySourceAndScreenname", EveKitUserAuthSource.class);
                getter.setParameter("source", (Object)source);
                getter.setParameter("screenname", (Object)screenName);
                getter.setMaxResults(1);
                List results = getter.getResultList();
                return results.isEmpty() ? null : (EveKitUserAuthSource)results.get(0);
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static EveKitUserAuthSource updateAccount(EveKitUserAuthSource src, EveKitUserAccount newAccount) throws IOException {
        try {
            return (EveKitUserAuthSource)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                src.account = newAccount;
                return (EveKitUserAuthSource)EveKitUserAccountProvider.getFactory().getEntityManager().merge((Object)src);
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static EveKitUserAuthSource createSource(EveKitUserAccount owner, String source, String screenName, String details) throws IOException {
        try {
            return (EveKitUserAuthSource)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                try {
                    return EveKitUserAuthSource.getSource(owner, source);
                }
                catch (AuthSourceNotFoundException e) {
                    EveKitUserAuthSource result = new EveKitUserAuthSource();
                    result.account = owner;
                    result.source = source;
                    result.setScreenName(screenName);
                    result.setDetails(details);
                    result.setLast(OrbitalProperties.getCurrentTime());
                    return (EveKitUserAuthSource)EveKitUserAccountProvider.getFactory().getEntityManager().merge((Object)result);
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static void removeSourceIfExists(EveKitUserAccount owner, String source) throws IOException {
        try {
            EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                try {
                    EveKitUserAuthSource result = EveKitUserAuthSource.getSource(owner, source);
                    EveKitUserAccountProvider.getFactory().getEntityManager().remove((Object)result);
                }
                catch (AuthSourceNotFoundException authSourceNotFoundException) {
                    // empty catch block
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public static EveKitUserAuthSource touch(EveKitUserAuthSource source) throws IOException {
        try {
            return (EveKitUserAuthSource)EveKitUserAccountProvider.getFactory().runTransaction(() -> {
                source.setLast(OrbitalProperties.getCurrentTime());
                return (EveKitUserAuthSource)EveKitUserAccountProvider.getFactory().getEntityManager().merge((Object)source);
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public String getBody() {
        return this.details;
    }

    public void touch() {
        try {
            EveKitUserAuthSource.touch(this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void updateAccount(UserAccount existing) {
        assert (existing instanceof EveKitUserAccount);
        try {
            EveKitUserAuthSource.updateAccount(this, (EveKitUserAccount)existing);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Date getLastSignOn() {
        return new Date(this.last);
    }
}

