/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.account;

import enterprises.orbital.base.OrbitalProperties;
import enterprises.orbital.db.ConnectionFactory;
import enterprises.orbital.evekit.account.AuthSourceNotFoundException;
import enterprises.orbital.evekit.account.EveKitUserAccount;
import enterprises.orbital.evekit.account.EveKitUserAuthSource;
import enterprises.orbital.evekit.account.UserNotFoundException;
import enterprises.orbital.oauth.UserAccount;
import enterprises.orbital.oauth.UserAccountProvider;
import enterprises.orbital.oauth.UserAuthSource;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EveKitUserAccountProvider
implements UserAccountProvider {
    private static final Logger log = Logger.getLogger(EveKitUserAccountProvider.class.getName());
    public static final String USER_ACCOUNT_PU_PROP = "enterprises.orbital.evekit.account.persistence_unit";
    public static final String USER_ACCOUNT_PU_DEFAULT = "evekit-production";

    public static ConnectionFactory getFactory() {
        return ConnectionFactory.getFactory((String)OrbitalProperties.getGlobalProperty((String)USER_ACCOUNT_PU_PROP, (String)USER_ACCOUNT_PU_DEFAULT));
    }

    public static <T> T update(T tracked) throws IOException {
        try {
            return (T)EveKitUserAccountProvider.getFactory().runTransaction(() -> EveKitUserAccountProvider.getFactory().getEntityManager().merge(tracked));
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.log(Level.SEVERE, "query error", e);
            throw new IOException(e.getCause());
        }
    }

    public UserAccount getAccount(String uid) {
        long user_id = 0L;
        try {
            user_id = Long.valueOf(uid);
        }
        catch (NumberFormatException e) {
            user_id = 0L;
        }
        try {
            return EveKitUserAccount.getAccount(user_id);
        }
        catch (UserNotFoundException | IOException e) {
            return null;
        }
    }

    public UserAuthSource getSource(UserAccount acct, String source) {
        assert (acct instanceof EveKitUserAccount);
        try {
            return EveKitUserAuthSource.getSource((EveKitUserAccount)acct, source);
        }
        catch (AuthSourceNotFoundException | IOException e) {
            return null;
        }
    }

    public void removeSourceIfExists(UserAccount acct, String source) {
        assert (acct instanceof EveKitUserAccount);
        try {
            EveKitUserAuthSource.removeSourceIfExists((EveKitUserAccount)acct, source);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public UserAuthSource getBySourceScreenname(String source, String screenName) {
        try {
            return EveKitUserAuthSource.getBySourceScreenname(source, screenName);
        }
        catch (IOException e) {
            return null;
        }
    }

    public UserAuthSource createSource(UserAccount newUser, String source, String screenName, String body) {
        assert (newUser instanceof EveKitUserAccount);
        try {
            return EveKitUserAuthSource.createSource((EveKitUserAccount)newUser, source, screenName, body);
        }
        catch (IOException e) {
            return null;
        }
    }

    public UserAccount createNewUserAccount(boolean disabled) {
        try {
            return EveKitUserAccount.createNewUserAccount(false, !disabled);
        }
        catch (IOException e) {
            return null;
        }
    }
}

