/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import enterprises.orbital.base.OrbitalProperties;
import enterprises.orbital.db.ConnectionFactory;
import enterprises.orbital.evekit.account.EveKitUserAccountProvider;
import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.SynchronizationState;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.NoResultException;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TypedQuery;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="evekit_sync", indexes={@Index(name="accountIndex", columnList="aid", unique=false), @Index(name="finishedIndex", columnList="aid, finished", unique=false), @Index(name="syncEndIndex", columnList="aid, syncEnd", unique=false)})
@NamedQueries(value={@NamedQuery(name="SyncTracker.get", query="SELECT c FROM SyncTracker c where c.account = :account and c.tid = :tid"), @NamedQuery(name="SyncTracker.getUnfinished", query="SELECT c FROM SyncTracker c where c.account = :account and c.finished = false"), @NamedQuery(name="SyncTracker.getLatestFinished", query="SELECT c FROM SyncTracker c where c.account = :account and c.finished = true order by c.syncEnd desc")})
@ApiModel(description="Synchronization tracker base attributes")
public abstract class SyncTracker {
    private static final Logger log = Logger.getLogger(SyncTracker.class.getName());
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ek_seq")
    @SequenceGenerator(name="ek_seq", initialValue=100000, allocationSize=10, sequenceName="account_sequence")
    @ApiModelProperty(value="Uniquer tracker ID")
    @JsonProperty(value="tid")
    protected long tid;
    @ManyToOne
    @JoinColumn(name="aid", referencedColumnName="aid")
    @JsonProperty(value="account")
    protected SynchronizedEveAccount account;
    @ApiModelProperty(value="Tracker start time (milliseconds UTC)")
    @JsonProperty(value="syncStart")
    protected long syncStart = -1L;
    @ApiModelProperty(value="True if this tracker has been completed")
    @JsonProperty(value="finished")
    protected boolean finished;
    @ApiModelProperty(value="Tracker end time (milliseconds UTC)")
    @JsonProperty(value="syncEnd")
    protected long syncEnd = -1L;

    public long getTid() {
        return this.tid;
    }

    public SynchronizedEveAccount getOwner() {
        return this.account;
    }

    public boolean getFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public long getSyncStart() {
        return this.syncStart;
    }

    public void setSyncStart(long syncStart) {
        this.syncStart = syncStart;
    }

    public long getSyncEnd() {
        return this.syncEnd;
    }

    public void setSyncEnd(long syncEnd) {
        this.syncEnd = syncEnd;
    }

    public SynchronizationState trackerComplete(Set<SynchronizationState> checkState) {
        return null;
    }

    public void setState(SynchronizationState state, SyncState status, String msg) {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.account == null ? 0 : this.account.hashCode());
        result = 31 * result + (this.finished ? 1231 : 1237);
        result = 31 * result + (int)(this.syncEnd ^ this.syncEnd >>> 32);
        result = 31 * result + (int)(this.syncStart ^ this.syncStart >>> 32);
        result = 31 * result + (int)(this.tid ^ this.tid >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SyncTracker other = (SyncTracker)obj;
        if (this.account == null ? other.account != null : !this.account.equals(other.account)) {
            return false;
        }
        if (this.finished != other.finished) {
            return false;
        }
        if (this.syncEnd != other.syncEnd) {
            return false;
        }
        if (this.syncStart != other.syncStart) {
            return false;
        }
        return this.tid == other.tid;
    }

    public String toString() {
        return "SyncTracker [tid=" + this.tid + ", account=" + this.account + ", syncStart=" + this.syncStart + ", finished=" + this.finished + ", syncEnd=" + this.syncEnd + "]";
    }

    public static void incrementSummary(String cat, String reason, Map<String, Map<String, AtomicInteger>> summary) {
        AtomicInteger counter;
        Map<String, AtomicInteger> category = summary.get(cat);
        if (category == null) {
            category = new HashMap<String, AtomicInteger>();
            summary.put(cat, category);
        }
        if ((counter = category.get(reason)) == null) {
            counter = new AtomicInteger();
            category.put(reason, counter);
        }
        counter.incrementAndGet();
    }

    public static <A extends SyncTracker> A finishTracker(final A tracker) {
        try {
            return (A)((SyncTracker)EveKitUserAccountProvider.getFactory().runTransaction(new ConnectionFactory.RunInTransaction<A>(){

                public A run() throws Exception {
                    tracker.setFinished(true);
                    tracker.setSyncEnd(OrbitalProperties.getCurrentTime());
                    return (SyncTracker)EveKitUserAccountProvider.getFactory().getEntityManager().merge((Object)tracker);
                }
            }));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static <A extends SyncTracker> A updateTracker(final A tracker) {
        try {
            return (A)((SyncTracker)EveKitUserAccountProvider.getFactory().runTransaction(new ConnectionFactory.RunInTransaction<A>(){

                public A run() throws Exception {
                    return (SyncTracker)EveKitUserAccountProvider.getFactory().getEntityManager().merge((Object)tracker);
                }
            }));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static <A extends SyncTracker> A get(final SynchronizedEveAccount syncAccount, final long tid) {
        try {
            return (A)((SyncTracker)EveKitUserAccountProvider.getFactory().runTransaction(new ConnectionFactory.RunInTransaction<A>(){

                public A run() throws Exception {
                    TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery("SyncTracker.get", SyncTracker.class);
                    getter.setParameter("account", (Object)syncAccount);
                    getter.setParameter("tid", (Object)tid);
                    try {
                        return (SyncTracker)getter.getSingleResult();
                    }
                    catch (NoResultException e) {
                        return null;
                    }
                }
            }));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static <A extends SyncTracker> A getUnfinishedTracker(final SynchronizedEveAccount syncAccount) {
        try {
            return (A)((SyncTracker)EveKitUserAccountProvider.getFactory().runTransaction(new ConnectionFactory.RunInTransaction<A>(){

                public A run() throws Exception {
                    TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery("SyncTracker.getUnfinished", SyncTracker.class);
                    getter.setParameter("account", (Object)syncAccount);
                    try {
                        return (SyncTracker)getter.getSingleResult();
                    }
                    catch (NoResultException e) {
                        return null;
                    }
                }
            }));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static <A extends SyncTracker> A getLatestFinishedTracker(final SynchronizedEveAccount owner) {
        try {
            return (A)((SyncTracker)EveKitUserAccountProvider.getFactory().runTransaction(new ConnectionFactory.RunInTransaction<A>(){

                public A run() throws Exception {
                    TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery("SyncTracker.getLatestFinished", SyncTracker.class);
                    getter.setParameter("account", (Object)owner);
                    getter.setMaxResults(1);
                    try {
                        return (SyncTracker)getter.getSingleResult();
                    }
                    catch (NoResultException e) {
                        return null;
                    }
                }
            }));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static enum SyncState {
        NOT_PROCESSED,
        UPDATED,
        NOT_EXPIRED,
        SYNC_ERROR,
        SYNC_WARNING,
        NOT_ALLOWED;

    }
}

