/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import enterprises.orbital.base.OrbitalProperties;
import enterprises.orbital.db.ConnectionFactory;
import enterprises.orbital.evekit.account.EveKitRefDataProvider;
import enterprises.orbital.evekit.model.SyncTracker;
import enterprises.orbital.evekit.model.SynchronizationState;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.NoResultException;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TypedQuery;

@Entity
@Table(name="evekit_ref_sync", indexes={@Index(name="finishedIndex", columnList="finished", unique=false), @Index(name="syncEndIndex", columnList="syncEnd", unique=false)})
@NamedQueries(value={@NamedQuery(name="RefSyncTracker.get", query="SELECT c FROM RefSyncTracker c where c.tid = :tid"), @NamedQuery(name="RefSyncTracker.getUnfinished", query="SELECT c FROM RefSyncTracker c where c.finished = false"), @NamedQuery(name="RefSyncTracker.getLatestFinished", query="SELECT c FROM RefSyncTracker c where c.finished = true order by c.syncEnd desc"), @NamedQuery(name="RefSyncTracker.getStart", query="SELECT c FROM RefSyncTracker c where c.syncStart = :start"), @NamedQuery(name="RefSyncTracker.getHistory", query="SELECT c FROM RefSyncTracker c where c.finished = true and c.syncStart < :start order by c.syncStart desc"), @NamedQuery(name="RefSyncTracker.getSummary", query="SELECT c FROM RefSyncTracker c where c.finished = true and c.syncStart >= :start")})
@ApiModel(description="Reference data synchronization tracker entity")
public class RefSyncTracker {
    private static final Logger log = Logger.getLogger(RefSyncTracker.class.getName());
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ek_ref_seq")
    @SequenceGenerator(name="ek_ref_seq", initialValue=100000, allocationSize=10, sequenceName="account_sequence")
    @ApiModelProperty(value="Uniquer tracker ID")
    @JsonProperty(value="tid")
    protected long tid;
    @ApiModelProperty(value="Tracker start time (milliseconds UTC)")
    @JsonProperty(value="syncStart")
    protected long syncStart = -1L;
    @ApiModelProperty(value="True if this tracker has been completed")
    @JsonProperty(value="finished")
    protected boolean finished;
    @ApiModelProperty(value="Tracker end time (milliseconds UTC)")
    @JsonProperty(value="syncEnd")
    protected long syncEnd = -1L;
    @ApiModelProperty(value="Server status")
    @JsonProperty(value="serverStatusStatus")
    private SyncTracker.SyncState serverStatusStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Server status detail message")
    @JsonProperty(value="serverStatusDetail")
    private String serverStatusDetail;
    @ApiModelProperty(value="API Call List status")
    @JsonProperty(value="callListStatus")
    private SyncTracker.SyncState callListStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="API Call List detail")
    @JsonProperty(value="callListDetail")
    private String callListDetail;
    @ApiModelProperty(value="Alliance list status")
    @JsonProperty(value="allianceListStatus")
    private SyncTracker.SyncState allianceListStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Alliance list detail")
    @JsonProperty(value="allianceListDetail")
    private String allianceListDetail;
    @ApiModelProperty(value="Conquerable station list status")
    @JsonProperty(value="conquerableStationsStatus")
    private SyncTracker.SyncState conquerableStationsStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Conquerable station list detail")
    @JsonProperty(value="conquerableStationsDetail")
    private String conquerableStationsDetail;
    @ApiModelProperty(value="Error list status")
    @JsonProperty(value="errorListStatus")
    private SyncTracker.SyncState errorListStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Error list detail")
    @JsonProperty(value="errorListDetail")
    private String errorListDetail;
    @ApiModelProperty(value="Faction war stats status")
    @JsonProperty(value="facWarStatsStatus")
    private SyncTracker.SyncState facWarStatsStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Faction war stats detail")
    @JsonProperty(value="facWarStatsDetail")
    private String facWarStatsDetail;
    @ApiModelProperty(value="Faction war top stats status")
    @JsonProperty(value="facWarTopStatsStatus")
    private SyncTracker.SyncState facWarTopStatsStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Faction war top stats detail")
    @JsonProperty(value="facWarTopStatsDetail")
    private String facWarTopStatsDetail;
    @ApiModelProperty(value="Reference type status")
    @JsonProperty(value="refTypeStatus")
    private SyncTracker.SyncState refTypeStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Reference type detail")
    @JsonProperty(value="refTypeDetail")
    private String refTypeDetail;
    @ApiModelProperty(value="Skill tree status")
    @JsonProperty(value="skillTreeStatus")
    private SyncTracker.SyncState skillTreeStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Skill tree detail")
    @JsonProperty(value="skillTreeDetail")
    private String skillTreeDetail;
    @ApiModelProperty(value="Faction war systems status")
    @JsonProperty(value="facWarSystemsStatus")
    private SyncTracker.SyncState facWarSystemsStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Faction war systems detail")
    @JsonProperty(value="facWarSystemsDetail")
    private String facWarSystemsDetail;
    @ApiModelProperty(value="Map jump status")
    @JsonProperty(value="mapJumpStatus")
    private SyncTracker.SyncState mapJumpStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Map jump detail")
    @JsonProperty(value="mapJumpDetail")
    private String mapJumpDetail;
    @ApiModelProperty(value="Map kill status")
    @JsonProperty(value="mapKillStatus")
    private SyncTracker.SyncState mapKillStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Map kill detail")
    @JsonProperty(value="mapKillDetail")
    private String mapKillDetail;
    @ApiModelProperty(value="Sovereignty status")
    @JsonProperty(value="sovereigntyStatus")
    private SyncTracker.SyncState sovereigntyStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Sovereignty detail")
    @JsonProperty(value="sovereigntyDetail")
    private String sovereigntyDetail;

    public long getTid() {
        return this.tid;
    }

    public boolean getFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public long getSyncStart() {
        return this.syncStart;
    }

    public void setSyncStart(long syncStart) {
        this.syncStart = syncStart;
    }

    public long getSyncEnd() {
        return this.syncEnd;
    }

    public void setSyncEnd(long syncEnd) {
        this.syncEnd = syncEnd;
    }

    public void setState(SynchronizationState state, SyncTracker.SyncState status, String msg) {
        switch (state) {
            case SYNC_REF_SERVERSTATUS: {
                this.setServerStatusStatus(status);
                this.setServerStatusDetail(msg);
                break;
            }
            case SYNC_REF_CALLS_LIST: {
                this.setCallListStatus(status);
                this.setCallListDetail(msg);
                break;
            }
            case SYNC_REF_ALLIANCES: {
                this.setAllianceListStatus(status);
                this.setAllianceListDetail(msg);
                break;
            }
            case SYNC_REF_CONQUERABLE: {
                this.setConquerableStationsStatus(status);
                this.setConquerableStationsDetail(msg);
                break;
            }
            case SYNC_REF_ERRORLIST: {
                this.setErrorListStatus(status);
                this.setErrorListDetail(msg);
                break;
            }
            case SYNC_REF_FACWARSTATS: {
                this.setFacWarStatsStatus(status);
                this.setFacWarStatsDetail(msg);
                break;
            }
            case SYNC_REF_FACWARTOPSTATS: {
                this.setFacWarTopStatsStatus(status);
                this.setFacWarTopStatsDetail(msg);
                break;
            }
            case SYNC_REF_REFTYPES: {
                this.setRefTypeStatus(status);
                this.setRefTypeDetail(msg);
                break;
            }
            case SYNC_REF_SKILLTREE: {
                this.setSkillTreeStatus(status);
                this.setSkillTreeDetail(msg);
                break;
            }
            case SYNC_REF_FACWARSYSTEMS: {
                this.setFacWarSystemsStatus(status);
                this.setFacWarSystemsDetail(msg);
                break;
            }
            case SYNC_REF_MAPJUMPS: {
                this.setMapJumpStatus(status);
                this.setMapJumpDetail(msg);
                break;
            }
            case SYNC_REF_MAPKILLS: {
                this.setMapKillStatus(status);
                this.setMapKillDetail(msg);
                break;
            }
            case SYNC_REF_SOVEREIGNTY: {
                this.setSovereigntyStatus(status);
                this.setSovereigntyDetail(msg);
                break;
            }
        }
    }

    public SynchronizationState trackerComplete(Set<SynchronizationState> checkState) {
        for (SynchronizationState next : checkState) {
            switch (next) {
                case SYNC_REF_SERVERSTATUS: {
                    if (this.serverStatusStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_REF_CALLS_LIST: {
                    if (this.callListStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_REF_ALLIANCES: {
                    if (this.allianceListStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_REF_CONQUERABLE: {
                    if (this.conquerableStationsStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_REF_ERRORLIST: {
                    if (this.errorListStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_REF_FACWARSTATS: {
                    if (this.facWarStatsStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_REF_FACWARTOPSTATS: {
                    if (this.facWarTopStatsStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_REF_REFTYPES: {
                    if (this.refTypeStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_REF_SKILLTREE: {
                    if (this.skillTreeStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_REF_FACWARSYSTEMS: {
                    if (this.facWarSystemsStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_REF_MAPJUMPS: {
                    if (this.mapJumpStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_REF_MAPKILLS: {
                    if (this.mapKillStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_REF_SOVEREIGNTY: {
                    if (this.sovereigntyStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
            }
        }
        return null;
    }

    public void setServerStatusStatus(SyncTracker.SyncState serverStatusStatus) {
        this.serverStatusStatus = serverStatusStatus;
    }

    public SyncTracker.SyncState getServerStatusStatus() {
        return this.serverStatusStatus;
    }

    public String getServerStatusDetail() {
        return this.serverStatusDetail;
    }

    public void setServerStatusDetail(String serverStatusDetail) {
        this.serverStatusDetail = serverStatusDetail;
    }

    public SyncTracker.SyncState getCallListStatus() {
        return this.callListStatus;
    }

    public void setCallListStatus(SyncTracker.SyncState callListStatus) {
        this.callListStatus = callListStatus;
    }

    public String getCallListDetail() {
        return this.callListDetail;
    }

    public void setCallListDetail(String callListDetail) {
        this.callListDetail = callListDetail;
    }

    public SyncTracker.SyncState getAllianceListStatus() {
        return this.allianceListStatus;
    }

    public void setAllianceListStatus(SyncTracker.SyncState allianceListStatus) {
        this.allianceListStatus = allianceListStatus;
    }

    public String getAllianceListDetail() {
        return this.allianceListDetail;
    }

    public void setAllianceListDetail(String allianceListDetail) {
        this.allianceListDetail = allianceListDetail;
    }

    public SyncTracker.SyncState getConquerableStationsStatus() {
        return this.conquerableStationsStatus;
    }

    public void setConquerableStationsStatus(SyncTracker.SyncState conquerableStationsStatus) {
        this.conquerableStationsStatus = conquerableStationsStatus;
    }

    public String getConquerableStationsDetail() {
        return this.conquerableStationsDetail;
    }

    public void setConquerableStationsDetail(String conquerableStationsDetail) {
        this.conquerableStationsDetail = conquerableStationsDetail;
    }

    public SyncTracker.SyncState getErrorListStatus() {
        return this.errorListStatus;
    }

    public void setErrorListStatus(SyncTracker.SyncState errorListStatus) {
        this.errorListStatus = errorListStatus;
    }

    public String getErrorListDetail() {
        return this.errorListDetail;
    }

    public void setErrorListDetail(String errorListDetail) {
        this.errorListDetail = errorListDetail;
    }

    public SyncTracker.SyncState getFacWarStatsStatus() {
        return this.facWarStatsStatus;
    }

    public void setFacWarStatsStatus(SyncTracker.SyncState facWarStatsStatus) {
        this.facWarStatsStatus = facWarStatsStatus;
    }

    public String getFacWarStatsDetail() {
        return this.facWarStatsDetail;
    }

    public void setFacWarStatsDetail(String facWarStatsDetail) {
        this.facWarStatsDetail = facWarStatsDetail;
    }

    public SyncTracker.SyncState getFacWarTopStatsStatus() {
        return this.facWarTopStatsStatus;
    }

    public void setFacWarTopStatsStatus(SyncTracker.SyncState facWarTopStatsStatus) {
        this.facWarTopStatsStatus = facWarTopStatsStatus;
    }

    public String getFacWarTopStatsDetail() {
        return this.facWarTopStatsDetail;
    }

    public void setFacWarTopStatsDetail(String facWarTopStatsDetail) {
        this.facWarTopStatsDetail = facWarTopStatsDetail;
    }

    public SyncTracker.SyncState getRefTypeStatus() {
        return this.refTypeStatus;
    }

    public void setRefTypeStatus(SyncTracker.SyncState refTypeStatus) {
        this.refTypeStatus = refTypeStatus;
    }

    public String getRefTypeDetail() {
        return this.refTypeDetail;
    }

    public void setRefTypeDetail(String refTypeDetail) {
        this.refTypeDetail = refTypeDetail;
    }

    public SyncTracker.SyncState getSkillTreeStatus() {
        return this.skillTreeStatus;
    }

    public void setSkillTreeStatus(SyncTracker.SyncState skillTreeStatus) {
        this.skillTreeStatus = skillTreeStatus;
    }

    public String getSkillTreeDetail() {
        return this.skillTreeDetail;
    }

    public void setSkillTreeDetail(String skillTreeDetail) {
        this.skillTreeDetail = skillTreeDetail;
    }

    public SyncTracker.SyncState getFacWarSystemsStatus() {
        return this.facWarSystemsStatus;
    }

    public void setFacWarSystemsStatus(SyncTracker.SyncState facWarSystemsStatus) {
        this.facWarSystemsStatus = facWarSystemsStatus;
    }

    public String getFacWarSystemsDetail() {
        return this.facWarSystemsDetail;
    }

    public void setFacWarSystemsDetail(String facWarSystemsDetail) {
        this.facWarSystemsDetail = facWarSystemsDetail;
    }

    public SyncTracker.SyncState getMapJumpStatus() {
        return this.mapJumpStatus;
    }

    public void setMapJumpStatus(SyncTracker.SyncState mapJumpStatus) {
        this.mapJumpStatus = mapJumpStatus;
    }

    public String getMapJumpDetail() {
        return this.mapJumpDetail;
    }

    public void setMapJumpDetail(String mapJumpDetail) {
        this.mapJumpDetail = mapJumpDetail;
    }

    public SyncTracker.SyncState getMapKillStatus() {
        return this.mapKillStatus;
    }

    public void setMapKillStatus(SyncTracker.SyncState mapKillStatus) {
        this.mapKillStatus = mapKillStatus;
    }

    public String getMapKillDetail() {
        return this.mapKillDetail;
    }

    public void setMapKillDetail(String mapKillDetail) {
        this.mapKillDetail = mapKillDetail;
    }

    public SyncTracker.SyncState getSovereigntyStatus() {
        return this.sovereigntyStatus;
    }

    public void setSovereigntyStatus(SyncTracker.SyncState sovereigntyStatus) {
        this.sovereigntyStatus = sovereigntyStatus;
    }

    public String getSovereigntyDetail() {
        return this.sovereigntyDetail;
    }

    public void setSovereigntyDetail(String sovereigntyDetail) {
        this.sovereigntyDetail = sovereigntyDetail;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allianceListDetail == null ? 0 : this.allianceListDetail.hashCode());
        result = 31 * result + (this.allianceListStatus == null ? 0 : this.allianceListStatus.hashCode());
        result = 31 * result + (this.callListDetail == null ? 0 : this.callListDetail.hashCode());
        result = 31 * result + (this.callListStatus == null ? 0 : this.callListStatus.hashCode());
        result = 31 * result + (this.conquerableStationsDetail == null ? 0 : this.conquerableStationsDetail.hashCode());
        result = 31 * result + (this.conquerableStationsStatus == null ? 0 : this.conquerableStationsStatus.hashCode());
        result = 31 * result + (this.errorListDetail == null ? 0 : this.errorListDetail.hashCode());
        result = 31 * result + (this.errorListStatus == null ? 0 : this.errorListStatus.hashCode());
        result = 31 * result + (this.facWarStatsDetail == null ? 0 : this.facWarStatsDetail.hashCode());
        result = 31 * result + (this.facWarStatsStatus == null ? 0 : this.facWarStatsStatus.hashCode());
        result = 31 * result + (this.facWarSystemsDetail == null ? 0 : this.facWarSystemsDetail.hashCode());
        result = 31 * result + (this.facWarSystemsStatus == null ? 0 : this.facWarSystemsStatus.hashCode());
        result = 31 * result + (this.facWarTopStatsDetail == null ? 0 : this.facWarTopStatsDetail.hashCode());
        result = 31 * result + (this.facWarTopStatsStatus == null ? 0 : this.facWarTopStatsStatus.hashCode());
        result = 31 * result + (this.finished ? 1231 : 1237);
        result = 31 * result + (this.mapJumpDetail == null ? 0 : this.mapJumpDetail.hashCode());
        result = 31 * result + (this.mapJumpStatus == null ? 0 : this.mapJumpStatus.hashCode());
        result = 31 * result + (this.mapKillDetail == null ? 0 : this.mapKillDetail.hashCode());
        result = 31 * result + (this.mapKillStatus == null ? 0 : this.mapKillStatus.hashCode());
        result = 31 * result + (this.refTypeDetail == null ? 0 : this.refTypeDetail.hashCode());
        result = 31 * result + (this.refTypeStatus == null ? 0 : this.refTypeStatus.hashCode());
        result = 31 * result + (this.serverStatusDetail == null ? 0 : this.serverStatusDetail.hashCode());
        result = 31 * result + (this.serverStatusStatus == null ? 0 : this.serverStatusStatus.hashCode());
        result = 31 * result + (this.skillTreeDetail == null ? 0 : this.skillTreeDetail.hashCode());
        result = 31 * result + (this.skillTreeStatus == null ? 0 : this.skillTreeStatus.hashCode());
        result = 31 * result + (this.sovereigntyDetail == null ? 0 : this.sovereigntyDetail.hashCode());
        result = 31 * result + (this.sovereigntyStatus == null ? 0 : this.sovereigntyStatus.hashCode());
        result = 31 * result + (int)(this.syncEnd ^ this.syncEnd >>> 32);
        result = 31 * result + (int)(this.syncStart ^ this.syncStart >>> 32);
        result = 31 * result + (int)(this.tid ^ this.tid >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RefSyncTracker other = (RefSyncTracker)obj;
        if (this.allianceListDetail == null ? other.allianceListDetail != null : !this.allianceListDetail.equals(other.allianceListDetail)) {
            return false;
        }
        if (this.allianceListStatus != other.allianceListStatus) {
            return false;
        }
        if (this.callListDetail == null ? other.callListDetail != null : !this.callListDetail.equals(other.callListDetail)) {
            return false;
        }
        if (this.callListStatus != other.callListStatus) {
            return false;
        }
        if (this.conquerableStationsDetail == null ? other.conquerableStationsDetail != null : !this.conquerableStationsDetail.equals(other.conquerableStationsDetail)) {
            return false;
        }
        if (this.conquerableStationsStatus != other.conquerableStationsStatus) {
            return false;
        }
        if (this.errorListDetail == null ? other.errorListDetail != null : !this.errorListDetail.equals(other.errorListDetail)) {
            return false;
        }
        if (this.errorListStatus != other.errorListStatus) {
            return false;
        }
        if (this.facWarStatsDetail == null ? other.facWarStatsDetail != null : !this.facWarStatsDetail.equals(other.facWarStatsDetail)) {
            return false;
        }
        if (this.facWarStatsStatus != other.facWarStatsStatus) {
            return false;
        }
        if (this.facWarSystemsDetail == null ? other.facWarSystemsDetail != null : !this.facWarSystemsDetail.equals(other.facWarSystemsDetail)) {
            return false;
        }
        if (this.facWarSystemsStatus != other.facWarSystemsStatus) {
            return false;
        }
        if (this.facWarTopStatsDetail == null ? other.facWarTopStatsDetail != null : !this.facWarTopStatsDetail.equals(other.facWarTopStatsDetail)) {
            return false;
        }
        if (this.facWarTopStatsStatus != other.facWarTopStatsStatus) {
            return false;
        }
        if (this.finished != other.finished) {
            return false;
        }
        if (this.mapJumpDetail == null ? other.mapJumpDetail != null : !this.mapJumpDetail.equals(other.mapJumpDetail)) {
            return false;
        }
        if (this.mapJumpStatus != other.mapJumpStatus) {
            return false;
        }
        if (this.mapKillDetail == null ? other.mapKillDetail != null : !this.mapKillDetail.equals(other.mapKillDetail)) {
            return false;
        }
        if (this.mapKillStatus != other.mapKillStatus) {
            return false;
        }
        if (this.refTypeDetail == null ? other.refTypeDetail != null : !this.refTypeDetail.equals(other.refTypeDetail)) {
            return false;
        }
        if (this.refTypeStatus != other.refTypeStatus) {
            return false;
        }
        if (this.serverStatusDetail == null ? other.serverStatusDetail != null : !this.serverStatusDetail.equals(other.serverStatusDetail)) {
            return false;
        }
        if (this.serverStatusStatus != other.serverStatusStatus) {
            return false;
        }
        if (this.skillTreeDetail == null ? other.skillTreeDetail != null : !this.skillTreeDetail.equals(other.skillTreeDetail)) {
            return false;
        }
        if (this.skillTreeStatus != other.skillTreeStatus) {
            return false;
        }
        if (this.sovereigntyDetail == null ? other.sovereigntyDetail != null : !this.sovereigntyDetail.equals(other.sovereigntyDetail)) {
            return false;
        }
        if (this.sovereigntyStatus != other.sovereigntyStatus) {
            return false;
        }
        if (this.syncEnd != other.syncEnd) {
            return false;
        }
        if (this.syncStart != other.syncStart) {
            return false;
        }
        return this.tid == other.tid;
    }

    public String toString() {
        return "RefSyncTracker [tid=" + this.tid + ", syncStart=" + this.syncStart + ", finished=" + this.finished + ", syncEnd=" + this.syncEnd + ", serverStatusStatus=" + (Object)((Object)this.serverStatusStatus) + ", serverStatusDetail=" + this.serverStatusDetail + ", callListStatus=" + (Object)((Object)this.callListStatus) + ", callListDetail=" + this.callListDetail + ", allianceListStatus=" + (Object)((Object)this.allianceListStatus) + ", allianceListDetail=" + this.allianceListDetail + ", conquerableStationsStatus=" + (Object)((Object)this.conquerableStationsStatus) + ", conquerableStationsDetail=" + this.conquerableStationsDetail + ", errorListStatus=" + (Object)((Object)this.errorListStatus) + ", errorListDetail=" + this.errorListDetail + ", facWarStatsStatus=" + (Object)((Object)this.facWarStatsStatus) + ", facWarStatsDetail=" + this.facWarStatsDetail + ", facWarTopStatsStatus=" + (Object)((Object)this.facWarTopStatsStatus) + ", facWarTopStatsDetail=" + this.facWarTopStatsDetail + ", refTypeStatus=" + (Object)((Object)this.refTypeStatus) + ", refTypeDetail=" + this.refTypeDetail + ", skillTreeStatus=" + (Object)((Object)this.skillTreeStatus) + ", skillTreeDetail=" + this.skillTreeDetail + ", facWarSystemsStatus=" + (Object)((Object)this.facWarSystemsStatus) + ", facWarSystemsDetail=" + this.facWarSystemsDetail + ", mapJumpStatus=" + (Object)((Object)this.mapJumpStatus) + ", mapJumpDetail=" + this.mapJumpDetail + ", mapKillStatus=" + (Object)((Object)this.mapKillStatus) + ", mapKillDetail=" + this.mapKillDetail + ", sovereigntyStatus=" + (Object)((Object)this.sovereigntyStatus) + ", sovereigntyDetail=" + this.sovereigntyDetail + "]";
    }

    public static RefSyncTracker finishTracker(final RefSyncTracker tracker) {
        try {
            return (RefSyncTracker)EveKitRefDataProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<RefSyncTracker>(){

                public RefSyncTracker run() throws Exception {
                    tracker.setFinished(true);
                    tracker.setSyncEnd(OrbitalProperties.getCurrentTime());
                    return (RefSyncTracker)EveKitRefDataProvider.getFactory().getEntityManager().merge((Object)tracker);
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static RefSyncTracker updateTracker(final RefSyncTracker tracker) {
        try {
            return (RefSyncTracker)EveKitRefDataProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<RefSyncTracker>(){

                public RefSyncTracker run() throws Exception {
                    return (RefSyncTracker)EveKitRefDataProvider.getFactory().getEntityManager().merge((Object)tracker);
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static RefSyncTracker get(final long tid) {
        try {
            return (RefSyncTracker)EveKitRefDataProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<RefSyncTracker>(){

                public RefSyncTracker run() throws Exception {
                    TypedQuery getter = EveKitRefDataProvider.getFactory().getEntityManager().createNamedQuery("RefSyncTracker.get", RefSyncTracker.class);
                    getter.setParameter("tid", (Object)tid);
                    try {
                        return (RefSyncTracker)getter.getSingleResult();
                    }
                    catch (NoResultException e) {
                        return null;
                    }
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static RefSyncTracker getUnfinishedTracker() {
        try {
            return (RefSyncTracker)EveKitRefDataProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<RefSyncTracker>(){

                public RefSyncTracker run() throws Exception {
                    TypedQuery getter = EveKitRefDataProvider.getFactory().getEntityManager().createNamedQuery("RefSyncTracker.getUnfinished", RefSyncTracker.class);
                    try {
                        return (RefSyncTracker)getter.getSingleResult();
                    }
                    catch (NoResultException e) {
                        return null;
                    }
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static RefSyncTracker getLatestFinishedTracker() {
        try {
            return (RefSyncTracker)EveKitRefDataProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<RefSyncTracker>(){

                public RefSyncTracker run() throws Exception {
                    TypedQuery getter = EveKitRefDataProvider.getFactory().getEntityManager().createNamedQuery("RefSyncTracker.getLatestFinished", RefSyncTracker.class);
                    getter.setMaxResults(1);
                    try {
                        return (RefSyncTracker)getter.getSingleResult();
                    }
                    catch (NoResultException e) {
                        return null;
                    }
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static RefSyncTracker createOrGetUnfinishedTracker() {
        try {
            return (RefSyncTracker)EveKitRefDataProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<RefSyncTracker>(){

                public RefSyncTracker run() throws Exception {
                    RefSyncTracker result = RefSyncTracker.getUnfinishedTracker();
                    if (result != null) {
                        return result;
                    }
                    result = new RefSyncTracker();
                    result.syncStart = OrbitalProperties.getCurrentTime();
                    result.setFinished(false);
                    return (RefSyncTracker)EveKitRefDataProvider.getFactory().getEntityManager().merge((Object)result);
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static List<RefSyncTracker> getAllUnfinishedTrackers() {
        try {
            return (List)EveKitRefDataProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<List<RefSyncTracker>>(){

                public List<RefSyncTracker> run() throws Exception {
                    TypedQuery getter = EveKitRefDataProvider.getFactory().getEntityManager().createNamedQuery("RefSyncTracker.getUnfinished", RefSyncTracker.class);
                    return getter.getResultList();
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static List<RefSyncTracker> getHistory(final long contid, final int maxResults) {
        try {
            return (List)EveKitRefDataProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<List<RefSyncTracker>>(){

                public List<RefSyncTracker> run() throws Exception {
                    TypedQuery getter = EveKitRefDataProvider.getFactory().getEntityManager().createNamedQuery("RefSyncTracker.getHistory", RefSyncTracker.class);
                    getter.setParameter("start", (Object)(contid < 0L ? Long.MAX_VALUE : contid));
                    getter.setMaxResults(maxResults);
                    return getter.getResultList();
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static List<RefSyncTracker> getSummary(final Date fromDate) {
        try {
            return (List)EveKitRefDataProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<List<RefSyncTracker>>(){

                public List<RefSyncTracker> run() throws Exception {
                    TypedQuery getter = EveKitRefDataProvider.getFactory().getEntityManager().createNamedQuery("RefSyncTracker.getSummary", RefSyncTracker.class);
                    getter.setParameter("account", (Object)fromDate);
                    return getter.getResultList();
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static String summarizeErrors(Date day) throws IOException {
        StringBuilder summary = new StringBuilder();
        summary.append("Reference Sync Tracker Error Summary on ");
        long days = day.getTime() / 86400000L;
        Date dayStart = new Date(days * 1000L * 60L * 60L * 24L + 1L);
        Date nextDay = new Date(dayStart.getTime() + 86400000L - 1L);
        summary.append(DateFormat.getDateInstance().format(dayStart)).append('\n');
        List<RefSyncTracker> result = RefSyncTracker.getSummary(dayStart);
        if (result == null) {
            result = Collections.emptyList();
        }
        int errorCount = 0;
        HashMap<String, Map<String, AtomicInteger>> data = new HashMap<String, Map<String, AtomicInteger>>();
        for (RefSyncTracker next : result) {
            if (new Date(next.getSyncEnd()).after(nextDay)) continue;
            if (next.serverStatusStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("serverStatus", next.serverStatusDetail, data);
                continue;
            }
            if (next.callListStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("callList", next.callListDetail, data);
                continue;
            }
            if (next.allianceListStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("allianceList", next.allianceListDetail, data);
                continue;
            }
            if (next.conquerableStationsStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("conquerableStations", next.conquerableStationsDetail, data);
                continue;
            }
            if (next.errorListStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("errorList", next.errorListDetail, data);
                continue;
            }
            if (next.facWarStatsStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("facWarStats", next.facWarStatsDetail, data);
                continue;
            }
            if (next.facWarTopStatsStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("facWarTopStats", next.facWarTopStatsDetail, data);
                continue;
            }
            if (next.refTypeStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("refType", next.refTypeDetail, data);
                continue;
            }
            if (next.skillTreeStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("skillTree", next.skillTreeDetail, data);
                continue;
            }
            if (next.facWarSystemsStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("facWarSystems", next.facWarSystemsDetail, data);
                continue;
            }
            if (next.mapJumpStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("mapJump", next.mapJumpDetail, data);
                continue;
            }
            if (next.mapKillStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("mapKillStatus", next.mapKillDetail, data);
                continue;
            }
            if (next.sovereigntyStatus != SyncTracker.SyncState.SYNC_ERROR) continue;
            ++errorCount;
            SyncTracker.incrementSummary("sovereignty", next.sovereigntyDetail, data);
        }
        summary.append(errorCount).append(" trackers with errors\n");
        for (String category : data.keySet()) {
            summary.append("Category - ").append(category).append(":\n");
            for (String reason : ((Map)data.get(category)).keySet()) {
                summary.append("    ").append(reason).append(" - ").append(((AtomicInteger)((Map)data.get(category)).get(reason)).get()).append('\n');
            }
            summary.append('\n');
        }
        return summary.toString();
    }
}

