/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.account;

import enterprises.orbital.base.OrbitalProperties;
import enterprises.orbital.db.ConnectionFactory;
import enterprises.orbital.evekit.account.EveKitUserAccount;
import enterprises.orbital.evekit.account.EveKitUserAuthSource;
import enterprises.orbital.oauth.UserAccount;
import enterprises.orbital.oauth.UserAccountProvider;
import enterprises.orbital.oauth.UserAuthSource;

public class EveKitUserAccountProvider
implements UserAccountProvider {
    public static final String USER_ACCOUNT_PU_PROP = "enterprises.orbital.evekit.account.persistence_unit";
    public static final String USER_ACCOUNT_PU_DEFAULT = "evekit-production";

    public static ConnectionFactory getFactory() {
        return ConnectionFactory.getFactory((String)OrbitalProperties.getGlobalProperty((String)USER_ACCOUNT_PU_PROP, (String)USER_ACCOUNT_PU_DEFAULT));
    }

    public UserAccount getAccount(String uid) {
        long user_id = 0L;
        try {
            user_id = Long.valueOf(uid);
        }
        catch (NumberFormatException e) {
            user_id = 0L;
        }
        return EveKitUserAccount.getAccount(user_id);
    }

    public UserAuthSource getSource(UserAccount acct, String source) {
        assert (acct instanceof EveKitUserAccount);
        return EveKitUserAuthSource.getSource((EveKitUserAccount)acct, source);
    }

    public void removeSourceIfExists(UserAccount acct, String source) {
        assert (acct instanceof EveKitUserAccount);
        EveKitUserAuthSource.removeSourceIfExists((EveKitUserAccount)acct, source);
    }

    public UserAuthSource getBySourceScreenname(String source, String screenName) {
        return EveKitUserAuthSource.getBySourceScreenname(source, screenName);
    }

    public UserAuthSource createSource(UserAccount newUser, String source, String screenName, String body) {
        assert (newUser instanceof EveKitUserAccount);
        return EveKitUserAuthSource.createSource((EveKitUserAccount)newUser, source, screenName, body);
    }

    public UserAccount createNewUserAccount(boolean disabled) {
        return EveKitUserAccount.createNewUserAccount(false, !disabled);
    }
}

