/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import enterprises.orbital.base.OrbitalProperties;
import enterprises.orbital.db.ConnectionFactory;
import enterprises.orbital.evekit.account.EveKitUserAccountProvider;
import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.SyncTracker;
import enterprises.orbital.evekit.model.SynchronizationState;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.TypedQuery;

@Entity
@Table(name="evekit_corp_sync")
@NamedQueries(value={@NamedQuery(name="CorporationSyncTracker.get", query="SELECT c FROM CorporationSyncTracker c where c.account = :account and c.syncStart = :start"), @NamedQuery(name="CorporationSyncTracker.getAllUnfinished", query="SELECT c FROM CorporationSyncTracker c where c.finished = false"), @NamedQuery(name="CorporationSyncTracker.getHistory", query="SELECT c FROM CorporationSyncTracker c where c.account = :account and c.finished = true and c.syncStart < :start order by c.syncStart desc"), @NamedQuery(name="CorporationSyncTracker.getSummary", query="SELECT c FROM CorporationSyncTracker c where c.finished = true and c.syncStart >= :start")})
@ApiModel(description="Corporation synchronization tracker entry")
public class CorporationSyncTracker
extends SyncTracker {
    private static final Logger log = Logger.getLogger(CorporationSyncTracker.class.getName());
    @ApiModelProperty(value="Account balance status")
    @JsonProperty(value="accountBalanceStatus")
    private SyncTracker.SyncState accountBalanceStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Account balance detail message")
    @JsonProperty(value="accountBalanceDetail")
    private String accountBalanceDetail;
    @ApiModelProperty(value="Asset list status")
    @JsonProperty(value="assetListStatus")
    private SyncTracker.SyncState assetListStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Asset list detail message")
    @JsonProperty(value="assetListDetail")
    private String assetListDetail;
    @ApiModelProperty(value="Corporation sheet status")
    @JsonProperty(value="corporationSheetStatus")
    private SyncTracker.SyncState corporationSheetStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Corporation sheet detail message")
    @JsonProperty(value="corporationSheetDetail")
    private String corporationSheetDetail;
    @ApiModelProperty(value="Contact list status")
    @JsonProperty(value="contactListStatus")
    private SyncTracker.SyncState contactListStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Contact list detail message")
    @JsonProperty(value="contactListDetail")
    private String contactListDetail;
    @ApiModelProperty(value="Customs office status")
    @JsonProperty(value="customsOfficeStatus")
    private SyncTracker.SyncState customsOfficeStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Customs office detail message")
    @JsonProperty(value="customsOfficeDetail")
    private String customsOfficeDetail;
    @ApiModelProperty(value="Blueprints status")
    @JsonProperty(value="blueprintsStatus")
    private SyncTracker.SyncState blueprintsStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Blueprints detail message")
    @JsonProperty(value="blueprintsDetail")
    private String blueprintsDetail;
    @ApiModelProperty(value="Bookmarks status")
    @JsonProperty(value="bookmarksStatus")
    private SyncTracker.SyncState bookmarksStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Bookmarks detail message")
    @JsonProperty(value="bookmarksDetail")
    private String bookmarksDetail;
    @ApiModelProperty(value="Contracts status")
    @JsonProperty(value="contractsStatus")
    private SyncTracker.SyncState contractsStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Contracts detail message")
    @JsonProperty(value="contractsDetail")
    private String contractsDetail;
    @ApiModelProperty(value="Contract items status")
    @JsonProperty(value="contractItemsStatus")
    private SyncTracker.SyncState contractItemsStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Contract items detail message")
    @JsonProperty(value="contractItemsDetail")
    private String contractItemsDetail;
    @ApiModelProperty(value="Contract bids status")
    @JsonProperty(value="contractBidsStatus")
    private SyncTracker.SyncState contractBidsStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Contract bids detail message")
    @JsonProperty(value="contractBidsDetail")
    private String contractBidsDetail;
    @ApiModelProperty(value="Faction war stats status")
    @JsonProperty(value="facWarStatsStatus")
    private SyncTracker.SyncState facWarStatsStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Faction war stats detail message")
    @JsonProperty(value="facWarStatsDetail")
    private String facWarStatsDetail;
    @ApiModelProperty(value="Facilities status")
    @JsonProperty(value="facilitiesStatus")
    private SyncTracker.SyncState facilitiesStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Facilities detail message")
    @JsonProperty(value="facilitiesDetail")
    private String facilitiesDetail;
    @ApiModelProperty(value="Industry jobs status")
    @JsonProperty(value="industryJobsStatus")
    private SyncTracker.SyncState industryJobsStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Industry jobs detail message")
    @JsonProperty(value="industryJobsDetail")
    private String industryJobsDetail;
    @ApiModelProperty(value="Industry jobs history status")
    @JsonProperty(value="industryJobsHistoryStatus")
    private SyncTracker.SyncState industryJobsHistoryStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Industry jobs history detail message")
    @JsonProperty(value="industryJobsHistoryDetail")
    private String industryJobsHistoryDetail;
    @ApiModelProperty(value="Kill log status")
    @JsonProperty(value="killlogStatus")
    private SyncTracker.SyncState killlogStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Kill log detail message")
    @JsonProperty(value="killlogDetail")
    private String killlogDetail;
    @ApiModelProperty(value="Market orders status")
    @JsonProperty(value="marketOrdersStatus")
    private SyncTracker.SyncState marketOrdersStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Market orders detail message")
    @JsonProperty(value="marketOrdersDetail")
    private String marketOrdersDetail;
    @ApiModelProperty(value="Member medals status")
    @JsonProperty(value="memberMedalsStatus")
    private SyncTracker.SyncState memberMedalsStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Member medals detail message")
    @JsonProperty(value="memberMedalsDetail")
    private String memberMedalsDetail;
    @ApiModelProperty(value="Standings status")
    @JsonProperty(value="standingsStatus")
    private SyncTracker.SyncState standingsStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Standings detail message")
    @JsonProperty(value="standingsDetail")
    private String standingsDetail;
    @ApiModelProperty(value="Wallet journal status")
    @JsonProperty(value="walletJournalStatus")
    private SyncTracker.SyncState walletJournalStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Wallet journal detail message")
    @JsonProperty(value="walletJournalDetail")
    private String walletJournalDetail;
    @ApiModelProperty(value="Wallet transactions status")
    @JsonProperty(value="walletTransactionsStatus")
    private SyncTracker.SyncState walletTransactionsStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Wallet transactions detail message")
    @JsonProperty(value="walletTransactionsDetail")
    private String walletTransactionsDetail;
    @ApiModelProperty(value="Member security status")
    @JsonProperty(value="memberSecurityStatus")
    private SyncTracker.SyncState memberSecurityStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Member security detail message")
    @JsonProperty(value="memberSecurityDetail")
    private String memberSecurityDetail;
    @ApiModelProperty(value="Container log status")
    @JsonProperty(value="containerLogStatus")
    private SyncTracker.SyncState containerLogStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Container log detail message")
    @JsonProperty(value="containerLogDetail")
    private String containerLogDetail;
    @ApiModelProperty(value="Member security log status")
    @JsonProperty(value="memberSecurityLogStatus")
    private SyncTracker.SyncState memberSecurityLogStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Member security log detail message")
    @JsonProperty(value="memberSecurityLogDetail")
    private String memberSecurityLogDetail;
    @ApiModelProperty(value="Member tracking status")
    @JsonProperty(value="memberTrackingStatus")
    private SyncTracker.SyncState memberTrackingStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Member tracking detail message")
    @JsonProperty(value="memberTrackingDetail")
    private String memberTrackingDetail;
    @ApiModelProperty(value="Corporation medals status")
    @JsonProperty(value="corpMedalsStatus")
    private SyncTracker.SyncState corpMedalsStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Corporation medals detail message")
    @JsonProperty(value="corpMedalsDetail")
    private String corpMedalsDetail;
    @ApiModelProperty(value="Outpost list status")
    @JsonProperty(value="outpostListStatus")
    private SyncTracker.SyncState outpostListStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Outpost list detail message")
    @JsonProperty(value="outpostListDetail")
    private String outpostListDetail;
    @ApiModelProperty(value="Outpost detail status")
    @JsonProperty(value="outpostDetailStatus")
    private SyncTracker.SyncState outpostDetailStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Outpost detail detail message")
    @JsonProperty(value="outpostDetailDetail")
    private String outpostDetailDetail;
    @ApiModelProperty(value="Shareholder status")
    @JsonProperty(value="shareholderStatus")
    private SyncTracker.SyncState shareholderStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Shareholder detail message")
    @JsonProperty(value="shareholderDetail")
    private String shareholderDetail;
    @ApiModelProperty(value="Starbase list status")
    @JsonProperty(value="starbaseListStatus")
    private SyncTracker.SyncState starbaseListStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Starbase list detail message")
    @JsonProperty(value="starbaseListDetail")
    private String starbaseListDetail;
    @ApiModelProperty(value="Starbase detail status")
    @JsonProperty(value="starbaseDetailStatus")
    private SyncTracker.SyncState starbaseDetailStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Starbase detail detail message")
    @JsonProperty(value="starbaseDetailDetail")
    private String starbaseDetailDetail;
    @ApiModelProperty(value="Corporation titles status")
    @JsonProperty(value="corpTitlesStatus")
    private SyncTracker.SyncState corpTitlesStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Corporation titles detail message")
    @JsonProperty(value="corpTitlesDetail")
    private String corpTitlesDetail;

    @Override
    public void setState(SynchronizationState state, SyncTracker.SyncState status, String msg) {
        switch (state) {
            case SYNC_CORP_ACCOUNTBALANCE: {
                this.setAccountBalanceStatus(status);
                this.setAccountBalanceDetail(msg);
                break;
            }
            case SYNC_CORP_ASSETLIST: {
                this.setAssetListStatus(status);
                this.setAssetListDetail(msg);
                break;
            }
            case SYNC_CORP_CORPSHEET: {
                this.setCorporationSheetStatus(status);
                this.setCorporationSheetDetail(msg);
                break;
            }
            case SYNC_CORP_CONTACTLIST: {
                this.setContactListStatus(status);
                this.setContactListDetail(msg);
                break;
            }
            case SYNC_CORP_BLUEPRINTS: {
                this.setBlueprintsStatus(status);
                this.setBlueprintsDetail(msg);
                break;
            }
            case SYNC_CORP_BOOKMARKS: {
                this.setBookmarksStatus(status);
                this.setBookmarksDetail(msg);
                break;
            }
            case SYNC_CORP_CONTRACTS: {
                this.setContractsStatus(status);
                this.setContractsDetail(msg);
                break;
            }
            case SYNC_CORP_CONTRACTITEMS: {
                this.setContractItemsStatus(status);
                this.setContractItemsDetail(msg);
                break;
            }
            case SYNC_CORP_CONTRACTBIDS: {
                this.setContractBidsStatus(status);
                this.setContractBidsDetail(msg);
                break;
            }
            case SYNC_CORP_FACWARSTATS: {
                this.setFacWarStatsStatus(status);
                this.setFacWarStatsDetail(msg);
                break;
            }
            case SYNC_CORP_FACILITIES: {
                this.setFacilitiesStatus(status);
                this.setFacilitiesDetail(msg);
                break;
            }
            case SYNC_CORP_INDUSTRYJOBS: {
                this.setIndustryJobsStatus(status);
                this.setIndustryJobsDetail(msg);
                break;
            }
            case SYNC_CORP_INDUSTRYJOBSHISTORY: {
                this.setIndustryJobsHistoryStatus(status);
                this.setIndustryJobsHistoryDetail(msg);
                break;
            }
            case SYNC_CORP_KILLLOG: {
                this.setKilllogStatus(status);
                this.setKilllogDetail(msg);
                break;
            }
            case SYNC_CORP_MARKETORDERS: {
                this.setMarketOrdersStatus(status);
                this.setMarketOrdersDetail(msg);
                break;
            }
            case SYNC_CORP_MEMBERMEDALS: {
                this.setMemberMedalsStatus(status);
                this.setMemberMedalsDetail(msg);
                break;
            }
            case SYNC_CORP_STANDINGS: {
                this.setStandingsStatus(status);
                this.setStandingsDetail(msg);
                break;
            }
            case SYNC_CORP_WALLETJOURNAL: {
                this.setWalletJournalStatus(status);
                this.setWalletJournalDetail(msg);
                break;
            }
            case SYNC_CORP_WALLETTRANSACTIONS: {
                this.setWalletTransactionsStatus(status);
                this.setWalletTransactionsDetail(msg);
                break;
            }
            case SYNC_CORP_SECURITY: {
                this.setMemberSecurityStatus(status);
                this.setMemberSecurityDetail(msg);
                break;
            }
            case SYNC_CORP_CONTAINERLOG: {
                this.setContainerLogStatus(status);
                this.setContainerLogDetail(msg);
                break;
            }
            case SYNC_CORP_MEMBERSECURITYLOG: {
                this.setMemberSecurityLogStatus(status);
                this.setMemberSecurityLogDetail(msg);
                break;
            }
            case SYNC_CORP_MEMBERTRACKING: {
                this.setMemberTrackingStatus(status);
                this.setMemberTrackingDetail(msg);
                break;
            }
            case SYNC_CORP_CORPMEDALS: {
                this.setCorpMedalsStatus(status);
                this.setCorpMedalsDetail(msg);
                break;
            }
            case SYNC_CORP_OUTPOSTLIST: {
                this.setOutpostListStatus(status);
                this.setOutpostListDetail(msg);
                break;
            }
            case SYNC_CORP_OUTPOSTDETAIL: {
                this.setOutpostDetailStatus(status);
                this.setOutpostDetailDetail(msg);
                break;
            }
            case SYNC_CORP_SHAREHOLDERS: {
                this.setShareholderStatus(status);
                this.setShareholderDetail(msg);
                break;
            }
            case SYNC_CORP_STARBASELIST: {
                this.setStarbaseListStatus(status);
                this.setStarbaseListDetail(msg);
                break;
            }
            case SYNC_CORP_STARBASEDETAIL: {
                this.setStarbaseDetailStatus(status);
                this.setStarbaseDetailDetail(msg);
                break;
            }
            case SYNC_CORP_CORPTITLES: {
                this.setCorpTitlesStatus(status);
                this.setCorpTitlesDetail(msg);
                break;
            }
        }
    }

    @Override
    public SynchronizationState trackerComplete(Set<SynchronizationState> checkState) {
        for (SynchronizationState next : checkState) {
            switch (next) {
                case SYNC_CORP_ACCOUNTBALANCE: {
                    if (this.accountBalanceStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CORP_ASSETLIST: {
                    if (this.assetListStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CORP_CORPSHEET: {
                    if (this.corporationSheetStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CORP_CONTACTLIST: {
                    if (this.contactListStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CORP_CUSTOMSOFFICE: {
                    if (this.customsOfficeStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CORP_BLUEPRINTS: {
                    if (this.blueprintsStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CORP_BOOKMARKS: {
                    if (this.bookmarksStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CORP_CONTRACTS: {
                    if (this.contractsStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CORP_CONTRACTITEMS: {
                    if (this.contractsStatus == SyncTracker.SyncState.NOT_PROCESSED || this.contractItemsStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CORP_CONTRACTBIDS: {
                    if (this.contractBidsStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CORP_FACILITIES: {
                    if (this.facilitiesStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CORP_FACWARSTATS: {
                    if (this.facWarStatsStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CORP_INDUSTRYJOBS: {
                    if (this.industryJobsStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CORP_INDUSTRYJOBSHISTORY: {
                    if (this.industryJobsHistoryStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CORP_KILLLOG: {
                    if (this.killlogStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CORP_MARKETORDERS: {
                    if (this.marketOrdersStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CORP_MEMBERMEDALS: {
                    if (this.memberMedalsStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CORP_STANDINGS: {
                    if (this.standingsStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CORP_WALLETJOURNAL: {
                    if (this.walletJournalStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CORP_WALLETTRANSACTIONS: {
                    if (this.walletTransactionsStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CORP_SECURITY: {
                    if (this.memberSecurityStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CORP_CONTAINERLOG: {
                    if (this.containerLogStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CORP_MEMBERSECURITYLOG: {
                    if (this.memberSecurityLogStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CORP_MEMBERTRACKING: {
                    if (this.memberTrackingStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CORP_CORPMEDALS: {
                    if (this.corpMedalsStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CORP_OUTPOSTLIST: {
                    if (this.outpostListStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CORP_OUTPOSTDETAIL: {
                    if (this.outpostListStatus == SyncTracker.SyncState.NOT_PROCESSED || this.outpostDetailStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CORP_SHAREHOLDERS: {
                    if (this.shareholderStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CORP_STARBASELIST: {
                    if (this.starbaseListStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CORP_STARBASEDETAIL: {
                    if (this.starbaseListStatus == SyncTracker.SyncState.NOT_PROCESSED || this.starbaseDetailStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CORP_CORPTITLES: {
                    if (this.corpTitlesStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
            }
        }
        return null;
    }

    public void setMemberMedalsStatus(SyncTracker.SyncState memberMedalsStatus) {
        this.memberMedalsStatus = memberMedalsStatus;
    }

    public void setMemberSecurityStatus(SyncTracker.SyncState memberSecurityStatus) {
        this.memberSecurityStatus = memberSecurityStatus;
    }

    public void setContainerLogStatus(SyncTracker.SyncState containerLogStatus) {
        this.containerLogStatus = containerLogStatus;
    }

    public void setMemberSecurityLogStatus(SyncTracker.SyncState memberSecurityLogStatus) {
        this.memberSecurityLogStatus = memberSecurityLogStatus;
    }

    public void setMemberTrackingStatus(SyncTracker.SyncState memberTrackingStatus) {
        this.memberTrackingStatus = memberTrackingStatus;
    }

    public void setCorpMedalsStatus(SyncTracker.SyncState corpMedalsStatus) {
        this.corpMedalsStatus = corpMedalsStatus;
    }

    public void setOutpostListStatus(SyncTracker.SyncState outpostListStatus) {
        this.outpostListStatus = outpostListStatus;
    }

    public void setOutpostDetailStatus(SyncTracker.SyncState outpostDetailStatus) {
        this.outpostDetailStatus = outpostDetailStatus;
    }

    public void setShareholderStatus(SyncTracker.SyncState shareholderStatus) {
        this.shareholderStatus = shareholderStatus;
    }

    public void setStarbaseListStatus(SyncTracker.SyncState starbaseListStatus) {
        this.starbaseListStatus = starbaseListStatus;
    }

    public void setStarbaseDetailStatus(SyncTracker.SyncState starbaseDetailStatus) {
        this.starbaseDetailStatus = starbaseDetailStatus;
    }

    public void setCorpTitlesStatus(SyncTracker.SyncState corpTitlesStatus) {
        this.corpTitlesStatus = corpTitlesStatus;
    }

    public SyncTracker.SyncState getAccountBalanceStatus() {
        return this.accountBalanceStatus;
    }

    public void setAccountBalanceStatus(SyncTracker.SyncState accountBalanceStatus) {
        this.accountBalanceStatus = accountBalanceStatus;
    }

    public String getAccountBalanceDetail() {
        return this.accountBalanceDetail;
    }

    public void setAccountBalanceDetail(String accountBalanceDetail) {
        this.accountBalanceDetail = accountBalanceDetail;
    }

    public SyncTracker.SyncState getAssetListStatus() {
        return this.assetListStatus;
    }

    public void setAssetListStatus(SyncTracker.SyncState assetListStatus) {
        this.assetListStatus = assetListStatus;
    }

    public String getAssetListDetail() {
        return this.assetListDetail;
    }

    public void setAssetListDetail(String assetListDetail) {
        this.assetListDetail = assetListDetail;
    }

    public SyncTracker.SyncState getCorporationSheetStatus() {
        return this.corporationSheetStatus;
    }

    public void setCorporationSheetStatus(SyncTracker.SyncState corporationSheetStatus) {
        this.corporationSheetStatus = corporationSheetStatus;
    }

    public String getCorporationSheetDetail() {
        return this.corporationSheetDetail;
    }

    public void setCorporationSheetDetail(String corporationSheetDetail) {
        this.corporationSheetDetail = corporationSheetDetail;
    }

    public SyncTracker.SyncState getContactListStatus() {
        return this.contactListStatus;
    }

    public void setContactListStatus(SyncTracker.SyncState contactListStatus) {
        this.contactListStatus = contactListStatus;
    }

    public String getContactListDetail() {
        return this.contactListDetail;
    }

    public void setContactListDetail(String contactListDetail) {
        this.contactListDetail = contactListDetail;
    }

    public SyncTracker.SyncState getCustomsOfficeStatus() {
        return this.customsOfficeStatus;
    }

    public void setCustomsOfficeStatus(SyncTracker.SyncState customsOfficeStatus) {
        this.customsOfficeStatus = customsOfficeStatus;
    }

    public String getCustomsOfficeDetail() {
        return this.customsOfficeDetail;
    }

    public void setCustomsOfficeDetail(String customsOfficeDetail) {
        this.customsOfficeDetail = customsOfficeDetail;
    }

    public SyncTracker.SyncState getBlueprintsStatus() {
        return this.blueprintsStatus;
    }

    public void setBlueprintsStatus(SyncTracker.SyncState blueprintsStatus) {
        this.blueprintsStatus = blueprintsStatus;
    }

    public String getBlueprintsDetail() {
        return this.blueprintsDetail;
    }

    public void setBlueprintsDetail(String blueprintsDetail) {
        this.blueprintsDetail = blueprintsDetail;
    }

    public SyncTracker.SyncState getBookmarksStatus() {
        return this.bookmarksStatus;
    }

    public void setBookmarksStatus(SyncTracker.SyncState bookmarksStatus) {
        this.bookmarksStatus = bookmarksStatus;
    }

    public String getBookmarksDetail() {
        return this.bookmarksDetail;
    }

    public void setBookmarksDetail(String bookmarksDetail) {
        this.bookmarksDetail = bookmarksDetail;
    }

    public SyncTracker.SyncState getContractsStatus() {
        return this.contractsStatus;
    }

    public void setContractsStatus(SyncTracker.SyncState contractsStatus) {
        this.contractsStatus = contractsStatus;
    }

    public String getContractsDetail() {
        return this.contractsDetail;
    }

    public void setContractsDetail(String contractsDetail) {
        this.contractsDetail = contractsDetail;
    }

    public SyncTracker.SyncState getContractItemsStatus() {
        return this.contractItemsStatus;
    }

    public void setContractItemsStatus(SyncTracker.SyncState contractItemsStatus) {
        this.contractItemsStatus = contractItemsStatus;
    }

    public String getContractItemsDetail() {
        return this.contractItemsDetail;
    }

    public void setContractItemsDetail(String contractItemsDetail) {
        this.contractItemsDetail = contractItemsDetail;
    }

    public SyncTracker.SyncState getContractBidsStatus() {
        return this.contractBidsStatus;
    }

    public void setContractBidsStatus(SyncTracker.SyncState contractBidsStatus) {
        this.contractBidsStatus = contractBidsStatus;
    }

    public String getContractBidsDetail() {
        return this.contractBidsDetail;
    }

    public void setContractBidsDetail(String contractBidsDetail) {
        this.contractBidsDetail = contractBidsDetail;
    }

    public SyncTracker.SyncState getFacWarStatsStatus() {
        return this.facWarStatsStatus;
    }

    public void setFacWarStatsStatus(SyncTracker.SyncState facWarStatsStatus) {
        this.facWarStatsStatus = facWarStatsStatus;
    }

    public String getFacWarStatsDetail() {
        return this.facWarStatsDetail;
    }

    public void setFacWarStatsDetail(String facWarStatsDetail) {
        this.facWarStatsDetail = facWarStatsDetail;
    }

    public String getFacilitiesDetail() {
        return this.facilitiesDetail;
    }

    public void setFacilitiesDetail(String facilitiesDetail) {
        this.facilitiesDetail = facilitiesDetail;
    }

    public SyncTracker.SyncState getFacilitiesStatus() {
        return this.facilitiesStatus;
    }

    public void setFacilitiesStatus(SyncTracker.SyncState facilitiesStatus) {
        this.facilitiesStatus = facilitiesStatus;
    }

    public SyncTracker.SyncState getIndustryJobsStatus() {
        return this.industryJobsStatus;
    }

    public void setIndustryJobsStatus(SyncTracker.SyncState industryJobsStatus) {
        this.industryJobsStatus = industryJobsStatus;
    }

    public String getIndustryJobsDetail() {
        return this.industryJobsDetail;
    }

    public void setIndustryJobsDetail(String industryJobsDetail) {
        this.industryJobsDetail = industryJobsDetail;
    }

    public SyncTracker.SyncState getIndustryJobsHistoryStatus() {
        return this.industryJobsHistoryStatus;
    }

    public void setIndustryJobsHistoryStatus(SyncTracker.SyncState industryJobsHistoryStatus) {
        this.industryJobsHistoryStatus = industryJobsHistoryStatus;
    }

    public String getIndustryJobsHistoryDetail() {
        return this.industryJobsHistoryDetail;
    }

    public void setIndustryJobsHistoryDetail(String industryJobsHistoryDetail) {
        this.industryJobsHistoryDetail = industryJobsHistoryDetail;
    }

    public SyncTracker.SyncState getKilllogStatus() {
        return this.killlogStatus;
    }

    public void setKilllogStatus(SyncTracker.SyncState killlogStatus) {
        this.killlogStatus = killlogStatus;
    }

    public String getKilllogDetail() {
        return this.killlogDetail;
    }

    public void setKilllogDetail(String killlogDetail) {
        this.killlogDetail = killlogDetail;
    }

    public SyncTracker.SyncState getMarketOrdersStatus() {
        return this.marketOrdersStatus;
    }

    public void setMarketOrdersStatus(SyncTracker.SyncState marketOrdersStatus) {
        this.marketOrdersStatus = marketOrdersStatus;
    }

    public String getMarketOrdersDetail() {
        return this.marketOrdersDetail;
    }

    public void setMarketOrdersDetail(String marketOrdersDetail) {
        this.marketOrdersDetail = marketOrdersDetail;
    }

    public String getMemberMedalsDetail() {
        return this.memberMedalsDetail;
    }

    public void setMemberMedalsDetail(String memberMedalsDetail) {
        this.memberMedalsDetail = memberMedalsDetail;
    }

    public SyncTracker.SyncState getStandingsStatus() {
        return this.standingsStatus;
    }

    public void setStandingsStatus(SyncTracker.SyncState standingsStatus) {
        this.standingsStatus = standingsStatus;
    }

    public String getStandingsDetail() {
        return this.standingsDetail;
    }

    public void setStandingsDetail(String standingsDetail) {
        this.standingsDetail = standingsDetail;
    }

    public SyncTracker.SyncState getWalletJournalStatus() {
        return this.walletJournalStatus;
    }

    public void setWalletJournalStatus(SyncTracker.SyncState walletJournalStatus) {
        this.walletJournalStatus = walletJournalStatus;
    }

    public String getWalletJournalDetail() {
        return this.walletJournalDetail;
    }

    public void setWalletJournalDetail(String walletJournalDetail) {
        this.walletJournalDetail = walletJournalDetail;
    }

    public SyncTracker.SyncState getWalletTransactionsStatus() {
        return this.walletTransactionsStatus;
    }

    public void setWalletTransactionsStatus(SyncTracker.SyncState walletTransactionsStatus) {
        this.walletTransactionsStatus = walletTransactionsStatus;
    }

    public String getWalletTransactionsDetail() {
        return this.walletTransactionsDetail;
    }

    public void setWalletTransactionsDetail(String walletTransactionsDetail) {
        this.walletTransactionsDetail = walletTransactionsDetail;
    }

    public String getMemberSecurityDetail() {
        return this.memberSecurityDetail;
    }

    public void setMemberSecurityDetail(String memberSecurityDetail) {
        this.memberSecurityDetail = memberSecurityDetail;
    }

    public String getContainerLogDetail() {
        return this.containerLogDetail;
    }

    public void setContainerLogDetail(String containerLogDetail) {
        this.containerLogDetail = containerLogDetail;
    }

    public String getMemberSecurityLogDetail() {
        return this.memberSecurityLogDetail;
    }

    public void setMemberSecurityLogDetail(String memberSecurityLogDetail) {
        this.memberSecurityLogDetail = memberSecurityLogDetail;
    }

    public String getMemberTrackingDetail() {
        return this.memberTrackingDetail;
    }

    public void setMemberTrackingDetail(String memberTrackingDetail) {
        this.memberTrackingDetail = memberTrackingDetail;
    }

    public String getCorpMedalsDetail() {
        return this.corpMedalsDetail;
    }

    public void setCorpMedalsDetail(String corpMedalsDetail) {
        this.corpMedalsDetail = corpMedalsDetail;
    }

    public String getOutpostListDetail() {
        return this.outpostListDetail;
    }

    public void setOutpostListDetail(String outpostListDetail) {
        this.outpostListDetail = outpostListDetail;
    }

    public String getOutpostDetailDetail() {
        return this.outpostDetailDetail;
    }

    public void setOutpostDetailDetail(String outpostDetailDetail) {
        this.outpostDetailDetail = outpostDetailDetail;
    }

    public String getShareholderDetail() {
        return this.shareholderDetail;
    }

    public void setShareholderDetail(String shareholderDetail) {
        this.shareholderDetail = shareholderDetail;
    }

    public String getStarbaseListDetail() {
        return this.starbaseListDetail;
    }

    public void setStarbaseListDetail(String starbaseListDetail) {
        this.starbaseListDetail = starbaseListDetail;
    }

    public String getStarbaseDetailDetail() {
        return this.starbaseDetailDetail;
    }

    public void setStarbaseDetailDetail(String starbaseDetailDetail) {
        this.starbaseDetailDetail = starbaseDetailDetail;
    }

    public String getCorpTitlesDetail() {
        return this.corpTitlesDetail;
    }

    public void setCorpTitlesDetail(String corpTitlesDetail) {
        this.corpTitlesDetail = corpTitlesDetail;
    }

    public SyncTracker.SyncState getMemberMedalsStatus() {
        return this.memberMedalsStatus;
    }

    public SyncTracker.SyncState getMemberSecurityStatus() {
        return this.memberSecurityStatus;
    }

    public SyncTracker.SyncState getContainerLogStatus() {
        return this.containerLogStatus;
    }

    public SyncTracker.SyncState getMemberSecurityLogStatus() {
        return this.memberSecurityLogStatus;
    }

    public SyncTracker.SyncState getMemberTrackingStatus() {
        return this.memberTrackingStatus;
    }

    public SyncTracker.SyncState getCorpMedalsStatus() {
        return this.corpMedalsStatus;
    }

    public SyncTracker.SyncState getOutpostListStatus() {
        return this.outpostListStatus;
    }

    public SyncTracker.SyncState getOutpostDetailStatus() {
        return this.outpostDetailStatus;
    }

    public SyncTracker.SyncState getShareholderStatus() {
        return this.shareholderStatus;
    }

    public SyncTracker.SyncState getStarbaseListStatus() {
        return this.starbaseListStatus;
    }

    public SyncTracker.SyncState getStarbaseDetailStatus() {
        return this.starbaseDetailStatus;
    }

    public SyncTracker.SyncState getCorpTitlesStatus() {
        return this.corpTitlesStatus;
    }

    @Override
    public String toString() {
        return "CorporationSyncTracker [accountBalanceStatus=" + (Object)((Object)this.accountBalanceStatus) + ", accountBalanceDetail=" + this.accountBalanceDetail + ", assetListStatus=" + (Object)((Object)this.assetListStatus) + ", assetListDetail=" + this.assetListDetail + ", corporationSheetStatus=" + (Object)((Object)this.corporationSheetStatus) + ", corporationSheetDetail=" + this.corporationSheetDetail + ", contactListStatus=" + (Object)((Object)this.contactListStatus) + ", contactListDetail=" + this.contactListDetail + ", customsOfficeStatus=" + (Object)((Object)this.customsOfficeStatus) + ", customsOfficeDetail=" + this.customsOfficeDetail + ", blueprintsStatus=" + (Object)((Object)this.blueprintsStatus) + ", blueprintsDetail=" + this.blueprintsDetail + ", bookmarksStatus=" + (Object)((Object)this.bookmarksStatus) + ", bookmarksDetail=" + this.bookmarksDetail + ", contractsStatus=" + (Object)((Object)this.contractsStatus) + ", contractsDetail=" + this.contractsDetail + ", contractItemsStatus=" + (Object)((Object)this.contractItemsStatus) + ", contractItemsDetail=" + this.contractItemsDetail + ", contractBidsStatus=" + (Object)((Object)this.contractBidsStatus) + ", contractBidsDetail=" + this.contractBidsDetail + ", facWarStatsStatus=" + (Object)((Object)this.facWarStatsStatus) + ", facWarStatsDetail=" + this.facWarStatsDetail + ", facilitiesStatus=" + (Object)((Object)this.facilitiesStatus) + ", facilitiesDetail=" + this.facilitiesDetail + ", industryJobsStatus=" + (Object)((Object)this.industryJobsStatus) + ", industryJobsDetail=" + this.industryJobsDetail + ", industryJobsHistoryStatus=" + (Object)((Object)this.industryJobsHistoryStatus) + ", industryJobsHistoryDetail=" + this.industryJobsHistoryDetail + ", killlogStatus=" + (Object)((Object)this.killlogStatus) + ", killlogDetail=" + this.killlogDetail + ", marketOrdersStatus=" + (Object)((Object)this.marketOrdersStatus) + ", marketOrdersDetail=" + this.marketOrdersDetail + ", memberMedalsStatus=" + (Object)((Object)this.memberMedalsStatus) + ", memberMedalsDetail=" + this.memberMedalsDetail + ", standingsStatus=" + (Object)((Object)this.standingsStatus) + ", standingsDetail=" + this.standingsDetail + ", walletJournalStatus=" + (Object)((Object)this.walletJournalStatus) + ", walletJournalDetail=" + this.walletJournalDetail + ", walletTransactionsStatus=" + (Object)((Object)this.walletTransactionsStatus) + ", walletTransactionsDetail=" + this.walletTransactionsDetail + ", memberSecurityStatus=" + (Object)((Object)this.memberSecurityStatus) + ", memberSecurityDetail=" + this.memberSecurityDetail + ", containerLogStatus=" + (Object)((Object)this.containerLogStatus) + ", containerLogDetail=" + this.containerLogDetail + ", memberSecurityLogStatus=" + (Object)((Object)this.memberSecurityLogStatus) + ", memberSecurityLogDetail=" + this.memberSecurityLogDetail + ", memberTrackingStatus=" + (Object)((Object)this.memberTrackingStatus) + ", memberTrackingDetail=" + this.memberTrackingDetail + ", corpMedalsStatus=" + (Object)((Object)this.corpMedalsStatus) + ", corpMedalsDetail=" + this.corpMedalsDetail + ", outpostListStatus=" + (Object)((Object)this.outpostListStatus) + ", outpostListDetail=" + this.outpostListDetail + ", outpostDetailStatus=" + (Object)((Object)this.outpostDetailStatus) + ", outpostDetailDetail=" + this.outpostDetailDetail + ", shareholderStatus=" + (Object)((Object)this.shareholderStatus) + ", shareholderDetail=" + this.shareholderDetail + ", starbaseListStatus=" + (Object)((Object)this.starbaseListStatus) + ", starbaseListDetail=" + this.starbaseListDetail + ", starbaseDetailStatus=" + (Object)((Object)this.starbaseDetailStatus) + ", starbaseDetailDetail=" + this.starbaseDetailDetail + ", corpTitlesStatus=" + (Object)((Object)this.corpTitlesStatus) + ", corpTitlesDetail=" + this.corpTitlesDetail + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.accountBalanceDetail == null ? 0 : this.accountBalanceDetail.hashCode());
        result = 31 * result + (this.accountBalanceStatus == null ? 0 : this.accountBalanceStatus.hashCode());
        result = 31 * result + (this.assetListDetail == null ? 0 : this.assetListDetail.hashCode());
        result = 31 * result + (this.assetListStatus == null ? 0 : this.assetListStatus.hashCode());
        result = 31 * result + (this.blueprintsDetail == null ? 0 : this.blueprintsDetail.hashCode());
        result = 31 * result + (this.blueprintsStatus == null ? 0 : this.blueprintsStatus.hashCode());
        result = 31 * result + (this.bookmarksDetail == null ? 0 : this.bookmarksDetail.hashCode());
        result = 31 * result + (this.bookmarksStatus == null ? 0 : this.bookmarksStatus.hashCode());
        result = 31 * result + (this.contactListDetail == null ? 0 : this.contactListDetail.hashCode());
        result = 31 * result + (this.contactListStatus == null ? 0 : this.contactListStatus.hashCode());
        result = 31 * result + (this.containerLogDetail == null ? 0 : this.containerLogDetail.hashCode());
        result = 31 * result + (this.containerLogStatus == null ? 0 : this.containerLogStatus.hashCode());
        result = 31 * result + (this.contractBidsDetail == null ? 0 : this.contractBidsDetail.hashCode());
        result = 31 * result + (this.contractBidsStatus == null ? 0 : this.contractBidsStatus.hashCode());
        result = 31 * result + (this.contractItemsDetail == null ? 0 : this.contractItemsDetail.hashCode());
        result = 31 * result + (this.contractItemsStatus == null ? 0 : this.contractItemsStatus.hashCode());
        result = 31 * result + (this.contractsDetail == null ? 0 : this.contractsDetail.hashCode());
        result = 31 * result + (this.contractsStatus == null ? 0 : this.contractsStatus.hashCode());
        result = 31 * result + (this.corpMedalsDetail == null ? 0 : this.corpMedalsDetail.hashCode());
        result = 31 * result + (this.corpMedalsStatus == null ? 0 : this.corpMedalsStatus.hashCode());
        result = 31 * result + (this.corpTitlesDetail == null ? 0 : this.corpTitlesDetail.hashCode());
        result = 31 * result + (this.corpTitlesStatus == null ? 0 : this.corpTitlesStatus.hashCode());
        result = 31 * result + (this.corporationSheetDetail == null ? 0 : this.corporationSheetDetail.hashCode());
        result = 31 * result + (this.corporationSheetStatus == null ? 0 : this.corporationSheetStatus.hashCode());
        result = 31 * result + (this.customsOfficeDetail == null ? 0 : this.customsOfficeDetail.hashCode());
        result = 31 * result + (this.customsOfficeStatus == null ? 0 : this.customsOfficeStatus.hashCode());
        result = 31 * result + (this.facWarStatsDetail == null ? 0 : this.facWarStatsDetail.hashCode());
        result = 31 * result + (this.facWarStatsStatus == null ? 0 : this.facWarStatsStatus.hashCode());
        result = 31 * result + (this.facilitiesDetail == null ? 0 : this.facilitiesDetail.hashCode());
        result = 31 * result + (this.facilitiesStatus == null ? 0 : this.facilitiesStatus.hashCode());
        result = 31 * result + (this.industryJobsDetail == null ? 0 : this.industryJobsDetail.hashCode());
        result = 31 * result + (this.industryJobsHistoryDetail == null ? 0 : this.industryJobsHistoryDetail.hashCode());
        result = 31 * result + (this.industryJobsHistoryStatus == null ? 0 : this.industryJobsHistoryStatus.hashCode());
        result = 31 * result + (this.industryJobsStatus == null ? 0 : this.industryJobsStatus.hashCode());
        result = 31 * result + (this.killlogDetail == null ? 0 : this.killlogDetail.hashCode());
        result = 31 * result + (this.killlogStatus == null ? 0 : this.killlogStatus.hashCode());
        result = 31 * result + (this.marketOrdersDetail == null ? 0 : this.marketOrdersDetail.hashCode());
        result = 31 * result + (this.marketOrdersStatus == null ? 0 : this.marketOrdersStatus.hashCode());
        result = 31 * result + (this.memberMedalsDetail == null ? 0 : this.memberMedalsDetail.hashCode());
        result = 31 * result + (this.memberMedalsStatus == null ? 0 : this.memberMedalsStatus.hashCode());
        result = 31 * result + (this.memberSecurityDetail == null ? 0 : this.memberSecurityDetail.hashCode());
        result = 31 * result + (this.memberSecurityLogDetail == null ? 0 : this.memberSecurityLogDetail.hashCode());
        result = 31 * result + (this.memberSecurityLogStatus == null ? 0 : this.memberSecurityLogStatus.hashCode());
        result = 31 * result + (this.memberSecurityStatus == null ? 0 : this.memberSecurityStatus.hashCode());
        result = 31 * result + (this.memberTrackingDetail == null ? 0 : this.memberTrackingDetail.hashCode());
        result = 31 * result + (this.memberTrackingStatus == null ? 0 : this.memberTrackingStatus.hashCode());
        result = 31 * result + (this.outpostDetailDetail == null ? 0 : this.outpostDetailDetail.hashCode());
        result = 31 * result + (this.outpostDetailStatus == null ? 0 : this.outpostDetailStatus.hashCode());
        result = 31 * result + (this.outpostListDetail == null ? 0 : this.outpostListDetail.hashCode());
        result = 31 * result + (this.outpostListStatus == null ? 0 : this.outpostListStatus.hashCode());
        result = 31 * result + (this.shareholderDetail == null ? 0 : this.shareholderDetail.hashCode());
        result = 31 * result + (this.shareholderStatus == null ? 0 : this.shareholderStatus.hashCode());
        result = 31 * result + (this.standingsDetail == null ? 0 : this.standingsDetail.hashCode());
        result = 31 * result + (this.standingsStatus == null ? 0 : this.standingsStatus.hashCode());
        result = 31 * result + (this.starbaseDetailDetail == null ? 0 : this.starbaseDetailDetail.hashCode());
        result = 31 * result + (this.starbaseDetailStatus == null ? 0 : this.starbaseDetailStatus.hashCode());
        result = 31 * result + (this.starbaseListDetail == null ? 0 : this.starbaseListDetail.hashCode());
        result = 31 * result + (this.starbaseListStatus == null ? 0 : this.starbaseListStatus.hashCode());
        result = 31 * result + (this.walletJournalDetail == null ? 0 : this.walletJournalDetail.hashCode());
        result = 31 * result + (this.walletJournalStatus == null ? 0 : this.walletJournalStatus.hashCode());
        result = 31 * result + (this.walletTransactionsDetail == null ? 0 : this.walletTransactionsDetail.hashCode());
        result = 31 * result + (this.walletTransactionsStatus == null ? 0 : this.walletTransactionsStatus.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CorporationSyncTracker other = (CorporationSyncTracker)obj;
        if (this.accountBalanceDetail == null ? other.accountBalanceDetail != null : !this.accountBalanceDetail.equals(other.accountBalanceDetail)) {
            return false;
        }
        if (this.accountBalanceStatus != other.accountBalanceStatus) {
            return false;
        }
        if (this.assetListDetail == null ? other.assetListDetail != null : !this.assetListDetail.equals(other.assetListDetail)) {
            return false;
        }
        if (this.assetListStatus != other.assetListStatus) {
            return false;
        }
        if (this.blueprintsDetail == null ? other.blueprintsDetail != null : !this.blueprintsDetail.equals(other.blueprintsDetail)) {
            return false;
        }
        if (this.blueprintsStatus != other.blueprintsStatus) {
            return false;
        }
        if (this.bookmarksDetail == null ? other.bookmarksDetail != null : !this.bookmarksDetail.equals(other.bookmarksDetail)) {
            return false;
        }
        if (this.bookmarksStatus != other.bookmarksStatus) {
            return false;
        }
        if (this.contactListDetail == null ? other.contactListDetail != null : !this.contactListDetail.equals(other.contactListDetail)) {
            return false;
        }
        if (this.contactListStatus != other.contactListStatus) {
            return false;
        }
        if (this.containerLogDetail == null ? other.containerLogDetail != null : !this.containerLogDetail.equals(other.containerLogDetail)) {
            return false;
        }
        if (this.containerLogStatus != other.containerLogStatus) {
            return false;
        }
        if (this.contractBidsDetail == null ? other.contractBidsDetail != null : !this.contractBidsDetail.equals(other.contractBidsDetail)) {
            return false;
        }
        if (this.contractBidsStatus != other.contractBidsStatus) {
            return false;
        }
        if (this.contractItemsDetail == null ? other.contractItemsDetail != null : !this.contractItemsDetail.equals(other.contractItemsDetail)) {
            return false;
        }
        if (this.contractItemsStatus != other.contractItemsStatus) {
            return false;
        }
        if (this.contractsDetail == null ? other.contractsDetail != null : !this.contractsDetail.equals(other.contractsDetail)) {
            return false;
        }
        if (this.contractsStatus != other.contractsStatus) {
            return false;
        }
        if (this.corpMedalsDetail == null ? other.corpMedalsDetail != null : !this.corpMedalsDetail.equals(other.corpMedalsDetail)) {
            return false;
        }
        if (this.corpMedalsStatus != other.corpMedalsStatus) {
            return false;
        }
        if (this.corpTitlesDetail == null ? other.corpTitlesDetail != null : !this.corpTitlesDetail.equals(other.corpTitlesDetail)) {
            return false;
        }
        if (this.corpTitlesStatus != other.corpTitlesStatus) {
            return false;
        }
        if (this.corporationSheetDetail == null ? other.corporationSheetDetail != null : !this.corporationSheetDetail.equals(other.corporationSheetDetail)) {
            return false;
        }
        if (this.corporationSheetStatus != other.corporationSheetStatus) {
            return false;
        }
        if (this.customsOfficeDetail == null ? other.customsOfficeDetail != null : !this.customsOfficeDetail.equals(other.customsOfficeDetail)) {
            return false;
        }
        if (this.customsOfficeStatus != other.customsOfficeStatus) {
            return false;
        }
        if (this.facWarStatsDetail == null ? other.facWarStatsDetail != null : !this.facWarStatsDetail.equals(other.facWarStatsDetail)) {
            return false;
        }
        if (this.facWarStatsStatus != other.facWarStatsStatus) {
            return false;
        }
        if (this.facilitiesDetail == null ? other.facilitiesDetail != null : !this.facilitiesDetail.equals(other.facilitiesDetail)) {
            return false;
        }
        if (this.facilitiesStatus != other.facilitiesStatus) {
            return false;
        }
        if (this.industryJobsDetail == null ? other.industryJobsDetail != null : !this.industryJobsDetail.equals(other.industryJobsDetail)) {
            return false;
        }
        if (this.industryJobsHistoryDetail == null ? other.industryJobsHistoryDetail != null : !this.industryJobsHistoryDetail.equals(other.industryJobsHistoryDetail)) {
            return false;
        }
        if (this.industryJobsHistoryStatus != other.industryJobsHistoryStatus) {
            return false;
        }
        if (this.industryJobsStatus != other.industryJobsStatus) {
            return false;
        }
        if (this.killlogDetail == null ? other.killlogDetail != null : !this.killlogDetail.equals(other.killlogDetail)) {
            return false;
        }
        if (this.killlogStatus != other.killlogStatus) {
            return false;
        }
        if (this.marketOrdersDetail == null ? other.marketOrdersDetail != null : !this.marketOrdersDetail.equals(other.marketOrdersDetail)) {
            return false;
        }
        if (this.marketOrdersStatus != other.marketOrdersStatus) {
            return false;
        }
        if (this.memberMedalsDetail == null ? other.memberMedalsDetail != null : !this.memberMedalsDetail.equals(other.memberMedalsDetail)) {
            return false;
        }
        if (this.memberMedalsStatus != other.memberMedalsStatus) {
            return false;
        }
        if (this.memberSecurityDetail == null ? other.memberSecurityDetail != null : !this.memberSecurityDetail.equals(other.memberSecurityDetail)) {
            return false;
        }
        if (this.memberSecurityLogDetail == null ? other.memberSecurityLogDetail != null : !this.memberSecurityLogDetail.equals(other.memberSecurityLogDetail)) {
            return false;
        }
        if (this.memberSecurityLogStatus != other.memberSecurityLogStatus) {
            return false;
        }
        if (this.memberSecurityStatus != other.memberSecurityStatus) {
            return false;
        }
        if (this.memberTrackingDetail == null ? other.memberTrackingDetail != null : !this.memberTrackingDetail.equals(other.memberTrackingDetail)) {
            return false;
        }
        if (this.memberTrackingStatus != other.memberTrackingStatus) {
            return false;
        }
        if (this.outpostDetailDetail == null ? other.outpostDetailDetail != null : !this.outpostDetailDetail.equals(other.outpostDetailDetail)) {
            return false;
        }
        if (this.outpostDetailStatus != other.outpostDetailStatus) {
            return false;
        }
        if (this.outpostListDetail == null ? other.outpostListDetail != null : !this.outpostListDetail.equals(other.outpostListDetail)) {
            return false;
        }
        if (this.outpostListStatus != other.outpostListStatus) {
            return false;
        }
        if (this.shareholderDetail == null ? other.shareholderDetail != null : !this.shareholderDetail.equals(other.shareholderDetail)) {
            return false;
        }
        if (this.shareholderStatus != other.shareholderStatus) {
            return false;
        }
        if (this.standingsDetail == null ? other.standingsDetail != null : !this.standingsDetail.equals(other.standingsDetail)) {
            return false;
        }
        if (this.standingsStatus != other.standingsStatus) {
            return false;
        }
        if (this.starbaseDetailDetail == null ? other.starbaseDetailDetail != null : !this.starbaseDetailDetail.equals(other.starbaseDetailDetail)) {
            return false;
        }
        if (this.starbaseDetailStatus != other.starbaseDetailStatus) {
            return false;
        }
        if (this.starbaseListDetail == null ? other.starbaseListDetail != null : !this.starbaseListDetail.equals(other.starbaseListDetail)) {
            return false;
        }
        if (this.starbaseListStatus != other.starbaseListStatus) {
            return false;
        }
        if (this.walletJournalDetail == null ? other.walletJournalDetail != null : !this.walletJournalDetail.equals(other.walletJournalDetail)) {
            return false;
        }
        if (this.walletJournalStatus != other.walletJournalStatus) {
            return false;
        }
        if (this.walletTransactionsDetail == null ? other.walletTransactionsDetail != null : !this.walletTransactionsDetail.equals(other.walletTransactionsDetail)) {
            return false;
        }
        return this.walletTransactionsStatus == other.walletTransactionsStatus;
    }

    public static CorporationSyncTracker createOrGetUnfinishedTracker(final SynchronizedEveAccount syncAccount) {
        try {
            return (CorporationSyncTracker)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<CorporationSyncTracker>(){

                public CorporationSyncTracker run() throws Exception {
                    CorporationSyncTracker result = CorporationSyncTracker.getUnfinishedTracker(syncAccount);
                    if (result != null) {
                        return result;
                    }
                    result = new CorporationSyncTracker();
                    result.account = syncAccount;
                    result.syncStart = OrbitalProperties.getCurrentTime();
                    result.setFinished(false);
                    return (CorporationSyncTracker)EveKitUserAccountProvider.getFactory().getEntityManager().merge((Object)result);
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static CorporationSyncTracker getUnfinishedTracker(SynchronizedEveAccount syncAccount) {
        return (CorporationSyncTracker)SyncTracker.getUnfinishedTracker(syncAccount);
    }

    public static List<CorporationSyncTracker> getAllUnfinishedTrackers() {
        try {
            return (List)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<List<CorporationSyncTracker>>(){

                public List<CorporationSyncTracker> run() throws Exception {
                    TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery("CorporationSyncTracker.getAllUnfinished", CorporationSyncTracker.class);
                    return getter.getResultList();
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static CorporationSyncTracker getLatestFinishedTracker(SynchronizedEveAccount owner) {
        return (CorporationSyncTracker)SyncTracker.getLatestFinishedTracker(owner);
    }

    public static List<CorporationSyncTracker> getHistory(final SynchronizedEveAccount owner, final long contid, final int maxResults) {
        try {
            return (List)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<List<CorporationSyncTracker>>(){

                public List<CorporationSyncTracker> run() throws Exception {
                    TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery("CorporationSyncTracker.getHistory", CorporationSyncTracker.class);
                    getter.setParameter("account", (Object)owner);
                    getter.setParameter("start", (Object)(contid < 0L ? Long.MAX_VALUE : contid));
                    getter.setMaxResults(maxResults);
                    return getter.getResultList();
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static List<CorporationSyncTracker> getSummary(final Date fromDate) {
        try {
            return (List)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<List<CorporationSyncTracker>>(){

                public List<CorporationSyncTracker> run() throws Exception {
                    TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery("CorporationSyncTracker.getSummary", CorporationSyncTracker.class);
                    getter.setParameter("account", (Object)fromDate);
                    return getter.getResultList();
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static String summarizeErrors(Date day) throws IOException {
        StringBuilder summary = new StringBuilder();
        summary.append("Corporation Sync Tracker Error Summary on ");
        long days = day.getTime() / 86400000L;
        Date dayStart = new Date(days * 1000L * 60L * 60L * 24L + 1L);
        Date nextDay = new Date(dayStart.getTime() + 86400000L - 1L);
        summary.append(DateFormat.getDateInstance().format(dayStart)).append('\n');
        List<CorporationSyncTracker> result = CorporationSyncTracker.getSummary(dayStart);
        if (result == null) {
            result = Collections.emptyList();
        }
        int errorCount = 0;
        HashMap<String, Map<String, AtomicInteger>> data = new HashMap<String, Map<String, AtomicInteger>>();
        for (CorporationSyncTracker next : result) {
            if (new Date(next.getSyncEnd()).after(nextDay)) continue;
            if (next.accountBalanceStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("accountBalance", next.accountBalanceDetail, data);
                continue;
            }
            if (next.assetListStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("assetList", next.assetListDetail, data);
                continue;
            }
            if (next.corporationSheetStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("corporationSheet", next.corporationSheetDetail, data);
                continue;
            }
            if (next.contactListStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("contactList", next.contactListDetail, data);
                continue;
            }
            if (next.customsOfficeStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("customsOffice", next.customsOfficeDetail, data);
                continue;
            }
            if (next.blueprintsStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("blueprints", next.blueprintsDetail, data);
                continue;
            }
            if (next.bookmarksStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("bookmarks", next.bookmarksDetail, data);
                continue;
            }
            if (next.contractsStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("contracts", next.contractsDetail, data);
                continue;
            }
            if (next.contractItemsStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("contractItems", next.contractItemsDetail, data);
                continue;
            }
            if (next.contractBidsStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("contractBids", next.contractBidsDetail, data);
                continue;
            }
            if (next.facWarStatsStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("facWarStats", next.facWarStatsDetail, data);
                continue;
            }
            if (next.facilitiesStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("facilities", next.facilitiesDetail, data);
                continue;
            }
            if (next.industryJobsStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("industryJobs", next.industryJobsDetail, data);
                continue;
            }
            if (next.industryJobsHistoryStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("industryJobsHistory", next.industryJobsHistoryDetail, data);
                continue;
            }
            if (next.killlogStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("killlog", next.killlogDetail, data);
                continue;
            }
            if (next.marketOrdersStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("marketOrders", next.marketOrdersDetail, data);
                continue;
            }
            if (next.memberMedalsStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("memberMedals", next.memberMedalsDetail, data);
                continue;
            }
            if (next.standingsStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("standings", next.standingsDetail, data);
                continue;
            }
            if (next.walletJournalStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("walletJournal", next.walletJournalDetail, data);
                continue;
            }
            if (next.walletTransactionsStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("walletTransactions", next.walletTransactionsDetail, data);
                continue;
            }
            if (next.memberSecurityStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("memberSecurity", next.memberSecurityDetail, data);
                continue;
            }
            if (next.containerLogStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("containerLog", next.containerLogDetail, data);
                continue;
            }
            if (next.memberSecurityLogStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("memberSecurityLog", next.memberSecurityLogDetail, data);
                continue;
            }
            if (next.memberTrackingStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("memberTracking", next.memberTrackingDetail, data);
                continue;
            }
            if (next.corpMedalsStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("corpMedals", next.corpMedalsDetail, data);
                continue;
            }
            if (next.outpostListStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("outpostList", next.outpostListDetail, data);
                continue;
            }
            if (next.outpostDetailStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("outpostDetail", next.outpostDetailDetail, data);
                continue;
            }
            if (next.shareholderStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("shareholder", next.shareholderDetail, data);
                continue;
            }
            if (next.starbaseListStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("starbaseList", next.starbaseListDetail, data);
                continue;
            }
            if (next.starbaseDetailStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("starbaseDetail", next.starbaseDetailDetail, data);
                continue;
            }
            if (next.corpTitlesStatus != SyncTracker.SyncState.SYNC_ERROR) continue;
            ++errorCount;
            SyncTracker.incrementSummary("corpTitles", next.corpTitlesDetail, data);
        }
        summary.append(errorCount).append(" trackers with errors\n");
        for (String category : data.keySet()) {
            summary.append("Category - ").append(category).append(":\n");
            for (String reason : ((Map)data.get(category)).keySet()) {
                summary.append("    ").append(reason).append(" - ").append(((AtomicInteger)((Map)data.get(category)).get(reason)).get()).append('\n');
            }
            summary.append('\n');
        }
        return summary.toString();
    }
}

