/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import enterprises.orbital.base.OrbitalProperties;
import enterprises.orbital.db.ConnectionFactory;
import enterprises.orbital.evekit.account.EveKitUserAccountProvider;
import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.SyncTracker;
import enterprises.orbital.evekit.model.SynchronizationState;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.TypedQuery;

@Entity
@Table(name="evekit_char_sync")
@NamedQueries(value={@NamedQuery(name="CapsuleerSyncTracker.get", query="SELECT c FROM CapsuleerSyncTracker c where c.account = :account and c.syncStart = :start"), @NamedQuery(name="CapsuleerSyncTracker.getAllUnfinished", query="SELECT c FROM CapsuleerSyncTracker c where c.finished = false"), @NamedQuery(name="CapsuleerSyncTracker.getHistory", query="SELECT c FROM CapsuleerSyncTracker c where c.account = :account and c.finished = true and c.syncStart < :start order by c.syncStart desc"), @NamedQuery(name="CapsuleerSyncTracker.getSummary", query="SELECT c FROM CapsuleerSyncTracker c where c.finished = true and c.syncStart >= :start")})
@ApiModel(description="Capsuleer synchronization tracker entry")
public class CapsuleerSyncTracker
extends SyncTracker {
    private static final Logger log = Logger.getLogger(CapsuleerSyncTracker.class.getName());
    @ApiModelProperty(value="Account status status")
    @JsonProperty(value="accountStatusStatus")
    private SyncTracker.SyncState accountStatusStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Account status detail message")
    @JsonProperty(value="accountStatusDetail")
    private String accountStatusDetail;
    @ApiModelProperty(value="Account balance status")
    @JsonProperty(value="accountBalanceStatus")
    private SyncTracker.SyncState accountBalanceStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Account balance detail message")
    @JsonProperty(value="accountBalanceDetail")
    private String accountBalanceDetail;
    @ApiModelProperty(value="Asset list status")
    @JsonProperty(value="assetListStatus")
    private SyncTracker.SyncState assetListStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Asset list detail message")
    @JsonProperty(value="assetListDetail")
    private String assetListDetail;
    @ApiModelProperty(value="Calendar event attendees status")
    @JsonProperty(value="calendarEventAttendeesStatus")
    private SyncTracker.SyncState calendarEventAttendeesStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Calendar event attendees detail message")
    @JsonProperty(value="calendarEventAttendeesDetail")
    private String calendarEventAttendeesDetail;
    @ApiModelProperty(value="Character sheet status")
    @JsonProperty(value="characterSheetStatus")
    private SyncTracker.SyncState characterSheetStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Character sheet detail message")
    @JsonProperty(value="characterSheetDetail")
    private String characterSheetDetail;
    @ApiModelProperty(value="Partial character sheet status (clones)")
    @JsonProperty(value="partialCharacterSheetStatus")
    private SyncTracker.SyncState partialCharacterSheetStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Partial character sheet detail message (clones)")
    @JsonProperty(value="partialCharacterSheetDetail")
    private String partialCharacterSheetDetail;
    @ApiModelProperty(value="Chat channel status")
    @JsonProperty(value="chatChannelsStatus")
    private SyncTracker.SyncState chatChannelsStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Chat channel detail message")
    @JsonProperty(value="chatChannelsDetail")
    private String chatChannelsDetail;
    @ApiModelProperty(value="Contact list status")
    @JsonProperty(value="contactListStatus")
    private SyncTracker.SyncState contactListStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Contact list detail message")
    @JsonProperty(value="contactListDetail")
    private String contactListDetail;
    @ApiModelProperty(value="Contact notifications status")
    @JsonProperty(value="contactNotificationsStatus")
    private SyncTracker.SyncState contactNotificationsStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Contact notifications detail message")
    @JsonProperty(value="contactNotificationsDetail")
    private String contactNotificationsDetail;
    @ApiModelProperty(value="Blueprints status")
    @JsonProperty(value="blueprintsStatus")
    private SyncTracker.SyncState blueprintsStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Blueprints detail message")
    @JsonProperty(value="blueprintsDetail")
    private String blueprintsDetail;
    @ApiModelProperty(value="Bookmarks status")
    @JsonProperty(value="bookmarksStatus")
    private SyncTracker.SyncState bookmarksStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Bookmarks detail message")
    @JsonProperty(value="bookmarksDetail")
    private String bookmarksDetail;
    @ApiModelProperty(value="Contracts status")
    @JsonProperty(value="contractsStatus")
    private SyncTracker.SyncState contractsStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Contracts detail message")
    @JsonProperty(value="contractsDetail")
    private String contractsDetail;
    @ApiModelProperty(value="Contract items status")
    @JsonProperty(value="contractItemsStatus")
    private SyncTracker.SyncState contractItemsStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Contract items detail message")
    @JsonProperty(value="contractItemsDetail")
    private String contractItemsDetail;
    @ApiModelProperty(value="Contract bids status")
    @JsonProperty(value="contractBidsStatus")
    private SyncTracker.SyncState contractBidsStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Contract bids detail message")
    @JsonProperty(value="contractBidsDetail")
    private String contractBidsDetail;
    @ApiModelProperty(value="Faction war stats status")
    @JsonProperty(value="facWarStatsStatus")
    private SyncTracker.SyncState facWarStatsStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Faction war stats detail message")
    @JsonProperty(value="facWarStatsDetail")
    private String facWarStatsDetail;
    @ApiModelProperty(value="Industry jobs status")
    @JsonProperty(value="industryJobsStatus")
    private SyncTracker.SyncState industryJobsStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Industry jobs detail message")
    @JsonProperty(value="industryJobsDetail")
    private String industryJobsDetail;
    @ApiModelProperty(value="Industry jobs history status")
    @JsonProperty(value="industryJobsHistoryStatus")
    private SyncTracker.SyncState industryJobsHistoryStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Industry jobs history detail message")
    @JsonProperty(value="industryJobsHistoryDetail")
    private String industryJobsHistoryDetail;
    @ApiModelProperty(value="Kill log status")
    @JsonProperty(value="killlogStatus")
    private SyncTracker.SyncState killlogStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Kill log detail message")
    @JsonProperty(value="killlogDetail")
    private String killlogDetail;
    @ApiModelProperty(value="Mail bodies status")
    @JsonProperty(value="mailBodiesStatus")
    private SyncTracker.SyncState mailBodiesStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Mail bodies detail message")
    @JsonProperty(value="mailBodiesDetail")
    private String mailBodiesDetail;
    @ApiModelProperty(value="Mailing lists status")
    @JsonProperty(value="mailingListsStatus")
    private SyncTracker.SyncState mailingListsStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Mailing lists detail message")
    @JsonProperty(value="mailingListsDetail")
    private String mailingListsDetail;
    @ApiModelProperty(value="Mail messages status")
    @JsonProperty(value="mailMessagesStatus")
    private SyncTracker.SyncState mailMessagesStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Mail messages detail message")
    @JsonProperty(value="mailMessagesDetail")
    private String mailMessagesDetail;
    @ApiModelProperty(value="Market orders status")
    @JsonProperty(value="marketOrdersStatus")
    private SyncTracker.SyncState marketOrdersStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Market orders detail message")
    @JsonProperty(value="marketOrdersDetail")
    private String marketOrdersDetail;
    @ApiModelProperty(value="Medals status")
    @JsonProperty(value="medalsStatus")
    private SyncTracker.SyncState medalsStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Medals detail message")
    @JsonProperty(value="medalsDetail")
    private String medalsDetail;
    @ApiModelProperty(value="Notifications status")
    @JsonProperty(value="notificationsStatus")
    private SyncTracker.SyncState notificationsStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Notifications detail message")
    @JsonProperty(value="notificationsDetail")
    private String notificationsDetail;
    @ApiModelProperty(value="Notification texts status")
    @JsonProperty(value="notificationTextsStatus")
    private SyncTracker.SyncState notificationTextsStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Notification texts detail message")
    @JsonProperty(value="notificationTextsDetail")
    private String notificationTextsDetail;
    @ApiModelProperty(value="Planetary colonies status")
    @JsonProperty(value="planetaryColoniesStatus")
    private SyncTracker.SyncState planetaryColoniesStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Planetary colonies detail message")
    @JsonProperty(value="planetaryColoniesDetail")
    private String planetaryColoniesDetail;
    @ApiModelProperty(value="Research status")
    @JsonProperty(value="researchStatus")
    private SyncTracker.SyncState researchStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Research detail message")
    @JsonProperty(value="researchDetail")
    private String researchDetail;
    @ApiModelProperty(value="Skill in training status")
    @JsonProperty(value="skillInTrainingStatus")
    private SyncTracker.SyncState skillInTrainingStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Skill in training detail message")
    @JsonProperty(value="skillInTrainingDetail")
    private String skillInTrainingDetail;
    @ApiModelProperty(value="Skill queue status")
    @JsonProperty(value="skillQueueStatus")
    private SyncTracker.SyncState skillQueueStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Skill queue detail message")
    @JsonProperty(value="skillQueueDetail")
    private String skillQueueDetail;
    @ApiModelProperty(value="Skills status")
    @JsonProperty(value="skillsStatus")
    private SyncTracker.SyncState skillsStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Skills detail message")
    @JsonProperty(value="skillsDetail")
    private String skillsDetail;
    @ApiModelProperty(value="Standings status")
    @JsonProperty(value="standingsStatus")
    private SyncTracker.SyncState standingsStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Standings detail message")
    @JsonProperty(value="standingsDetail")
    private String standingsDetail;
    @ApiModelProperty(value="Upcoming calendar events status")
    @JsonProperty(value="upcomingCalendarEventsStatus")
    private SyncTracker.SyncState upcomingCalendarEventsStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Upcoming calendar events detail message")
    @JsonProperty(value="upcomingCalendarEventsDetail")
    private String upcomingCalendarEventsDetail;
    @ApiModelProperty(value="Wallet journal status")
    @JsonProperty(value="walletJournalStatus")
    private SyncTracker.SyncState walletJournalStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Wallet journal detail message")
    @JsonProperty(value="walletJournalDetail")
    private String walletJournalDetail;
    @ApiModelProperty(value="Wallet transaction status")
    @JsonProperty(value="walletTransactionsStatus")
    private SyncTracker.SyncState walletTransactionsStatus = SyncTracker.SyncState.NOT_PROCESSED;
    @ApiModelProperty(value="Wallet transaction detail message")
    @JsonProperty(value="walletTransactionsDetail")
    private String walletTransactionsDetail;

    @Override
    public void setState(SynchronizationState state, SyncTracker.SyncState status, String msg) {
        switch (state) {
            case SYNC_CHAR_ACCOUNTSTATUS: {
                this.setAccountStatusStatus(status);
                this.setAccountStatusDetail(msg);
                break;
            }
            case SYNC_CHAR_ACCOUNTBALANCE: {
                this.setAccountBalanceStatus(status);
                this.setAccountBalanceDetail(msg);
                break;
            }
            case SYNC_CHAR_ASSETLIST: {
                this.setAssetListStatus(status);
                this.setAssetListDetail(msg);
                break;
            }
            case SYNC_CHAR_CALENDAREVENTATTENDEES: {
                this.setCalendarEventAttendeesStatus(status);
                this.setCalendarEventAttendeesDetail(msg);
                break;
            }
            case SYNC_CHAR_CHARACTERSHEET: {
                this.setCharacterSheetStatus(status);
                this.setCharacterSheetDetail(msg);
                break;
            }
            case SYNC_CHAR_PARTIALCHARACTERSHEET: {
                this.setPartialCharacterSheetStatus(status);
                this.setPartialCharacterSheetDetail(msg);
                break;
            }
            case SYNC_CHAR_CHATCHANNELS: {
                this.setChatChannelsStatus(status);
                this.setChatChannelsDetail(msg);
                break;
            }
            case SYNC_CHAR_CONTACTLIST: {
                this.setContactListStatus(status);
                this.setContactListDetail(msg);
                break;
            }
            case SYNC_CHAR_CONTACTNOTIFICATIONS: {
                this.setContactNotificationsStatus(status);
                this.setContactNotificationsDetail(msg);
                break;
            }
            case SYNC_CHAR_BLUEPRINTS: {
                this.setBlueprintsStatus(status);
                this.setBlueprintsDetail(msg);
                break;
            }
            case SYNC_CHAR_BOOKMARKS: {
                this.setBookmarksStatus(status);
                this.setBookmarksDetail(msg);
                break;
            }
            case SYNC_CHAR_CONTRACTS: {
                this.setContractsStatus(status);
                this.setContractsDetail(msg);
                break;
            }
            case SYNC_CHAR_CONTRACTITEMS: {
                this.setContractItemsStatus(status);
                this.setContractItemsDetail(msg);
                break;
            }
            case SYNC_CHAR_CONTRACTBIDS: {
                this.setContractBidsStatus(status);
                this.setContractBidsDetail(msg);
                break;
            }
            case SYNC_CHAR_FACWARSTATS: {
                this.setFacWarStatsStatus(status);
                this.setFacWarStatsDetail(msg);
                break;
            }
            case SYNC_CHAR_INDUSTRYJOBS: {
                this.setIndustryJobsStatus(status);
                this.setIndustryJobsDetail(msg);
                break;
            }
            case SYNC_CHAR_INDUSTRYJOBSHISTORY: {
                this.setIndustryJobsHistoryStatus(status);
                this.setIndustryJobsHistoryDetail(msg);
                break;
            }
            case SYNC_CHAR_KILLLOG: {
                this.setKilllogStatus(status);
                this.setKilllogDetail(msg);
                break;
            }
            case SYNC_CHAR_MAILBODIES: {
                this.setMailBodiesStatus(status);
                this.setMailBodiesDetail(msg);
                break;
            }
            case SYNC_CHAR_MAILINGLISTS: {
                this.setMailingListsStatus(status);
                this.setMailingListsDetail(msg);
                break;
            }
            case SYNC_CHAR_MAILMESSAGES: {
                this.setMailMessagesStatus(status);
                this.setMailMessagesDetail(msg);
                break;
            }
            case SYNC_CHAR_MARKETORDERS: {
                this.setMarketOrdersStatus(status);
                this.setMarketOrdersDetail(msg);
                break;
            }
            case SYNC_CHAR_MEDALS: {
                this.setMedalsStatus(status);
                this.setMedalsDetail(msg);
                break;
            }
            case SYNC_CHAR_NOTIFICATIONS: {
                this.setNotificationsStatus(status);
                this.setNotificationsDetail(msg);
                break;
            }
            case SYNC_CHAR_NOTIFICATIONTEXTS: {
                this.setNotificationTextsStatus(status);
                this.setNotificationTextsDetail(msg);
                break;
            }
            case SYNC_CHAR_PLANETARY_COLONIES: {
                this.setPlanetaryColoniesStatus(status);
                this.setPlanetaryColoniesDetail(msg);
                break;
            }
            case SYNC_CHAR_RESEARCH: {
                this.setResearchStatus(status);
                this.setResearchDetail(msg);
                break;
            }
            case SYNC_CHAR_SKILLINTRAINING: {
                this.setSkillInTrainingStatus(status);
                this.setSkillInTrainingDetail(msg);
                break;
            }
            case SYNC_CHAR_SKILLQUEUE: {
                this.setSkillQueueStatus(status);
                this.setSkillQueueDetail(msg);
                break;
            }
            case SYNC_CHAR_SKILLS: {
                this.setSkillsStatus(status);
                this.setSkillsDetail(msg);
                break;
            }
            case SYNC_CHAR_STANDINGS: {
                this.setStandingsStatus(status);
                this.setStandingsDetail(msg);
                break;
            }
            case SYNC_CHAR_UPCOMINGCALENDAREVENTS: {
                this.setUpcomingCalendarEventsStatus(status);
                this.setUpcomingCalendarEventsDetail(msg);
                break;
            }
            case SYNC_CHAR_WALLETJOURNAL: {
                this.setWalletJournalStatus(status);
                this.setWalletJournalDetail(msg);
                break;
            }
            case SYNC_CHAR_WALLETTRANSACTIONS: {
                this.setWalletTransactionsStatus(status);
                this.setWalletTransactionsDetail(msg);
                break;
            }
        }
    }

    @Override
    public SynchronizationState trackerComplete(Set<SynchronizationState> checkState) {
        for (SynchronizationState next : checkState) {
            switch (next) {
                case SYNC_CHAR_ACCOUNTSTATUS: {
                    if (this.accountStatusStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_ACCOUNTBALANCE: {
                    if (this.accountBalanceStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_ASSETLIST: {
                    if (this.assetListStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_CALENDAREVENTATTENDEES: {
                    if (this.upcomingCalendarEventsStatus == SyncTracker.SyncState.NOT_PROCESSED || this.characterSheetStatus == SyncTracker.SyncState.NOT_PROCESSED || this.calendarEventAttendeesStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_CHARACTERSHEET: {
                    if (this.characterSheetStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_PARTIALCHARACTERSHEET: {
                    if (this.characterSheetStatus == SyncTracker.SyncState.NOT_PROCESSED || this.partialCharacterSheetStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_CHATCHANNELS: {
                    if (this.chatChannelsStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_CONTACTLIST: {
                    if (this.contactListStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_CONTACTNOTIFICATIONS: {
                    if (this.contactNotificationsStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_BLUEPRINTS: {
                    if (this.blueprintsStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_BOOKMARKS: {
                    if (this.bookmarksStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_CONTRACTS: {
                    if (this.contractsStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_CONTRACTITEMS: {
                    if (this.contractsStatus == SyncTracker.SyncState.NOT_PROCESSED || this.contractItemsStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_CONTRACTBIDS: {
                    if (this.contractBidsStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_FACWARSTATS: {
                    if (this.facWarStatsStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_INDUSTRYJOBS: {
                    if (this.industryJobsStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_INDUSTRYJOBSHISTORY: {
                    if (this.industryJobsHistoryStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_KILLLOG: {
                    if (this.killlogStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_MAILBODIES: {
                    if (this.mailMessagesStatus == SyncTracker.SyncState.NOT_PROCESSED || this.mailBodiesStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_MAILINGLISTS: {
                    if (this.mailingListsStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_MAILMESSAGES: {
                    if (this.mailMessagesStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_MARKETORDERS: {
                    if (this.marketOrdersStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_MEDALS: {
                    if (this.medalsStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_NOTIFICATIONS: {
                    if (this.notificationsStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_NOTIFICATIONTEXTS: {
                    if (this.notificationsStatus == SyncTracker.SyncState.NOT_PROCESSED || this.notificationTextsStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_PLANETARY_COLONIES: {
                    if (this.planetaryColoniesStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_RESEARCH: {
                    if (this.researchStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_SKILLINTRAINING: {
                    if (this.skillInTrainingStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_SKILLQUEUE: {
                    if (this.skillQueueStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_SKILLS: {
                    if (this.characterSheetStatus == SyncTracker.SyncState.NOT_PROCESSED || this.skillsStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_STANDINGS: {
                    if (this.standingsStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_UPCOMINGCALENDAREVENTS: {
                    if (this.upcomingCalendarEventsStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_WALLETJOURNAL: {
                    if (this.walletJournalStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
                case SYNC_CHAR_WALLETTRANSACTIONS: {
                    if (this.walletTransactionsStatus != SyncTracker.SyncState.NOT_PROCESSED) break;
                    return next;
                }
            }
        }
        return null;
    }

    public SyncTracker.SyncState getAccountStatusStatus() {
        return this.accountStatusStatus;
    }

    public void setAccountStatusStatus(SyncTracker.SyncState accountStatus) {
        this.accountStatusStatus = accountStatus;
    }

    public String getAccountStatusDetail() {
        return this.accountStatusDetail;
    }

    public void setAccountStatusDetail(String accountDetail) {
        this.accountStatusDetail = accountDetail;
    }

    public SyncTracker.SyncState getAccountBalanceStatus() {
        return this.accountBalanceStatus;
    }

    public void setAccountBalanceStatus(SyncTracker.SyncState accountBalanceStatus) {
        this.accountBalanceStatus = accountBalanceStatus;
    }

    public String getAccountBalanceDetail() {
        return this.accountBalanceDetail;
    }

    public void setAccountBalanceDetail(String accountBalanceDetail) {
        this.accountBalanceDetail = accountBalanceDetail;
    }

    public SyncTracker.SyncState getAssetListStatus() {
        return this.assetListStatus;
    }

    public void setAssetListStatus(SyncTracker.SyncState assetListStatus) {
        this.assetListStatus = assetListStatus;
    }

    public String getAssetListDetail() {
        return this.assetListDetail;
    }

    public void setAssetListDetail(String assetListDetail) {
        this.assetListDetail = assetListDetail;
    }

    public SyncTracker.SyncState getCalendarEventAttendeesStatus() {
        return this.calendarEventAttendeesStatus;
    }

    public void setCalendarEventAttendeesStatus(SyncTracker.SyncState calendarEventAttendeesStatus) {
        this.calendarEventAttendeesStatus = calendarEventAttendeesStatus;
    }

    public String getCalendarEventAttendeesDetail() {
        return this.calendarEventAttendeesDetail;
    }

    public void setCalendarEventAttendeesDetail(String calendarEventAttendeesDetail) {
        this.calendarEventAttendeesDetail = calendarEventAttendeesDetail;
    }

    public SyncTracker.SyncState getCharacterSheetStatus() {
        return this.characterSheetStatus;
    }

    public void setCharacterSheetStatus(SyncTracker.SyncState characterSheetStatus) {
        this.characterSheetStatus = characterSheetStatus;
    }

    public String getCharacterSheetDetail() {
        return this.characterSheetDetail;
    }

    public void setCharacterSheetDetail(String characterSheetDetail) {
        this.characterSheetDetail = characterSheetDetail;
    }

    public SyncTracker.SyncState getPartialCharacterSheetStatus() {
        return this.partialCharacterSheetStatus;
    }

    public void setPartialCharacterSheetStatus(SyncTracker.SyncState partialCharacterSheetStatus) {
        this.partialCharacterSheetStatus = partialCharacterSheetStatus;
    }

    public String getPartialCharacterSheetDetail() {
        return this.partialCharacterSheetDetail;
    }

    public void setPartialCharacterSheetDetail(String partialCharacterSheetDetail) {
        this.partialCharacterSheetDetail = partialCharacterSheetDetail;
    }

    public SyncTracker.SyncState getChatChannelsStatus() {
        return this.chatChannelsStatus;
    }

    public void setChatChannelsStatus(SyncTracker.SyncState chatChannelsStatus) {
        this.chatChannelsStatus = chatChannelsStatus;
    }

    public String getChatChannelsDetail() {
        return this.chatChannelsDetail;
    }

    public void setChatChannelsDetail(String chatChannelsDetail) {
        this.chatChannelsDetail = chatChannelsDetail;
    }

    public SyncTracker.SyncState getContactListStatus() {
        return this.contactListStatus;
    }

    public void setContactListStatus(SyncTracker.SyncState contactListStatus) {
        this.contactListStatus = contactListStatus;
    }

    public String getContactListDetail() {
        return this.contactListDetail;
    }

    public void setContactListDetail(String contactListDetail) {
        this.contactListDetail = contactListDetail;
    }

    public SyncTracker.SyncState getContactNotificationsStatus() {
        return this.contactNotificationsStatus;
    }

    public void setContactNotificationsStatus(SyncTracker.SyncState contactNotificationsStatus) {
        this.contactNotificationsStatus = contactNotificationsStatus;
    }

    public String getContactNotificationsDetail() {
        return this.contactNotificationsDetail;
    }

    public void setContactNotificationsDetail(String contactNotificationsDetail) {
        this.contactNotificationsDetail = contactNotificationsDetail;
    }

    public String getBlueprintsDetail() {
        return this.blueprintsDetail;
    }

    public void setBlueprintsDetail(String blueprintsDetail) {
        this.blueprintsDetail = blueprintsDetail;
    }

    public String getBookmarksDetail() {
        return this.bookmarksDetail;
    }

    public void setBookmarksDetail(String bookmarksDetail) {
        this.bookmarksDetail = bookmarksDetail;
    }

    public String getContractsDetail() {
        return this.contractsDetail;
    }

    public void setContractsDetail(String contractDetail) {
        this.contractsDetail = contractDetail;
    }

    public String getContractItemsDetail() {
        return this.contractItemsDetail;
    }

    public void setContractItemsDetail(String contractItemDetail) {
        this.contractItemsDetail = contractItemDetail;
    }

    public String getContractBidsDetail() {
        return this.contractBidsDetail;
    }

    public void setContractBidsDetail(String contractBidsDetail) {
        this.contractBidsDetail = contractBidsDetail;
    }

    public SyncTracker.SyncState getBlueprintsStatus() {
        return this.blueprintsStatus;
    }

    public void setBlueprintsStatus(SyncTracker.SyncState status) {
        this.blueprintsStatus = status;
    }

    public SyncTracker.SyncState getBookmarksStatus() {
        return this.bookmarksStatus;
    }

    public void setBookmarksStatus(SyncTracker.SyncState status) {
        this.bookmarksStatus = status;
    }

    public SyncTracker.SyncState getContractsStatus() {
        return this.contractsStatus;
    }

    public void setContractsStatus(SyncTracker.SyncState status) {
        this.contractsStatus = status;
    }

    public SyncTracker.SyncState getContractItemsStatus() {
        return this.contractItemsStatus;
    }

    public void setContractItemsStatus(SyncTracker.SyncState status) {
        this.contractItemsStatus = status;
    }

    public SyncTracker.SyncState getContractBidsStatus() {
        return this.contractBidsStatus;
    }

    public void setContractBidsStatus(SyncTracker.SyncState status) {
        this.contractBidsStatus = status;
    }

    public SyncTracker.SyncState getFacWarStatsStatus() {
        return this.facWarStatsStatus;
    }

    public void setFacWarStatsStatus(SyncTracker.SyncState facWarStatsStatus) {
        this.facWarStatsStatus = facWarStatsStatus;
    }

    public String getFacWarStatsDetail() {
        return this.facWarStatsDetail;
    }

    public void setFacWarStatsDetail(String facWarStatsDetail) {
        this.facWarStatsDetail = facWarStatsDetail;
    }

    public SyncTracker.SyncState getIndustryJobsStatus() {
        return this.industryJobsStatus;
    }

    public void setIndustryJobsStatus(SyncTracker.SyncState industryJobsStatus) {
        this.industryJobsStatus = industryJobsStatus;
    }

    public String getIndustryJobsDetail() {
        return this.industryJobsDetail;
    }

    public void setIndustryJobsDetail(String industryJobsDetail) {
        this.industryJobsDetail = industryJobsDetail;
    }

    public SyncTracker.SyncState getIndustryJobsHistoryStatus() {
        return this.industryJobsHistoryStatus;
    }

    public void setIndustryJobsHistoryStatus(SyncTracker.SyncState industryJobsHistoryStatus) {
        this.industryJobsHistoryStatus = industryJobsHistoryStatus;
    }

    public String getIndustryJobsHistoryDetail() {
        return this.industryJobsHistoryDetail;
    }

    public void setIndustryJobsHistoryDetail(String industryJobsHistoryDetail) {
        this.industryJobsHistoryDetail = industryJobsHistoryDetail;
    }

    public SyncTracker.SyncState getKilllogStatus() {
        return this.killlogStatus;
    }

    public void setKilllogStatus(SyncTracker.SyncState killlogStatus) {
        this.killlogStatus = killlogStatus;
    }

    public String getKilllogDetail() {
        return this.killlogDetail;
    }

    public void setKilllogDetail(String killlogDetail) {
        this.killlogDetail = killlogDetail;
    }

    public SyncTracker.SyncState getMailBodiesStatus() {
        return this.mailBodiesStatus;
    }

    public void setMailBodiesStatus(SyncTracker.SyncState mailBodiesStatus) {
        this.mailBodiesStatus = mailBodiesStatus;
    }

    public String getMailBodiesDetail() {
        return this.mailBodiesDetail;
    }

    public void setMailBodiesDetail(String mailBodiesDetail) {
        this.mailBodiesDetail = mailBodiesDetail;
    }

    public SyncTracker.SyncState getMailingListsStatus() {
        return this.mailingListsStatus;
    }

    public void setMailingListsStatus(SyncTracker.SyncState mailingListsStatus) {
        this.mailingListsStatus = mailingListsStatus;
    }

    public String getMailingListsDetail() {
        return this.mailingListsDetail;
    }

    public void setMailingListsDetail(String mailingListsDetail) {
        this.mailingListsDetail = mailingListsDetail;
    }

    public SyncTracker.SyncState getMailMessagesStatus() {
        return this.mailMessagesStatus;
    }

    public void setMailMessagesStatus(SyncTracker.SyncState mailMessagesStatus) {
        this.mailMessagesStatus = mailMessagesStatus;
    }

    public String getMailMessagesDetail() {
        return this.mailMessagesDetail;
    }

    public void setMailMessagesDetail(String mailMessagesDetail) {
        this.mailMessagesDetail = mailMessagesDetail;
    }

    public SyncTracker.SyncState getMarketOrdersStatus() {
        return this.marketOrdersStatus;
    }

    public void setMarketOrdersStatus(SyncTracker.SyncState marketOrdersStatus) {
        this.marketOrdersStatus = marketOrdersStatus;
    }

    public String getMarketOrdersDetail() {
        return this.marketOrdersDetail;
    }

    public void setMarketOrdersDetail(String marketOrdersDetail) {
        this.marketOrdersDetail = marketOrdersDetail;
    }

    public SyncTracker.SyncState getMedalsStatus() {
        return this.medalsStatus;
    }

    public void setMedalsStatus(SyncTracker.SyncState medalsStatus) {
        this.medalsStatus = medalsStatus;
    }

    public String getMedalsDetail() {
        return this.medalsDetail;
    }

    public void setMedalsDetail(String medalsDetail) {
        this.medalsDetail = medalsDetail;
    }

    public SyncTracker.SyncState getNotificationsStatus() {
        return this.notificationsStatus;
    }

    public void setNotificationsStatus(SyncTracker.SyncState notificationsStatus) {
        this.notificationsStatus = notificationsStatus;
    }

    public String getNotificationsDetail() {
        return this.notificationsDetail;
    }

    public void setNotificationsDetail(String notificationsDetail) {
        this.notificationsDetail = notificationsDetail;
    }

    public SyncTracker.SyncState getNotificationTextsStatus() {
        return this.notificationTextsStatus;
    }

    public void setNotificationTextsStatus(SyncTracker.SyncState notificationTextsStatus) {
        this.notificationTextsStatus = notificationTextsStatus;
    }

    public String getNotificationTextsDetail() {
        return this.notificationTextsDetail;
    }

    public void setNotificationTextsDetail(String notificationTextsDetail) {
        this.notificationTextsDetail = notificationTextsDetail;
    }

    public SyncTracker.SyncState getPlanetaryColoniesStatus() {
        return this.planetaryColoniesStatus;
    }

    public void setPlanetaryColoniesStatus(SyncTracker.SyncState planetaryColoniesStatus) {
        this.planetaryColoniesStatus = planetaryColoniesStatus;
    }

    public String getPlanetaryColoniesDetail() {
        return this.planetaryColoniesDetail;
    }

    public void setPlanetaryColoniesDetail(String planetaryColoniesDetail) {
        this.planetaryColoniesDetail = planetaryColoniesDetail;
    }

    public SyncTracker.SyncState getResearchStatus() {
        return this.researchStatus;
    }

    public void setResearchStatus(SyncTracker.SyncState researchStatus) {
        this.researchStatus = researchStatus;
    }

    public String getResearchDetail() {
        return this.researchDetail;
    }

    public void setResearchDetail(String researchDetail) {
        this.researchDetail = researchDetail;
    }

    public SyncTracker.SyncState getSkillInTrainingStatus() {
        return this.skillInTrainingStatus;
    }

    public void setSkillInTrainingStatus(SyncTracker.SyncState skillInTrainingStatus) {
        this.skillInTrainingStatus = skillInTrainingStatus;
    }

    public String getSkillInTrainingDetail() {
        return this.skillInTrainingDetail;
    }

    public void setSkillInTrainingDetail(String skillInTrainingDetail) {
        this.skillInTrainingDetail = skillInTrainingDetail;
    }

    public SyncTracker.SyncState getSkillQueueStatus() {
        return this.skillQueueStatus;
    }

    public void setSkillQueueStatus(SyncTracker.SyncState skillQueueStatus) {
        this.skillQueueStatus = skillQueueStatus;
    }

    public String getSkillQueueDetail() {
        return this.skillQueueDetail;
    }

    public void setSkillQueueDetail(String skillQueueDetail) {
        this.skillQueueDetail = skillQueueDetail;
    }

    public SyncTracker.SyncState getSkillsStatus() {
        return this.skillsStatus;
    }

    public void setSkillsStatus(SyncTracker.SyncState skillsStatus) {
        this.skillsStatus = skillsStatus;
    }

    public String getSkillsDetail() {
        return this.skillsDetail;
    }

    public void setSkillsDetail(String skillsDetail) {
        this.skillsDetail = skillsDetail;
    }

    public SyncTracker.SyncState getStandingsStatus() {
        return this.standingsStatus;
    }

    public void setStandingsStatus(SyncTracker.SyncState standingsStatus) {
        this.standingsStatus = standingsStatus;
    }

    public String getStandingsDetail() {
        return this.standingsDetail;
    }

    public void setStandingsDetail(String standingsDetail) {
        this.standingsDetail = standingsDetail;
    }

    public SyncTracker.SyncState getUpcomingCalendarEventsStatus() {
        return this.upcomingCalendarEventsStatus;
    }

    public void setUpcomingCalendarEventsStatus(SyncTracker.SyncState upcomingCalendarEventsStatus) {
        this.upcomingCalendarEventsStatus = upcomingCalendarEventsStatus;
    }

    public String getUpcomingCalendarEventsDetail() {
        return this.upcomingCalendarEventsDetail;
    }

    public void setUpcomingCalendarEventsDetail(String upcomingCalendarEventsDetail) {
        this.upcomingCalendarEventsDetail = upcomingCalendarEventsDetail;
    }

    public SyncTracker.SyncState getWalletJournalStatus() {
        return this.walletJournalStatus;
    }

    public void setWalletJournalStatus(SyncTracker.SyncState walletJournalStatus) {
        this.walletJournalStatus = walletJournalStatus;
    }

    public String getWalletJournalDetail() {
        return this.walletJournalDetail;
    }

    public void setWalletJournalDetail(String walletJournalDetail) {
        this.walletJournalDetail = walletJournalDetail;
    }

    public SyncTracker.SyncState getWalletTransactionsStatus() {
        return this.walletTransactionsStatus;
    }

    public void setWalletTransactionsStatus(SyncTracker.SyncState walletTransactionsStatus) {
        this.walletTransactionsStatus = walletTransactionsStatus;
    }

    public String getWalletTransactionsDetail() {
        return this.walletTransactionsDetail;
    }

    public void setWalletTransactionsDetail(String walletTransactionsDetail) {
        this.walletTransactionsDetail = walletTransactionsDetail;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.accountBalanceDetail == null ? 0 : this.accountBalanceDetail.hashCode());
        result = 31 * result + (this.accountBalanceStatus == null ? 0 : this.accountBalanceStatus.hashCode());
        result = 31 * result + (this.accountStatusDetail == null ? 0 : this.accountStatusDetail.hashCode());
        result = 31 * result + (this.accountStatusStatus == null ? 0 : this.accountStatusStatus.hashCode());
        result = 31 * result + (this.assetListDetail == null ? 0 : this.assetListDetail.hashCode());
        result = 31 * result + (this.assetListStatus == null ? 0 : this.assetListStatus.hashCode());
        result = 31 * result + (this.blueprintsDetail == null ? 0 : this.blueprintsDetail.hashCode());
        result = 31 * result + (this.blueprintsStatus == null ? 0 : this.blueprintsStatus.hashCode());
        result = 31 * result + (this.bookmarksDetail == null ? 0 : this.bookmarksDetail.hashCode());
        result = 31 * result + (this.bookmarksStatus == null ? 0 : this.bookmarksStatus.hashCode());
        result = 31 * result + (this.calendarEventAttendeesDetail == null ? 0 : this.calendarEventAttendeesDetail.hashCode());
        result = 31 * result + (this.calendarEventAttendeesStatus == null ? 0 : this.calendarEventAttendeesStatus.hashCode());
        result = 31 * result + (this.characterSheetDetail == null ? 0 : this.characterSheetDetail.hashCode());
        result = 31 * result + (this.characterSheetStatus == null ? 0 : this.characterSheetStatus.hashCode());
        result = 31 * result + (this.chatChannelsDetail == null ? 0 : this.chatChannelsDetail.hashCode());
        result = 31 * result + (this.chatChannelsStatus == null ? 0 : this.chatChannelsStatus.hashCode());
        result = 31 * result + (this.contactListDetail == null ? 0 : this.contactListDetail.hashCode());
        result = 31 * result + (this.contactListStatus == null ? 0 : this.contactListStatus.hashCode());
        result = 31 * result + (this.contactNotificationsDetail == null ? 0 : this.contactNotificationsDetail.hashCode());
        result = 31 * result + (this.contactNotificationsStatus == null ? 0 : this.contactNotificationsStatus.hashCode());
        result = 31 * result + (this.contractBidsDetail == null ? 0 : this.contractBidsDetail.hashCode());
        result = 31 * result + (this.contractBidsStatus == null ? 0 : this.contractBidsStatus.hashCode());
        result = 31 * result + (this.contractItemsDetail == null ? 0 : this.contractItemsDetail.hashCode());
        result = 31 * result + (this.contractItemsStatus == null ? 0 : this.contractItemsStatus.hashCode());
        result = 31 * result + (this.contractsDetail == null ? 0 : this.contractsDetail.hashCode());
        result = 31 * result + (this.contractsStatus == null ? 0 : this.contractsStatus.hashCode());
        result = 31 * result + (this.facWarStatsDetail == null ? 0 : this.facWarStatsDetail.hashCode());
        result = 31 * result + (this.facWarStatsStatus == null ? 0 : this.facWarStatsStatus.hashCode());
        result = 31 * result + (this.industryJobsDetail == null ? 0 : this.industryJobsDetail.hashCode());
        result = 31 * result + (this.industryJobsHistoryDetail == null ? 0 : this.industryJobsHistoryDetail.hashCode());
        result = 31 * result + (this.industryJobsHistoryStatus == null ? 0 : this.industryJobsHistoryStatus.hashCode());
        result = 31 * result + (this.industryJobsStatus == null ? 0 : this.industryJobsStatus.hashCode());
        result = 31 * result + (this.killlogDetail == null ? 0 : this.killlogDetail.hashCode());
        result = 31 * result + (this.killlogStatus == null ? 0 : this.killlogStatus.hashCode());
        result = 31 * result + (this.mailBodiesDetail == null ? 0 : this.mailBodiesDetail.hashCode());
        result = 31 * result + (this.mailBodiesStatus == null ? 0 : this.mailBodiesStatus.hashCode());
        result = 31 * result + (this.mailMessagesDetail == null ? 0 : this.mailMessagesDetail.hashCode());
        result = 31 * result + (this.mailMessagesStatus == null ? 0 : this.mailMessagesStatus.hashCode());
        result = 31 * result + (this.mailingListsDetail == null ? 0 : this.mailingListsDetail.hashCode());
        result = 31 * result + (this.mailingListsStatus == null ? 0 : this.mailingListsStatus.hashCode());
        result = 31 * result + (this.marketOrdersDetail == null ? 0 : this.marketOrdersDetail.hashCode());
        result = 31 * result + (this.marketOrdersStatus == null ? 0 : this.marketOrdersStatus.hashCode());
        result = 31 * result + (this.medalsDetail == null ? 0 : this.medalsDetail.hashCode());
        result = 31 * result + (this.medalsStatus == null ? 0 : this.medalsStatus.hashCode());
        result = 31 * result + (this.notificationTextsDetail == null ? 0 : this.notificationTextsDetail.hashCode());
        result = 31 * result + (this.notificationTextsStatus == null ? 0 : this.notificationTextsStatus.hashCode());
        result = 31 * result + (this.notificationsDetail == null ? 0 : this.notificationsDetail.hashCode());
        result = 31 * result + (this.notificationsStatus == null ? 0 : this.notificationsStatus.hashCode());
        result = 31 * result + (this.planetaryColoniesDetail == null ? 0 : this.planetaryColoniesDetail.hashCode());
        result = 31 * result + (this.planetaryColoniesStatus == null ? 0 : this.planetaryColoniesStatus.hashCode());
        result = 31 * result + (this.researchDetail == null ? 0 : this.researchDetail.hashCode());
        result = 31 * result + (this.researchStatus == null ? 0 : this.researchStatus.hashCode());
        result = 31 * result + (this.skillInTrainingDetail == null ? 0 : this.skillInTrainingDetail.hashCode());
        result = 31 * result + (this.skillInTrainingStatus == null ? 0 : this.skillInTrainingStatus.hashCode());
        result = 31 * result + (this.skillQueueDetail == null ? 0 : this.skillQueueDetail.hashCode());
        result = 31 * result + (this.skillQueueStatus == null ? 0 : this.skillQueueStatus.hashCode());
        result = 31 * result + (this.standingsDetail == null ? 0 : this.standingsDetail.hashCode());
        result = 31 * result + (this.standingsStatus == null ? 0 : this.standingsStatus.hashCode());
        result = 31 * result + (this.upcomingCalendarEventsDetail == null ? 0 : this.upcomingCalendarEventsDetail.hashCode());
        result = 31 * result + (this.upcomingCalendarEventsStatus == null ? 0 : this.upcomingCalendarEventsStatus.hashCode());
        result = 31 * result + (this.walletJournalDetail == null ? 0 : this.walletJournalDetail.hashCode());
        result = 31 * result + (this.walletJournalStatus == null ? 0 : this.walletJournalStatus.hashCode());
        result = 31 * result + (this.walletTransactionsDetail == null ? 0 : this.walletTransactionsDetail.hashCode());
        result = 31 * result + (this.walletTransactionsStatus == null ? 0 : this.walletTransactionsStatus.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CapsuleerSyncTracker other = (CapsuleerSyncTracker)obj;
        if (this.accountBalanceDetail == null ? other.accountBalanceDetail != null : !this.accountBalanceDetail.equals(other.accountBalanceDetail)) {
            return false;
        }
        if (this.accountBalanceStatus != other.accountBalanceStatus) {
            return false;
        }
        if (this.accountStatusDetail == null ? other.accountStatusDetail != null : !this.accountStatusDetail.equals(other.accountStatusDetail)) {
            return false;
        }
        if (this.accountStatusStatus != other.accountStatusStatus) {
            return false;
        }
        if (this.assetListDetail == null ? other.assetListDetail != null : !this.assetListDetail.equals(other.assetListDetail)) {
            return false;
        }
        if (this.assetListStatus != other.assetListStatus) {
            return false;
        }
        if (this.blueprintsDetail == null ? other.blueprintsDetail != null : !this.blueprintsDetail.equals(other.blueprintsDetail)) {
            return false;
        }
        if (this.blueprintsStatus != other.blueprintsStatus) {
            return false;
        }
        if (this.bookmarksDetail == null ? other.bookmarksDetail != null : !this.bookmarksDetail.equals(other.bookmarksDetail)) {
            return false;
        }
        if (this.bookmarksStatus != other.bookmarksStatus) {
            return false;
        }
        if (this.calendarEventAttendeesDetail == null ? other.calendarEventAttendeesDetail != null : !this.calendarEventAttendeesDetail.equals(other.calendarEventAttendeesDetail)) {
            return false;
        }
        if (this.calendarEventAttendeesStatus != other.calendarEventAttendeesStatus) {
            return false;
        }
        if (this.characterSheetDetail == null ? other.characterSheetDetail != null : !this.characterSheetDetail.equals(other.characterSheetDetail)) {
            return false;
        }
        if (this.characterSheetStatus != other.characterSheetStatus) {
            return false;
        }
        if (this.chatChannelsDetail == null ? other.chatChannelsDetail != null : !this.chatChannelsDetail.equals(other.chatChannelsDetail)) {
            return false;
        }
        if (this.chatChannelsStatus != other.chatChannelsStatus) {
            return false;
        }
        if (this.contactListDetail == null ? other.contactListDetail != null : !this.contactListDetail.equals(other.contactListDetail)) {
            return false;
        }
        if (this.contactListStatus != other.contactListStatus) {
            return false;
        }
        if (this.contactNotificationsDetail == null ? other.contactNotificationsDetail != null : !this.contactNotificationsDetail.equals(other.contactNotificationsDetail)) {
            return false;
        }
        if (this.contactNotificationsStatus != other.contactNotificationsStatus) {
            return false;
        }
        if (this.contractBidsDetail == null ? other.contractBidsDetail != null : !this.contractBidsDetail.equals(other.contractBidsDetail)) {
            return false;
        }
        if (this.contractBidsStatus != other.contractBidsStatus) {
            return false;
        }
        if (this.contractItemsDetail == null ? other.contractItemsDetail != null : !this.contractItemsDetail.equals(other.contractItemsDetail)) {
            return false;
        }
        if (this.contractItemsStatus != other.contractItemsStatus) {
            return false;
        }
        if (this.contractsDetail == null ? other.contractsDetail != null : !this.contractsDetail.equals(other.contractsDetail)) {
            return false;
        }
        if (this.contractsStatus != other.contractsStatus) {
            return false;
        }
        if (this.facWarStatsDetail == null ? other.facWarStatsDetail != null : !this.facWarStatsDetail.equals(other.facWarStatsDetail)) {
            return false;
        }
        if (this.facWarStatsStatus != other.facWarStatsStatus) {
            return false;
        }
        if (this.industryJobsDetail == null ? other.industryJobsDetail != null : !this.industryJobsDetail.equals(other.industryJobsDetail)) {
            return false;
        }
        if (this.industryJobsHistoryDetail == null ? other.industryJobsHistoryDetail != null : !this.industryJobsHistoryDetail.equals(other.industryJobsHistoryDetail)) {
            return false;
        }
        if (this.industryJobsHistoryStatus != other.industryJobsHistoryStatus) {
            return false;
        }
        if (this.industryJobsStatus != other.industryJobsStatus) {
            return false;
        }
        if (this.killlogDetail == null ? other.killlogDetail != null : !this.killlogDetail.equals(other.killlogDetail)) {
            return false;
        }
        if (this.killlogStatus != other.killlogStatus) {
            return false;
        }
        if (this.mailBodiesDetail == null ? other.mailBodiesDetail != null : !this.mailBodiesDetail.equals(other.mailBodiesDetail)) {
            return false;
        }
        if (this.mailBodiesStatus != other.mailBodiesStatus) {
            return false;
        }
        if (this.mailMessagesDetail == null ? other.mailMessagesDetail != null : !this.mailMessagesDetail.equals(other.mailMessagesDetail)) {
            return false;
        }
        if (this.mailMessagesStatus != other.mailMessagesStatus) {
            return false;
        }
        if (this.mailingListsDetail == null ? other.mailingListsDetail != null : !this.mailingListsDetail.equals(other.mailingListsDetail)) {
            return false;
        }
        if (this.mailingListsStatus != other.mailingListsStatus) {
            return false;
        }
        if (this.marketOrdersDetail == null ? other.marketOrdersDetail != null : !this.marketOrdersDetail.equals(other.marketOrdersDetail)) {
            return false;
        }
        if (this.marketOrdersStatus != other.marketOrdersStatus) {
            return false;
        }
        if (this.medalsDetail == null ? other.medalsDetail != null : !this.medalsDetail.equals(other.medalsDetail)) {
            return false;
        }
        if (this.medalsStatus != other.medalsStatus) {
            return false;
        }
        if (this.notificationTextsDetail == null ? other.notificationTextsDetail != null : !this.notificationTextsDetail.equals(other.notificationTextsDetail)) {
            return false;
        }
        if (this.notificationTextsStatus != other.notificationTextsStatus) {
            return false;
        }
        if (this.notificationsDetail == null ? other.notificationsDetail != null : !this.notificationsDetail.equals(other.notificationsDetail)) {
            return false;
        }
        if (this.notificationsStatus != other.notificationsStatus) {
            return false;
        }
        if (this.planetaryColoniesDetail == null ? other.planetaryColoniesDetail != null : !this.planetaryColoniesDetail.equals(other.planetaryColoniesDetail)) {
            return false;
        }
        if (this.planetaryColoniesStatus != other.planetaryColoniesStatus) {
            return false;
        }
        if (this.researchDetail == null ? other.researchDetail != null : !this.researchDetail.equals(other.researchDetail)) {
            return false;
        }
        if (this.researchStatus != other.researchStatus) {
            return false;
        }
        if (this.skillInTrainingDetail == null ? other.skillInTrainingDetail != null : !this.skillInTrainingDetail.equals(other.skillInTrainingDetail)) {
            return false;
        }
        if (this.skillInTrainingStatus != other.skillInTrainingStatus) {
            return false;
        }
        if (this.skillQueueDetail == null ? other.skillQueueDetail != null : !this.skillQueueDetail.equals(other.skillQueueDetail)) {
            return false;
        }
        if (this.skillQueueStatus != other.skillQueueStatus) {
            return false;
        }
        if (this.standingsDetail == null ? other.standingsDetail != null : !this.standingsDetail.equals(other.standingsDetail)) {
            return false;
        }
        if (this.standingsStatus != other.standingsStatus) {
            return false;
        }
        if (this.upcomingCalendarEventsDetail == null ? other.upcomingCalendarEventsDetail != null : !this.upcomingCalendarEventsDetail.equals(other.upcomingCalendarEventsDetail)) {
            return false;
        }
        if (this.upcomingCalendarEventsStatus != other.upcomingCalendarEventsStatus) {
            return false;
        }
        if (this.walletJournalDetail == null ? other.walletJournalDetail != null : !this.walletJournalDetail.equals(other.walletJournalDetail)) {
            return false;
        }
        if (this.walletJournalStatus != other.walletJournalStatus) {
            return false;
        }
        if (this.walletTransactionsDetail == null ? other.walletTransactionsDetail != null : !this.walletTransactionsDetail.equals(other.walletTransactionsDetail)) {
            return false;
        }
        return this.walletTransactionsStatus == other.walletTransactionsStatus;
    }

    @Override
    public String toString() {
        return "CapsuleerSyncTracker [accountStatusStatus=" + (Object)((Object)this.accountStatusStatus) + ", accountStatusDetail=" + this.accountStatusDetail + ", accountBalanceStatus=" + (Object)((Object)this.accountBalanceStatus) + ", accountBalanceDetail=" + this.accountBalanceDetail + ", assetListStatus=" + (Object)((Object)this.assetListStatus) + ", assetListDetail=" + this.assetListDetail + ", calendarEventAttendeesStatus=" + (Object)((Object)this.calendarEventAttendeesStatus) + ", calendarEventAttendeesDetail=" + this.calendarEventAttendeesDetail + ", characterSheetStatus=" + (Object)((Object)this.characterSheetStatus) + ", characterSheetDetail=" + this.characterSheetDetail + ", chatChannelsStatus=" + (Object)((Object)this.chatChannelsStatus) + ", chatChannelsDetail=" + this.chatChannelsDetail + ", contactListStatus=" + (Object)((Object)this.contactListStatus) + ", contactListDetail=" + this.contactListDetail + ", contactNotificationsStatus=" + (Object)((Object)this.contactNotificationsStatus) + ", contactNotificationsDetail=" + this.contactNotificationsDetail + ", blueprintsStatus=" + (Object)((Object)this.blueprintsStatus) + ", blueprintsDetail=" + this.blueprintsDetail + ", bookmarksStatus=" + (Object)((Object)this.bookmarksStatus) + ", bookmarksDetail=" + this.bookmarksDetail + ", contractsStatus=" + (Object)((Object)this.contractsStatus) + ", contractsDetail=" + this.contractsDetail + ", contractItemsStatus=" + (Object)((Object)this.contractItemsStatus) + ", contractItemsDetail=" + this.contractItemsDetail + ", contractBidsStatus=" + (Object)((Object)this.contractBidsStatus) + ", contractBidsDetail=" + this.contractBidsDetail + ", facWarStatsStatus=" + (Object)((Object)this.facWarStatsStatus) + ", facWarStatsDetail=" + this.facWarStatsDetail + ", industryJobsStatus=" + (Object)((Object)this.industryJobsStatus) + ", industryJobsDetail=" + this.industryJobsDetail + ", industryJobsHistoryStatus=" + (Object)((Object)this.industryJobsHistoryStatus) + ", industryJobsHistoryDetail=" + this.industryJobsHistoryDetail + ", killlogStatus=" + (Object)((Object)this.killlogStatus) + ", killlogDetail=" + this.killlogDetail + ", mailBodiesStatus=" + (Object)((Object)this.mailBodiesStatus) + ", mailBodiesDetail=" + this.mailBodiesDetail + ", mailingListsStatus=" + (Object)((Object)this.mailingListsStatus) + ", mailingListsDetail=" + this.mailingListsDetail + ", mailMessagesStatus=" + (Object)((Object)this.mailMessagesStatus) + ", mailMessagesDetail=" + this.mailMessagesDetail + ", marketOrdersStatus=" + (Object)((Object)this.marketOrdersStatus) + ", marketOrdersDetail=" + this.marketOrdersDetail + ", medalsStatus=" + (Object)((Object)this.medalsStatus) + ", medalsDetail=" + this.medalsDetail + ", notificationsStatus=" + (Object)((Object)this.notificationsStatus) + ", notificationsDetail=" + this.notificationsDetail + ", notificationTextsStatus=" + (Object)((Object)this.notificationTextsStatus) + ", notificationTextsDetail=" + this.notificationTextsDetail + ", planetaryColoniesStatus=" + (Object)((Object)this.planetaryColoniesStatus) + ", planetaryColoniesDetail=" + this.planetaryColoniesDetail + ", researchStatus=" + (Object)((Object)this.researchStatus) + ", researchDetail=" + this.researchDetail + ", skillInTrainingStatus=" + (Object)((Object)this.skillInTrainingStatus) + ", skillInTrainingDetail=" + this.skillInTrainingDetail + ", skillQueueStatus=" + (Object)((Object)this.skillQueueStatus) + ", skillQueueDetail=" + this.skillQueueDetail + ", standingsStatus=" + (Object)((Object)this.standingsStatus) + ", standingsDetail=" + this.standingsDetail + ", upcomingCalendarEventsStatus=" + (Object)((Object)this.upcomingCalendarEventsStatus) + ", upcomingCalendarEventsDetail=" + this.upcomingCalendarEventsDetail + ", walletJournalStatus=" + (Object)((Object)this.walletJournalStatus) + ", walletJournalDetail=" + this.walletJournalDetail + ", walletTransactionsStatus=" + (Object)((Object)this.walletTransactionsStatus) + ", walletTransactionsDetail=" + this.walletTransactionsDetail + "]";
    }

    public static CapsuleerSyncTracker createOrGetUnfinishedTracker(final SynchronizedEveAccount syncAccount) {
        try {
            return (CapsuleerSyncTracker)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<CapsuleerSyncTracker>(){

                public CapsuleerSyncTracker run() throws Exception {
                    CapsuleerSyncTracker result = CapsuleerSyncTracker.getUnfinishedTracker(syncAccount);
                    if (result != null) {
                        return result;
                    }
                    result = new CapsuleerSyncTracker();
                    result.account = syncAccount;
                    result.syncStart = OrbitalProperties.getCurrentTime();
                    result.setFinished(false);
                    return (CapsuleerSyncTracker)EveKitUserAccountProvider.getFactory().getEntityManager().merge((Object)result);
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static CapsuleerSyncTracker getUnfinishedTracker(SynchronizedEveAccount syncAccount) {
        return (CapsuleerSyncTracker)SyncTracker.getUnfinishedTracker(syncAccount);
    }

    public static List<CapsuleerSyncTracker> getAllUnfinishedTrackers() {
        try {
            return (List)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<List<CapsuleerSyncTracker>>(){

                public List<CapsuleerSyncTracker> run() throws Exception {
                    TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery("CapsuleerSyncTracker.getAllUnfinished", CapsuleerSyncTracker.class);
                    return getter.getResultList();
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static CapsuleerSyncTracker getLatestFinishedTracker(SynchronizedEveAccount owner) {
        return (CapsuleerSyncTracker)SyncTracker.getLatestFinishedTracker(owner);
    }

    public static List<CapsuleerSyncTracker> getHistory(final SynchronizedEveAccount owner, final long contid, final int maxResults) {
        try {
            return (List)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<List<CapsuleerSyncTracker>>(){

                public List<CapsuleerSyncTracker> run() throws Exception {
                    TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery("CapsuleerSyncTracker.getHistory", CapsuleerSyncTracker.class);
                    getter.setParameter("account", (Object)owner);
                    getter.setParameter("start", (Object)(contid < 0L ? Long.MAX_VALUE : contid));
                    getter.setMaxResults(maxResults);
                    return getter.getResultList();
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static List<CapsuleerSyncTracker> getSummary(final Date fromDate) {
        try {
            return (List)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<List<CapsuleerSyncTracker>>(){

                public List<CapsuleerSyncTracker> run() throws Exception {
                    TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery("CapsuleerSyncTracker.getSummary", CapsuleerSyncTracker.class);
                    getter.setParameter("account", (Object)fromDate);
                    return getter.getResultList();
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static String summarizeErrors(Date day) throws IOException {
        StringBuilder summary = new StringBuilder();
        summary.append("Capsuleer Sync Tracker Error Summary on ");
        long days = day.getTime() / 86400000L;
        Date dayStart = new Date(days * 1000L * 60L * 60L * 24L + 1L);
        Date nextDay = new Date(dayStart.getTime() + 86400000L - 1L);
        summary.append(DateFormat.getDateInstance().format(dayStart)).append('\n');
        List<CapsuleerSyncTracker> result = CapsuleerSyncTracker.getSummary(dayStart);
        if (result == null) {
            result = Collections.emptyList();
        }
        int errorCount = 0;
        HashMap<String, Map<String, AtomicInteger>> data = new HashMap<String, Map<String, AtomicInteger>>();
        for (CapsuleerSyncTracker next : result) {
            if (new Date(next.getSyncEnd()).after(nextDay)) continue;
            if (next.accountStatusStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("accountStatus", next.accountStatusDetail, data);
                continue;
            }
            if (next.accountBalanceStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("accountBalance", next.accountBalanceDetail, data);
                continue;
            }
            if (next.assetListStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("assetList", next.assetListDetail, data);
                continue;
            }
            if (next.calendarEventAttendeesStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("calendarEventAttendees", next.calendarEventAttendeesDetail, data);
                continue;
            }
            if (next.characterSheetStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("characterSheet", next.characterSheetDetail, data);
                continue;
            }
            if (next.chatChannelsStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("chatChannels", next.chatChannelsDetail, data);
                continue;
            }
            if (next.contactListStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("contactList", next.contactListDetail, data);
                continue;
            }
            if (next.contactNotificationsStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("contactNotifications", next.contactNotificationsDetail, data);
                continue;
            }
            if (next.blueprintsStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("blueprints", next.blueprintsDetail, data);
                continue;
            }
            if (next.bookmarksStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("bookmarks", next.bookmarksDetail, data);
                continue;
            }
            if (next.contractsStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("contracts", next.contractsDetail, data);
                continue;
            }
            if (next.contractItemsStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("contractItems", next.contractItemsDetail, data);
                continue;
            }
            if (next.contractBidsStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("contractBids", next.contractBidsDetail, data);
                continue;
            }
            if (next.facWarStatsStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("facWarStats", next.facWarStatsDetail, data);
                continue;
            }
            if (next.industryJobsStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("industryJobs", next.industryJobsDetail, data);
                continue;
            }
            if (next.industryJobsHistoryStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("industryJobsHistory", next.industryJobsHistoryDetail, data);
                continue;
            }
            if (next.killlogStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("killlog", next.killlogDetail, data);
                continue;
            }
            if (next.mailBodiesStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("mailBodies", next.mailBodiesDetail, data);
                continue;
            }
            if (next.mailingListsStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("mailingLists", next.mailingListsDetail, data);
                continue;
            }
            if (next.mailMessagesStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("mailMessages", next.mailMessagesDetail, data);
                continue;
            }
            if (next.marketOrdersStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("marketOrders", next.marketOrdersDetail, data);
                continue;
            }
            if (next.medalsStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("medals", next.medalsDetail, data);
                continue;
            }
            if (next.notificationsStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("notifications", next.notificationsDetail, data);
                continue;
            }
            if (next.notificationTextsStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("notificationTexts", next.notificationTextsDetail, data);
                continue;
            }
            if (next.planetaryColoniesStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("planetaryColonies", next.planetaryColoniesDetail, data);
                continue;
            }
            if (next.researchStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("research", next.researchDetail, data);
                continue;
            }
            if (next.skillInTrainingStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("skillInTraining", next.skillInTrainingDetail, data);
                continue;
            }
            if (next.skillQueueStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("skillQueue", next.skillQueueDetail, data);
                continue;
            }
            if (next.standingsStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("standings", next.standingsDetail, data);
                continue;
            }
            if (next.upcomingCalendarEventsStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("upcomingCalendarEvents", next.upcomingCalendarEventsDetail, data);
                continue;
            }
            if (next.walletJournalStatus == SyncTracker.SyncState.SYNC_ERROR) {
                ++errorCount;
                SyncTracker.incrementSummary("walletJournal", next.walletJournalDetail, data);
                continue;
            }
            if (next.walletTransactionsStatus != SyncTracker.SyncState.SYNC_ERROR) continue;
            ++errorCount;
            SyncTracker.incrementSummary("walletTransactions", next.walletTransactionsDetail, data);
        }
        summary.append(errorCount).append(" trackers with errors\n");
        for (String category : data.keySet()) {
            summary.append("Category - ").append(category).append(":\n");
            for (String reason : ((Map)data.get(category)).keySet()) {
                summary.append("    ").append(reason).append(" - ").append(((AtomicInteger)((Map)data.get(category)).get(reason)).get()).append('\n');
            }
            summary.append('\n');
        }
        return summary.toString();
    }
}

