/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import enterprises.orbital.base.OrbitalProperties;
import enterprises.orbital.db.ConnectionFactory;
import enterprises.orbital.evekit.account.AccountCreationException;
import enterprises.orbital.evekit.account.EveKitUserAccount;
import enterprises.orbital.evekit.account.EveKitUserAccountProvider;
import enterprises.orbital.evekit.account.SynchronizedAccountAccessKey;
import enterprises.orbital.evekit.model.SyncTracker;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.NoResultException;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.TypedQuery;

@Entity
@Table(name="evekit_sync_accounts", indexes={@Index(name="accountIndex", columnList="uid", unique=false), @Index(name="nameIndex", columnList="name", unique=false), @Index(name="autoIndex", columnList="autoSynchronized", unique=false), @Index(name="deleteableIndex", columnList="markedForDelete", unique=false)})
@NamedQueries(value={@NamedQuery(name="SynchronizedEveAccount.findByAcctAndName", query="SELECT c FROM SynchronizedEveAccount c where c.userAccount = :account and c.name = :name and c.markedForDelete = -1"), @NamedQuery(name="SynchronizedEveAccount.findByAcctAndNameIncludeMarked", query="SELECT c FROM SynchronizedEveAccount c where c.userAccount = :account and c.name = :name"), @NamedQuery(name="SynchronizedEveAccount.findByAcctAndId", query="SELECT c FROM SynchronizedEveAccount c where c.userAccount = :account and c.aid = :aid and c.markedForDelete = -1"), @NamedQuery(name="SynchronizedEveAccount.findByAcctAndIdIncludeMarked", query="SELECT c FROM SynchronizedEveAccount c where c.userAccount = :account and c.aid = :aid"), @NamedQuery(name="SynchronizedEveAccount.findByAcct", query="SELECT c FROM SynchronizedEveAccount c where c.userAccount = :account and c.markedForDelete = -1"), @NamedQuery(name="SynchronizedEveAccount.findByAcctIncludeMarked", query="SELECT c FROM SynchronizedEveAccount c where c.userAccount = :account"), @NamedQuery(name="SynchronizedEveAccount.findAllMarkedForDelete", query="SELECT c FROM SynchronizedEveAccount c where c.markedForDelete > -1"), @NamedQuery(name="SynchronizedEveAccount.findAllAutoSync", query="SELECT c FROM SynchronizedEveAccount c where c.autoSynchronized = true and c.markedForDelete = -1"), @NamedQuery(name="SynchronizedEveAccount.findAllAutoSyncIncludeMarked", query="SELECT c FROM SynchronizedEveAccount c where c.autoSynchronized = true")})
@ApiModel(description="EveKit synchronized account")
public class SynchronizedEveAccount {
    private static final Logger log = Logger.getLogger(SynchronizedEveAccount.class.getName());
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ek_seq")
    @SequenceGenerator(name="ek_seq", initialValue=100000, allocationSize=10)
    @ApiModelProperty(value="Unique account ID")
    @JsonProperty(value="aid")
    protected long aid;
    @ManyToOne
    @JoinColumn(name="uid", referencedColumnName="uid")
    @JsonProperty(value="userAccount")
    private EveKitUserAccount userAccount;
    @ApiModelProperty(value="Date (milliseconds UTC) when this account was created")
    @JsonProperty(value="created")
    private long created = -1L;
    @ApiModelProperty(value="Account name")
    @JsonProperty(value="name")
    private String name;
    @ApiModelProperty(value="True if this is a character account, false for a corporation account")
    @JsonProperty(value="characterType")
    private boolean characterType;
    @ApiModelProperty(value="True if this account will auto-synchronize")
    @JsonProperty(value="autoSynchronized")
    private boolean autoSynchronized;
    @ApiModelProperty(value="EVE XML API access key")
    @JsonProperty(value="eveKey")
    private int eveKey;
    @ApiModelProperty(value="EVE XML API access vcode")
    @JsonProperty(value="eveVCode")
    private String eveVCode;
    @ApiModelProperty(value="Character ID to use for accessing the EVE XML API")
    @JsonProperty(value="eveCharacterID")
    private long eveCharacterID;
    @ApiModelProperty(value="Character name of character used for access")
    @JsonProperty(value="eveCharacterName")
    private String eveCharacterName;
    @ApiModelProperty(value="Corporation ID of character used for access")
    @JsonProperty(value="eveCorporationID")
    private long eveCorporationID;
    @ApiModelProperty(value="Corporation Name of character used for access")
    @JsonProperty(value="eveCorporationName")
    private String eveCorporationName;
    @Transient
    @ApiModelProperty(value="Date (milliseconds UTC) when this account was last synchronized")
    @JsonProperty(value="lastSynchronized")
    private long lastSynchronized = -1L;
    @ApiModelProperty(value="If greater than 0, then the date (milliseconds UTC) when this account was marked for deletion")
    @JsonProperty(value="markedForDelete")
    private long markedForDelete = -1L;

    public SynchronizedEveAccount() {
    }

    public SynchronizedEveAccount(String name, boolean ischar, boolean autoSynchronized, int eveKey, String eveVCode, long eveCharacterID, String eveCharacterName, long eveCorporationID, String eveCorporationName) {
        this.name = name;
        this.characterType = ischar;
        this.autoSynchronized = autoSynchronized;
        this.eveKey = eveKey;
        this.eveVCode = eveVCode;
        this.eveCharacterID = eveCharacterID;
        this.eveCharacterName = eveCharacterName;
        this.eveCorporationID = eveCorporationID;
        this.eveCorporationName = eveCorporationName;
    }

    public EveKitUserAccount getUserAccount() {
        return this.userAccount;
    }

    public void setUserAccount(EveKitUserAccount o) {
        this.userAccount = o;
    }

    public long getAid() {
        return this.aid;
    }

    public long getCreated() {
        return this.created;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isCharacterType() {
        return this.characterType;
    }

    public void setCharacterType(boolean characterType) {
        this.characterType = characterType;
    }

    public boolean isAutoSynchronized() {
        return this.autoSynchronized;
    }

    public void setAutoSynchronized(boolean autoSynchronized) {
        this.autoSynchronized = autoSynchronized;
    }

    public int getEveKey() {
        return this.eveKey;
    }

    public void setEveKey(int eveKey) {
        this.eveKey = eveKey;
    }

    public String getEveVCode() {
        return this.eveVCode;
    }

    public void setEveVCode(String eveVCode) {
        this.eveVCode = eveVCode;
    }

    public long getEveCharacterID() {
        return this.eveCharacterID;
    }

    public void setEveCharacterID(long eveCharacterID) {
        this.eveCharacterID = eveCharacterID;
    }

    public String getEveCharacterName() {
        return this.eveCharacterName;
    }

    public void setEveCharacterName(String eveCharacterName) {
        this.eveCharacterName = eveCharacterName;
    }

    public long getEveCorporationID() {
        return this.eveCorporationID;
    }

    public void setEveCorporationID(long eveCorporationID) {
        this.eveCorporationID = eveCorporationID;
    }

    public String getEveCorporationName() {
        return this.eveCorporationName;
    }

    public void setEveCorporationName(String eveCorporationName) {
        this.eveCorporationName = eveCorporationName;
    }

    public long getLastSynchronized() {
        return this.lastSynchronized;
    }

    public void setLastSynchronized(long lastSynchronized) {
        this.lastSynchronized = lastSynchronized;
    }

    public long getMarkedForDelete() {
        return this.markedForDelete;
    }

    public void setMarkedForDelete(long markedForDelete) {
        this.markedForDelete = markedForDelete;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.aid ^ this.aid >>> 32);
        result = 31 * result + (this.autoSynchronized ? 1231 : 1237);
        result = 31 * result + (this.characterType ? 1231 : 1237);
        result = 31 * result + (int)(this.created ^ this.created >>> 32);
        result = 31 * result + (int)(this.eveCharacterID ^ this.eveCharacterID >>> 32);
        result = 31 * result + (this.eveCharacterName == null ? 0 : this.eveCharacterName.hashCode());
        result = 31 * result + (int)(this.eveCorporationID ^ this.eveCorporationID >>> 32);
        result = 31 * result + (this.eveCorporationName == null ? 0 : this.eveCorporationName.hashCode());
        result = 31 * result + this.eveKey;
        result = 31 * result + (this.eveVCode == null ? 0 : this.eveVCode.hashCode());
        result = 31 * result + (int)(this.markedForDelete ^ this.markedForDelete >>> 32);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.userAccount == null ? 0 : this.userAccount.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SynchronizedEveAccount other = (SynchronizedEveAccount)obj;
        if (this.aid != other.aid) {
            return false;
        }
        if (this.autoSynchronized != other.autoSynchronized) {
            return false;
        }
        if (this.characterType != other.characterType) {
            return false;
        }
        if (this.created != other.created) {
            return false;
        }
        if (this.eveCharacterID != other.eveCharacterID) {
            return false;
        }
        if (this.eveCharacterName == null ? other.eveCharacterName != null : !this.eveCharacterName.equals(other.eveCharacterName)) {
            return false;
        }
        if (this.eveCorporationID != other.eveCorporationID) {
            return false;
        }
        if (this.eveCorporationName == null ? other.eveCorporationName != null : !this.eveCorporationName.equals(other.eveCorporationName)) {
            return false;
        }
        if (this.eveKey != other.eveKey) {
            return false;
        }
        if (this.eveVCode == null ? other.eveVCode != null : !this.eveVCode.equals(other.eveVCode)) {
            return false;
        }
        if (this.markedForDelete != other.markedForDelete) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.userAccount == null ? other.userAccount != null : !this.userAccount.equals(other.userAccount));
    }

    public String toString() {
        return "SynchronizedEveAccount [aid=" + this.aid + ", userAccount=" + this.userAccount + ", created=" + this.created + ", name=" + this.name + ", characterType=" + this.characterType + ", autoSynchronized=" + this.autoSynchronized + ", eveKey=" + this.eveKey + ", eveVCode=" + this.eveVCode + ", eveCharacterID=" + this.eveCharacterID + ", eveCharacterName=" + this.eveCharacterName + ", eveCorporationID=" + this.eveCorporationID + ", eveCorporationName=" + this.eveCorporationName + ", lastSynchronized=" + this.lastSynchronized + ", markedForDelete=" + this.markedForDelete + "]";
    }

    public static SynchronizedEveAccount createSynchronizedEveAccount(final EveKitUserAccount userAccount, final String name, final boolean isChar, final boolean autoSync, final int key, final String vCode, final long charID, final String charName, final long corpID, final String corpName) throws AccountCreationException {
        SynchronizedEveAccount newAccount = null;
        try {
            newAccount = (SynchronizedEveAccount)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<SynchronizedEveAccount>(){

                public SynchronizedEveAccount run() throws Exception {
                    SynchronizedEveAccount result = SynchronizedEveAccount.getSynchronizedAccount(userAccount, name, true);
                    if (result != null) {
                        return null;
                    }
                    result = new SynchronizedEveAccount(name, isChar, autoSync, key, vCode, charID, charName, corpID, corpName);
                    result.userAccount = userAccount;
                    result.created = OrbitalProperties.getCurrentTime();
                    return (SynchronizedEveAccount)EveKitUserAccountProvider.getFactory().getEntityManager().merge((Object)result);
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
        }
        if (newAccount == null) {
            throw new AccountCreationException("Account with name " + name + " already exists");
        }
        return newAccount;
    }

    public static SynchronizedEveAccount getSynchronizedAccount(final EveKitUserAccount owner, final String name, final boolean includeMarkedForDelete) {
        try {
            return (SynchronizedEveAccount)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<SynchronizedEveAccount>(){

                public SynchronizedEveAccount run() throws Exception {
                    TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery(includeMarkedForDelete ? "SynchronizedEveAccount.findByAcctAndNameIncludeMarked" : "SynchronizedEveAccount.findByAcctAndName", SynchronizedEveAccount.class);
                    getter.setParameter("account", (Object)owner);
                    getter.setParameter("name", (Object)name);
                    try {
                        return (SynchronizedEveAccount)getter.getSingleResult();
                    }
                    catch (NoResultException e) {
                        return null;
                    }
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static SynchronizedEveAccount getSynchronizedAccount(final EveKitUserAccount owner, final long id, final boolean includeMarkedForDelete) {
        try {
            return (SynchronizedEveAccount)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<SynchronizedEveAccount>(){

                public SynchronizedEveAccount run() throws Exception {
                    TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery(includeMarkedForDelete ? "SynchronizedEveAccount.findByAcctAndIdIncludeMarked" : "SynchronizedEveAccount.findByAcctAndId", SynchronizedEveAccount.class);
                    getter.setParameter("account", (Object)owner);
                    getter.setParameter("aid", (Object)id);
                    try {
                        return (SynchronizedEveAccount)getter.getSingleResult();
                    }
                    catch (NoResultException e) {
                        return null;
                    }
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static List<SynchronizedEveAccount> getAllAccounts(final EveKitUserAccount owner, final boolean includeMarkedForDelete) {
        try {
            return (List)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<List<SynchronizedEveAccount>>(){

                public List<SynchronizedEveAccount> run() throws Exception {
                    TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery(includeMarkedForDelete ? "SynchronizedEveAccount.findByAcctIncludeMarked" : "SynchronizedEveAccount.findByAcct", SynchronizedEveAccount.class);
                    getter.setParameter("account", (Object)owner);
                    return getter.getResultList();
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static SynchronizedEveAccount deleteAccount(final EveKitUserAccount owner, final long id) {
        try {
            return (SynchronizedEveAccount)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<SynchronizedEveAccount>(){

                public SynchronizedEveAccount run() throws Exception {
                    SynchronizedEveAccount acct = SynchronizedEveAccount.getSynchronizedAccount(owner, id, false);
                    if (acct == null) {
                        log.warning("Account not found for marking, ignoring: owner=" + owner + " id=" + id);
                        return null;
                    }
                    acct.setMarkedForDelete(OrbitalProperties.getCurrentTime());
                    return (SynchronizedEveAccount)EveKitUserAccountProvider.getFactory().getEntityManager().merge((Object)acct);
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static SynchronizedEveAccount restoreAccount(final EveKitUserAccount owner, final long id) {
        try {
            return (SynchronizedEveAccount)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<SynchronizedEveAccount>(){

                public SynchronizedEveAccount run() throws Exception {
                    SynchronizedEveAccount acct = SynchronizedEveAccount.getSynchronizedAccount(owner, id, true);
                    if (acct == null) {
                        log.warning("Account not found for restoring, ignoring: owner=" + owner + " id=" + id);
                        return null;
                    }
                    acct.setMarkedForDelete(-1L);
                    return (SynchronizedEveAccount)EveKitUserAccountProvider.getFactory().getEntityManager().merge((Object)acct);
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static void updateAccount(final EveKitUserAccount owner, final long id, final String name, final boolean isChar, final boolean autoSync, final int key, final String vCode, final long charID, final String charName, final long corpID, final String corpName) throws AccountCreationException {
        AccountCreationException result = null;
        try {
            result = (AccountCreationException)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<AccountCreationException>(){

                public AccountCreationException run() throws Exception {
                    SynchronizedEveAccount result = SynchronizedEveAccount.getSynchronizedAccount(owner, id, false);
                    if (result == null) {
                        return null;
                    }
                    if (!name.equals(result.getName())) {
                        SynchronizedEveAccount check = SynchronizedEveAccount.getSynchronizedAccount(owner, name, true);
                        if (check != null) {
                            return new AccountCreationException("Account with target name \"" + name + "\" already exists");
                        }
                        result.setName(name);
                    }
                    result.setCharacterType(isChar);
                    result.setAutoSynchronized(autoSync);
                    result.setEveKey(key);
                    result.setEveVCode(vCode);
                    result.setEveCharacterID(charID);
                    result.setEveCharacterName(charName);
                    result.setEveCorporationID(corpID);
                    result.setEveCorporationName(corpName);
                    EveKitUserAccountProvider.getFactory().getEntityManager().merge((Object)result);
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
        }
        if (result != null) {
            throw result;
        }
    }

    public static List<SynchronizedEveAccount> getAllAutoSyncAccounts(final boolean includeMarkedForDelete) {
        try {
            return (List)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<List<SynchronizedEveAccount>>(){

                public List<SynchronizedEveAccount> run() throws Exception {
                    TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery(includeMarkedForDelete ? "SynchronizedEveAccount.findAllAutoSyncIncludeMarked" : "SynchronizedEveAccount.findAllAutoSync", SynchronizedEveAccount.class);
                    return getter.getResultList();
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static List<SynchronizedEveAccount> getAllMarkedForDelete() {
        try {
            return (List)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<List<SynchronizedEveAccount>>(){

                public List<SynchronizedEveAccount> run() throws Exception {
                    TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery("SynchronizedEveAccount.findAllMarkedForDelete", SynchronizedEveAccount.class);
                    return getter.getResultList();
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static void remove(final SynchronizedEveAccount toRemove) {
        try {
            long lastRemoved = 0L;
            while ((lastRemoved = ((Long)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<Long>(){

                public Long run() throws Exception {
                    long removed = 0L;
                    TypedQuery query = EveKitUserAccountProvider.getFactory().getEntityManager().createQuery("SELECT c FROM SyncTracker c where c.account = :account", SyncTracker.class);
                    query.setParameter("account", (Object)toRemove);
                    query.setMaxResults(1000);
                    for (SyncTracker next : query.getResultList()) {
                        EveKitUserAccountProvider.getFactory().getEntityManager().remove((Object)next);
                        ++removed;
                    }
                    return removed;
                }
            })).longValue()) > 0L) {
            }
            EveKitUserAccountProvider.getFactory().runTransaction(new ConnectionFactory.RunInVoidTransaction(){

                public void run() throws Exception {
                    TypedQuery query = EveKitUserAccountProvider.getFactory().getEntityManager().createQuery("SELECT c FROM SynchronizedAccountAccessKey c where c.account = :account", SynchronizedAccountAccessKey.class);
                    query.setParameter("account", (Object)toRemove);
                    for (SynchronizedAccountAccessKey next : query.getResultList()) {
                        EveKitUserAccountProvider.getFactory().getEntityManager().remove((Object)next);
                    }
                }
            });
            EveKitUserAccountProvider.getFactory().runTransaction(new ConnectionFactory.RunInVoidTransaction(){

                public void run() throws Exception {
                    EveKitUserAccountProvider.getFactory().getEntityManager().remove((Object)SynchronizedEveAccount.getSynchronizedAccount(toRemove.getUserAccount(), toRemove.getAid(), true));
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
        }
    }

    public static SynchronizedEveAccount update(final SynchronizedEveAccount data) {
        try {
            return (SynchronizedEveAccount)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<SynchronizedEveAccount>(){

                public SynchronizedEveAccount run() throws Exception {
                    return (SynchronizedEveAccount)EveKitUserAccountProvider.getFactory().getEntityManager().merge((Object)data);
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }
}

