/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.account;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import enterprises.orbital.base.OrbitalProperties;
import enterprises.orbital.base.Stamper;
import enterprises.orbital.db.ConnectionFactory;
import enterprises.orbital.evekit.account.AccessKeyCreationException;
import enterprises.orbital.evekit.account.AccountAccessMask;
import enterprises.orbital.evekit.account.EveKitUserAccountProvider;
import enterprises.orbital.evekit.account.GeneralSequenceNumber;
import enterprises.orbital.evekit.account.NoSuchKeyException;
import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.NoResultException;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.TypedQuery;

@Entity
@Table(name="evekit_access_keys", indexes={@Index(name="accountIndex", columnList="aid", unique=false), @Index(name="accessKeyIndex", columnList="accessKey", unique=true), @Index(name="keyNameIndex", columnList="keyName", unique=false)})
@NamedQueries(value={@NamedQuery(name="SynchronizedAccountAccessKey.findByAcctAndName", query="SELECT c FROM SynchronizedAccountAccessKey c where c.account = :account and c.keyName = :name"), @NamedQuery(name="SynchronizedAccountAccessKey.findByAcctAndID", query="SELECT c FROM SynchronizedAccountAccessKey c where c.account = :account and c.kid = :kid"), @NamedQuery(name="SynchronizedAccountAccessKey.findAllByAcct", query="SELECT c FROM SynchronizedAccountAccessKey c where c.account = :account"), @NamedQuery(name="SynchronizedAccountAccessKey.findByAccessKey", query="SELECT c FROM SynchronizedAccountAccessKey c where c.accessKey.value = :accesskey")})
@ApiModel(description="EveKit synchronized account access key")
@JsonIgnoreProperties(value={"randomSeed", "accessMask"})
public class SynchronizedAccountAccessKey {
    protected static final Logger log = Logger.getLogger(SynchronizedAccountAccessKey.class.getName());
    protected static ThreadLocal<ByteBuffer> assembly = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            return ByteBuffer.allocate(550);
        }
    };
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ek_seq")
    @SequenceGenerator(name="ek_seq", initialValue=100000, allocationSize=10)
    @ApiModelProperty(value="Unique key ID")
    @JsonProperty(value="kid")
    protected long kid;
    @ManyToOne
    @JoinColumn(name="aid", referencedColumnName="aid")
    @ApiModelProperty(value="Key owner")
    @JsonProperty(value="account")
    private SynchronizedEveAccount account;
    @ApiModelProperty(value="Key name")
    @JsonProperty(value="keyName")
    private String keyName;
    @OneToOne
    @JoinColumn(name="accessKey", referencedColumnName="value")
    @ApiModelProperty(value="Access key")
    @JsonProperty(value="accessKey")
    private GeneralSequenceNumber accessKey;
    private long randomSeed;
    @ApiModelProperty(value="-1 if this key never expires, otherwise the date (milliseconds UTC) when this key expires")
    @JsonProperty(value="expiry")
    private long expiry = -1L;
    @ApiModelProperty(value="-1 if this key is unlimited, otherwise the date (milliseconds UTC) before which data may not be accessed")
    @JsonProperty(value="limit")
    @Column(name="\"limit\"")
    private long limit = -1L;
    @Lob
    private byte[] accessMask;
    @Transient
    @ApiModelProperty(value="Access credential")
    @JsonProperty(value="credential")
    private String credential;
    @Transient
    @ApiModelProperty(value="Access key mask")
    @JsonProperty(value="maskValue")
    @JsonSerialize(using=BigIntegerSerializer.class)
    private BigInteger maskValue;
    @Transient
    @ApiModelProperty(value="String value of access key mask")
    @JsonProperty(value="maskValueString")
    private String maskValueString;

    public SynchronizedEveAccount getSyncAccount() {
        return this.account;
    }

    public void setSyncAccount(SynchronizedEveAccount o) {
        this.account = o;
    }

    public long getAccessKey() {
        return this.accessKey.getValue();
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public long getRandomSeed() {
        return this.randomSeed;
    }

    public void setRandomSeed(long randomSeed) {
        this.randomSeed = randomSeed;
    }

    public long getExpiry() {
        return this.expiry;
    }

    public void setExpiry(long expiry) {
        this.expiry = expiry;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public byte[] getAccessMask() {
        return this.accessMask;
    }

    public void setAccessMask(byte[] accessMask) {
        this.accessMask = accessMask;
    }

    public String getCredential() {
        return this.credential;
    }

    public void setCredential(String credential) {
        this.credential = credential;
    }

    public BigInteger getMaskValue() {
        return this.maskValue;
    }

    public void setMaskValue(BigInteger maskValue) {
        this.maskValue = maskValue;
    }

    public String getMaskValueString() {
        return this.maskValueString;
    }

    public void setMaskValueString(String maskValueString) {
        this.maskValueString = maskValueString;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accessKey == null ? 0 : this.accessKey.hashCode());
        result = 31 * result + Arrays.hashCode(this.accessMask);
        result = 31 * result + (this.account == null ? 0 : this.account.hashCode());
        result = 31 * result + (this.credential == null ? 0 : this.credential.hashCode());
        result = 31 * result + (int)(this.expiry ^ this.expiry >>> 32);
        result = 31 * result + (this.keyName == null ? 0 : this.keyName.hashCode());
        result = 31 * result + (int)(this.kid ^ this.kid >>> 32);
        result = 31 * result + (int)(this.limit ^ this.limit >>> 32);
        result = 31 * result + (int)(this.randomSeed ^ this.randomSeed >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SynchronizedAccountAccessKey other = (SynchronizedAccountAccessKey)obj;
        if (this.accessKey == null ? other.accessKey != null : !this.accessKey.equals(other.accessKey)) {
            return false;
        }
        if (!Arrays.equals(this.accessMask, other.accessMask)) {
            return false;
        }
        if (this.account == null ? other.account != null : !this.account.equals(other.account)) {
            return false;
        }
        if (this.credential == null ? other.credential != null : !this.credential.equals(other.credential)) {
            return false;
        }
        if (this.expiry != other.expiry) {
            return false;
        }
        if (this.keyName == null ? other.keyName != null : !this.keyName.equals(other.keyName)) {
            return false;
        }
        if (this.kid != other.kid) {
            return false;
        }
        if (this.limit != other.limit) {
            return false;
        }
        return this.randomSeed == other.randomSeed;
    }

    public String toString() {
        return "SynchronizedAccountAccessKey [kid=" + this.kid + ", account=" + this.account + ", keyName=" + this.keyName + ", accessKey=" + this.accessKey + ", randomSeed=" + this.randomSeed + ", expiry=" + this.expiry + ", limit=" + this.limit + ", accessMask=" + Arrays.toString(this.accessMask) + ", credential=" + this.credential + ", maskValue=" + this.maskValue + ", maskValueString=" + this.maskValueString + "]";
    }

    public static SynchronizedAccountAccessKey createKey(final SynchronizedEveAccount accountKey, final String keyName, final long expiry, final long limit, final byte[] accessMask) throws AccessKeyCreationException {
        SynchronizedAccountAccessKey newKey = null;
        try {
            newKey = (SynchronizedAccountAccessKey)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<SynchronizedAccountAccessKey>(){

                public SynchronizedAccountAccessKey run() throws Exception {
                    SynchronizedAccountAccessKey result = SynchronizedAccountAccessKey.getKeyByOwnerAndName(accountKey, keyName);
                    if (result != null) {
                        return null;
                    }
                    long seed = new Random(OrbitalProperties.getCurrentTime()).nextLong();
                    result = new SynchronizedAccountAccessKey();
                    result.account = accountKey;
                    result.keyName = keyName;
                    result.expiry = expiry;
                    result.limit = limit;
                    SynchronizedAccountAccessKey.access$402(result, accessMask);
                    result.randomSeed = seed;
                    result.accessKey = GeneralSequenceNumber.create();
                    return (SynchronizedAccountAccessKey)EveKitUserAccountProvider.getFactory().getEntityManager().merge((Object)result);
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
        }
        if (newKey == null) {
            throw new AccessKeyCreationException("Access key with name " + keyName + " already exists");
        }
        return newKey;
    }

    public static SynchronizedAccountAccessKey getKeyByOwnerAndName(final SynchronizedEveAccount owner, final String name) {
        try {
            return (SynchronizedAccountAccessKey)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<SynchronizedAccountAccessKey>(){

                public SynchronizedAccountAccessKey run() throws Exception {
                    TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery("SynchronizedAccountAccessKey.findByAcctAndName", SynchronizedAccountAccessKey.class);
                    getter.setParameter("account", (Object)owner);
                    getter.setParameter("name", (Object)name);
                    try {
                        return (SynchronizedAccountAccessKey)getter.getSingleResult();
                    }
                    catch (NoResultException e) {
                        return null;
                    }
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static SynchronizedAccountAccessKey getKeyByOwnerAndID(final SynchronizedEveAccount owner, final long kid) {
        try {
            return (SynchronizedAccountAccessKey)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<SynchronizedAccountAccessKey>(){

                public SynchronizedAccountAccessKey run() throws Exception {
                    TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery("SynchronizedAccountAccessKey.findByAcctAndID", SynchronizedAccountAccessKey.class);
                    getter.setParameter("account", (Object)owner);
                    getter.setParameter("kid", (Object)kid);
                    try {
                        return (SynchronizedAccountAccessKey)getter.getSingleResult();
                    }
                    catch (NoResultException e) {
                        return null;
                    }
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static SynchronizedAccountAccessKey getKeyByAccessKey(final long accessKey) {
        try {
            return (SynchronizedAccountAccessKey)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<SynchronizedAccountAccessKey>(){

                public SynchronizedAccountAccessKey run() throws Exception {
                    TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery("SynchronizedAccountAccessKey.findByAccessKey", SynchronizedAccountAccessKey.class);
                    getter.setParameter("accesskey", (Object)accessKey);
                    try {
                        return (SynchronizedAccountAccessKey)getter.getSingleResult();
                    }
                    catch (NoResultException e) {
                        return null;
                    }
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static List<SynchronizedAccountAccessKey> getAllKeys(final SynchronizedEveAccount owner) {
        try {
            return (List)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<List<SynchronizedAccountAccessKey>>(){

                public List<SynchronizedAccountAccessKey> run() throws Exception {
                    TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery("SynchronizedAccountAccessKey.findAllByAcct", SynchronizedAccountAccessKey.class);
                    getter.setParameter("account", (Object)owner);
                    return getter.getResultList();
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static boolean deleteKey(final SynchronizedEveAccount owner, final String name) {
        try {
            EveKitUserAccountProvider.getFactory().runTransaction(new ConnectionFactory.RunInVoidTransaction(){

                public void run() throws Exception {
                    SynchronizedAccountAccessKey key = SynchronizedAccountAccessKey.getKeyByOwnerAndName(owner, name);
                    if (key != null) {
                        EveKitUserAccountProvider.getFactory().getEntityManager().remove((Object)key);
                    }
                }
            });
            return true;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return false;
        }
    }

    public static boolean deleteKey(final SynchronizedEveAccount owner, final long kid) {
        try {
            EveKitUserAccountProvider.getFactory().runTransaction(new ConnectionFactory.RunInVoidTransaction(){

                public void run() throws Exception {
                    SynchronizedAccountAccessKey key = SynchronizedAccountAccessKey.getKeyByOwnerAndID(owner, kid);
                    if (key != null) {
                        EveKitUserAccountProvider.getFactory().getEntityManager().remove((Object)key);
                    }
                }
            });
            return true;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return false;
        }
    }

    public static void updateKey(final SynchronizedEveAccount owner, final String keyName, final String newKeyName, final long expiry, final long limit, final byte[] accessMask) throws AccessKeyCreationException {
        AccessKeyCreationException result = null;
        try {
            result = (AccessKeyCreationException)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<AccessKeyCreationException>(){

                public AccessKeyCreationException run() throws Exception {
                    SynchronizedAccountAccessKey key = SynchronizedAccountAccessKey.getKeyByOwnerAndName(owner, keyName);
                    if (key == null) {
                        return null;
                    }
                    if (!keyName.equals(newKeyName)) {
                        if (SynchronizedAccountAccessKey.getKeyByOwnerAndName(owner, newKeyName) != null) {
                            return new AccessKeyCreationException("Key already exists with new name: " + newKeyName);
                        }
                        key.keyName = newKeyName;
                    }
                    key.setExpiry(expiry);
                    key.setLimit(limit);
                    key.setAccessMask(accessMask);
                    EveKitUserAccountProvider.getFactory().getEntityManager().merge((Object)key);
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
        }
        if (result != null) {
            throw result;
        }
    }

    public void generateCredential() {
        this.setCredential(SynchronizedAccountAccessKey.generateHash(this));
    }

    public void generateMaskValue() {
        BigInteger value = new BigInteger("0");
        for (AccountAccessMask next : AccountAccessMask.values()) {
            if (!AccountAccessMask.isAccessAllowed(this.accessMask, next)) continue;
            value = value.flipBit(next.getMaskValue());
        }
        this.setMaskValue(value);
    }

    public void generateMaskValueString() {
        this.setMaskValueString(AccountAccessMask.stringifyMask(this.accessMask));
    }

    public static String generateHash(SynchronizedAccountAccessKey ref) {
        ByteBuffer assemble = assembly.get();
        assemble.clear();
        assemble.putLong(ref.getAccessKey());
        assemble.put(ref.getSyncAccount().getUserAccount().getUid().getBytes());
        assemble.putLong(ref.getRandomSeed());
        assemble.limit(assemble.position());
        assemble.rewind();
        return Stamper.digest((ByteBuffer)assemble);
    }

    public static SynchronizedAccountAccessKey checkHash(long keyID, String submittedHash) throws NoSuchKeyException {
        SynchronizedAccountAccessKey accessKey = SynchronizedAccountAccessKey.getKeyByAccessKey(keyID);
        if (accessKey == null) {
            log.fine("Can't find any access key with ID " + keyID + ", returning false");
            throw new NoSuchKeyException("No access key found with ID: " + String.valueOf(keyID));
        }
        return SynchronizedAccountAccessKey.generateHash(accessKey).equals(submittedHash) ? accessKey : null;
    }

    public static void remove(final SynchronizedEveAccount acct) {
        try {
            EveKitUserAccountProvider.getFactory().runTransaction(new ConnectionFactory.RunInVoidTransaction(){

                public void run() throws Exception {
                    for (SynchronizedAccountAccessKey next : SynchronizedAccountAccessKey.getAllKeys(acct)) {
                        EveKitUserAccountProvider.getFactory().getEntityManager().remove((Object)next);
                    }
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
        }
    }

    static /* synthetic */ byte[] access$402(SynchronizedAccountAccessKey x0, byte[] x1) {
        x0.accessMask = x1;
        return x1;
    }

    public static class BigIntegerSerializer
    extends JsonSerializer<BigInteger> {
        public void serialize(BigInteger value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(value.toString());
        }
    }
}

