/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import enterprises.orbital.base.OrbitalProperties;
import enterprises.orbital.base.PersistentPropertyKey;
import enterprises.orbital.db.ConnectionFactory;
import enterprises.orbital.evekit.account.EveKitUserAccountProvider;
import enterprises.orbital.oauth.UserAccount;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.NoResultException;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TypedQuery;

@Entity
@Table(name="evekit_users")
@NamedQueries(value={@NamedQuery(name="EveKitUserAccount.findByUid", query="SELECT c FROM EveKitUserAccount c where c.uid = :uid"), @NamedQuery(name="EveKitUserAccount.allAccounts", query="SELECT c FROM EveKitUserAccount c")})
@ApiModel(description="User account")
@JsonSerialize(typing=JsonSerialize.Typing.DYNAMIC)
public class EveKitUserAccount
implements UserAccount,
PersistentPropertyKey<String> {
    private static final Logger log = Logger.getLogger(EveKitUserAccount.class.getName());
    public static final String PROP_STATIC_DB_ACCESS_LIMIT = "StaticDBAccessLimit";
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ek_seq")
    @SequenceGenerator(name="ek_seq", initialValue=100000, allocationSize=10)
    @ApiModelProperty(value="Unique user ID")
    @JsonProperty(value="uid")
    protected long uid;
    @ApiModelProperty(value="True if user is active, false otherwise")
    @JsonProperty(value="active")
    protected boolean active;
    @ApiModelProperty(value="Date (milliseconds UTC) when account was created")
    @JsonProperty(value="created")
    protected long created = -1L;
    @ApiModelProperty(value="True if user is an admin, false otherwise")
    @JsonProperty(value="admin")
    protected boolean admin;
    @ApiModelProperty(value="Last time (milliseconds UTC) user logged in")
    @JsonProperty(value="last")
    protected long last = -1L;

    public long getID() {
        return this.uid;
    }

    public String getUid() {
        return String.valueOf(this.uid);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public long getCreated() {
        return this.created;
    }

    public void setCreated(long created) {
        this.created = created;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public long getLast() {
        return this.last;
    }

    public void setLast(long last) {
        this.last = last;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.active ? 1231 : 1237);
        result = 31 * result + (this.admin ? 1231 : 1237);
        result = 31 * result + (int)(this.created ^ this.created >>> 32);
        result = 31 * result + (int)(this.last ^ this.last >>> 32);
        result = 31 * result + (int)(this.uid ^ this.uid >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EveKitUserAccount other = (EveKitUserAccount)obj;
        if (this.active != other.active) {
            return false;
        }
        if (this.admin != other.admin) {
            return false;
        }
        if (this.created != other.created) {
            return false;
        }
        if (this.last != other.last) {
            return false;
        }
        return this.uid == other.uid;
    }

    public String toString() {
        return "EveKitUserAccount [uid=" + this.uid + ", active=" + this.active + ", created=" + this.created + ", admin=" + this.admin + ", last=" + this.last + "]";
    }

    public EveKitUserAccount copy() {
        EveKitUserAccount copy = new EveKitUserAccount();
        copy.uid = this.uid;
        copy.active = this.active;
        copy.created = this.created;
        copy.admin = this.admin;
        copy.last = this.last;
        return copy;
    }

    public static EveKitUserAccount createNewUserAccount(final boolean admin, final boolean active) {
        try {
            return (EveKitUserAccount)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<EveKitUserAccount>(){

                public EveKitUserAccount run() throws Exception {
                    EveKitUserAccount result = new EveKitUserAccount();
                    result.active = active;
                    result.created = OrbitalProperties.getCurrentTime();
                    result.admin = admin;
                    result.last = result.created;
                    return (EveKitUserAccount)EveKitUserAccountProvider.getFactory().getEntityManager().merge((Object)result);
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static EveKitUserAccount getAccount(final long uid) {
        try {
            return (EveKitUserAccount)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<EveKitUserAccount>(){

                public EveKitUserAccount run() throws Exception {
                    TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery("EveKitUserAccount.findByUid", EveKitUserAccount.class);
                    getter.setParameter("uid", (Object)uid);
                    try {
                        return (EveKitUserAccount)getter.getSingleResult();
                    }
                    catch (NoResultException e) {
                        return null;
                    }
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static EveKitUserAccount touch(final EveKitUserAccount user) {
        try {
            return (EveKitUserAccount)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<EveKitUserAccount>(){

                public EveKitUserAccount run() throws Exception {
                    EveKitUserAccount result = EveKitUserAccount.getAccount(user.uid);
                    if (result == null) {
                        throw new IOException("No user found with UUID " + user.getUid());
                    }
                    result.last = OrbitalProperties.getCurrentTime();
                    return (EveKitUserAccount)EveKitUserAccountProvider.getFactory().getEntityManager().merge((Object)result);
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public static List<EveKitUserAccount> getAllAccounts() {
        try {
            return (List)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<List<EveKitUserAccount>>(){

                public List<EveKitUserAccount> run() throws Exception {
                    TypedQuery getter = EveKitUserAccountProvider.getFactory().getEntityManager().createNamedQuery("EveKitUserAccount.allAccounts", EveKitUserAccount.class);
                    return getter.getResultList();
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }

    public boolean isDisabled() {
        return !this.active;
    }

    public void touch() {
        EveKitUserAccount.touch(this);
    }

    public Date getJoinTime() {
        return new Date(this.created);
    }

    public Date getLastSignOn() {
        return new Date(this.last);
    }

    public String getPeristentPropertyKey(String field) {
        return "EveKitUserAccount." + String.valueOf(this.uid) + "." + field;
    }

    public static EveKitUserAccount update(final EveKitUserAccount data) {
        try {
            return (EveKitUserAccount)EveKitUserAccountProvider.getFactory().runTransaction((ConnectionFactory.RunInTransaction)new ConnectionFactory.RunInTransaction<EveKitUserAccount>(){

                public EveKitUserAccount run() throws Exception {
                    return (EveKitUserAccount)EveKitUserAccountProvider.getFactory().getEntityManager().merge((Object)data);
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "query error", e);
            return null;
        }
    }
}

