/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.ws.model;

import enterprises.orbital.base.OrbitalProperties;
import enterprises.orbital.base.PersistentProperty;
import enterprises.orbital.evekit.account.AccountNotFoundException;
import enterprises.orbital.evekit.account.EveKitUserAccount;
import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.account.UserNotFoundException;
import enterprises.orbital.evekit.model.CapsuleerSyncTracker;
import enterprises.orbital.evekit.model.CorporationSyncTracker;
import enterprises.orbital.evekit.model.RefSyncTracker;
import enterprises.orbital.evekit.model.SyncTracker;
import enterprises.orbital.evekit.ws.account.AccountWS;
import enterprises.orbital.evekit.ws.common.ServiceError;
import enterprises.orbital.oauth.AuthUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/ws/v1/tracker")
@Produces(value={"application/json"})
@Api(tags={"Account"}, produces="application/json")
public class SyncTrackerWS {
    private static final Logger log = Logger.getLogger(SyncTrackerWS.class.getName());
    public static final int DEF_MAX_CAP_SYNC_HISTORY = 100;
    public static final int DEF_MAX_CORP_SYNC_HISTORY = 100;
    public static final int DEF_MAX_REF_SYNC_HISTORY = 100;

    @Path(value="/cap_sync_history/{aid}")
    @GET
    @ApiOperation(value="Retrieve synchronization history for a Capsuleer account", notes="Retrieves capsuleer synchronization history ordered in descending order by sync start time")
    @ApiResponses(value={@ApiResponse(code=200, message="capsuleer sync history", response=CapsuleerSyncTracker.class, responseContainer="array"), @ApiResponse(code=401, message="requesting user not authenticated", response=ServiceError.class), @ApiResponse(code=404, message="requested account ID not found", response=ServiceError.class), @ApiResponse(code=500, message="Internal account service service error", response=ServiceError.class)})
    public Response requestCapsuleerSyncHistory(@Context HttpServletRequest request, @PathParam(value="aid") @ApiParam(name="aid", required=true, value="Sync Account ID") long aid, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Optional sync start time before which results will be returned") long contid, @QueryParam(value="maxresults") @ApiParam(name="maxresults", required=false, value="Maximum number of results to return") int maxResults) {
        EveKitUserAccount user = (EveKitUserAccount)AuthUtil.getCurrentUser((HttpServletRequest)request);
        if (user == null) {
            return AccountWS.createUserNotLoggedResponse();
        }
        try {
            SynchronizedEveAccount account = SynchronizedEveAccount.getSynchronizedAccount((EveKitUserAccount)user, (long)aid, (boolean)true);
            maxResults = OrbitalProperties.getNonzeroLimited((int)maxResults, (int)((int)PersistentProperty.getLongPropertyWithFallback((String)OrbitalProperties.getPropertyName(CapsuleerSyncTracker.class, (String)"maxresults"), (long)100L)));
            List results = CapsuleerSyncTracker.getHistory((SynchronizedEveAccount)account, (long)contid, (int)maxResults);
            return Response.ok().entity((Object)results).build();
        }
        catch (AccountNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Sync account with the given ID not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        catch (IOException e) {
            ServiceError errMsg = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Error retrieving history, contact admin if this problem persists");
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build();
        }
    }

    @Path(value="/corp_sync_history/{aid}")
    @GET
    @ApiOperation(value="Retrieve synchronization history for a Corporation account", notes="Retrieves corporation synchronization history ordered in descending order by sync start time")
    @ApiResponses(value={@ApiResponse(code=200, message="corporation sync history", response=CorporationSyncTracker.class, responseContainer="array"), @ApiResponse(code=401, message="requesting user not authenticated", response=ServiceError.class), @ApiResponse(code=404, message="requested account ID not found", response=ServiceError.class), @ApiResponse(code=500, message="Internal account service service error", response=ServiceError.class)})
    public Response requestCorporationSyncHistory(@Context HttpServletRequest request, @PathParam(value="aid") @ApiParam(name="aid", required=true, value="Sync Account ID") long aid, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Optional sync start time before which results will be returned") long contid, @QueryParam(value="maxresults") @ApiParam(name="maxresult", required=false, value="Maximum number of results to return") int maxResults) {
        EveKitUserAccount user = (EveKitUserAccount)AuthUtil.getCurrentUser((HttpServletRequest)request);
        if (user == null) {
            return AccountWS.createUserNotLoggedResponse();
        }
        try {
            SynchronizedEveAccount account = SynchronizedEveAccount.getSynchronizedAccount((EveKitUserAccount)user, (long)aid, (boolean)true);
            maxResults = OrbitalProperties.getNonzeroLimited((int)maxResults, (int)((int)PersistentProperty.getLongPropertyWithFallback((String)OrbitalProperties.getPropertyName(CorporationSyncTracker.class, (String)"maxresults"), (long)100L)));
            List results = CorporationSyncTracker.getHistory((SynchronizedEveAccount)account, (long)contid, (int)maxResults);
            return Response.ok().entity((Object)results).build();
        }
        catch (AccountNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Sync account with the given ID not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        catch (IOException e) {
            ServiceError errMsg = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Error retrieving history, contact admin if this problem persists");
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build();
        }
    }

    @Path(value="/cap_sync_unfinished")
    @GET
    @ApiOperation(value="Retrieve all unfinished capsuleer synchronization trackers", notes="Retrieves capsuleer synchronization trackers which are not yet finished")
    @ApiResponses(value={@ApiResponse(code=200, message="list of unfinished capsuleer sync trackers", response=CapsuleerSyncTracker.class, responseContainer="array"), @ApiResponse(code=401, message="requesting user not authenticated or not an admin", response=ServiceError.class), @ApiResponse(code=500, message="Internal account service service error", response=ServiceError.class)})
    public Response requestUnfinishedCapsuleerSync(@Context HttpServletRequest request) {
        EveKitUserAccount user = (EveKitUserAccount)AuthUtil.getCurrentUser((HttpServletRequest)request);
        if (user == null || !user.isAdmin()) {
            ServiceError errMsg = new ServiceError(Response.Status.UNAUTHORIZED.getStatusCode(), "User not logged in or is not an administrator");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)errMsg).build();
        }
        List results = CapsuleerSyncTracker.getAllUnfinishedTrackers();
        return Response.ok().entity((Object)results).build();
    }

    @Path(value="/corp_sync_unfinished")
    @GET
    @ApiOperation(value="Retrieve all unfinished corporation synchronization trackers", notes="Retrieves corporation synchronization trackers which are not yet finished")
    @ApiResponses(value={@ApiResponse(code=200, message="corporation sync history", response=CorporationSyncTracker.class, responseContainer="array"), @ApiResponse(code=401, message="requesting user not authenticated or not an admin", response=ServiceError.class), @ApiResponse(code=500, message="Internal account service service error", response=ServiceError.class)})
    public Response requestUnfinishedCorporationSync(@Context HttpServletRequest request) {
        EveKitUserAccount user = (EveKitUserAccount)AuthUtil.getCurrentUser((HttpServletRequest)request);
        if (user == null || !user.isAdmin()) {
            ServiceError errMsg = new ServiceError(Response.Status.UNAUTHORIZED.getStatusCode(), "User not logged in or is not an administrator");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)errMsg).build();
        }
        List results = CorporationSyncTracker.getAllUnfinishedTrackers();
        return Response.ok().entity((Object)results).build();
    }

    @Path(value="/finish_tracker/{uid}/{aid}/{tid}")
    @GET
    @ApiOperation(value="Force a tracker to be marked finished if it's not finished already", notes="Forces a tracker into the finished state whether it's been finished or not")
    @ApiResponses(value={@ApiResponse(code=200, message="finished successfully"), @ApiResponse(code=401, message="requesting user not authenticated or not an admin", response=ServiceError.class), @ApiResponse(code=404, message="Given user ID, account ID or tracker ID not found", response=ServiceError.class), @ApiResponse(code=500, message="Internal account service service error", response=ServiceError.class)})
    public Response requestFinishTracker(@Context HttpServletRequest request, @PathParam(value="uid") @ApiParam(name="uid", required=true, value="EveKit User Account ID") long uid, @PathParam(value="aid") @ApiParam(name="aid", required=true, value="Sync Account ID") long aid, @PathParam(value="tid") @ApiParam(name="tid", required=true, value="Sync Tracker ID") long tid) {
        EveKitUserAccount admin = (EveKitUserAccount)AuthUtil.getCurrentUser((HttpServletRequest)request);
        if (admin == null || !admin.isAdmin()) {
            ServiceError errMsg = new ServiceError(Response.Status.UNAUTHORIZED.getStatusCode(), "User not logged in or is not an administrator");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)errMsg).build();
        }
        try {
            EveKitUserAccount user = EveKitUserAccount.getAccount((long)uid);
            SynchronizedEveAccount account = SynchronizedEveAccount.getSynchronizedAccount((EveKitUserAccount)user, (long)aid, (boolean)true);
            SyncTracker tracker = SyncTracker.get((SynchronizedEveAccount)account, (long)tid);
            if (tracker == null) {
                ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Target sync tracker not found");
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
            }
            if ((tracker = SyncTracker.finishTracker((SyncTracker)tracker)) == null) {
                ServiceError errMsg = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Failed to finish tracker, contact admin for details");
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build();
            }
            return Response.ok().build();
        }
        catch (UserNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Target user not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        catch (AccountNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Target synchronized account not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        catch (IOException e) {
            ServiceError errMsg = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Error finishing tracker, contact admin if this problem persists");
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build();
        }
    }

    @Path(value="/ref_sync_history")
    @GET
    @ApiOperation(value="Retrieve synchronization history for a reference data", notes="Retrieves reference data synchronization history ordered in descending order by sync start time")
    @ApiResponses(value={@ApiResponse(code=200, message="reference data sync history", response=RefSyncTracker.class, responseContainer="array"), @ApiResponse(code=401, message="requesting user not authenticated", response=ServiceError.class), @ApiResponse(code=500, message="Internal account service service error", response=ServiceError.class)})
    public Response requestRefSyncHistory(@Context HttpServletRequest request, @QueryParam(value="contid") @DefaultValue(value="-1") @ApiParam(name="contid", required=false, defaultValue="-1", value="Optional sync start time before which results will be returned") long contid, @QueryParam(value="maxresults") @ApiParam(name="maxresults", required=false, value="Maximum number of results to return") int maxResults) {
        EveKitUserAccount user = (EveKitUserAccount)AuthUtil.getCurrentUser((HttpServletRequest)request);
        if (user == null || !user.isAdmin()) {
            ServiceError errMsg = new ServiceError(Response.Status.UNAUTHORIZED.getStatusCode(), "User not logged in or is not an administrator");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)errMsg).build();
        }
        maxResults = OrbitalProperties.getNonzeroLimited((int)maxResults, (int)((int)PersistentProperty.getLongPropertyWithFallback((String)OrbitalProperties.getPropertyName(RefSyncTracker.class, (String)"maxresults"), (long)100L)));
        List results = RefSyncTracker.getHistory((long)contid, (int)maxResults);
        return Response.ok().entity((Object)results).build();
    }

    @Path(value="/ref_sync_unfinished")
    @GET
    @ApiOperation(value="Retrieve all unfinished ref data synchronization trackers", notes="Retrieves ref data synchronization trackers which are not yet finished")
    @ApiResponses(value={@ApiResponse(code=200, message="list of unfinished ref data sync trackers", response=RefSyncTracker.class, responseContainer="array"), @ApiResponse(code=401, message="requesting user not authenticated or not an admin", response=ServiceError.class), @ApiResponse(code=500, message="Internal account service service error", response=ServiceError.class)})
    public Response requestUnfinishedRefSync(@Context HttpServletRequest request) {
        EveKitUserAccount user = (EveKitUserAccount)AuthUtil.getCurrentUser((HttpServletRequest)request);
        if (user == null || !user.isAdmin()) {
            ServiceError errMsg = new ServiceError(Response.Status.UNAUTHORIZED.getStatusCode(), "User not logged in or is not an administrator");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)errMsg).build();
        }
        List results = RefSyncTracker.getAllUnfinishedTrackers();
        return Response.ok().entity((Object)results).build();
    }

    @Path(value="/finish_ref_tracker/{tid}")
    @GET
    @ApiOperation(value="Force a ref tracker to be marked finished if it's not finished already", notes="Forces a ref tracker into the finished state whether it's been finished or not")
    @ApiResponses(value={@ApiResponse(code=200, message="finished successfully"), @ApiResponse(code=401, message="requesting user not authenticated or not an admin", response=ServiceError.class), @ApiResponse(code=404, message="Given tracker ID not found", response=ServiceError.class), @ApiResponse(code=500, message="Internal account service service error", response=ServiceError.class)})
    public Response requestFinishRefTracker(@Context HttpServletRequest request, @PathParam(value="tid") @ApiParam(name="tid", required=true, value="Ref Sync Tracker ID") long tid) {
        EveKitUserAccount admin = (EveKitUserAccount)AuthUtil.getCurrentUser((HttpServletRequest)request);
        if (admin == null || !admin.isAdmin()) {
            ServiceError errMsg = new ServiceError(Response.Status.UNAUTHORIZED.getStatusCode(), "User not logged in or is not an administrator");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)errMsg).build();
        }
        RefSyncTracker tracker = RefSyncTracker.get((long)tid);
        if (tracker == null) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Target sync tracker not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        if ((tracker = RefSyncTracker.finishTracker((RefSyncTracker)tracker)) == null) {
            ServiceError errMsg = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Failed to finish tracker, contact admin for details");
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build();
        }
        return Response.ok().build();
    }
}

