/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.ws.account;

import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.BaseApi;
import com.github.scribejava.core.model.AbstractRequest;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import enterprises.orbital.base.OrbitalProperties;
import enterprises.orbital.eve.esi.client.api.CharacterApi;
import enterprises.orbital.eve.esi.client.api.CorporationApi;
import enterprises.orbital.eve.esi.client.invoker.ApiException;
import enterprises.orbital.eve.esi.client.model.GetCharactersCharacterIdOk;
import enterprises.orbital.eve.esi.client.model.GetCorporationsCorporationIdOk;
import enterprises.orbital.evekit.account.AccountNotFoundException;
import enterprises.orbital.evekit.account.AccountUpdateException;
import enterprises.orbital.evekit.account.EveKitUserAccount;
import enterprises.orbital.evekit.account.NewESIToken;
import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.ws.account.AccountWS;
import enterprises.orbital.evekit.ws.common.ServiceError;
import enterprises.orbital.evexmlapi.EveXmlApiAdapter;
import enterprises.orbital.evexmlapi.EveXmlApiConfig;
import enterprises.orbital.evexmlapi.act.IAccountAPI;
import enterprises.orbital.evexmlapi.act.ICharacter;
import enterprises.orbital.oauth.AuthUtil;
import enterprises.orbital.oauth.EVEApi;
import enterprises.orbital.oauth.EVEAuthHandler;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.http.client.utils.URIBuilder;

@Path(value="/ws/v1/cred")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(tags={"Credential"}, produces="application/json", consumes="application/json")
public class CredentialWS {
    public static final Logger log = Logger.getLogger(CredentialWS.class.getName());
    public static final String PROP_TOKEN_EVE_CLIENT_ID = "enterprises.orbital.token.eve_client_id";
    public static final String PROP_TOKEN_EVE_SECRET_KEY = "enterprises.orbital.token.eve_secret_key";
    public static final String PROP_EVE_VERIFY_URL = "enterprises.orbital.auth.eve_verify_url";
    public static final String PROP_ESI_SERVER_PATH = "enterprises.orbital.evekit.accountws.esiServerPath";
    public static final String DEF_ESI_SERVER_PATH = "https://esi.tech.ccp.is/latest";
    public static final String PROP_APP_PATH = "enterprises.orbital.evekit.accountws.apppath";
    public static final String DEF_APP_PATH = "http://localhost/controller";
    public static final String PROP_TEMP_TOKEN_LIFETIME = "enterprises.orbital.evekit.tempTokenLifetime";
    public static final long DEF_TEMP_TOKEN_LIFETIME = TimeUnit.MILLISECONDS.convert(10L, TimeUnit.MINUTES);
    public static final String PROP_REAUTH_SUCCESS_FRAGMENT = "enterprises.orbital.evekit.reauthFragment";
    public static final String DEF_REAUTH_SUCCESS_FRAGMENT = "account";
    public static final String PROP_SITE_AGENT = "enterprises.orbital.evekit.site_agent";
    public static final String DEF_SITE_AGENT = "EveKit/4.0.0 (https://evekit.orbital.enterprises; deadlybulb@orbital.enterprises; )";

    protected static URIBuilder makeStandardBuilder() {
        try {
            URIBuilder builder = new URIBuilder(OrbitalProperties.getGlobalProperty((String)PROP_APP_PATH, (String)DEF_APP_PATH) + "/");
            return builder;
        }
        catch (URISyntaxException e) {
            log.log(Level.SEVERE, "Configuration error: " + e);
            throw new RuntimeException("Unrecoverable configuration error");
        }
    }

    protected static Response startTokenFlow(HttpServletRequest request, EveKitUserAccount user, SynchronizedEveAccount account, String scopes) throws IOException {
        URIBuilder builder = CredentialWS.makeStandardBuilder();
        builder.setPath(builder.getPath() + "api/ws/v1/cred/esi_callback");
        String eveClientID = OrbitalProperties.getGlobalProperty((String)PROP_TOKEN_EVE_CLIENT_ID);
        String eveSecretKey = OrbitalProperties.getGlobalProperty((String)PROP_TOKEN_EVE_SECRET_KEY);
        long now = OrbitalProperties.getCurrentTime();
        long expiry = now + OrbitalProperties.getLongGlobalProperty((String)PROP_TEMP_TOKEN_LIFETIME, (long)DEF_TEMP_TOKEN_LIFETIME);
        NewESIToken key = NewESIToken.createKey((EveKitUserAccount)user, (SynchronizedEveAccount)account, (long)now, (long)expiry, (String)scopes);
        final String redirect = EVEAuthHandler.doGet((String)eveClientID, (String)eveSecretKey, (String)builder.toString(), (String)scopes, (String)key.getStateKey(), (HttpServletRequest)request);
        if (redirect == null) {
            ServiceError errMsg = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Internal error creating ESI credential, contact admin if this problem persists");
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build();
        }
        return Response.ok().entity(new Object(){
            public final String newLocation;
            {
                this.newLocation = redirect;
            }
        }).build();
    }

    protected static void processTokenCallback(HttpServletRequest req, String verifyURL, String eveClientID, String eveSecretKey) throws AccountUpdateException, IOException {
        String corpName;
        long corpID;
        String stateKey = req.getParameter("state");
        if (stateKey == null) {
            throw new IOException("request missing OAuth state");
        }
        NewESIToken keyState = NewESIToken.getKeyByState((String)stateKey);
        if (keyState == null) {
            throw new IOException("no temporary key found with provided state");
        }
        NewESIToken.deleteKey((long)keyState.getKid());
        OAuth20Service service = (OAuth20Service)new ServiceBuilder().apiKey(eveClientID).apiSecret(eveSecretKey).build((BaseApi)EVEApi.instance());
        OAuth2AccessToken accessToken = service.getAccessToken(req.getParameter("code"));
        OAuthRequest request = new OAuthRequest(Verb.GET, verifyURL, service.getConfig());
        service.signRequest(accessToken, (AbstractRequest)request);
        com.github.scribejava.core.model.Response response = request.send();
        if (!response.isSuccessful()) {
            throw new IOException("credential request was not successful!");
        }
        JsonObject responseObject = new JsonParser().parse(response.getBody()).getAsJsonObject();
        String charName = responseObject.get("CharacterName").getAsString();
        long charID = responseObject.get("CharacterID").getAsLong();
        String siteAgent = OrbitalProperties.getGlobalProperty((String)PROP_SITE_AGENT, (String)DEF_SITE_AGENT);
        try {
            CharacterApi charApi = new CharacterApi();
            GetCharactersCharacterIdOk charResult = charApi.getCharactersCharacterId(Integer.valueOf((int)charID), null, siteAgent, null);
            corpID = charResult.getCorporationId().intValue();
            CorporationApi corpApi = new CorporationApi();
            GetCorporationsCorporationIdOk result = corpApi.getCorporationsCorporationId(charResult.getCorporationId(), null, siteAgent, null);
            corpName = result.getCorporationName();
        }
        catch (ApiException e) {
            throw new IOException("Exception while retrieving corporation information", e);
        }
        try {
            long tokenExpiry = OrbitalProperties.getCurrentTime() + TimeUnit.MILLISECONDS.convert(accessToken.getExpiresIn().intValue(), TimeUnit.SECONDS);
            SynchronizedEveAccount.setESICredential((EveKitUserAccount)keyState.getUser(), (long)keyState.getAccount().getAid(), (String)accessToken.getAccessToken(), (long)tokenExpiry, (String)accessToken.getRefreshToken(), (String)keyState.getScopes(), (long)charID, (String)charName, (long)corpID, (String)corpName);
        }
        catch (AccountNotFoundException e) {
            throw new IOException("Account disappeared before authorization could complete");
        }
    }

    @Path(value="/cred_xml/{aid}")
    @POST
    @ApiOperation(value="Set the XML API credential for a synchronized EVE account.  Returns the result of applying the change.")
    @ApiResponses(value={@ApiResponse(code=200, message="Credential set successfully", response=SynchronizedEveAccount.class), @ApiResponse(code=401, message="Requestor is not logged in", response=ServiceError.class), @ApiResponse(code=403, message="Provided xml credential has an illegal value.  More details are provided in the response message", response=ServiceError.class), @ApiResponse(code=404, message="Requesting for other than logged in user, but target user not found; or, the target account is not found", response=ServiceError.class), @ApiResponse(code=500, message="Error using provided credentials, or other internal account service service error", response=ServiceError.class)})
    public Response setXMLCredential(@Context HttpServletRequest request, @PathParam(value="aid") @ApiParam(name="aid", required=true, value="ID of sync account owning credential to be updated or saved.") long aid, @QueryParam(value="key") @ApiParam(name="key", required=true, value="XML API access key") int key, @QueryParam(value="charID") @ApiParam(name="charID", required=true, value="Character ID to use with this credential") long charID, @ApiParam(name="vcode", required=true, value="XML API access verification code") String vcode) {
        ServiceError errMsg;
        if (vcode == null) {
            ServiceError errMsg2 = new ServiceError(Response.Status.FORBIDDEN.getStatusCode(), "POST argument is null");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)errMsg2).build();
        }
        EveKitUserAccount user = (EveKitUserAccount)AuthUtil.getCurrentUser((HttpServletRequest)request);
        if (user == null) {
            return AccountWS.createUserNotLoggedResponse();
        }
        long characterID = -1L;
        long corporationID = -1L;
        String characterName = null;
        String corporationName = null;
        try {
            String siteAgent = OrbitalProperties.getGlobalProperty((String)PROP_SITE_AGENT, (String)DEF_SITE_AGENT);
            EveXmlApiAdapter apiHandle = new EveXmlApiAdapter(EveXmlApiConfig.get().agent(siteAgent));
            IAccountAPI accountHandle = apiHandle.getAccountAPIService(key, vcode);
            Collection charList = accountHandle.requestCharacters();
            for (ICharacter next : charList) {
                if (next.getCharacterID() != charID) continue;
                characterID = charID;
                characterName = next.getName();
                corporationID = (int)next.getCorporationID();
                corporationName = next.getCorporationName();
                break;
            }
            if (characterName == null) {
                ServiceError errMsg3 = new ServiceError(Response.Status.FORBIDDEN.getStatusCode(), "Could not find character " + charID + " with provided credentials");
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)errMsg3).build();
            }
        }
        catch (URISyntaxException e) {
            log.log(Level.SEVERE, "error setting site agent", e);
            ServiceError errMsg4 = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Internal error saving credential, contact admin if problem persists");
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg4).build();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "error retrieving character info", e);
            ServiceError errMsg5 = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Unable to retrieve character info with provided credentials, contact admin if problem persists");
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg5).build();
        }
        try {
            SynchronizedEveAccount account = SynchronizedEveAccount.setXMLCredential((EveKitUserAccount)user, (long)aid, (int)key, (String)vcode, (long)characterID, characterName, (long)corporationID, corporationName);
            return Response.ok().entity((Object)account).build();
        }
        catch (AccountNotFoundException | AccountUpdateException e) {
            errMsg = new ServiceError(Response.Status.FORBIDDEN.getStatusCode(), e.getMessage());
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)errMsg).build();
        }
        catch (IOException e) {
            errMsg = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Internal error saving credential, contact admin if problem persists");
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build();
        }
    }

    @Path(value="/cred_esi/{aid}")
    @POST
    @ApiOperation(value="Set the ESI credential for a synchronized account by starting an OAuth flow.")
    @ApiResponses(value={@ApiResponse(code=200, message="OAuth flow started.  Result will be an object with a 'newLocation' field containing a redirect"), @ApiResponse(code=401, message="requestor not logged in", response=ServiceError.class), @ApiResponse(code=403, message="illegal scope value or can't find target account.", response=ServiceError.class), @ApiResponse(code=500, message="Internal service error", response=ServiceError.class)})
    public Response setESICredential(@Context HttpServletRequest request, @PathParam(value="aid") @ApiParam(name="aid", required=true, value="ID of sync account owning credential to be created.") long aid, @ApiParam(name="scopes", required=true, value="Space separated list of scopes for credential") String scopes) {
        if (scopes == null || scopes.length() == 0) {
            ServiceError errMsg = new ServiceError(Response.Status.FORBIDDEN.getStatusCode(), "POST argument is null or has zero length");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)errMsg).build();
        }
        EveKitUserAccount user = (EveKitUserAccount)AuthUtil.getCurrentUser((HttpServletRequest)request);
        if (user == null) {
            return AccountWS.createUserNotLoggedResponse();
        }
        try {
            SynchronizedEveAccount account = SynchronizedEveAccount.getSynchronizedAccount((EveKitUserAccount)user, (long)aid, (boolean)false);
            return CredentialWS.startTokenFlow(request, user, account, scopes);
        }
        catch (AccountNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.FORBIDDEN.getStatusCode(), "Can't find target account");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)errMsg).build();
        }
        catch (IOException e) {
            ServiceError errMsg = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Internal error starting OAuth flow, contact admin if problem persists");
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build();
        }
    }

    @Path(value="/esi_callback")
    @GET
    @ApiOperation(value="Handle OAuth callback for ESI credential setting")
    @ApiResponses(value={@ApiResponse(code=307, message="Temporary redirect back to main site."), @ApiResponse(code=403, message="Inconsistency detected when attempting to set credential"), @ApiResponse(code=500, message="Internal error while handling callback")})
    public Response esiCredentialCallback(@Context HttpServletRequest req) {
        String eveClientID = OrbitalProperties.getGlobalProperty((String)PROP_TOKEN_EVE_CLIENT_ID);
        String eveSecretKey = OrbitalProperties.getGlobalProperty((String)PROP_TOKEN_EVE_SECRET_KEY);
        String eveVerifyURL = OrbitalProperties.getGlobalProperty((String)PROP_EVE_VERIFY_URL);
        URIBuilder builder = CredentialWS.makeStandardBuilder();
        builder.setFragment(OrbitalProperties.getGlobalProperty((String)PROP_REAUTH_SUCCESS_FRAGMENT, (String)DEF_REAUTH_SUCCESS_FRAGMENT));
        try {
            CredentialWS.processTokenCallback(req, eveVerifyURL, eveClientID, eveSecretKey);
            return Response.temporaryRedirect((URI)new URI(builder.toString())).build();
        }
        catch (URISyntaxException e) {
            log.log(Level.SEVERE, "Configuration error: " + e);
            throw new RuntimeException("Unrecoverable configuration error");
        }
        catch (AccountUpdateException e) {
            builder.setCustomQuery("auth_error=" + e.getMessage());
            try {
                return Response.temporaryRedirect((URI)new URI(builder.toString())).build();
            }
            catch (URISyntaxException f) {
                log.log(Level.SEVERE, "Configuration error: " + (Object)((Object)e));
                throw new RuntimeException("Unrecoverable configuration error");
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Error processing token callback", e);
            builder.setCustomQuery("auth_error=Internal error setting ESI credential, contact admin if problem persists");
            try {
                return Response.temporaryRedirect((URI)new URI(builder.toString())).build();
            }
            catch (URISyntaxException f) {
                log.log(Level.SEVERE, "Configuration error: " + e);
                throw new RuntimeException("Unrecoverable configuration error");
            }
        }
    }

    @Path(value="/cred_xml/{aid}")
    @DELETE
    @ApiOperation(value="Remove the XML credential from a sync account")
    @ApiResponses(value={@ApiResponse(code=200, message="credential removed successfully"), @ApiResponse(code=401, message="requestor is not logged in", response=ServiceError.class), @ApiResponse(code=404, message="target account not found", response=ServiceError.class), @ApiResponse(code=500, message="Internal account service service error", response=ServiceError.class)})
    public Response clearXMLCredential(@Context HttpServletRequest request, @PathParam(value="aid") @ApiParam(name="aid", required=true, value="ID of sync account owning credential to be deleted.") long aid) {
        EveKitUserAccount user = (EveKitUserAccount)AuthUtil.getCurrentUser((HttpServletRequest)request);
        if (user == null) {
            return AccountWS.createUserNotLoggedResponse();
        }
        try {
            SynchronizedEveAccount.clearXMLCredential((EveKitUserAccount)user, (long)aid);
        }
        catch (AccountNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Target account not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        catch (IOException e) {
            ServiceError errMsg = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Internal error removing XML credential, contact admin if this problem persists");
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build();
        }
        return Response.ok().build();
    }

    @Path(value="/cred_esi/{aid}")
    @DELETE
    @ApiOperation(value="Remove the ESI credential from a sync account")
    @ApiResponses(value={@ApiResponse(code=200, message="credential removed successfully"), @ApiResponse(code=401, message="requestor is not logged in", response=ServiceError.class), @ApiResponse(code=404, message="target account not found", response=ServiceError.class), @ApiResponse(code=500, message="Internal account service service error", response=ServiceError.class)})
    public Response clearESICredential(@Context HttpServletRequest request, @PathParam(value="aid") @ApiParam(name="aid", required=true, value="ID of sync account owning credential to be deleted.") long aid) {
        EveKitUserAccount user = (EveKitUserAccount)AuthUtil.getCurrentUser((HttpServletRequest)request);
        if (user == null) {
            return AccountWS.createUserNotLoggedResponse();
        }
        try {
            SynchronizedEveAccount.clearESICredential((EveKitUserAccount)user, (long)aid);
        }
        catch (AccountNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Target account not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        catch (IOException e) {
            ServiceError errMsg = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Internal error removing ESI credential, contact admin if this problem persists");
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build();
        }
        return Response.ok().build();
    }
}

