/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.ws.account;

import enterprises.orbital.evekit.account.AccessKeyCreationException;
import enterprises.orbital.evekit.account.AccessKeyNotFoundException;
import enterprises.orbital.evekit.account.AccessKeyUpdateException;
import enterprises.orbital.evekit.account.AccountAccessMask;
import enterprises.orbital.evekit.account.AccountCreationException;
import enterprises.orbital.evekit.account.AccountNotFoundException;
import enterprises.orbital.evekit.account.AccountUpdateException;
import enterprises.orbital.evekit.account.EveKitUserAccount;
import enterprises.orbital.evekit.account.EveKitUserAuthSource;
import enterprises.orbital.evekit.account.SynchronizedAccountAccessKey;
import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.account.UserNotFoundException;
import enterprises.orbital.evekit.model.CapsuleerSyncTracker;
import enterprises.orbital.evekit.model.CorporationSyncTracker;
import enterprises.orbital.evekit.model.ESISyncEndpoint;
import enterprises.orbital.evekit.model.SyncTracker;
import enterprises.orbital.evekit.ws.common.ServiceError;
import enterprises.orbital.evekit.ws.model.ESISyncEndpointModel;
import enterprises.orbital.oauth.AuthUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/ws/v1/account")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(tags={"Account"}, produces="application/json", consumes="application/json")
public class AccountWS {
    public static Response checkRequireAdmin(EveKitUserAccount user, long uid) {
        if (user.getID() != uid && uid != -1L) {
            if (!user.isAdmin()) {
                ServiceError errMsg = new ServiceError(Response.Status.UNAUTHORIZED.getStatusCode(), "Requestor must be an admin for this request");
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)errMsg).build();
            }
            try {
                EveKitUserAccount.getAccount((long)uid);
            }
            catch (UserNotFoundException | IOException e) {
                ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Target user not found");
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
            }
        }
        return null;
    }

    public static Response createUserNotLoggedResponse() {
        ServiceError errMsg = new ServiceError(Response.Status.UNAUTHORIZED.getStatusCode(), "Requestor not logged in");
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)errMsg).build();
    }

    @Path(value="/sync_account/{uid}/{aid}")
    @GET
    @ApiOperation(value="Get list of sync accounts for the given user or only a single account if an id is provided")
    @ApiResponses(value={@ApiResponse(code=200, message="list of sync accounts", response=SynchronizedEveAccount.class, responseContainer="array"), @ApiResponse(code=401, message="requesting for other than logged in user but requestor not logged in or not an admin", response=ServiceError.class), @ApiResponse(code=404, message="specified user or sync account not found", response=ServiceError.class), @ApiResponse(code=500, message="Internal account service service error", response=ServiceError.class)})
    public Response getSyncAccount(@Context HttpServletRequest request, @PathParam(value="uid") @ApiParam(name="uid", required=true, value="ID of user for which sync accounts will be retrieved.  Set to -1 to retrieve for the current logged in user.") long uid, @PathParam(value="aid") @ApiParam(name="aid", required=true, value="ID of single sync account to retrieve.  Set to -1 to retrieve all sync accounts for the given user.") long aid) {
        EveKitUserAccount user = (EveKitUserAccount)AuthUtil.getCurrentUser((HttpServletRequest)request);
        if (user == null) {
            return AccountWS.createUserNotLoggedResponse();
        }
        Response error = AccountWS.checkRequireAdmin(user, uid);
        if (error != null) {
            return error;
        }
        try {
            if (uid != -1L) {
                user = EveKitUserAccount.getAccount((long)uid);
            }
            ArrayList<SynchronizedEveAccount> result = new ArrayList<SynchronizedEveAccount>();
            if (aid != -1L) {
                result.add(SynchronizedEveAccount.getSynchronizedAccount((EveKitUserAccount)user, (long)aid, (boolean)true));
            } else {
                result.addAll(SynchronizedEveAccount.getAllAccounts((EveKitUserAccount)user, (boolean)true));
            }
            for (SynchronizedEveAccount next : result) {
                SyncTracker tracker = SyncTracker.getLatestFinishedTracker((SynchronizedEveAccount)next);
                if (tracker != null) {
                    next.setLastSynchronized(tracker.getSyncEnd());
                }
                next.updateValid();
            }
            return Response.ok().entity(result).build();
        }
        catch (UserNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Target user not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        catch (AccountNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Account with given ID not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        catch (IOException e) {
            ServiceError errMsg = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Error retrieving accounts, contact admin if this problem persists");
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build();
        }
    }

    @Path(value="/sync_account/{uid}/{aid}")
    @POST
    @ApiOperation(value="Create or update a sync account.  Returns the result of applying the change.")
    @ApiResponses(value={@ApiResponse(code=200, message="account saved or updated successfully", response=SynchronizedEveAccount.class), @ApiResponse(code=401, message="either the requestor is not logged in, or requesting for other than logged in user but requestor not logged in or not an admin", response=ServiceError.class), @ApiResponse(code=403, message="provided sync account has an illegal value.  More details are provided in the response message.", response=ServiceError.class), @ApiResponse(code=404, message="requesting for other than logged in user, but target user not found; or, updating an existing account but target account not found", response=ServiceError.class), @ApiResponse(code=500, message="Internal account service service error", response=ServiceError.class)})
    public Response saveSyncAccount(@Context HttpServletRequest request, @PathParam(value="uid") @ApiParam(name="uid", required=true, value="ID of user for which a sync account will be updated or saved.  Set to -1 for the current logged in user.") long uid, @PathParam(value="aid") @ApiParam(name="aid", required=true, value="ID of sync account to update.  Set to -1 to save a new account.") long aid, @QueryParam(value="name") @ApiParam(name="name", required=true, value="Name of new account, or new name of existing account") String name, @QueryParam(value="charType") @ApiParam(name="charType", required=true, value="True if account will sync a character, false otherwise.  Ignored for updates to existing accounts.") boolean charType, @QueryParam(value="autoSync") @ApiParam(name="autoSync", required=true, value="True if account should auto synchronized, false otherwise") boolean autoSync) {
        EveKitUserAccount user = (EveKitUserAccount)AuthUtil.getCurrentUser((HttpServletRequest)request);
        if (user == null) {
            return AccountWS.createUserNotLoggedResponse();
        }
        Response error = AccountWS.checkRequireAdmin(user, uid);
        if (error != null) {
            return error;
        }
        try {
            if (uid != -1L) {
                user = EveKitUserAccount.getAccount((long)uid);
            }
            SynchronizedEveAccount result = aid == -1L ? SynchronizedEveAccount.createSynchronizedEveAccount((EveKitUserAccount)user, (String)name, (boolean)charType, (boolean)autoSync) : SynchronizedEveAccount.updateAccount((EveKitUserAccount)user, (long)aid, (String)name, (boolean)autoSync);
            result.updateValid();
            return Response.ok().entity((Object)result).build();
        }
        catch (UserNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Target user not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        catch (AccountCreationException e) {
            ServiceError errMsg = new ServiceError(Response.Status.FORBIDDEN.getStatusCode(), "Requested account name already in use for user");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)errMsg).build();
        }
        catch (AccountNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Target account not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        catch (AccountUpdateException e) {
            ServiceError errMsg = new ServiceError(Response.Status.FORBIDDEN.getStatusCode(), "Account name change requested, but new name already in use");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)errMsg).build();
        }
        catch (IOException e) {
            ServiceError errMsg = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Internal error processing change, contact admin if problem persists");
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build();
        }
    }

    @Path(value="/sync_account/{uid}/{aid}")
    @DELETE
    @ApiOperation(value="Delete a sync account.")
    @ApiResponses(value={@ApiResponse(code=200, message="account marked for delete successfully"), @ApiResponse(code=401, message="either the requestor is not logged in, or requesting for other than logged in user but requestor not logged in or not an admin", response=ServiceError.class), @ApiResponse(code=404, message="requesting for other than logged in user, but target user not found; or, deleting an existing account but target account not found", response=ServiceError.class), @ApiResponse(code=500, message="Internal account service service error", response=ServiceError.class)})
    public Response deleteSyncAccount(@Context HttpServletRequest request, @PathParam(value="uid") @ApiParam(name="uid", required=true, value="ID of user for which a sync account will be marked for delete.  Set to -1 for the current logged in user.") long uid, @PathParam(value="aid") @ApiParam(name="aid", required=true, value="ID of sync account to mark.") long aid) {
        EveKitUserAccount user = (EveKitUserAccount)AuthUtil.getCurrentUser((HttpServletRequest)request);
        if (user == null) {
            return AccountWS.createUserNotLoggedResponse();
        }
        Response error = AccountWS.checkRequireAdmin(user, uid);
        if (error != null) {
            return error;
        }
        try {
            if (uid != -1L) {
                user = EveKitUserAccount.getAccount((long)uid);
            }
            SynchronizedEveAccount.deleteAccount((EveKitUserAccount)user, (long)aid);
            return Response.ok().build();
        }
        catch (UserNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Target user not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        catch (AccountNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Target account not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        catch (IOException e) {
            ServiceError errMsg = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Internal error marking account, contact admin if problem persists");
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build();
        }
    }

    @Path(value="/restore_sync_account/{uid}/{aid}")
    @PUT
    @ApiOperation(value="Restore a sync account previously marked for deletion.")
    @ApiResponses(value={@ApiResponse(code=200, message="account restored successfully"), @ApiResponse(code=401, message="either the requestor is not logged in, or requesting for other than logged in user but requestor not logged in or not an admin", response=ServiceError.class), @ApiResponse(code=404, message="requesting for other than logged in user, but target user not found; or, restoring an existing account but target account not found", response=ServiceError.class), @ApiResponse(code=500, message="Internal account service service error", response=ServiceError.class)})
    public Response restoreSyncAccount(@Context HttpServletRequest request, @PathParam(value="uid") @ApiParam(name="uid", required=true, value="ID of user for which a sync account will be restored.  Set to -1 for the current logged in user.") long uid, @PathParam(value="aid") @ApiParam(name="aid", required=true, value="ID of sync account to restore.") long aid) {
        EveKitUserAccount user = (EveKitUserAccount)AuthUtil.getCurrentUser((HttpServletRequest)request);
        if (user == null) {
            return AccountWS.createUserNotLoggedResponse();
        }
        Response error = AccountWS.checkRequireAdmin(user, uid);
        if (error != null) {
            return error;
        }
        try {
            if (uid != -1L) {
                user = EveKitUserAccount.getAccount((long)uid);
            }
            SynchronizedEveAccount.restoreAccount((EveKitUserAccount)user, (long)aid);
            return Response.ok().build();
        }
        catch (UserNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Target user not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        catch (AccountNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Target account not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        catch (IOException e) {
            ServiceError errMsg = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Internal error marking account, contact admin if this problem persists");
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build();
        }
    }

    @Path(value="/start_sync/{uid}/{aid}")
    @GET
    @ApiOperation(value="Request a sync of the given account and, optionally, the given user id")
    @ApiResponses(value={@ApiResponse(code=200, message="sync request initiated"), @ApiResponse(code=401, message="requesting for other than logged in user but requestor not logged in or not an admin", response=ServiceError.class), @ApiResponse(code=404, message="specified user or sync account not found", response=ServiceError.class), @ApiResponse(code=500, message="Internal account service service error", response=ServiceError.class)})
    public Response requestSync(@Context HttpServletRequest request, @PathParam(value="uid") @ApiParam(name="uid", required=true, value="ID of user for which a sync will be initiated.  Set to -1 to retrieve for the current logged in user.") long uid, @PathParam(value="aid") @ApiParam(name="aid", required=true, value="ID of sync account for which a sync will be initiated.") long aid) {
        EveKitUserAccount user = (EveKitUserAccount)AuthUtil.getCurrentUser((HttpServletRequest)request);
        if (user == null) {
            return AccountWS.createUserNotLoggedResponse();
        }
        Response error = AccountWS.checkRequireAdmin(user, uid);
        if (error != null) {
            return error;
        }
        try {
            SynchronizedEveAccount sa;
            Object result;
            if (uid != -1L) {
                user = EveKitUserAccount.getAccount((long)uid);
            }
            if ((result = (sa = SynchronizedEveAccount.getSynchronizedAccount((EveKitUserAccount)user, (long)aid, (boolean)true)).isCharacterType() ? CapsuleerSyncTracker.createOrGetUnfinishedTracker((SynchronizedEveAccount)sa) : CorporationSyncTracker.createOrGetUnfinishedTracker((SynchronizedEveAccount)sa)) == null) {
                ServiceError errMsg = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Error creating sync request.  If this problem persists, please contact the system administrator.");
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build();
            }
            return Response.ok().build();
        }
        catch (UserNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Target user not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        catch (AccountNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Account with given ID not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        catch (IOException e) {
            ServiceError errMsg = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Internal error starting sync, contact admin if this problem persists");
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build();
        }
    }

    @Path(value="/access_key/{uid}/{aid}/{kid}")
    @GET
    @ApiOperation(value="Get list of access keys for the given user and account id")
    @ApiResponses(value={@ApiResponse(code=200, message="list of access keys", response=SynchronizedAccountAccessKey.class, responseContainer="array"), @ApiResponse(code=401, message="requesting for other than logged in user but requestor not logged in or not an admin", response=ServiceError.class), @ApiResponse(code=404, message="specified user, sync account, or access key not found", response=ServiceError.class), @ApiResponse(code=500, message="Internal account service service error", response=ServiceError.class)})
    public Response getAccessKey(@Context HttpServletRequest request, @PathParam(value="uid") @ApiParam(name="uid", required=true, value="ID of user for which access keys will be retrieved.  Set to -1 to retrieve for the current logged in user.") long uid, @PathParam(value="aid") @ApiParam(name="aid", required=true, value="ID of sync account for which keys will be retrieved.") long aid, @PathParam(value="kid") @ApiParam(name="kid", required=true, value="ID of access key to retrieve, or -1 to retrieve all access keys for the given account.") long kid) {
        EveKitUserAccount user = (EveKitUserAccount)AuthUtil.getCurrentUser((HttpServletRequest)request);
        if (user == null) {
            return AccountWS.createUserNotLoggedResponse();
        }
        Response error = AccountWS.checkRequireAdmin(user, uid);
        if (error != null) {
            return error;
        }
        try {
            if (uid != -1L) {
                user = EveKitUserAccount.getAccount((long)uid);
            }
            SynchronizedEveAccount account = SynchronizedEveAccount.getSynchronizedAccount((EveKitUserAccount)user, (long)aid, (boolean)true);
            ArrayList<SynchronizedAccountAccessKey> result = new ArrayList<SynchronizedAccountAccessKey>();
            if (kid != -1L) {
                result.add(SynchronizedAccountAccessKey.getKeyByOwnerAndID((SynchronizedEveAccount)account, (long)kid));
            } else {
                result.addAll(SynchronizedAccountAccessKey.getAllKeys((SynchronizedEveAccount)account));
            }
            for (SynchronizedAccountAccessKey nextKey : result) {
                nextKey.generateMaskValue();
                nextKey.generateMaskValueString();
                nextKey.generateCredential();
            }
            return Response.ok().entity(result).build();
        }
        catch (UserNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Target user not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        catch (AccessKeyNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Key with given ID not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        catch (AccountNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Target account not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        catch (IOException e) {
            ServiceError errMsg = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Error retrieving access keys, contact admin if this problem persists");
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build();
        }
    }

    @Path(value="/access_key/{uid}/{aid}/{kid}")
    @POST
    @ApiOperation(value="Create or update an access key.  Returns the result of applying the change.")
    @ApiResponses(value={@ApiResponse(code=200, message="access key saved or updated successfully", response=SynchronizedEveAccount.class), @ApiResponse(code=401, message="either the requestor is not logged in, or requesting for other than logged in user but requestor not logged in or not an admin", response=ServiceError.class), @ApiResponse(code=403, message="provided access key has an illegal value.  More details are provided in the response message.", response=ServiceError.class), @ApiResponse(code=404, message="requesting for other than logged in user, but target user not found; or, target account not found; or, updating an existing access key, but target key not found ", response=ServiceError.class), @ApiResponse(code=500, message="Internal account service service error", response=ServiceError.class)})
    public Response saveAccessKey(@Context HttpServletRequest request, @PathParam(value="uid") @ApiParam(name="uid", required=true, value="ID of user for which a access key will be updated or saved.  Set to -1 for the current logged in user.") long uid, @PathParam(value="aid") @ApiParam(name="aid", required=true, value="ID of sync account which owns new or updated key.") long aid, @PathParam(value="kid") @ApiParam(name="kid", required=true, value="ID of access key to update.  Set to -1 to save a new access key.") long kid, @ApiParam(name="key", required=true, value="Access key to save or update") SynchronizedAccountAccessKey key) {
        if (key == null) {
            ServiceError errMsg = new ServiceError(Response.Status.FORBIDDEN.getStatusCode(), "POST argument is null");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)errMsg).build();
        }
        EveKitUserAccount user = (EveKitUserAccount)AuthUtil.getCurrentUser((HttpServletRequest)request);
        if (user == null) {
            return AccountWS.createUserNotLoggedResponse();
        }
        Response error = AccountWS.checkRequireAdmin(user, uid);
        if (error != null) {
            return error;
        }
        try {
            SynchronizedAccountAccessKey result;
            if (uid != -1L) {
                user = EveKitUserAccount.getAccount((long)uid);
            }
            SynchronizedEveAccount account = SynchronizedEveAccount.getSynchronizedAccount((EveKitUserAccount)user, (long)aid, (boolean)true);
            byte[] maskUpload = AccountAccessMask.unstringifyMask((String)key.getMaskValueString());
            if (kid == -1L) {
                result = SynchronizedAccountAccessKey.createKey((SynchronizedEveAccount)account, (String)key.getKeyName(), (long)key.getExpiry(), (long)key.getLimit(), (byte[])maskUpload);
            } else {
                SynchronizedAccountAccessKey existing = SynchronizedAccountAccessKey.getKeyByOwnerAndID((SynchronizedEveAccount)account, (long)kid);
                result = SynchronizedAccountAccessKey.updateKey((SynchronizedEveAccount)account, (String)existing.getKeyName(), (String)key.getKeyName(), (long)key.getExpiry(), (long)key.getLimit(), (byte[])maskUpload);
            }
            result.generateMaskValue();
            result.generateMaskValueString();
            result.generateCredential();
            return Response.ok().entity((Object)result).build();
        }
        catch (UserNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Target user not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        catch (AccessKeyUpdateException e) {
            ServiceError errMsg = new ServiceError(Response.Status.FORBIDDEN.getStatusCode(), "Key name change requested, but new name already in use");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)errMsg).build();
        }
        catch (AccessKeyCreationException e) {
            ServiceError errMsg = new ServiceError(Response.Status.FORBIDDEN.getStatusCode(), "Requested access key name already in use for this account");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)errMsg).build();
        }
        catch (AccessKeyNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Key with given ID not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        catch (AccountNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Target account not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        catch (IOException e) {
            ServiceError errMsg = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Error modifying access key, contact admin if this problem persists");
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build();
        }
    }

    @Path(value="/access_key/{uid}/{aid}/{kid}")
    @DELETE
    @ApiOperation(value="Delete an access key.")
    @ApiResponses(value={@ApiResponse(code=200, message="access key deleted successfully"), @ApiResponse(code=401, message="either the requestor is not logged in, or requesting for other than logged in user but requestor not logged in or not an admin", response=ServiceError.class), @ApiResponse(code=404, message="requesting for other than logged in user, but target user not found; or, target account not found; or, target key not found", response=ServiceError.class), @ApiResponse(code=500, message="Internal account service service error", response=ServiceError.class)})
    public Response deleteAccessKey(@Context HttpServletRequest request, @PathParam(value="uid") @ApiParam(name="uid", required=true, value="ID of user for which a access key will be deleted.  Set to -1 for the current logged in user.") long uid, @PathParam(value="aid") @ApiParam(name="aid", required=true, value="ID of sync account for which an access key will be deleted.") long aid, @PathParam(value="kid") @ApiParam(name="kid", required=true, value="ID of access key to delete.") long kid) {
        EveKitUserAccount user = (EveKitUserAccount)AuthUtil.getCurrentUser((HttpServletRequest)request);
        if (user == null) {
            return AccountWS.createUserNotLoggedResponse();
        }
        Response error = AccountWS.checkRequireAdmin(user, uid);
        if (error != null) {
            return error;
        }
        try {
            if (uid != -1L) {
                user = EveKitUserAccount.getAccount((long)uid);
            }
            SynchronizedEveAccount account = SynchronizedEveAccount.getSynchronizedAccount((EveKitUserAccount)user, (long)aid, (boolean)false);
            SynchronizedAccountAccessKey key = SynchronizedAccountAccessKey.getKeyByOwnerAndID((SynchronizedEveAccount)account, (long)kid);
            SynchronizedAccountAccessKey.deleteKey((SynchronizedEveAccount)account, (long)kid);
            return Response.ok().build();
        }
        catch (UserNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Target user not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        catch (AccessKeyNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Key with given ID not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        catch (AccountNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Target account not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        catch (IOException e) {
            ServiceError errMsg = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Error deleting access key, contact admin if this problem persists");
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build();
        }
    }

    @Path(value="/user_last_source/{uid}")
    @GET
    @ApiOperation(value="Get the last user auth source used by the given user, or the currently logged in user")
    @ApiResponses(value={@ApiResponse(code=200, message="last user auth source, or null", response=EveKitUserAuthSource.class), @ApiResponse(code=401, message="requesting source for other than local user, but requestor not an admin", response=ServiceError.class), @ApiResponse(code=404, message="requesting source for other than local user, but specified user not found", response=ServiceError.class), @ApiResponse(code=500, message="Internal account service service error", response=ServiceError.class)})
    public Response getUserLastSource(@Context HttpServletRequest request, @PathParam(value="uid") @ApiParam(name="uid", required=true, value="ID of user account for which the last source will be retrieved.  Set to -1 to retrieve for the current logged in user.") long uid) {
        EveKitUserAccount user = (EveKitUserAccount)AuthUtil.getCurrentUser((HttpServletRequest)request);
        if (user == null) {
            return AccountWS.createUserNotLoggedResponse();
        }
        Response error = AccountWS.checkRequireAdmin(user, uid);
        if (error != null) {
            return error;
        }
        try {
            EveKitUserAuthSource src;
            if (uid != -1L) {
                user = EveKitUserAccount.getAccount((long)uid);
            }
            if ((src = EveKitUserAuthSource.getLastUsedSource((EveKitUserAccount)user)) == null) {
                ServiceError errMsg = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Error retrieving auth source, please contact the administrator if this error persists");
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build();
            }
            return Response.ok().entity((Object)src).build();
        }
        catch (UserNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Target user not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        catch (IOException e) {
            ServiceError errMsg = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Error retrieving last user source, contact admin if this problem persists");
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build();
        }
    }

    @Path(value="/user_sources/{uid}")
    @GET
    @ApiOperation(value="Get the list of all user auth sources for the given user, or the currently logged in user")
    @ApiResponses(value={@ApiResponse(code=200, message="List of all user auth sources, or empty list", response=EveKitUserAuthSource.class, responseContainer="array"), @ApiResponse(code=401, message="requesting source for other than local user, but requestor not an admin", response=ServiceError.class), @ApiResponse(code=404, message="requesting source for other than local user, but specified user not found", response=ServiceError.class), @ApiResponse(code=500, message="Internal account service service error", response=ServiceError.class)})
    public Response getUserSources(@Context HttpServletRequest request, @PathParam(value="uid") @ApiParam(name="uid", required=true, value="ID of user account for which all sources will be retrieved.  Set to -1 to retrieve for the current logged in user.") long uid) {
        EveKitUserAccount user = (EveKitUserAccount)AuthUtil.getCurrentUser((HttpServletRequest)request);
        if (user == null) {
            return AccountWS.createUserNotLoggedResponse();
        }
        Response error = AccountWS.checkRequireAdmin(user, uid);
        if (error != null) {
            return error;
        }
        try {
            if (uid != -1L) {
                user = EveKitUserAccount.getAccount((long)uid);
            }
            ArrayList sources = new ArrayList();
            List result = EveKitUserAuthSource.getAllSources((EveKitUserAccount)user);
            if (result == null) {
                ServiceError errMsg = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Error retrieving auth source, please contact the administrator if this error persists");
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build();
            }
            sources.addAll(result);
            return Response.ok().entity(sources).build();
        }
        catch (UserNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Target user not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        catch (IOException e) {
            ServiceError errMsg = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Error retrieving user sources, contact admin if this problem persists");
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build();
        }
    }

    @Path(value="/user")
    @GET
    @ApiOperation(value="Get information about the current logged in user")
    @ApiResponses(value={@ApiResponse(code=200, message="logged in user, or null", response=EveKitUserAccount.class)})
    public Response getUser(@Context HttpServletRequest request) {
        EveKitUserAccount user = (EveKitUserAccount)AuthUtil.getCurrentUser((HttpServletRequest)request);
        return Response.ok().entity((Object)user).build();
    }

    @Path(value="/list_users")
    @GET
    @ApiOperation(value="List all site users", notes="List all site users")
    @ApiResponses(value={@ApiResponse(code=200, message="user list", response=EveKitUserAccount.class, responseContainer="array"), @ApiResponse(code=401, message="requesting user not authenticated or not an admin", response=ServiceError.class), @ApiResponse(code=500, message="Internal account service service error", response=ServiceError.class)})
    public Response listUsers(@Context HttpServletRequest request) {
        EveKitUserAccount admin = (EveKitUserAccount)AuthUtil.getCurrentUser((HttpServletRequest)request);
        if (admin == null || !admin.isAdmin()) {
            ServiceError errMsg = new ServiceError(Response.Status.UNAUTHORIZED.getStatusCode(), "User not logged in or not an admin");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)errMsg).build();
        }
        try {
            List allUsers = EveKitUserAccount.getAllAccounts();
            if (allUsers == null) {
                ServiceError errMsg = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Error retrieving user list, check logs");
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build();
            }
            return Response.ok().entity((Object)allUsers).build();
        }
        catch (IOException e) {
            ServiceError errMsg = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Error retrieving user list");
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build();
        }
    }

    @Path(value="/toggle_auto_sync/{uid}/{aid}/{autosync}")
    @GET
    @ApiOperation(value="Change the autosync state of a synchronized account")
    @ApiResponses(value={@ApiResponse(code=200, message="status successfully changed"), @ApiResponse(code=401, message="requesting user not authenticated or not an admin", response=ServiceError.class), @ApiResponse(code=404, message="User with the specified ID not found, or account with specified ID not found", response=ServiceError.class), @ApiResponse(code=500, message="Internal account service service error", response=ServiceError.class)})
    public Response toggleAutoSync(@Context HttpServletRequest request, @PathParam(value="uid") @ApiParam(name="uid", required=true, value="ID of user account to toggle") long uid, @PathParam(value="aid") @ApiParam(name="aid", required=true, value="ID of sync account to toggle") long aid, @PathParam(value="autosync") @ApiParam(name="autosync", required=true, value="New autosync state for user") boolean autosync) {
        EveKitUserAccount user = (EveKitUserAccount)AuthUtil.getCurrentUser((HttpServletRequest)request);
        if (user == null) {
            return AccountWS.createUserNotLoggedResponse();
        }
        Response error = AccountWS.checkRequireAdmin(user, uid);
        if (error != null) {
            return error;
        }
        try {
            if (uid != -1L) {
                user = EveKitUserAccount.getAccount((long)uid);
            }
            SynchronizedEveAccount account = SynchronizedEveAccount.getSynchronizedAccount((EveKitUserAccount)user, (long)aid, (boolean)true);
            account.setAutoSynchronized(autosync);
            SynchronizedEveAccount.update((SynchronizedEveAccount)account);
            return Response.ok().build();
        }
        catch (UserNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Target user not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        catch (AccountNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Target account not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        catch (IOException e) {
            ServiceError errMsg = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Error changing autosync state, check logs");
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build();
        }
    }

    @Path(value="/toggle_user_active/{uid}/{active}")
    @GET
    @ApiOperation(value="Change the active state of a user")
    @ApiResponses(value={@ApiResponse(code=200, message="status successfully changed"), @ApiResponse(code=401, message="requesting user not authenticated or not an admin", response=ServiceError.class), @ApiResponse(code=404, message="User with the specified ID not found", response=ServiceError.class), @ApiResponse(code=500, message="Internal account service service error", response=ServiceError.class)})
    public Response toggleActive(@Context HttpServletRequest request, @PathParam(value="uid") @ApiParam(name="uid", required=true, value="ID of user account to toggle") long uid, @PathParam(value="active") @ApiParam(name="active", required=true, value="New active state for user") boolean active) {
        EveKitUserAccount user = (EveKitUserAccount)AuthUtil.getCurrentUser((HttpServletRequest)request);
        if (user == null) {
            return AccountWS.createUserNotLoggedResponse();
        }
        Response error = AccountWS.checkRequireAdmin(user, uid);
        if (error != null) {
            return error;
        }
        try {
            if (uid != -1L) {
                user = EveKitUserAccount.getAccount((long)uid);
            }
            user.setActive(active);
            EveKitUserAccount.update((EveKitUserAccount)user);
            return Response.ok().build();
        }
        catch (UserNotFoundException e) {
            ServiceError errMsg = new ServiceError(Response.Status.NOT_FOUND.getStatusCode(), "Target user not found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        catch (IOException e) {
            ServiceError errMsg = new ServiceError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Error changing active state, check logs");
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errMsg).build();
        }
    }

    @Path(value="/isadmin")
    @GET
    @ApiOperation(value="Check whether the current user is an admin")
    @ApiResponses(value={@ApiResponse(code=200, message="admin status of logged in user", response=Boolean.class), @ApiResponse(code=401, message="requesting user not authenticated", response=ServiceError.class), @ApiResponse(code=500, message="Internal account service service error", response=ServiceError.class)})
    public Response checkAdmin(@Context HttpServletRequest request) {
        final EveKitUserAccount user = (EveKitUserAccount)AuthUtil.getCurrentUser((HttpServletRequest)request);
        if (user == null) {
            return AccountWS.createUserNotLoggedResponse();
        }
        return Response.ok().entity(new Object(){
            public final boolean isAdmin;
            {
                this.isAdmin = user.isAdmin();
            }
        }).build();
    }

    @Path(value="/list_char_endpoints")
    @GET
    @ApiOperation(value="List all character ESI endpoints")
    @ApiResponses(value={@ApiResponse(code=200, message="endpoint list", response=ESISyncEndpointModel.class, responseContainer="array"), @ApiResponse(code=500, message="Internal account service service error", response=ServiceError.class)})
    public Response charEndpoints(@Context HttpServletRequest request) {
        ArrayList<ESISyncEndpointModel> results = new ArrayList<ESISyncEndpointModel>();
        for (ESISyncEndpoint next : ESISyncEndpoint.getCharEndpoints()) {
            results.add(ESISyncEndpointModel.fromSyncEndpoint(next));
        }
        return Response.ok().entity(results).build();
    }

    @Path(value="/list_corp_endpoints")
    @GET
    @ApiOperation(value="List all corporation ESI endpoints")
    @ApiResponses(value={@ApiResponse(code=200, message="endpoint list", response=ESISyncEndpointModel.class, responseContainer="array"), @ApiResponse(code=500, message="Internal account service service error", response=ServiceError.class)})
    public Response corpEndpoints(@Context HttpServletRequest request) {
        ArrayList<ESISyncEndpointModel> results = new ArrayList<ESISyncEndpointModel>();
        for (ESISyncEndpoint next : ESISyncEndpoint.getCorpEndpoints()) {
            results.add(ESISyncEndpointModel.fromSyncEndpoint(next));
        }
        return Response.ok().entity(results).build();
    }
}

