/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.base;

import enterprises.orbital.base.NoPersistentPropertyException;
import enterprises.orbital.base.OrbitalProperties;
import enterprises.orbital.base.PersistentPropertyKey;
import enterprises.orbital.base.PersistentPropertyProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PersistentProperty {
    protected static PersistentPropertyProvider provider = new InMemoryPersistentPropertyProvider();
    protected String propertyName;
    protected String propertyValue;

    public static void setProvider(PersistentPropertyProvider p) {
        if (p == null) {
            p = new InMemoryPersistentPropertyProvider();
        }
        provider = p;
    }

    public PersistentProperty() {
    }

    public PersistentProperty(String propertyName, String propertyValue) {
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
    }

    public String toString() {
        return "PersistentProperty [propertyName=" + this.propertyName + ", propertyValue=" + this.propertyValue + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.propertyName == null ? 0 : this.propertyName.hashCode());
        result = 31 * result + (this.propertyValue == null ? 0 : this.propertyValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersistentProperty other = (PersistentProperty)obj;
        if (this.propertyName == null ? other.propertyName != null : !this.propertyName.equals(other.propertyName)) {
            return false;
        }
        return !(this.propertyValue == null ? other.propertyValue != null : !this.propertyValue.equals(other.propertyValue));
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    public static String getProperty(String key, String defValue) {
        try {
            return PersistentProperty.getProperty(key);
        }
        catch (NoPersistentPropertyException e) {
            return defValue;
        }
    }

    public static <B, A extends PersistentPropertyKey<B>> String getProperty(A ns, B key, String defValue) {
        return PersistentProperty.getProperty(ns.getPeristentPropertyKey(key), defValue);
    }

    public static List<PersistentProperty> getAll() {
        return provider.retrieveAll();
    }

    public static String getProperty(String key) throws NoPersistentPropertyException {
        PersistentProperty val = provider.get(key);
        if (val == null) {
            throw new NoPersistentPropertyException();
        }
        return val.getPropertyValue();
    }

    public static <B, A extends PersistentPropertyKey<B>> String getProperty(A ns, B key) throws NoPersistentPropertyException {
        return PersistentProperty.getProperty(ns.getPeristentPropertyKey(key));
    }

    public static String setProperty(String key, String value) {
        return provider.set(key, value);
    }

    public static <B, A extends PersistentPropertyKey<B>> String setProperty(A ns, B key, String value) {
        return PersistentProperty.setProperty(ns.getPeristentPropertyKey(key), value);
    }

    public static String removeProperty(String key) {
        return provider.remove(key);
    }

    public static <B, A extends PersistentPropertyKey<B>> String removeProperty(A ns, B key) {
        return PersistentProperty.removeProperty(ns.getPeristentPropertyKey(key));
    }

    public static String getPropertyWithFallback(String key) {
        try {
            return PersistentProperty.getProperty(key);
        }
        catch (NoPersistentPropertyException noPersistentPropertyException) {
            return OrbitalProperties.getGlobalProperty(key);
        }
    }

    public static <B, A extends PersistentPropertyKey<B>> String getPropertyWithFallback(A ns, B key) {
        return PersistentProperty.getPropertyWithFallback(ns.getPeristentPropertyKey(key));
    }

    public static String getPropertyWithFallback(String key, String def) {
        return PersistentProperty.getProperty(key, OrbitalProperties.getGlobalProperty(key, def));
    }

    public static <B, A extends PersistentPropertyKey<B>> String getPropertyWithFallback(A ns, B key, String def) {
        String ky = ns.getPeristentPropertyKey(key);
        return PersistentProperty.getProperty(ky, OrbitalProperties.getGlobalProperty(ky, def));
    }

    public static boolean getBooleanPropertyWithFallback(String key) {
        return Boolean.valueOf(PersistentProperty.getProperty(key, OrbitalProperties.getGlobalProperty(key)));
    }

    public static <B, A extends PersistentPropertyKey<B>> boolean getBooleanPropertyWithFallback(A ns, B key) {
        String ky = ns.getPeristentPropertyKey(key);
        return Boolean.valueOf(PersistentProperty.getProperty(ky, OrbitalProperties.getGlobalProperty(ky)));
    }

    public static boolean getBooleanPropertyWithFallback(String key, boolean def) {
        return Boolean.valueOf(PersistentProperty.getProperty(key, OrbitalProperties.getGlobalProperty(key, String.valueOf(def))));
    }

    public static <B, A extends PersistentPropertyKey<B>> boolean getBooleanPropertyWithFallback(A ns, B key, boolean def) {
        String ky = ns.getPeristentPropertyKey(key);
        return Boolean.valueOf(PersistentProperty.getProperty(ky, OrbitalProperties.getGlobalProperty(ky, String.valueOf(def))));
    }

    public static long getLongPropertyWithFallback(String key) {
        return Long.valueOf(PersistentProperty.getProperty(key, OrbitalProperties.getGlobalProperty(key)));
    }

    public static <B, A extends PersistentPropertyKey<B>> long getLongPropertyWithFallback(A ns, B key) {
        String ky = ns.getPeristentPropertyKey(key);
        return Long.valueOf(PersistentProperty.getProperty(ky, OrbitalProperties.getGlobalProperty(ky)));
    }

    public static long getLongPropertyWithFallback(String key, long def) {
        return Long.valueOf(PersistentProperty.getProperty(key, OrbitalProperties.getGlobalProperty(key, String.valueOf(def))));
    }

    public static <B, A extends PersistentPropertyKey<B>> long getLongPropertyWithFallback(A ns, B key, long def) {
        String ky = ns.getPeristentPropertyKey(key);
        return Long.valueOf(PersistentProperty.getProperty(ky, OrbitalProperties.getGlobalProperty(ky, String.valueOf(def))));
    }

    public static int getIntegerPropertyWithFallback(String key) {
        return Integer.valueOf(PersistentProperty.getProperty(key, OrbitalProperties.getGlobalProperty(key)));
    }

    public static <B, A extends PersistentPropertyKey<B>> int getIntegerPropertyWithFallback(A ns, B key) {
        String ky = ns.getPeristentPropertyKey(key);
        return Integer.valueOf(PersistentProperty.getProperty(ky, OrbitalProperties.getGlobalProperty(ky)));
    }

    public static int getIntegerPropertyWithFallback(String key, int def) {
        return Integer.valueOf(PersistentProperty.getProperty(key, OrbitalProperties.getGlobalProperty(key, String.valueOf(def))));
    }

    public static <B, A extends PersistentPropertyKey<B>> int getIntegerPropertyWithFallback(A ns, B key, int def) {
        String ky = ns.getPeristentPropertyKey(key);
        return Integer.valueOf(PersistentProperty.getProperty(ky, OrbitalProperties.getGlobalProperty(ky, String.valueOf(def))));
    }

    public static class InMemoryPersistentPropertyProvider
    implements PersistentPropertyProvider {
        protected Map<String, String> properties = Collections.synchronizedMap(new HashMap());

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<PersistentProperty> retrieveAll() {
            ArrayList<PersistentProperty> all = new ArrayList<PersistentProperty>();
            Map<String, String> map = this.properties;
            synchronized (map) {
                for (Map.Entry<String, String> val : this.properties.entrySet()) {
                    all.add(new PersistentProperty(val.getKey(), val.getValue()));
                }
            }
            return all;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PersistentProperty get(String key) {
            Map<String, String> map = this.properties;
            synchronized (map) {
                if (this.properties.containsKey(key)) {
                    return new PersistentProperty(key, this.properties.get(key));
                }
                return null;
            }
        }

        @Override
        public String set(String key, String value) {
            return this.properties.put(key, value);
        }

        @Override
        public String remove(String key) {
            return this.properties.remove(key);
        }
    }
}

