/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.base;

import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public abstract class OrbitalProperties {
    private static final Set<String> loadedFiles = new HashSet<String>();
    private static final Properties globalProperties = new Properties();
    private static boolean assertsEnabled = false;
    private static TimeGenerator timeGenerator;

    public OrbitalProperties() {
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
    }

    public static boolean isAssertEnabled() {
        return assertsEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addPropertyFile(String path) throws IOException {
        Set<String> set = loadedFiles;
        synchronized (set) {
            if (loadedFiles.contains(path)) {
                return;
            }
            loadedFiles.add(path);
        }
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            InputStream build = loader.getResourceAsStream(path);
            if (build != null) {
                globalProperties.load(build);
                build.close();
            }
        }
        catch (IOException e) {
            Set<String> set2 = loadedFiles;
            synchronized (set2) {
                loadedFiles.remove(path);
                throw e;
            }
        }
    }

    public static final String getPropertyName(Class<?> caller, String attribute) {
        return caller.getName() + ".attr." + attribute;
    }

    public static final int getNonzeroLimited(int provided, int max) {
        if (provided < 1) {
            provided = max;
        }
        return Math.min(provided, max);
    }

    public static void setTimeGenerator(TimeGenerator tg) {
        timeGenerator = tg;
    }

    public static long getCurrentTime() {
        return timeGenerator.getTime();
    }

    public static Date getCurrentDate() {
        return new Date(OrbitalProperties.getCurrentTime());
    }

    public static String getGlobalProperty(String key) {
        return globalProperties.getProperty(key);
    }

    public static String getGlobalProperty(String key, String def) {
        return globalProperties.getProperty(key, def);
    }

    public static boolean getBooleanGlobalProperty(String key) {
        return Boolean.valueOf(globalProperties.getProperty(key));
    }

    public static boolean getBooleanGlobalProperty(String key, boolean def) {
        return Boolean.valueOf(globalProperties.getProperty(key, String.valueOf(def)));
    }

    public static long getLongGlobalProperty(String key) {
        return Long.valueOf(globalProperties.getProperty(key));
    }

    public static long getLongGlobalProperty(String key, long def) {
        return Long.valueOf(globalProperties.getProperty(key, String.valueOf(def)));
    }

    public static ThreadLocal<DateFormat> dateFormatFactory(final DateFormatGenerator generator) {
        return new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return generator.generate();
            }
        };
    }

    static {
        OrbitalProperties.setTimeGenerator(new TimeGenerator(){

            @Override
            public long getTime() {
                return System.currentTimeMillis();
            }
        });
    }

    public static interface DateFormatGenerator {
        public DateFormat generate();
    }

    public static interface TimeGenerator {
        public long getTime();
    }
}

