/*
 * Decompiled with CFR 0.152.
 */
package engineering.everest.starterkit.filestorage;

import engineering.everest.starterkit.filestorage.FileService;
import engineering.everest.starterkit.filestorage.PartialInputStreamResource;
import java.util.Optional;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourceRegion;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRange;
import org.springframework.stereotype.Component;

@Component
public class FileResourceRegionFactory {
    private final FileService fileService;
    private final long maxChunkSizeInBytes;

    public FileResourceRegionFactory(FileService fileService, @Value(value="${application.filestore.streaming.chunk.max.bytes:10485760}") String maxChunkSizeInBytes) {
        this.fileService = fileService;
        this.maxChunkSizeInBytes = Long.parseLong(maxChunkSizeInBytes);
    }

    public ResourceRegion createFileResourceRegion(UUID fileId, HttpHeaders headers) {
        long actualFileSize = this.fileService.fileSizeInBytes(fileId);
        Optional range = headers.getRange().stream().findFirst();
        if (range.isPresent()) {
            long requestedStartIndex = ((HttpRange)range.get()).getRangeStart(actualFileSize);
            long requestedEndIndex = ((HttpRange)range.get()).getRangeEnd(actualFileSize);
            if (requestedEndIndex - requestedStartIndex > this.maxChunkSizeInBytes) {
                PartialInputStreamResource partialInputStreamResource = new PartialInputStreamResource(actualFileSize, this.fileService, fileId, requestedStartIndex, requestedStartIndex + this.maxChunkSizeInBytes - 1L);
                return new ResourceRegion((Resource)partialInputStreamResource, requestedStartIndex, this.maxChunkSizeInBytes);
            }
            PartialInputStreamResource partialInputStreamResource = new PartialInputStreamResource(actualFileSize, this.fileService, fileId, requestedStartIndex, requestedEndIndex);
            return new ResourceRegion((Resource)partialInputStreamResource, requestedStartIndex, requestedEndIndex - requestedStartIndex + 1L);
        }
        long count = Math.min(this.maxChunkSizeInBytes, actualFileSize);
        return new ResourceRegion((Resource)new PartialInputStreamResource(actualFileSize, this.fileService, fileId, 0L, count - 1L), 0L, count);
    }
}

