/*
 * Decompiled with CFR 0.152.
 */
package engineering.everest.starterkit.filestorage.filestores;

import com.google.common.base.Preconditions;
import engineering.everest.starterkit.filestorage.InputStreamOfKnownLength;
import engineering.everest.starterkit.filestorage.PersistedFileIdentifier;
import engineering.everest.starterkit.filestorage.backing.BackingStore;
import engineering.everest.starterkit.filestorage.filestores.FileStoreType;
import engineering.everest.starterkit.filestorage.filestores.PermanentDeduplicatingFileStore;
import engineering.everest.starterkit.filestorage.persistence.FileMappingRepository;
import engineering.everest.starterkit.filestorage.persistence.PersistableFileMapping;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public class EphemeralDeduplicatingFileStore
extends PermanentDeduplicatingFileStore {
    public EphemeralDeduplicatingFileStore(FileMappingRepository fileMappingRepository, BackingStore backingStore) {
        super(FileStoreType.EPHEMERAL, fileMappingRepository, backingStore);
    }

    @Override
    public InputStreamOfKnownLength downloadAsStream(PersistableFileMapping persistableFileMapping) throws IOException {
        if (persistableFileMapping.isMarkedForDeletion()) {
            throw new NoSuchElementException("Ephemeral file not found");
        }
        return super.downloadAsStream(persistableFileMapping);
    }

    public void markFilesForDeletion(List<PersistedFileIdentifier> persistedFileIdentifiers) {
        persistedFileIdentifiers.forEach(identifier -> Preconditions.checkArgument((identifier.getFileStoreType() == FileStoreType.EPHEMERAL ? 1 : 0) != 0));
        persistedFileIdentifiers.forEach(identifier -> this.fileMappingRepository.findById(identifier.getFileId()).ifPresent(this::markPersistedFileForDeletion));
    }

    public void markFileForDeletion(PersistedFileIdentifier persistedFileIdentifier) {
        Preconditions.checkArgument((persistedFileIdentifier.getFileStoreType() == FileStoreType.EPHEMERAL ? 1 : 0) != 0);
        this.fileMappingRepository.findById(persistedFileIdentifier.getFileId()).ifPresent(this::markPersistedFileForDeletion);
    }

    public void markAllFilesForDeletion() {
        List<PersistableFileMapping> persistableFileMappings = this.fileMappingRepository.findByFileStoreType(FileStoreType.EPHEMERAL);
        persistableFileMappings.forEach(persistableFileMapping -> persistableFileMapping.setMarkedForDeletion(true));
        this.fileMappingRepository.saveAll(persistableFileMappings);
    }

    public void deleteFileBatch(int batchSize) {
        PageRequest pageable = PageRequest.of((int)0, (int)batchSize);
        Set<String> filesInBatch = this.fileMappingRepository.findByMarkedForDeletionTrue((Pageable)pageable).stream().map(PersistableFileMapping::getBackingStorageFileId).collect(Collectors.toSet());
        this.backingStore.deleteFiles(filesInBatch);
        this.fileMappingRepository.deleteAllByBackingStorageFileIdIn(filesInBatch);
    }

    private void markPersistedFileForDeletion(PersistableFileMapping persistableFileMapping) {
        persistableFileMapping.setMarkedForDeletion(true);
        this.fileMappingRepository.save(persistableFileMapping);
    }
}

