/*
 * Decompiled with CFR 0.152.
 */
package engineering.everest.starterkit.filestorage;

import engineering.everest.starterkit.filestorage.FileService;
import engineering.everest.starterkit.filestorage.PartialInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import lombok.Generated;
import org.springframework.core.io.AbstractResource;

public class PartialInputStreamResource
extends AbstractResource {
    private final FileService fileService;
    private final long actualFileSize;
    private final UUID fileId;
    private final long startOffset;
    private final long endOffset;

    public PartialInputStreamResource(long actualFileSize, FileService fileService, UUID fileId, long startOffset, long endOffset) {
        this.fileService = fileService;
        this.fileId = fileId;
        this.actualFileSize = actualFileSize;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public String getDescription() {
        return String.format("Partial input stream resource for file %s", this.fileId);
    }

    public InputStream getInputStream() throws IOException {
        return new PartialInputStream(this.fileService.stream(this.fileId, this.startOffset, this.endOffset).getInputStream(), this.startOffset);
    }

    public boolean exists() {
        return true;
    }

    public boolean isOpen() {
        return false;
    }

    public boolean isFile() {
        return false;
    }

    public boolean isReadable() {
        return true;
    }

    public long contentLength() {
        return this.actualFileSize;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PartialInputStreamResource)) {
            return false;
        }
        PartialInputStreamResource other = (PartialInputStreamResource)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.actualFileSize != other.actualFileSize) {
            return false;
        }
        if (this.startOffset != other.startOffset) {
            return false;
        }
        if (this.endOffset != other.endOffset) {
            return false;
        }
        FileService this$fileService = this.fileService;
        FileService other$fileService = other.fileService;
        if (this$fileService == null ? other$fileService != null : !this$fileService.equals(other$fileService)) {
            return false;
        }
        UUID this$fileId = this.fileId;
        UUID other$fileId = other.fileId;
        return !(this$fileId == null ? other$fileId != null : !((Object)this$fileId).equals(other$fileId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PartialInputStreamResource;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $actualFileSize = this.actualFileSize;
        result = result * 59 + (int)($actualFileSize >>> 32 ^ $actualFileSize);
        long $startOffset = this.startOffset;
        result = result * 59 + (int)($startOffset >>> 32 ^ $startOffset);
        long $endOffset = this.endOffset;
        result = result * 59 + (int)($endOffset >>> 32 ^ $endOffset);
        FileService $fileService = this.fileService;
        result = result * 59 + ($fileService == null ? 43 : $fileService.hashCode());
        UUID $fileId = this.fileId;
        result = result * 59 + ($fileId == null ? 43 : ((Object)$fileId).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PartialInputStreamResource(fileService=" + this.fileService + ", actualFileSize=" + this.actualFileSize + ", fileId=" + this.fileId + ", startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ")";
    }
}

