/*
 * Decompiled with CFR 0.152.
 */
package engineering.everest.starterkit.filestorage.filestores;

import com.mongodb.client.gridfs.model.GridFSFile;
import engineering.everest.starterkit.filestorage.FileStore;
import engineering.everest.starterkit.filestorage.InputStreamOfKnownLength;
import engineering.everest.starterkit.filestorage.NativeStorageType;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;

public class MongoGridFsFileStore
implements FileStore {
    private final GridFsTemplate gridFs;

    public MongoGridFsFileStore(GridFsTemplate gridFs) {
        this.gridFs = gridFs;
    }

    @Override
    public String uploadStream(InputStream inputStream, String fileName) {
        ObjectId mongoObjectId = this.gridFs.store(inputStream, fileName);
        return mongoObjectId.toHexString();
    }

    @Override
    public String uploadStream(InputStream inputStream, String fileName, long ignored) {
        ObjectId mongoObjectId = this.gridFs.store(inputStream, fileName);
        return mongoObjectId.toHexString();
    }

    @Override
    public void delete(String fileIdentifier) {
        this.gridFs.delete(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(fileIdentifier))));
    }

    @Override
    public InputStreamOfKnownLength downloadAsStream(String fileIdentifier) throws IOException {
        GridFSFile gridFSFile = this.gridFs.findOne(new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)fileIdentifier)));
        if (gridFSFile == null) {
            throw new RuntimeException("Unable to retrieve file " + fileIdentifier);
        }
        return new InputStreamOfKnownLength(this.gridFs.getResource(gridFSFile).getInputStream(), gridFSFile.getLength());
    }

    @Override
    public NativeStorageType nativeStorageType() {
        return NativeStorageType.MONGO_GRID_FS;
    }

    @Override
    public void deleteFiles(Set<String> fileIdentifiers) {
        this.gridFs.delete(Query.query((CriteriaDefinition)Criteria.where((String)"_id").in(fileIdentifiers)));
    }
}

