/*
 * Decompiled with CFR 0.152.
 */
package engineering.everest.starterkit.filestorage;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import engineering.everest.starterkit.filestorage.FileStore;
import engineering.everest.starterkit.filestorage.FileStoreType;
import engineering.everest.starterkit.filestorage.InputStreamOfKnownLength;
import engineering.everest.starterkit.filestorage.NativeStorageType;
import engineering.everest.starterkit.filestorage.PersistedFile;
import engineering.everest.starterkit.filestorage.PersistedFileIdentifier;
import engineering.everest.starterkit.filestorage.persistence.FileMappingRepository;
import engineering.everest.starterkit.filestorage.persistence.PersistableFileMapping;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.data.domain.Example;

public class PermanentDeduplicatingFileStore {
    protected final FileStoreType fileStoreType;
    protected final FileMappingRepository fileMappingRepository;
    protected final FileStore fileStore;

    public PermanentDeduplicatingFileStore(FileMappingRepository fileMappingRepository, FileStore fileStore) {
        this.fileStoreType = FileStoreType.PERMANENT;
        this.fileMappingRepository = fileMappingRepository;
        this.fileStore = fileStore;
    }

    protected PermanentDeduplicatingFileStore(FileStoreType fileStoreType, FileMappingRepository fileMappingRepository, FileStore fileStore) {
        this.fileStoreType = fileStoreType;
        this.fileMappingRepository = fileMappingRepository;
        this.fileStore = fileStore;
    }

    /*
     * Exception decompiling
     */
    public PersistedFile uploadAsStream(String originalFilename, InputStream inputStream) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public PersistedFile uploadAsStream(String originalFilename, long fileSize, InputStream inputStream) throws IOException {
        try (HashingInputStream sha256ingInputStream = new HashingInputStream(Hashing.sha256(), inputStream);){
            PersistedFile persistedFile;
            try (HashingInputStream sha512ingInputStream = new HashingInputStream(Hashing.sha512(), (InputStream)sha256ingInputStream);){
                String fileIdentifier = this.fileStore.uploadStream((InputStream)sha512ingInputStream, originalFilename, fileSize);
                persistedFile = this.persistDeduplicateAndUpdateFileMapping(sha256ingInputStream.hash().toString(), sha512ingInputStream.hash().toString(), fileIdentifier, fileSize);
            }
            return persistedFile;
        }
    }

    public InputStreamOfKnownLength downloadAsStream(PersistedFileIdentifier persistedFileIdentifier) throws IOException {
        return this.fileStore.downloadAsStream(persistedFileIdentifier.getNativeStorageFileId());
    }

    private PersistedFile persistDeduplicateAndUpdateFileMapping(String sha256, String sha512, String fileIdentifier, long fileSizeBytes) {
        PersistedFile persistedFile = this.deduplicateUploadedFile(fileIdentifier, sha256, sha512, fileSizeBytes, this.fileStore.nativeStorageType());
        this.addFileMapping(persistedFile, fileSizeBytes, this.fileStore.nativeStorageType());
        return persistedFile;
    }

    private PersistedFile deduplicateUploadedFile(String fileIdentifier, String uploadSha256, String uploadSha512, long fileSizeBytes, NativeStorageType nativeStorageType) {
        Optional<PersistableFileMapping> existingFileMapping = this.searchForExistingFileMappingToBothHashes(uploadSha256, uploadSha512);
        if (existingFileMapping.isPresent()) {
            this.deletePersistedFile(fileIdentifier);
            return new PersistedFile(UUID.randomUUID(), this.fileStoreType, nativeStorageType, existingFileMapping.get().getNativeStorageFileId(), uploadSha256, uploadSha512, fileSizeBytes);
        }
        return new PersistedFile(UUID.randomUUID(), this.fileStoreType, nativeStorageType, fileIdentifier, uploadSha256, uploadSha512, fileSizeBytes);
    }

    protected Optional<PersistableFileMapping> searchForExistingFileMappingToBothHashes(String uploadSha256, String uploadSha512) {
        PersistableFileMapping fileMappingExample = new PersistableFileMapping();
        fileMappingExample.setSha256(uploadSha256);
        fileMappingExample.setSha512(uploadSha512);
        List matchingFiles = this.fileMappingRepository.findAll(Example.of((Object)fileMappingExample));
        return matchingFiles.isEmpty() ? Optional.empty() : Optional.of((PersistableFileMapping)matchingFiles.get(0));
    }

    private void addFileMapping(PersistedFile persistedFile, long fileSizeBytes, NativeStorageType nativeStorageType) {
        this.fileMappingRepository.save(new PersistableFileMapping(persistedFile.getFileId(), this.fileStoreType, nativeStorageType, persistedFile.getNativeStorageFileId(), persistedFile.getSha256(), persistedFile.getSha512(), fileSizeBytes, false));
    }

    private void deletePersistedFile(String fileIdentifier) {
        this.fileStore.delete(fileIdentifier);
    }
}

