/*
 * Decompiled with CFR 0.152.
 */
package engineering.everest.starterkit.filestorage;

import com.google.common.base.Preconditions;
import engineering.everest.starterkit.filestorage.FileStore;
import engineering.everest.starterkit.filestorage.FileStoreType;
import engineering.everest.starterkit.filestorage.PermanentDeduplicatingFileStore;
import engineering.everest.starterkit.filestorage.PersistedFileIdentifier;
import engineering.everest.starterkit.filestorage.persistence.FileMappingRepository;
import engineering.everest.starterkit.filestorage.persistence.PersistableFileMapping;
import java.util.Set;

public class EphemeralDeduplicatingFileStore
extends PermanentDeduplicatingFileStore {
    public EphemeralDeduplicatingFileStore(FileMappingRepository fileMappingRepository, FileStore fileStore) {
        super(FileStoreType.EPHEMERAL, fileMappingRepository, fileStore);
    }

    public void deleteFiles(Set<PersistedFileIdentifier> persistedFileIdentifiers) {
        persistedFileIdentifiers.forEach(this::deleteFile);
    }

    public void deleteFile(PersistedFileIdentifier persistedFileIdentifier) {
        Preconditions.checkArgument((persistedFileIdentifier.getFileStoreType() == FileStoreType.EPHEMERAL ? 1 : 0) != 0);
        this.fileMappingRepository.findById(persistedFileIdentifier.getFileId()).ifPresent(this::markPersistedFileForDeletion);
    }

    private void markPersistedFileForDeletion(PersistableFileMapping persistableFileMapping) {
        persistableFileMapping.setMarkedForDeletion(true);
        this.fileMappingRepository.save(persistableFileMapping);
    }
}

