/*
 * Decompiled with CFR 0.152.
 */
package engineering.everest.starterkit.filestorage.backing;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3URI;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import engineering.everest.starterkit.filestorage.InputStreamOfKnownLength;
import engineering.everest.starterkit.filestorage.backing.BackingFileStoreException;
import engineering.everest.starterkit.filestorage.backing.BackingStorageType;
import engineering.everest.starterkit.filestorage.backing.BackingStore;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class AwsS3BackingStore
implements BackingStore {
    private final AmazonS3 amazonS3;
    private final String bucketName;

    public AwsS3BackingStore(AmazonS3 amazonS3, String bucketName) {
        this.amazonS3 = amazonS3;
        this.bucketName = bucketName;
    }

    @Override
    public String uploadStream(InputStream inputStream, String fileName) {
        return this.streamToS3(inputStream, fileName, null);
    }

    @Override
    public String uploadStream(InputStream inputStream, String fileName, long fileSize) {
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(fileSize);
        return this.streamToS3(inputStream, fileName, metadata);
    }

    @Override
    public void delete(String fileIdentifier) {
        AmazonS3URI s3URI = new AmazonS3URI(fileIdentifier);
        this.amazonS3.deleteObject(s3URI.getBucket(), s3URI.getKey());
    }

    @Override
    public InputStreamOfKnownLength downloadAsStream(String fileIdentifier) {
        AmazonS3URI s3URI = new AmazonS3URI(fileIdentifier);
        if (this.amazonS3.doesObjectExist(s3URI.getBucket(), s3URI.getKey())) {
            S3Object s3Object = this.amazonS3.getObject(s3URI.getBucket(), s3URI.getKey());
            return new InputStreamOfKnownLength((InputStream)s3Object.getObjectContent(), s3Object.getObjectMetadata().getInstanceLength());
        }
        throw new BackingFileStoreException(String.format("Unable to retrieve file: %s", fileIdentifier));
    }

    @Override
    public InputStreamOfKnownLength downloadAsStream(String fileIdentifier, long startingOffset, long endingOffset) {
        AmazonS3URI s3URI = new AmazonS3URI(fileIdentifier);
        if (this.amazonS3.doesObjectExist(s3URI.getBucket(), s3URI.getKey())) {
            GetObjectRequest objectRequest = new GetObjectRequest(s3URI.getBucket(), s3URI.getKey());
            objectRequest.setRange(startingOffset, endingOffset);
            S3Object s3Object = this.amazonS3.getObject(objectRequest);
            return new InputStreamOfKnownLength((InputStream)s3Object.getObjectContent(), s3Object.getObjectMetadata().getInstanceLength());
        }
        throw new BackingFileStoreException(String.format("Unable to retrieve file: %s", fileIdentifier));
    }

    @Override
    public BackingStorageType backingStorageType() {
        return BackingStorageType.AWS_S3;
    }

    @Override
    public void deleteFiles(Set<String> fileIdentifiers) {
        List keyVersions = fileIdentifiers.stream().map(fileIdentifier -> {
            AmazonS3URI s3URI = new AmazonS3URI(fileIdentifier);
            return new DeleteObjectsRequest.KeyVersion(s3URI.getKey(), s3URI.getVersionId());
        }).collect(Collectors.toList());
        DeleteObjectsRequest multiObjectDeleteRequest = new DeleteObjectsRequest(this.bucketName).withKeys(keyVersions).withQuiet(false);
        this.amazonS3.deleteObjects(multiObjectDeleteRequest);
    }

    private String streamToS3(InputStream inputStream, String fileName, ObjectMetadata o) {
        String uniqueS3Filename = this.ensureFilenameIsUniqueForS3(fileName);
        this.amazonS3.putObject(this.bucketName, uniqueS3Filename, inputStream, o);
        return String.format("s3://%s/%s", this.bucketName, uniqueS3Filename);
    }

    private String ensureFilenameIsUniqueForS3(String filename) {
        return String.format("%s-%s", filename, UUID.randomUUID());
    }
}

